/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

abstract class BoundsChecker {
    float bound;

    BoundsChecker() {
    }

    abstract void update(float var1);

    void set(float sample) {
        this.bound = sample;
    }

    abstract boolean check(float var1);

    static BoundsChecker create(boolean reversed) {
        if (reversed) {
            return new Min();
        }
        return new Max();
    }

    static class Min
    extends BoundsChecker {
        Min() {
            this.bound = Float.POSITIVE_INFINITY;
        }

        @Override
        void update(float sample) {
            if (sample < this.bound) {
                this.bound = sample;
            }
        }

        @Override
        boolean check(float sample) {
            return sample > this.bound;
        }
    }

    static class Max
    extends BoundsChecker {
        Max() {
            this.bound = Float.NEGATIVE_INFINITY;
        }

        @Override
        void update(float sample) {
            if (sample > this.bound) {
                this.bound = sample;
            }
        }

        @Override
        boolean check(float sample) {
            return sample < this.bound;
        }
    }
}

