/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.core.NodeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowListUrlChecker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String URL_ALLOW_LIST = "allowUrls";
    public static final String DISABLE_URL_ALLOW_LIST = "solr.disable.allowUrls";
    public static final String SET_SOLR_DISABLE_URL_ALLOW_LIST_CLUE = "Set -Dsolr.disable.allowUrls=true to disable URL allow-list checks.";
    public static final AllowListUrlChecker ALLOW_ALL;
    private static final Pattern PROTOCOL_PATTERN;
    private final Set<String> hostAllowList;

    public AllowListUrlChecker(List<String> urlAllowList) throws MalformedURLException {
        this.hostAllowList = AllowListUrlChecker.parseHostPorts(urlAllowList);
    }

    public static AllowListUrlChecker create(NodeConfig config) {
        if (Boolean.getBoolean(DISABLE_URL_ALLOW_LIST)) {
            return ALLOW_ALL;
        }
        if (System.getProperty("solr.disable.shardsWhitelist") != null) {
            log.warn("Property 'solr.disable.shardsWhitelist' is deprecated, please use '{}' instead.", (Object)DISABLE_URL_ALLOW_LIST);
        }
        try {
            return new AllowListUrlChecker(config.getAllowUrls());
        }
        catch (MalformedURLException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid URL syntax in 'allowUrls' configuration: " + config.getAllowUrls(), (Throwable)e);
        }
    }

    public void checkAllowList(List<String> urls) throws MalformedURLException {
        this.checkAllowList(urls, null);
    }

    public void checkAllowList(List<String> urls, ClusterState clusterState) throws MalformedURLException {
        Set clusterHostAllowList = clusterState == null ? Collections.emptySet() : clusterState.getHostAllowList();
        for (String url : urls) {
            String hostPort = AllowListUrlChecker.parseHostPort(url);
            if (clusterHostAllowList.contains(hostPort) || this.hostAllowList.contains(hostPort)) continue;
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "URL " + url + " is neither a live node of the cluster nor in the configured 'allowUrls' " + this.hostAllowList);
        }
    }

    public boolean hasExplicitAllowList() {
        return !this.hostAllowList.isEmpty();
    }

    public boolean isEnabled() {
        return true;
    }

    @VisibleForTesting
    public Set<String> getHostAllowList() {
        return this.hostAllowList == null ? null : Collections.unmodifiableSet(this.hostAllowList);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [allowList=" + this.hostAllowList + "]";
    }

    @VisibleForTesting
    static Set<String> parseHostPorts(List<String> urls) throws MalformedURLException {
        if (urls == null || urls.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> hostPorts = new HashSet<String>();
        for (String urlString : urls) {
            hostPorts.add(AllowListUrlChecker.parseHostPort(urlString));
        }
        return hostPorts;
    }

    private static String parseHostPort(String url) throws MalformedURLException {
        URL u;
        Matcher protocolMatcher = PROTOCOL_PATTERN.matcher((CharSequence)(url = ((String)url).trim()));
        if (protocolMatcher.matches()) {
            if (!protocolMatcher.group(1).startsWith("http")) {
                url = "http" + protocolMatcher.group(2);
            }
            u = new URL((String)url);
        } else {
            u = new URL("http://" + (String)url);
        }
        if (u.getHost() == null || u.getPort() < 0) {
            throw new MalformedURLException("Invalid host or port in '" + (String)url + "'");
        }
        return u.getHost() + ":" + u.getPort();
    }

    static {
        try {
            ALLOW_ALL = new AllowListUrlChecker(Collections.emptyList()){

                @Override
                public void checkAllowList(List<String> urls, ClusterState clusterState) {
                }

                @Override
                public boolean isEnabled() {
                    return false;
                }

                @Override
                public String toString() {
                    return this.getClass().getSimpleName() + " [allow all]";
                }
            };
        }
        catch (MalformedURLException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        PROTOCOL_PATTERN = Pattern.compile("(\\w+)(://.*)");
    }
}

