/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.ranking;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.BinSearch;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceContainerCache;
import net.yacy.kelondro.rwi.ReferenceIterator;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.peers.graphics.WebStructureGraph;

public class BlockRank {
    public static ReferenceContainerCache<WebStructureGraph.HostReference> collect(SeedDB seeds2, WebStructureGraph myGraph, int maxcount) {
        ReferenceContainerCache<WebStructureGraph.HostReference> index2 = new ReferenceContainerCache<WebStructureGraph.HostReference>(WebStructureGraph.hostReferenceFactory, Base64Order.enhancedCoder, 6);
        Iterator<Seed> si = seeds2.seedsConnected(true, false, null, 0.99f);
        ArrayList<IndexRetrieval> jobs = new ArrayList<IndexRetrieval>();
        while (maxcount-- > 0 && si.hasNext()) {
            IndexRetrieval loader = new IndexRetrieval(index2, si.next());
            loader.start();
            jobs.add(loader);
        }
        if (myGraph != null) {
            try {
                ReferenceContainerCache<WebStructureGraph.HostReference> myIndex = myGraph.incomingReferences();
                ConcurrentLog.info("BlockRank", "loaded " + myIndex.size() + " host indexes from my peer");
                index2.merge(myIndex);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        for (IndexRetrieval job : jobs) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        ConcurrentLog.info("BlockRank", "create " + index2.size() + " host indexes from all peers");
        return index2;
    }

    public static void saveHostIndex(ReferenceContainerCache<WebStructureGraph.HostReference> index2, File file) {
        ConcurrentLog.info("BlockRank", "saving " + index2.size() + " host indexes to file " + file.toString());
        index2.dump(file, 0x400000, false);
        ConcurrentLog.info("BlockRank", "saved " + index2.size() + " host indexes to file " + file.toString());
    }

    public static ReferenceContainerCache<WebStructureGraph.HostReference> loadHostIndex(File file) {
        ConcurrentLog.info("BlockRank", "reading host indexes from file " + file.toString());
        ReferenceContainerCache<WebStructureGraph.HostReference> index2 = new ReferenceContainerCache<WebStructureGraph.HostReference>(WebStructureGraph.hostReferenceFactory, Base64Order.enhancedCoder, 6);
        try {
            ReferenceIterator<WebStructureGraph.HostReference> ri = new ReferenceIterator<WebStructureGraph.HostReference>(file, WebStructureGraph.hostReferenceFactory);
            while (ri.hasNext()) {
                ReferenceContainer references = (ReferenceContainer)ri.next();
                index2.add(references);
            }
            ri.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        ConcurrentLog.info("BlockRank", "read " + index2.size() + " host indexes from file " + file.toString());
        return index2;
    }

    public static int ranking(byte[] hash, BinSearch[] rankingTable) {
        byte[] hosthash;
        if (rankingTable == null) {
            return 16;
        }
        if (hash.length == 6) {
            hosthash = hash;
        } else {
            hosthash = new byte[6];
            System.arraycopy(hash, 6, hosthash, 0, 6);
        }
        int m = Math.min(16, rankingTable.length);
        for (int i = 0; i < m; ++i) {
            if (rankingTable[i] == null || !rankingTable[i].contains(hosthash)) continue;
            return i;
        }
        return 16;
    }

    public static class IndexRetrieval
    extends Thread {
        ReferenceContainerCache<WebStructureGraph.HostReference> index;
        Seed seed;

        public IndexRetrieval(ReferenceContainerCache<WebStructureGraph.HostReference> index2, Seed seed) {
            super("BlockRank.IndexRetrieval");
            this.index = index2;
            this.seed = seed;
        }

        @Override
        public void run() {
            ReferenceContainerCache<WebStructureGraph.HostReference> partialIndex = Protocol.loadIDXHosts(this.seed);
            if (partialIndex == null || partialIndex.isEmpty()) {
                return;
            }
            ConcurrentLog.info("BlockRank", "loaded " + partialIndex.size() + " host indexes from peer " + this.seed.getName());
            try {
                this.index.merge(partialIndex);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
    }
}

