/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.query;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.WorkTables;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.peers.SeedDB;
import net.yacy.repository.LoaderDispatcher;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;

public class SearchEventCache {
    private static volatile LinkedHashMap<String, SearchEvent> lastEvents = new LinkedHashMap();
    private static final long eventLifetimeBigMem = 600000L;
    private static final long eventLifetimeMediumMem = 60000L;
    private static final long eventLifetimeShortMem = 10000L;
    private static final long memlimitHigh = 629145600L;
    private static final long memlimitMedium = 0xC800000L;
    public static volatile String lastEventID = "";
    public static long cacheInsert = 0L;
    public static long cacheHit = 0L;
    public static long cacheMiss = 0L;
    public static long cacheDelete = 0L;

    public static int size() {
        return lastEvents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void put(String eventID, SearchEvent event) {
        if (MemoryControl.shortStatus()) {
            SearchEventCache.cleanupEvents(false);
        }
        lastEventID = eventID;
        LinkedHashMap<String, SearchEvent> linkedHashMap = lastEvents;
        synchronized (linkedHashMap) {
            SearchEvent oldEvent = lastEvents.put(eventID, event);
            if (oldEvent == null) {
                ++cacheInsert;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(String urlhash) {
        LinkedHashMap<String, SearchEvent> linkedHashMap = lastEvents;
        synchronized (linkedHashMap) {
            for (SearchEvent event : lastEvents.values()) {
                if (!event.delete(urlhash)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupEvents(boolean all2) {
        long memx;
        if (MemoryControl.shortStatus()) {
            all2 = true;
        }
        long acceptTime = (memx = MemoryControl.available()) > 629145600L ? 600000L : (memx > 0xC800000L ? 60000L : 10000L);
        LinkedHashMap<String, SearchEvent> linkedHashMap = lastEvents;
        synchronized (linkedHashMap) {
            Iterator<Map.Entry<String, SearchEvent>> i = lastEvents.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, SearchEvent> eventEntry = i.next();
                SearchEvent event = eventEntry.getValue();
                if (event == null || !all2 && event.getEventTime() + acceptTime >= System.currentTimeMillis()) continue;
                event.cleanup();
                i.remove();
                ++cacheDelete;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupEvents(int maxsize) {
        if (MemoryControl.shortStatus()) {
            SearchEventCache.cleanupEvents(true);
            return;
        }
        LinkedHashMap<String, SearchEvent> linkedHashMap = lastEvents;
        synchronized (linkedHashMap) {
            Iterator<Map.Entry<String, SearchEvent>> i = lastEvents.entrySet().iterator();
            int dc = lastEvents.size() - maxsize;
            if (dc <= 0) {
                return;
            }
            while (i.hasNext()) {
                Map.Entry<String, SearchEvent> eventEntry = i.next();
                SearchEvent event = eventEntry.getValue();
                if (event == null) continue;
                event.cleanup();
                i.remove();
                ++cacheDelete;
                if (--dc > 0) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchEvent getEvent(String eventID) {
        SearchEvent event = lastEvents.get(eventID);
        if (event == null) {
            LinkedHashMap<String, SearchEvent> linkedHashMap = lastEvents;
            synchronized (linkedHashMap) {
                event = lastEvents.get(eventID);
                if (event == null) {
                    ++cacheMiss;
                } else {
                    ++cacheHit;
                }
            }
            ++cacheMiss;
        } else {
            ++cacheHit;
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchEvent getEvent(QueryParams query2, SeedDB peers, WorkTables workTables, SortedSet<byte[]> preselectedPeerHashes, boolean generateAbstracts, LoaderDispatcher loader, int remote_maxcount, long remote_maxtime) {
        LinkedHashMap<String, SearchEvent> linkedHashMap;
        String id;
        SearchEvent event;
        if (MemoryControl.shortStatus()) {
            SearchEventCache.cleanupEvents(true);
        }
        if ((event = SearchEventCache.getEvent(id = query2.id(false))) != null && query2.isLocal()) {
            linkedHashMap = lastEvents;
            synchronized (linkedHashMap) {
                lastEvents.remove(id);
            }
            ++cacheDelete;
            event = null;
        }
        if (Switchboard.getSwitchboard() != null && !Switchboard.getSwitchboard().crawlQueues.noticeURL.isEmpty() && event != null && System.currentTimeMillis() - event.getEventTime() > 60000L) {
            linkedHashMap = lastEvents;
            synchronized (linkedHashMap) {
                lastEvents.remove(id);
            }
            ++cacheDelete;
            event = null;
        } else if (event != null) {
            if (!query2.isLocal() && event.getResultCount() == 0 && event.isFeedingFinished()) {
                linkedHashMap = lastEvents;
                synchronized (linkedHashMap) {
                    lastEvents.remove(id);
                }
                ++cacheDelete;
                event = null;
            } else if (event != null) {
                event.resetEventTime();
                event.query.offset = query2.offset;
                event.query.itemsPerPage = query2.itemsPerPage;
            }
        }
        if (event == null) {
            linkedHashMap = lastEvents;
            synchronized (linkedHashMap) {
                ConcurrentLog.info("SearchEventCache", "getEvent: " + lastEvents.size() + " in cache");
            }
            Switchboard sb = Switchboard.getSwitchboard();
            boolean delete = sb == null || Switchboard.getSwitchboard().getConfigBool("search.verify.delete", true) || sb.getConfigBool("network.unit.inspection.searchverify", false) && sb.peers.mySeed().getFlagAcceptRemoteIndex();
            boolean addToLocalIdx = sb == null || Switchboard.getSwitchboard().getConfigBool("remotesearch.result.store", true);
            event = new SearchEvent(query2, peers, workTables, preselectedPeerHashes, generateAbstracts, loader, remote_maxcount, remote_maxtime, delete, addToLocalIdx);
            if (sb != null) {
                event.setRemoteDocStoredMaxSize(sb.getConfigLong("remotesearch.result.store.maxsize", -1L));
            }
            MemoryControl.request(0x6400000L, false);
        }
        return event;
    }
}

