/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.query;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.DateDetection;
import net.yacy.kelondro.util.ISO639;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import org.apache.solr.common.params.MultiMapSolrParams;

public class QueryModifier {
    private final StringBuilder modifier;
    public String sitehost;
    public String sitehash;
    public String filetype;
    public String protocol;
    public String language;
    public String author;
    public String keyword;
    public String collection;
    public String on;
    public String from;
    public String to;
    public int timezoneOffset;

    public QueryModifier(int timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
        this.sitehash = null;
        this.sitehost = null;
        this.filetype = null;
        this.protocol = null;
        this.language = null;
        this.author = null;
        this.keyword = null;
        this.collection = null;
        this.on = null;
        this.from = null;
        this.to = null;
        this.modifier = new StringBuilder(20);
    }

    public String parse(String querystring) {
        int q;
        int langi;
        int toi;
        int fromi;
        int oni;
        int keywordi;
        int ftb;
        int p;
        if (((String)querystring).indexOf("/https", 0) >= 0) {
            querystring = ((String)querystring).replace("/https", "");
            this.protocol = "https";
            this.add("/https");
        } else if (((String)querystring).indexOf("/http", 0) >= 0) {
            querystring = ((String)querystring).replace("/http", "");
            this.protocol = "http";
            this.add("/http");
        }
        if (((String)querystring).indexOf("/ftp", 0) >= 0) {
            querystring = ((String)querystring).replace("/ftp", "");
            this.protocol = "ftp";
            this.add("/ftp");
        }
        if (((String)querystring).indexOf("/smb", 0) >= 0) {
            querystring = ((String)querystring).replace("/smb", "");
            this.protocol = "smb";
            this.add("/smb");
        }
        if (((String)querystring).indexOf("/file", 0) >= 0) {
            querystring = ((String)querystring).replace("/file", "");
            this.protocol = "file";
            this.add("/file");
        }
        if ((p = ((String)querystring).indexOf(42)) >= 0 && (p > 0 && ((String)querystring).charAt(p - 1) != ' ' || p > 1 && p < ((String)querystring).length() - 1 && ((String)querystring).charAt(p + 1) != ' ')) {
            querystring = ((String)querystring).substring(0, p - 1) + ((String)querystring).substring(p + 1);
        }
        querystring = this.filetypeParser((String)querystring, "filetype:");
        int authori = ((String)(querystring = this.parseSiteModifier((String)querystring))).indexOf("author:", 0);
        if (authori >= 0) {
            boolean quotes;
            boolean bl = quotes = ((String)querystring).charAt(authori + 7) == '(';
            if (quotes) {
                ftb = ((String)querystring).indexOf(41, authori + 8);
                this.author = ((String)querystring).substring(authori + 8, ftb == -1 ? ((String)querystring).length() : ftb);
                querystring = ((String)querystring).replace("author:(" + this.author + ")", "");
                this.add("author:(" + this.author + ")");
            } else {
                ftb = ((String)querystring).indexOf(32, authori);
                if (ftb == -1) {
                    ftb = ((String)querystring).length();
                }
                this.author = ((String)querystring).substring(authori + 7, ftb);
                querystring = ((String)querystring).replace("author:" + this.author, "").replace("  ", " ").trim();
                this.add("author:" + this.author);
            }
        }
        if ((keywordi = ((String)querystring).indexOf("keyword:", 0)) >= 0) {
            ftb = ((String)querystring).indexOf(32, keywordi);
            this.keyword = ((String)querystring).substring(keywordi + 8, ftb == -1 ? ((String)querystring).length() : ftb);
            querystring = ((String)querystring).replace("keyword:" + this.keyword, "").replace("  ", " ").trim();
            this.add("keyword:" + this.keyword);
        }
        int collectioni = ((String)querystring).indexOf("collection:", 0);
        while (collectioni >= 0) {
            int ftb2 = ((String)querystring).indexOf(32, collectioni);
            this.collection = ((String)querystring).substring(collectioni + 11, ftb2 == -1 ? ((String)querystring).length() : ftb2);
            querystring = ((String)querystring).replace("collection:" + this.collection, "").replace("  ", " ").trim();
            collectioni = ((String)querystring).indexOf("collection:", 0);
        }
        if (this.collection != null) {
            this.add("collection:" + this.collection);
        }
        if ((oni = ((String)querystring).indexOf("on:", 0)) >= 0) {
            int ftb3 = ((String)querystring).indexOf(32, oni);
            this.on = ((String)querystring).substring(oni + 3, ftb3 == -1 ? ((String)querystring).length() : ftb3);
            querystring = ((String)querystring).replace("on:" + this.on, "").replace("  ", " ").trim();
            this.add("on:" + this.on);
        }
        if ((fromi = ((String)querystring).indexOf("from:", 0)) >= 0) {
            int ftb4 = ((String)querystring).indexOf(32, fromi);
            this.from = ((String)querystring).substring(fromi + 5, ftb4 == -1 ? ((String)querystring).length() : ftb4);
            querystring = ((String)querystring).replace("from:" + this.from, "").replace("  ", " ").trim();
            this.add("from:" + this.from);
        }
        if ((toi = ((String)querystring).indexOf("to:", 0)) >= 0) {
            int ftb5 = ((String)querystring).indexOf(32, toi);
            this.to = ((String)querystring).substring(toi + 3, ftb5 == -1 ? ((String)querystring).length() : ftb5);
            querystring = ((String)querystring).replace("to:" + this.to, "").replace("  ", " ").trim();
            this.add("to:" + this.to);
        }
        if ((langi = ((String)querystring).indexOf("/language/")) >= 0 && ((String)querystring).length() >= langi + 12) {
            this.language = ((String)querystring).substring(langi + 10, langi + 12);
            querystring = ((String)querystring).replace("/language/" + this.language, "");
            if (this.language.length() == 2 && ISO639.exists(this.language)) {
                this.language = this.language.toLowerCase(Locale.ROOT);
                this.add("/language/" + this.language);
            } else {
                this.language = null;
            }
        }
        if ((p = ((String)querystring).indexOf(34)) >= 0 && (q = ((String)querystring).indexOf(34, p + 1)) < 0) {
            querystring = (String)querystring + "\"";
        }
        return ((String)querystring).trim();
    }

    private String filetypeParser(String querystring, String filetypePrefix) {
        int ftp = querystring.indexOf(filetypePrefix, 0);
        if (ftp >= 0) {
            int ftb = querystring.indexOf(32, ftp);
            if (ftb < 0) {
                ftb = querystring.length();
            }
            String tmpqueryparameter = querystring.substring(ftp + filetypePrefix.length(), ftb);
            querystring = querystring.replace(filetypePrefix + tmpqueryparameter, "");
            this.filetype = tmpqueryparameter.toLowerCase(Locale.ROOT);
            while (!this.filetype.isEmpty() && this.filetype.charAt(0) == '.') {
                this.filetype = this.filetype.substring(1);
            }
            this.add(filetypePrefix + this.filetype);
            if (this.filetype.isEmpty()) {
                this.filetype = null;
            }
            if (querystring.length() == 0) {
                querystring = "*";
            }
        }
        return querystring;
    }

    protected String parseSiteModifier(String querystring) {
        String modifierPrefix = "site:";
        int sp = querystring.indexOf("site:", 0);
        if (sp >= 0) {
            int ftb = querystring.indexOf(32, sp);
            if (ftb == -1) {
                ftb = querystring.length();
            }
            this.sitehost = querystring.substring(sp + "site:".length(), ftb);
            querystring = querystring.replace("site:" + this.sitehost, "");
            while (this.sitehost.length() > 0 && this.sitehost.charAt(0) == '.') {
                this.sitehost = this.sitehost.substring(1);
            }
            while (this.sitehost.endsWith(".")) {
                this.sitehost = this.sitehost.substring(0, this.sitehost.length() - 1);
            }
            try {
                this.sitehost = MultiProtocolURL.toPunycode(this.sitehost);
            }
            catch (Punycode.PunycodeException e1) {
                ConcurrentLog.logException(e1);
            }
            this.sitehost = this.sitehost.toLowerCase(Locale.ROOT);
            try {
                this.sitehash = DigestURL.hosthash(this.sitehost, this.sitehost.startsWith("ftp.") ? 21 : 80);
            }
            catch (MalformedURLException e) {
                this.sitehash = "";
                ConcurrentLog.logException(e);
            }
            this.add("site:" + this.sitehost);
        }
        return querystring;
    }

    public void add(String m) {
        if (this.modifier.length() > 0 && this.modifier.charAt(this.modifier.length() - 1) != ' ' && m != null && m.length() > 0) {
            this.modifier.append(' ');
        }
        if (m != null) {
            this.modifier.append(m);
        }
    }

    public void remove(String m) {
        int p = this.modifier.indexOf(" " + m);
        if (p >= 0) {
            this.modifier.delete(p, p + m.length() + 1);
        }
        if ((p = this.modifier.indexOf(m)) == 0) {
            this.modifier.delete(p, p + m.length());
        }
        if (this.modifier.length() > 0 && this.modifier.charAt(0) == ' ') {
            this.modifier.delete(0, 1);
        }
    }

    public String toString() {
        return this.modifier.toString();
    }

    public boolean isEmpty() {
        return this.modifier.length() == 0;
    }

    private StringBuilder apply(String FQ) {
        StringBuilder fq = new StringBuilder(FQ);
        if (this.sitehost != null && this.sitehost.length() > 0 && fq.indexOf(CollectionSchema.host_s.getSolrFieldName()) < 0) {
            if (this.sitehost.startsWith("www.")) {
                fq.append(" AND (").append(CollectionSchema.host_s.getSolrFieldName()).append(":\"").append(this.sitehost.substring(4)).append('\"');
                fq.append(" OR ").append(CollectionSchema.host_s.getSolrFieldName()).append(":\"").append(this.sitehost).append("\")");
            } else {
                fq.append(" AND (").append(CollectionSchema.host_s.getSolrFieldName()).append(":\"").append(this.sitehost).append('\"');
                fq.append(" OR ").append(CollectionSchema.host_s.getSolrFieldName()).append(":\"www.").append(this.sitehost).append("\")");
            }
        }
        if (this.sitehash != null && this.sitehash.length() > 0 && fq.indexOf(CollectionSchema.host_id_s.getSolrFieldName()) < 0) {
            fq.append(" AND ").append(CollectionSchema.host_id_s.getSolrFieldName()).append(":\"").append(this.sitehash).append('\"');
        }
        if (this.filetype != null && this.filetype.length() > 0 && fq.indexOf(CollectionSchema.url_file_ext_s.getSolrFieldName()) < 0) {
            fq.append(" AND ").append(CollectionSchema.url_file_ext_s.getSolrFieldName()).append(":\"").append(this.filetype).append('\"');
        }
        if (this.author != null && this.author.length() > 0 && fq.indexOf(CollectionSchema.author_sxt.getSolrFieldName()) < 0) {
            fq.append(" AND ").append(CollectionSchema.author_sxt.getSolrFieldName()).append(":\"").append(this.author).append('\"');
        }
        if (this.keyword != null && this.keyword.length() > 0 && fq.indexOf(CollectionSchema.keywords.getSolrFieldName()) < 0) {
            fq.append(" AND ").append(CollectionSchema.keywords.getSolrFieldName()).append(":\"").append(this.keyword).append('\"');
        }
        if (this.collection != null && this.collection.length() > 0 && fq.indexOf(CollectionSchema.collection_sxt.getSolrFieldName()) < 0) {
            fq.append(" AND ").append(QueryModifier.parseCollectionExpression(this.collection));
        }
        if (fq.indexOf(CollectionSchema.dates_in_content_dts.getSolrFieldName()) < 0) {
            if (this.on != null && this.on.length() > 0) {
                fq.append(" AND ").append(QueryModifier.parseOnExpression(this.on, this.timezoneOffset));
            }
            if (this.from != null && this.from.length() > 0 && (this.to == null || this.to.equals("*"))) {
                fq.append(" AND ").append(QueryModifier.parseFromToExpression(this.from, null, this.timezoneOffset));
            }
            if ((this.from == null || this.from.equals("*")) && this.to != null && this.to.length() > 0) {
                fq.append(" AND ").append(QueryModifier.parseFromToExpression(null, this.to, this.timezoneOffset));
            }
            if (this.from != null && this.from.length() > 0 && this.to != null && this.to.length() > 0) {
                fq.append(" AND ").append(QueryModifier.parseFromToExpression(this.from, this.to, this.timezoneOffset));
            }
        }
        if (this.protocol != null && this.protocol.length() > 0 && fq.indexOf(CollectionSchema.url_protocol_s.getSolrFieldName()) < 0) {
            fq.append(" AND ").append(CollectionSchema.url_protocol_s.getSolrFieldName()).append(":\"").append(this.protocol).append('\"');
        }
        return fq;
    }

    public void apply(serverObjects post) {
        StringBuilder fq = this.apply(post.get("fq", ""));
        if (fq.length() > 0) {
            String fqs = fq.toString();
            if (fqs.startsWith(" AND ")) {
                fqs = fqs.substring(5);
            }
            post.remove("fq");
            post.put("fq", fqs);
        }
    }

    public void apply(MultiMapSolrParams mmsp) {
        StringBuilder fq = this.apply(mmsp.get("fq", ""));
        if (fq.length() > 0) {
            String fqs = fq.toString();
            if (fqs.startsWith(" AND ")) {
                fqs = fqs.substring(5);
            }
            mmsp.getMap().remove("fq");
            mmsp.getMap().put("fq", new String[]{fqs});
        }
    }

    public static String parseCollectionExpression(String collectionDescription) {
        String[] s0 = CommonPattern.VERTICALBAR.split(collectionDescription);
        ArrayList<String> collections = new ArrayList<String>(2);
        for (String s : s0) {
            if ((s = s.trim()).length() <= 0) continue;
            collections.add(s);
        }
        StringBuilder fq = new StringBuilder(20);
        if (collections.size() > 1) {
            fq.append('(').append(CollectionSchema.collection_sxt.getSolrFieldName()).append(":\"").append((String)collections.get(0)).append('\"');
            for (int i = 1; i < collections.size(); ++i) {
                fq.append(" OR ").append(CollectionSchema.collection_sxt.getSolrFieldName()).append(":\"").append((String)collections.get(i)).append('\"');
            }
            fq.append(')');
        } else if (collections.size() == 1) {
            fq.append(CollectionSchema.collection_sxt.getSolrFieldName()).append(":\"").append((String)collections.get(0)).append('\"');
        }
        if (fq.length() > 0) {
            fq.insert(0, "{!tag=" + CollectionSchema.collection_sxt.getSolrFieldName() + "}");
        }
        return fq.toString();
    }

    public static String parseOnExpression(String onDescription, int timezoneOffset) {
        assert (onDescription != null);
        Date onDate = DateDetection.parseLine(onDescription, timezoneOffset);
        StringBuilder filterQuery = new StringBuilder(20);
        if (onDate != null) {
            String dstr = onDate.toInstant().toString();
            filterQuery.append(CollectionSchema.dates_in_content_dts.getSolrFieldName()).append(":[").append(dstr).append(" TO ").append(dstr).append(']');
        }
        return filterQuery.toString();
    }

    public static String parseFromToExpression(String from, String to, int timezoneOffset) {
        Date fromDate = from == null || from.equals("*") ? null : DateDetection.parseLine(from, timezoneOffset);
        Date toDate = to == null || to.equals("*") ? null : DateDetection.parseLine(to, timezoneOffset);
        StringBuilder filterQuery = new StringBuilder(20);
        if (fromDate != null && toDate != null) {
            String dstrFrom = fromDate.toInstant().toString();
            String dstrTo = toDate.toInstant().toString();
            filterQuery.append(CollectionSchema.dates_in_content_dts.getSolrFieldName()).append(":[").append(dstrFrom).append(" TO ").append(dstrTo).append(']');
        }
        return filterQuery.toString();
    }
}

