/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.Collection;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.util.ISO639;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.StringNavigator;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;

public class LanguageNavigator
extends StringNavigator
implements Navigator {
    public LanguageNavigator(String title, NavigatorSort sort) {
        super(title, CollectionSchema.language_s, sort);
    }

    @Override
    public void inc(String lang) {
        if (ISO639.exists(lang)) {
            super.inc(lang);
        }
    }

    @Override
    public void inc(ScoreMap<String> map) {
        if (map == null) {
            return;
        }
        for (String entry2 : map) {
            int count;
            if (!ISO639.exists(entry2) || (count = map.get(entry2)) <= 0) continue;
            this.inc(entry2, count);
        }
    }

    @Override
    public void incDoc(URIMetadataNode doc) {
        if (this.field != null) {
            Object val = doc.getFieldValue(this.field.getSolrFieldName());
            if (val != null) {
                if (val instanceof Collection) {
                    Collection ll = (Collection)val;
                    for (Object obj : ll) {
                        String s;
                        if (!(obj instanceof String) || (s = (String)obj).isEmpty()) continue;
                        this.inc(s);
                    }
                } else {
                    this.inc((String)val);
                }
            } else if (doc.word() != null && doc.word().getLanguageString() != null) {
                String lang = doc.word().getLanguageString();
                this.inc(lang);
            }
        }
    }

    @Override
    public String getQueryModifier(String key) {
        return "/language/" + key;
    }

    @Override
    public String getElementDisplayName(String lng) {
        String longname = ISO639.country(lng);
        if (longname == null) {
            return lng;
        }
        return longname;
    }

    @Override
    public boolean modifieractive(QueryModifier modifier, String name) {
        return modifier.language != null && modifier.language.contains(name);
    }
}

