/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.index;

import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.Query;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.LuceneQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.update.DocumentBuilder;

public abstract class SingleDocumentMatcher {
    public static Query toLuceneQuery(String query2, SolrCore targetCore) throws SyntaxError, SolrException {
        if (query2 == null || targetCore == null) {
            throw new IllegalArgumentException("All parameters must be non null");
        }
        SolrQuery solrQuery = new SolrQuery(query2);
        solrQuery.setParam("df", new String[]{CollectionSchema.text_t.getSolrFieldName()});
        SolrQueryRequestBase solrRequest = new SolrQueryRequestBase(targetCore, (SolrParams)solrQuery){};
        LuceneQParserPlugin luceneParserPlugin = new LuceneQParserPlugin();
        QParser solrParser = luceneParserPlugin.createParser(query2, null, solrRequest.getParams(), (SolrQueryRequest)solrRequest);
        return solrParser.parse();
    }

    public static boolean matches(SolrInputDocument solrDoc, String query2, SolrCore core) throws SyntaxError, IllegalArgumentException {
        Query luceneQuery;
        Analyzer indexAnalyzer;
        if (solrDoc == null || query2 == null || core == null) {
            throw new IllegalArgumentException("All parameters must be non null");
        }
        IndexSchema schema2 = core.getLatestSchema();
        if (schema2 == null) {
            throw new IllegalArgumentException("All parameters must be non null");
        }
        Document luceneDoc = DocumentBuilder.toDocument((SolrInputDocument)solrDoc, (IndexSchema)schema2);
        MemoryIndex index2 = MemoryIndex.fromDocument((Iterable)luceneDoc, (Analyzer)(indexAnalyzer = schema2.getIndexAnalyzer()));
        float score = index2.search(luceneQuery = SingleDocumentMatcher.toLuceneQuery(query2, core));
        return score > 0.0f;
    }
}

