/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.http.HTTPClient;

public class HFClient {
    private static final String BASE = "https://huggingface.co";

    private static String textOrNull(JsonNode n) {
        return n != null && !n.isNull() ? n.asText() : null;
    }

    public static List<String> listYaCyPacks() throws IOException, InterruptedException {
        List<String> repos = HFClient.listRepositories(null, RepoType.DATASET, 20, "YaCy-Pack");
        return repos;
    }

    private static List<String> listRepositories(String author, RepoType type, int limit, String search2) throws IOException, InterruptedException {
        if (limit <= 0) {
            limit = 100;
        }
        StringBuilder url = new StringBuilder(BASE).append("/api/").append(type.segment()).append("?limit=").append(limit);
        if (author != null && !author.isBlank()) {
            url.append("&author=").append(URLEncoder.encode(author, StandardCharsets.UTF_8));
        }
        if (search2 != null && !search2.isBlank()) {
            url.append("&search=").append(URLEncoder.encode(search2, StandardCharsets.UTF_8));
        }
        HTTPClient hc = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);
        byte[] body = hc.GETbytes(url.toString(), null, null, false);
        hc.close();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode arr = mapper.readTree(body);
        ArrayList<String> ids = new ArrayList<String>();
        if (arr.isArray()) {
            for (JsonNode n : arr) {
                String id = HFClient.textOrNull(n.get("modelId"));
                if (id == null) {
                    id = HFClient.textOrNull(n.get("id"));
                }
                if (id == null) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    public static ArrayList<String> listFiles(String repoId, boolean only_jsonl) throws IOException, InterruptedException {
        ArrayList<String> files = HFClient.listFiles(repoId, RepoType.DATASET);
        if (!only_jsonl) {
            return files;
        }
        for (int i = files.size() - 1; i >= 0; --i) {
            String file = files.get(i);
            if (file.contains(".jsonl")) continue;
            files.remove(i);
        }
        return files;
    }

    public static ArrayList<String> listFiles(String repoId, RepoType type) throws IOException, InterruptedException {
        String url = "https://huggingface.co/api/" + type.segment() + "/" + repoId;
        HTTPClient hc = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);
        byte[] body = hc.GETbytes(url, null, null, false);
        hc.close();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(body);
        JsonNode filesArray = root.get("siblings");
        if (filesArray == null) {
            filesArray = root.get("files");
        }
        ArrayList<String> out = new ArrayList<String>();
        if (filesArray != null && filesArray.isArray()) {
            for (JsonNode f : filesArray) {
                String path = HFClient.textOrNull(f.get("rfilename"));
                if (path == null) {
                    path = HFClient.textOrNull(f.get("path"));
                }
                if (path == null) continue;
                out.add(path);
            }
        }
        return out;
    }

    public static Map<String, List<String>> getAllPacks(boolean only_jsonl) throws IOException, InterruptedException {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        List<String> repos = HFClient.listYaCyPacks();
        for (String repoId : repos) {
            ArrayList<String> files = HFClient.listFiles(repoId, only_jsonl);
            if (files.isEmpty()) continue;
            map.put(repoId, files);
        }
        return map;
    }

    public static byte[] downloadFile(String repoId, String filePath) throws IOException, InterruptedException {
        return HFClient.downloadFile(repoId, RepoType.DATASET, "main", filePath);
    }

    private static byte[] downloadFile(String repoId, RepoType type, String revision, String filePath) throws IOException, InterruptedException {
        Objects.requireNonNull(repoId);
        Objects.requireNonNull(filePath);
        if (revision == null || revision.isBlank()) {
            revision = "main";
        }
        String url = "https://huggingface.co/" + RepoType.DATASET.segment() + "/" + repoId + "/resolve/" + revision + "/" + filePath + "?download=true";
        HTTPClient hc = new HTTPClient(ClientIdentification.browserAgent);
        hc.setRedirecting(true);
        byte[] body = hc.GETbytes(url, null, null, false);
        hc.close();
        return body;
    }

    public static void main(String[] args) throws Exception {
        List<String> repos = HFClient.listYaCyPacks();
        System.out.println("Repos: " + String.valueOf(repos));
        String test_repo_id = repos.isEmpty() ? null : repos.get(0);
        ArrayList<String> all_files = test_repo_id == null ? new ArrayList<String>(0) : HFClient.listFiles(test_repo_id, false);
        ArrayList<String> jsonl_files = test_repo_id == null ? new ArrayList<String>(0) : HFClient.listFiles(test_repo_id, true);
        System.out.println("all   files in " + test_repo_id + ": " + String.valueOf(all_files));
        System.out.println("jsonl files in " + test_repo_id + ": " + String.valueOf(jsonl_files));
        if (!jsonl_files.isEmpty()) {
            byte[] data = HFClient.downloadFile(test_repo_id, RepoType.DATASET, "main", jsonl_files.get(0));
            System.out.println("Downloaded " + data.length + " bytes from " + jsonl_files.get(0) + " in " + test_repo_id);
        }
        Map<String, List<String>> map = HFClient.getAllPacks(true);
        for (Map.Entry<String, List<String>> entry2 : map.entrySet()) {
            String repo = entry2.getKey();
            List<String> files = entry2.getValue();
            System.out.println("Repo: " + repo + ", Files: " + String.valueOf(files));
        }
    }

    public static enum RepoType {
        MODEL("models"),
        DATASET("datasets"),
        SPACE("spaces");

        private final String pluralSegment;

        private RepoType(String s) {
            this.pluralSegment = s;
        }

        public String segment() {
            return this.pluralSegment;
        }
    }
}

