/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.table;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.Order;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Cache;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MergeIterator;
import net.yacy.kelondro.util.StackIterator;

public class SplitTable
implements Index,
Iterable<Row.Entry> {
    private static final int EcoFSBufferSize = 20;
    private Map<String, Index> tables;
    private final Row rowdef;
    private final File path;
    private final String prefix;
    private final Order<Row.Entry> entryOrder;
    private String current;
    private final long fileAgeLimit;
    private final long fileSizeLimit;
    private final boolean useTailCache;
    private final boolean exceed134217727;

    public SplitTable(File path, String tablename, Row rowdef, boolean useTailCache, boolean exceed134217727) {
        this(path, tablename, rowdef, 2628000000L, Integer.MAX_VALUE, useTailCache, exceed134217727);
    }

    private SplitTable(File path, String tablename, Row rowdef, long fileAgeLimit, long fileSizeLimit, boolean useTailCache, boolean exceed134217727) {
        this.path = path;
        this.prefix = tablename;
        this.rowdef = rowdef;
        this.fileAgeLimit = fileAgeLimit;
        this.fileSizeLimit = fileSizeLimit;
        this.useTailCache = useTailCache;
        this.exceed134217727 = exceed134217727;
        this.entryOrder = new Row.EntryComparator(rowdef.objectOrder);
        this.init();
    }

    @Override
    public void optimize() {
        for (Index table : this.tables.values()) {
            table.optimize();
        }
    }

    @Override
    public long mem() {
        long m = 0L;
        for (Index i : this.tables.values()) {
            m += i.mem();
        }
        return m;
    }

    @Override
    public final byte[] smallestKey() {
        RowHandleSet keysort = new RowHandleSet(this.rowdef.primaryKeyLength, this.rowdef.objectOrder, this.tables.size());
        for (Index oi : this.tables.values()) {
            try {
                keysort.put(oi.smallestKey());
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        return keysort.smallestKey();
    }

    @Override
    public final byte[] largestKey() {
        RowHandleSet keysort = new RowHandleSet(this.rowdef.primaryKeyLength, this.rowdef.objectOrder, this.tables.size());
        for (Index oi : this.tables.values()) {
            try {
                keysort.put(oi.largestKey());
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        return keysort.largestKey();
    }

    private String newFilename() {
        return this.prefix + "." + GenericFormatter.SHORT_MILSEC_FORMATTER.format() + ".table";
    }

    private void init() {
        File f;
        this.current = null;
        this.tables = new HashMap<String, Index>();
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
        String[] tablefile = this.path.list();
        Random r = new Random(System.currentTimeMillis());
        for (String element : tablefile) {
            if (!element.startsWith(this.prefix) || element.charAt(this.prefix.length()) != '.' || element.length() != this.prefix.length() + 7) continue;
            f = new File(this.path, element);
            String newname = element + "0100000" + (Long.toString(r.nextLong()) + "00000").substring(1, 5) + ".table";
            f.renameTo(new File(this.path, newname));
        }
        tablefile = this.path.list();
        HashMap<String, Long> t = new HashMap<String, Long>();
        long maxtime = 0L;
        for (String element : tablefile) {
            Date d;
            if (!element.startsWith(this.prefix) || element.charAt(this.prefix.length()) != '.' || element.length() != this.prefix.length() + 24) continue;
            f = new File(this.path, element);
            try {
                d = GenericFormatter.SHORT_MILSEC_FORMATTER.parse(element.substring(this.prefix.length() + 1, this.prefix.length() + 18), 0).getTime();
            }
            catch (ParseException e) {
                ConcurrentLog.severe("KELONDRO", "SplitTable: ", e);
                continue;
            }
            long time = d.getTime();
            if (time > maxtime) {
                this.current = element;
                assert (this.current != null);
                maxtime = time;
            }
            t.put(element, Table.staticRAMIndexNeed(f, this.rowdef));
        }
        ArrayList<1> warmingUp = new ArrayList<1>();
        while (!t.isEmpty()) {
            Table table;
            long maxram = 0L;
            String maxf = null;
            for (Map.Entry entry2 : t.entrySet()) {
                long ram = (Long)entry2.getValue();
                if (maxf != null && ram <= maxram) continue;
                maxf = (String)entry2.getKey();
                maxram = ram;
            }
            t.remove(maxf);
            f = new File(this.path, maxf);
            ConcurrentLog.info("KELONDRO", "SplitTable: opening partial eco table " + String.valueOf(f));
            try {
                table = new Table(f, this.rowdef, 20, 0, this.useTailCache, this.exceed134217727, false);
            }
            catch (SpaceExceededException spaceExceededException) {
                try {
                    table = new Table(f, this.rowdef, 0, 0, false, this.exceed134217727, false);
                }
                catch (SpaceExceededException ee) {
                    ConcurrentLog.severe("KELONDRO", "SplitTable: Table " + f.toString() + " cannot be initialized: " + ee.getMessage(), ee);
                    continue;
                }
            }
            final Table table2 = table;
            Thread p = new Thread("SplitTable.warmUp"){

                @Override
                public void run() {
                    table2.warmUp();
                }
            };
            p.start();
            warmingUp.add(p);
            this.tables.put(maxf, table);
        }
        for (Thread thread : warmingUp) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        assert (this.current == null || this.tables.get(this.current) != null) : "this.current = " + this.current;
    }

    @Override
    public void clear() throws IOException {
        String[] l;
        this.close();
        for (String element : l = this.path.list()) {
            if (!element.startsWith(this.prefix)) continue;
            File f = new File(this.path, element);
            if (f.isDirectory()) {
                SplitTable.delete(this.path, element);
                continue;
            }
            FileUtils.deletedelete(f);
        }
        this.init();
    }

    public static void delete(File path, String tablename) {
        String[] files;
        if (path == null || tablename == null) {
            return;
        }
        File tabledir = new File(path, tablename);
        if (!tabledir.exists()) {
            return;
        }
        if (!tabledir.isDirectory()) {
            FileUtils.deletedelete(tabledir);
            return;
        }
        for (String file : files = tabledir.list()) {
            FileUtils.deletedelete(new File(tabledir, file));
        }
        FileUtils.deletedelete(tabledir);
    }

    @Override
    public String filename() {
        return new File(this.path, this.prefix).toString();
    }

    @Override
    public int size() {
        Iterator<Index> i = this.tables.values().iterator();
        int s = 0;
        while (i.hasNext()) {
            s += i.next().size();
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        Iterator<Index> i = this.tables.values().iterator();
        while (i.hasNext()) {
            if (i.next().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int writeBufferSize() {
        int s = 0;
        for (Index index2 : this.tables.values()) {
            if (!(index2 instanceof Cache)) continue;
            s += ((Cache)index2).writeBufferSize();
        }
        return s;
    }

    @Override
    public Row row() {
        return this.rowdef;
    }

    @Override
    public boolean has(byte[] key) {
        return this.keeperOf(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry get(byte[] key, boolean forcecopy) throws IOException {
        Index keeper = this.keeperOf(key);
        if (keeper == null) {
            return null;
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            return keeper.get(key, forcecopy);
        }
    }

    @Override
    public Map<byte[], Row.Entry> getMap(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public List<Row.Entry> getList(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>(keys.size());
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            list2.add(entry2);
        }
        return list2;
    }

    private Index newTable() {
        this.current = this.newFilename();
        File f = new File(this.path, this.current);
        Table table = null;
        try {
            table = new Table(f, this.rowdef, 20, 0, this.useTailCache, this.exceed134217727, true);
        }
        catch (SpaceExceededException e) {
            try {
                table = new Table(f, this.rowdef, 0, 0, false, this.exceed134217727, true);
            }
            catch (SpaceExceededException e1) {
                ConcurrentLog.logException(e1);
            }
        }
        this.tables.put(this.current, table);
        assert (this.current == null || this.tables.get(this.current) != null) : "this.current = " + this.current;
        return table;
    }

    private Index checkTable(Index table) {
        long d;
        assert (table != null);
        long t = System.currentTimeMillis();
        if (t / 1000L % 10L != 0L) {
            return table;
        }
        String name = new File(table.filename()).getName();
        try {
            d = GenericFormatter.SHORT_MILSEC_FORMATTER.parse(name.substring(this.prefix.length() + 1, this.prefix.length() + 18), 0).getTime().getTime();
        }
        catch (ParseException e) {
            ConcurrentLog.severe("KELONDRO", "SplitTable", e);
            d = 0L;
        }
        if (d + this.fileAgeLimit < t || new File(this.path, name).length() >= this.fileSizeLimit) {
            return this.newTable();
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry replace(Row.Entry row) throws IOException, SpaceExceededException {
        assert (row.objectsize() <= this.rowdef.objectsize);
        Index keeper = this.keeperOf(row.getPrimaryKeyBytes());
        if (keeper != null) {
            SplitTable splitTable = this;
            synchronized (splitTable) {
                return keeper.replace(row);
            }
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            assert (this.current == null || this.tables.get(this.current) != null) : "this.current = " + this.current;
            keeper = this.current == null ? this.newTable() : this.checkTable(this.tables.get(this.current));
        }
        keeper.put(row);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Row.Entry row) throws IOException, SpaceExceededException {
        assert (row.objectsize() <= this.rowdef.objectsize);
        byte[] key = row.getPrimaryKeyBytes();
        if (this.tables == null) {
            return true;
        }
        Index keeper = this.keeperOf(key);
        if (keeper != null) {
            SplitTable splitTable = this;
            synchronized (splitTable) {
                return keeper.put(row);
            }
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            keeper = this.keeperOf(key);
            if (keeper != null) {
                return keeper.put(row);
            }
            assert (this.current == null || this.tables.get(this.current) != null) : "this.current = " + this.current;
            keeper = this.current == null ? this.newTable() : this.checkTable(this.tables.get(this.current));
            boolean b = keeper.put(row);
            assert (b);
            return b;
        }
    }

    private Index keeperOf(byte[] key) {
        if (key == null) {
            return null;
        }
        if (this.tables == null) {
            return null;
        }
        for (Index oi : this.tables.values()) {
            if (!oi.has(key)) continue;
            return oi;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnique(Row.Entry row) throws IOException, SpaceExceededException {
        assert (row.objectsize() <= this.rowdef.objectsize);
        Index keeper = this.current == null ? null : this.tables.get(this.current);
        SplitTable splitTable = this;
        synchronized (splitTable) {
            assert (this.current == null || this.tables.get(this.current) != null) : "this.current = " + this.current;
            keeper = keeper == null ? this.newTable() : this.checkTable(keeper);
        }
        keeper.addUnique(row);
    }

    @Override
    public List<RowCollection> removeDoubles() throws IOException, SpaceExceededException {
        Iterator<Index> i = this.tables.values().iterator();
        ArrayList<RowCollection> report = new ArrayList<RowCollection>();
        while (i.hasNext()) {
            report.addAll(i.next().removeDoubles());
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(byte[] key) throws IOException {
        Index table = this.keeperOf(key);
        if (table == null) {
            return false;
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            return table.delete(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry remove(byte[] key) throws IOException {
        Index table = this.keeperOf(key);
        if (table == null) {
            return null;
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            return table.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry removeOne() throws IOException {
        Iterator<Index> i = this.tables.values().iterator();
        Index maxtable = null;
        int maxcount = -1;
        while (i.hasNext()) {
            Index table = i.next();
            if (table.size() <= maxcount) continue;
            maxtable = table;
            maxcount = table.size();
        }
        if (maxtable == null) {
            return null;
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            return maxtable.removeOne();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row.Entry> top(int count) throws IOException {
        Iterator<Index> i = this.tables.values().iterator();
        Index maxtable = null;
        int maxcount = -1;
        while (i.hasNext()) {
            Index table = i.next();
            if (table.size() <= maxcount) continue;
            maxtable = table;
            maxcount = table.size();
        }
        if (maxtable == null) {
            return null;
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            return maxtable.top(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row.Entry> random(int count) throws IOException {
        Iterator<Index> i = this.tables.values().iterator();
        Index maxtable = null;
        int maxcount = -1;
        while (i.hasNext()) {
            Index table = i.next();
            if (table.size() <= maxcount) continue;
            maxtable = table;
            maxcount = table.size();
        }
        if (maxtable == null) {
            return null;
        }
        SplitTable splitTable = this;
        synchronized (splitTable) {
            return maxtable.random(count);
        }
    }

    @Override
    public CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        ArrayList c = new ArrayList(this.tables.size());
        Iterator<Index> i = this.tables.values().iterator();
        while (i.hasNext()) {
            CloneableIterator<byte[]> k = i.next().keys(up, firstKey);
            if (k == null) continue;
            c.add(k);
        }
        return MergeIterator.cascade(c, this.rowdef.objectOrder, MergeIterator.simpleMerge, up);
    }

    @Override
    public CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) throws IOException {
        ArrayList c = new ArrayList(this.tables.size());
        Iterator<Index> i = this.tables.values().iterator();
        while (i.hasNext()) {
            c.add(i.next().rows(up, firstKey));
        }
        return MergeIterator.cascade(c, this.entryOrder, MergeIterator.simpleMerge, up);
    }

    @Override
    public Iterator<Row.Entry> iterator() {
        try {
            return this.rows();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public synchronized CloneableIterator<Row.Entry> rows() throws IOException {
        CloneableIterator[] c = (CloneableIterator[])Array.newInstance(CloneableIterator.class, this.tables.size());
        Iterator<Index> i = this.tables.values().iterator();
        int d = 0;
        while (i.hasNext()) {
            c[d++] = i.next().rows();
        }
        return StackIterator.stack(c, null, true);
    }

    @Override
    public synchronized void close() {
        if (this.tables == null) {
            return;
        }
        Iterator<Index> i = this.tables.values().iterator();
        while (i.hasNext()) {
            i.next().close();
        }
        this.tables = null;
    }

    @Override
    public void deleteOnExit() {
        for (Index i : this.tables.values()) {
            i.deleteOnExit();
        }
    }
}

