/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.File;
import java.io.IOException;
import net.yacy.kelondro.io.Reader;

public abstract class AbstractReader
implements Reader {
    protected String name = null;
    protected File file = null;

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public abstract void readFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract long length() throws IOException;

    @Override
    public abstract long available() throws IOException;

    @Override
    public abstract void seek(long var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public final byte[] readFully() throws IOException {
        long a = this.available();
        if (a <= 0L) {
            return null;
        }
        if (a > Integer.MAX_VALUE) {
            throw new IOException("available too large for a single array");
        }
        byte[] buffer = new byte[(int)a];
        this.readFully(buffer, 0, (int)a);
        return buffer;
    }

    @Override
    public final short readShort() throws IOException {
        byte[] b = new byte[2];
        this.readFully(b, 0, 2);
        return (short)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        byte[] b = new byte[4];
        this.readFully(b, 0, 4);
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }
}

