/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.storage.HandleMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.RAMIndexCluster;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.util.NamePrefixThreadFactory;
import net.yacy.kelondro.workflow.WorkflowProcessor;

public final class RowHandleMap
implements HandleMap,
Iterable<Map.Entry<byte[], Long>> {
    private final Row rowdef;
    private RAMIndexCluster index;
    protected static final entry poisonEntry = new entry(new byte[0], 0L);

    public RowHandleMap(int keylength, ByteOrder objectOrder, int idxbytes, int expectedspace, String name) {
        this.rowdef = new Row(new Column[]{new Column("key", 2, 3, keylength, "key"), new Column("long c-" + idxbytes + " {b256}")}, objectOrder);
        this.index = new RAMIndexCluster(name, this.rowdef, RowHandleMap.spread(expectedspace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowHandleMap(int keylength, ByteOrder objectOrder, int idxbytes, File file) throws IOException, SpaceExceededException {
        this(keylength, objectOrder, idxbytes, (int)(file.length() / (long)(keylength + idxbytes)), file.getAbsolutePath());
        InputStream is;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            is = new BufferedInputStream(fis, 0x100000);
        }
        catch (OutOfMemoryError e) {
            is = fis != null ? fis : new FileInputStream(file);
        }
        try {
            int c;
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            byte[] a = new byte[keylength + idxbytes];
            while ((c = is.read(a)) > 0) {
                Row.Entry entry2 = this.rowdef.newEntry(a);
                if (entry2 == null) continue;
                this.index.addUnique(entry2);
            }
        }
        finally {
            is.close();
        }
        is = null;
        assert ((long)this.index.size() == file.length() / (long)(keylength + idxbytes));
        this.optimize();
    }

    @Override
    public void optimize() {
        this.index.optimize();
    }

    @Override
    public long mem() {
        return this.index.mem();
    }

    private static final int spread(int expectedspace) {
        return Math.min(WorkflowProcessor.availableCPU, Math.max(WorkflowProcessor.availableCPU, expectedspace / 8000));
    }

    public final int[] saturation() {
        int valm = this.rowdef.width(1);
        byte[] lastk = null;
        int keym = 0;
        CloneableIterator<Row.Entry> i = this.rows(true, null);
        while (i.hasNext()) {
            int valc;
            Row.Entry row = (Row.Entry)i.next();
            if (lastk == null) {
                lastk = row.bytes();
            } else {
                byte[] thisk = row.bytes();
                keym = Math.max(keym, RowHandleMap.eq(lastk, thisk));
                lastk = thisk;
            }
            for (valc = this.rowdef.primaryKeyLength; valc < this.rowdef.objectsize && lastk[valc] == 0; ++valc) {
            }
            valm = Math.min(valm, valc - this.rowdef.primaryKeyLength);
        }
        return new int[]{keym, this.rowdef.width(1) - valm};
    }

    private static final int eq(byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return i;
        }
        return a.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int dump(File file) throws IOException {
        File tmp = new File(file.getParentFile(), file.getName() + ".prt");
        CloneableIterator<Row.Entry> i = this.index.rows(true, null);
        int c = 0;
        FileOutputStream fileStream = new FileOutputStream(tmp);
        OutputStream os = null;
        try {
            try {
                os = new BufferedOutputStream(fileStream, 0x400000);
            }
            catch (OutOfMemoryError e) {
                os = fileStream;
            }
            if (file.getName().endsWith(".gz")) {
                os = new GZIPOutputStream(os, 65536){
                    {
                        this.def.setLevel(9);
                    }
                };
            }
            while (i.hasNext()) {
                os.write(((Row.Entry)i.next()).bytes());
                ++c;
            }
            os.flush();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            finally {
                if (fileStream != os) {
                    fileStream.close();
                }
            }
        }
        tmp.renameTo(file);
        assert (file.exists()) : file.toString();
        assert (!tmp.exists()) : tmp.toString();
        return c;
    }

    public final Row row() {
        return this.index.row();
    }

    @Override
    public final void clear() {
        this.index.clear();
    }

    @Override
    public final byte[] smallestKey() {
        return this.index.smallestKey();
    }

    @Override
    public final byte[] largestKey() {
        return this.index.largestKey();
    }

    @Override
    public final boolean has(byte[] key) {
        assert (key != null);
        return this.index.has(key);
    }

    @Override
    public final long get(byte[] key) {
        assert (key != null);
        Row.Entry indexentry = this.index.get(key, false);
        if (indexentry == null) {
            return -1L;
        }
        return indexentry.getColLong(1);
    }

    @Override
    public final long put(byte[] key, long l) throws SpaceExceededException {
        assert (l >= 0L) : "l = " + l;
        assert (key != null);
        Row.Entry newentry = this.rowdef.newEntry();
        newentry.setCol(0, key);
        newentry.setCol(1, l);
        Row.Entry oldentry = this.index.replace(newentry);
        if (oldentry == null) {
            return -1L;
        }
        return oldentry.getColLong(1);
    }

    @Override
    public final void putUnique(byte[] key, long l) throws SpaceExceededException {
        assert (l >= 0L) : "l = " + l;
        assert (key != null);
        Row.Entry newentry = this.rowdef.newEntry();
        newentry.setCol(0, key);
        newentry.setCol(1, l);
        this.index.addUnique(newentry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long add(byte[] key, long a) throws SpaceExceededException {
        assert (key != null);
        assert (a >= 0L);
        RAMIndexCluster rAMIndexCluster = this.index;
        synchronized (rAMIndexCluster) {
            Row.Entry indexentry = this.index.get(key, true);
            if (indexentry == null) {
                Row.Entry newentry = this.rowdef.newEntry();
                newentry.setCol(0, key);
                newentry.setCol(1, a);
                this.index.addUnique(newentry);
                return 1L;
            }
            long i = indexentry.getColLong(1) + a;
            indexentry.setCol(1, i);
            this.index.put(indexentry);
            return i;
        }
    }

    @Override
    public final long inc(byte[] key) throws SpaceExceededException {
        return this.add(key, 1L);
    }

    @Override
    public final long dec(byte[] key) throws SpaceExceededException {
        return this.add(key, -1L);
    }

    @Override
    public final ArrayList<long[]> removeDoubles() throws SpaceExceededException {
        ArrayList<long[]> report = new ArrayList<long[]>();
        int initialSize = this.size();
        List rd = this.index.removeDoubles();
        for (RowCollection rowset : rd) {
            long[] is = new long[rowset.size()];
            int c = 0;
            for (Row.Entry e : rowset) {
                long l = e.getColLong(1);
                assert (l < (long)initialSize) : "l = " + l + ", initialSize = " + initialSize;
                is[c++] = l;
            }
            report.add(is);
        }
        return report;
    }

    @Override
    public final ArrayList<byte[]> top(int count) {
        List<Row.Entry> list0 = this.index.top(count);
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        for (Row.Entry entry2 : list0) {
            list2.add(entry2.getPrimaryKeyBytes());
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized long remove(byte[] key) {
        Row.Entry indexentry;
        assert (key != null);
        RAMIndexCluster rAMIndexCluster = this.index;
        synchronized (rAMIndexCluster) {
            boolean exist = this.index.has(key);
            if (!exist) {
                return -1L;
            }
            indexentry = this.index.remove(key);
            assert (indexentry != null);
        }
        if (indexentry == null) {
            return -1L;
        }
        return indexentry.getColLong(1);
    }

    @Override
    public final long removeone() {
        Row.Entry indexentry = this.index.removeOne();
        if (indexentry == null) {
            return -1L;
        }
        return indexentry.getColLong(1);
    }

    @Override
    public final int size() {
        return this.index.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public final CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) {
        return this.index.keys(up, firstKey);
    }

    public final CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) {
        return this.index.rows(up, firstKey);
    }

    @Override
    public final void close() {
        this.index.close();
        this.index = null;
    }

    public static final initDataConsumer asynchronusInitializer(String name, int keylength, ByteOrder objectOrder, int idxbytes, int expectedspace) {
        initDataConsumer initializer = new initDataConsumer(new RowHandleMap(keylength, objectOrder, idxbytes, expectedspace, name));
        ExecutorService service = Executors.newSingleThreadExecutor(new NamePrefixThreadFactory("RowHandleMap.initDataConsumer"));
        initializer.setResult(service.submit(initializer));
        service.shutdown();
        return initializer;
    }

    @Override
    public Iterator<Map.Entry<byte[], Long>> iterator() {
        final Iterator<Row.Entry> i = this.index.iterator();
        return new Iterator<Map.Entry<byte[], Long>>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Map.Entry<byte[], Long> next() {
                Row.Entry row = (Row.Entry)i.next();
                return new AbstractMap.SimpleEntry<byte[], Long>(row.getPrimaryKeyBytes(), row.getColLong(1));
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    public static final class initDataConsumer
    implements Callable<RowHandleMap> {
        private final BlockingQueue<entry> cache;
        private final RowHandleMap map;
        private Future<RowHandleMap> result;

        public initDataConsumer(RowHandleMap map) {
            this.map = map;
            this.cache = new LinkedBlockingQueue<entry>();
        }

        protected final void setResult(Future<RowHandleMap> result) {
            this.result = result;
        }

        public final void consume(byte[] key, long l) {
            while (true) {
                try {
                    this.cache.put(new entry(key, l));
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }

        public final void finish() {
            while (true) {
                try {
                    this.cache.put(poisonEntry);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }

        public final RowHandleMap result() throws InterruptedException, ExecutionException {
            return this.result.get();
        }

        @Override
        public final RowHandleMap call() throws IOException {
            try {
                while (true) {
                    try {
                        entry c;
                        while ((c = this.cache.take()) != poisonEntry) {
                            this.map.putUnique(c.key, c.l);
                        }
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
            return this.map;
        }

        public synchronized void close() {
            this.map.close();
        }
    }

    private static final class entry {
        public byte[] key;
        public long l;

        public entry(byte[] key, long l) {
            this.key = key;
            this.l = l;
        }
    }
}

