/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.util.MemoryControl;

public final class Cache
implements Index,
Iterable<Row.Entry> {
    private static final TreeMap<String, Cache> objectTracker = new TreeMap();
    private static final long memStopGrow = 0x2800000L;
    private static final long memStartShrink = 0x1400000L;
    private final Index index;
    private RowSet readHitCache;
    private RowSet readMissCache;
    private Row keyrow;
    private int readHit;
    private int readMiss;
    private int writeUnique;
    private int writeDouble;
    private int cacheDelete;
    private int cacheFlush;
    private int hasnotHit;
    private int hasnotMiss;
    private int hasnotUnique;
    private int hasnotDouble;
    private int hasnotDelete;
    private final int hitLimit;
    private final int missLimit;

    public Cache(Index backupIndex, int hitLimit, int missLimit) {
        this.index = backupIndex;
        this.hitLimit = hitLimit;
        this.missLimit = missLimit;
        this.init();
        objectTracker.put(backupIndex.filename(), this);
    }

    private void init() {
        Row row = this.index.row();
        this.keyrow = new Row(new Column[]{row.column(0)}, row.objectOrder);
        this.readHitCache = new RowSet(row);
        this.readMissCache = new RowSet(this.keyrow);
        this.readHit = 0;
        this.readMiss = 0;
        this.writeUnique = 0;
        this.writeDouble = 0;
        this.cacheDelete = 0;
        this.cacheFlush = 0;
        this.hasnotHit = 0;
        this.hasnotMiss = 0;
        this.hasnotUnique = 0;
        this.hasnotDouble = 0;
        this.hasnotDelete = 0;
    }

    @Override
    public long mem() {
        return this.index.mem() + this.readHitCache.mem() + this.readMissCache.mem();
    }

    @Override
    public void optimize() {
        this.index.optimize();
        this.readHitCache.optimize();
        this.readMissCache.optimize();
    }

    public final int writeBufferSize() {
        return 0;
    }

    public static final long getMemStopGrow() {
        return 0x2800000L;
    }

    public static final long getMemStartShrink() {
        return 0x1400000L;
    }

    public final int getHitLimit() {
        return this.hitLimit;
    }

    public final int getMissLimit() {
        return this.missLimit;
    }

    @Override
    public byte[] smallestKey() {
        return this.index.smallestKey();
    }

    @Override
    public byte[] largestKey() {
        return this.index.largestKey();
    }

    public static final Iterator<String> filenames() {
        return objectTracker.keySet().iterator();
    }

    public static final Map<StatKeys, String> memoryStats(String filename) {
        Cache theObjectsCache = objectTracker.get(filename);
        return theObjectsCache.memoryStats();
    }

    private final Map<StatKeys, String> memoryStats() {
        HashMap<StatKeys, String> map = new HashMap<StatKeys, String>(20);
        map.put(StatKeys.objectHitChunkSize, this.readHitCache == null ? "0" : Integer.toString(this.readHitCache.rowdef.objectsize));
        map.put(StatKeys.objectHitCacheCount, this.readHitCache == null ? "0" : Integer.toString(this.readHitCache.size()));
        map.put(StatKeys.objectHitMem, this.readHitCache == null ? "0" : Long.toString(this.readHitCache.rowdef.objectsize * this.readHitCache.size()));
        map.put(StatKeys.objectHitCacheReadHit, Integer.toString(this.readHit));
        map.put(StatKeys.objectHitCacheReadMiss, Integer.toString(this.readMiss));
        map.put(StatKeys.objectHitCacheWriteUnique, Integer.toString(this.writeUnique));
        map.put(StatKeys.objectHitCacheWriteDouble, Integer.toString(this.writeDouble));
        map.put(StatKeys.objectHitCacheDeletes, Integer.toString(this.cacheDelete));
        map.put(StatKeys.objectHitCacheFlushes, Integer.toString(this.cacheFlush));
        map.put(StatKeys.objectMissChunkSize, this.readMissCache == null ? "0" : Integer.toString(this.readMissCache.rowdef.objectsize));
        map.put(StatKeys.objectMissCacheCount, this.readMissCache == null ? "0" : Integer.toString(this.readMissCache.size()));
        map.put(StatKeys.objectMissMem, this.readMissCache == null ? "0" : Long.toString(this.readMissCache.rowdef.objectsize * this.readMissCache.size()));
        map.put(StatKeys.objectMissCacheReadHit, Integer.toString(this.hasnotHit));
        map.put(StatKeys.objectMissCacheReadMiss, Integer.toString(this.hasnotMiss));
        map.put(StatKeys.objectMissCacheWriteUnique, Integer.toString(this.hasnotUnique));
        map.put(StatKeys.objectMissCacheWriteDouble, Integer.toString(this.hasnotDouble));
        map.put(StatKeys.objectMissCacheDeletes, Integer.toString(this.hasnotDelete));
        map.put(StatKeys.objectMissCacheFlushes, "0");
        return map;
    }

    private final boolean checkMissSpace() {
        if (this.readMissCache == null) {
            return false;
        }
        if (this.missLimit > 0 && this.readMissCache.size() >= this.missLimit) {
            return false;
        }
        long available = MemoryControl.available();
        if (MemoryControl.shortStatus() || available - 0x200000L < this.readMissCache.memoryNeededForGrow()) {
            this.readMissCache.clear();
        }
        return (available = MemoryControl.available()) - 0x200000L > this.readMissCache.memoryNeededForGrow();
    }

    private final boolean checkHitSpace() {
        if (this.readHitCache == null) {
            return false;
        }
        if (this.hitLimit > 0 && this.readHitCache.size() >= this.hitLimit) {
            return false;
        }
        long available = MemoryControl.available();
        if (MemoryControl.shortStatus() || available - 0x200000L < this.readHitCache.memoryNeededForGrow()) {
            this.readHitCache.clear();
        }
        return (available = MemoryControl.available()) - 0x200000L > this.readHitCache.memoryNeededForGrow();
    }

    public final synchronized void clearCache() {
        if (this.readMissCache != null) {
            this.readMissCache.clear();
        }
        if (this.readHitCache != null) {
            this.readHitCache.clear();
        }
    }

    @Override
    public final synchronized void close() {
        this.index.close();
        this.readHitCache = null;
        this.readMissCache = null;
    }

    @Override
    public final synchronized boolean has(byte[] key) {
        if (this.readMissCache != null) {
            if (this.readMissCache.has(key)) {
                ++this.hasnotHit;
                return false;
            }
            ++this.hasnotMiss;
        }
        if (this.readHitCache != null) {
            if (this.readHitCache.has(key)) {
                ++this.readHit;
                return true;
            }
            ++this.readMiss;
        }
        return this.index.has(key);
    }

    @Override
    public final synchronized Row.Entry get(byte[] key, boolean cachecopy) throws IOException {
        if (this.readMissCache != null) {
            if (this.readMissCache.has(key)) {
                ++this.hasnotHit;
                return null;
            }
            ++this.hasnotMiss;
        }
        Row.Entry entry2 = null;
        if (this.readHitCache != null && (entry2 = this.readHitCache.get(key, cachecopy)) != null) {
            ++this.readHit;
            return entry2;
        }
        ++this.readMiss;
        entry2 = this.index.get(key, cachecopy);
        if (entry2 == null) {
            if (this.checkMissSpace()) {
                try {
                    Row.Entry dummy = this.readMissCache.replace(this.readMissCache.row().newEntry(key));
                    if (dummy == null) {
                        ++this.hasnotUnique;
                    } else {
                        ++this.hasnotDouble;
                    }
                }
                catch (SpaceExceededException e) {
                    this.clearCache();
                }
            }
            return null;
        }
        if (this.checkHitSpace()) {
            try {
                Row.Entry dummy = this.readHitCache.replace(entry2);
                if (dummy == null) {
                    ++this.writeUnique;
                } else {
                    ++this.writeDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
        return entry2;
    }

    @Override
    public Map<byte[], Row.Entry> getMap(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public List<Row.Entry> getList(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>(keys.size());
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            list2.add(entry2);
        }
        return list2;
    }

    @Override
    public final synchronized boolean put(Row.Entry row) throws IOException, SpaceExceededException {
        boolean c;
        assert (row != null);
        assert (row.columns() == this.row().columns());
        byte[] key = row.getPrimaryKeyBytes();
        this.checkHitSpace();
        if (this.readMissCache != null && this.readMissCache.delete(key)) {
            ++this.hasnotHit;
        }
        try {
            c = this.index.put(row);
        }
        catch (SpaceExceededException e1) {
            this.clearCache();
            c = this.index.put(row);
        }
        if (this.checkHitSpace()) {
            try {
                Row.Entry dummy = this.readHitCache.replace(row);
                if (dummy == null) {
                    ++this.writeUnique;
                } else {
                    ++this.writeDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
        return c;
    }

    @Override
    public final synchronized Row.Entry replace(Row.Entry row) throws IOException, SpaceExceededException {
        assert (row != null);
        assert (row.columns() == this.row().columns());
        byte[] key = row.getPrimaryKeyBytes();
        this.checkHitSpace();
        if (this.readMissCache != null && this.readMissCache.delete(key)) {
            ++this.hasnotHit;
            try {
                this.index.put(row);
            }
            catch (SpaceExceededException e1) {
                this.clearCache();
                this.index.put(row);
            }
            if (this.checkHitSpace()) {
                try {
                    Row.Entry dummy = this.readHitCache.replace(row);
                    if (dummy == null) {
                        ++this.writeUnique;
                    } else {
                        ++this.writeDouble;
                    }
                }
                catch (SpaceExceededException e) {
                    this.clearCache();
                }
            }
            return null;
        }
        Row.Entry entry2 = null;
        try {
            entry2 = this.index.replace(row);
        }
        catch (SpaceExceededException e1) {
            this.clearCache();
            this.index.replace(row);
        }
        if (this.checkHitSpace()) {
            try {
                Row.Entry dummy = this.readHitCache.replace(row);
                if (dummy == null) {
                    ++this.writeUnique;
                } else {
                    ++this.writeDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
        return entry2;
    }

    @Override
    public final synchronized void addUnique(Row.Entry row) throws IOException, SpaceExceededException {
        assert (row != null);
        assert (row.columns() == this.row().columns());
        byte[] key = row.getPrimaryKeyBytes();
        this.checkHitSpace();
        if (this.readMissCache != null) {
            this.readMissCache.delete(key);
            ++this.hasnotDelete;
        }
        try {
            this.index.addUnique(row);
        }
        catch (SpaceExceededException e1) {
            this.clearCache();
            this.index.addUnique(row);
        }
        if (this.checkHitSpace()) {
            try {
                Row.Entry dummy = this.readHitCache.replace(row);
                if (dummy == null) {
                    ++this.writeUnique;
                } else {
                    ++this.writeDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
    }

    public final synchronized void addUnique(Row.Entry row, Date entryDate) throws IOException, SpaceExceededException {
        if (entryDate == null) {
            this.addUnique(row);
            return;
        }
        assert (row != null);
        assert (row.columns() == this.row().columns());
        byte[] key = row.getPrimaryKeyBytes();
        this.checkHitSpace();
        if (this.readMissCache != null) {
            this.readMissCache.delete(key);
            ++this.hasnotDelete;
        }
        try {
            this.index.addUnique(row);
        }
        catch (SpaceExceededException e1) {
            this.clearCache();
            this.index.addUnique(row);
        }
        if (this.checkHitSpace()) {
            try {
                Row.Entry dummy = this.readHitCache.replace(row);
                if (dummy == null) {
                    ++this.writeUnique;
                } else {
                    ++this.writeDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
    }

    public final synchronized void addUnique(List<Row.Entry> rows) throws IOException, SpaceExceededException {
        for (Row.Entry r : rows) {
            try {
                this.addUnique(r);
            }
            catch (SpaceExceededException e) {
                this.clearCache();
                this.addUnique(r);
            }
        }
    }

    @Override
    public final synchronized List<RowCollection> removeDoubles() throws IOException, SpaceExceededException {
        return this.index.removeDoubles();
    }

    @Override
    public final synchronized boolean delete(byte[] key) throws IOException {
        this.checkMissSpace();
        if (this.checkMissSpace()) {
            try {
                Row.Entry dummy = this.readMissCache.replace(this.readMissCache.row().newEntry(key));
                if (dummy == null) {
                    ++this.hasnotUnique;
                } else {
                    ++this.hasnotHit;
                    ++this.hasnotDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
        if (this.readHitCache != null) {
            Row.Entry entry2 = this.readHitCache.remove(key);
            if (entry2 == null) {
                ++this.readMiss;
            } else {
                ++this.readHit;
                ++this.cacheDelete;
            }
        }
        return this.index.delete(key);
    }

    @Override
    public final synchronized Row.Entry remove(byte[] key) throws IOException {
        this.checkMissSpace();
        if (this.checkMissSpace()) {
            try {
                Row.Entry dummy = this.readMissCache.replace(this.readMissCache.row().newEntry(key));
                if (dummy == null) {
                    ++this.hasnotUnique;
                } else {
                    ++this.hasnotHit;
                    ++this.hasnotDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
        if (this.readHitCache != null) {
            Row.Entry entry2 = this.readHitCache.remove(key);
            if (entry2 == null) {
                ++this.readMiss;
            } else {
                ++this.readHit;
                ++this.cacheDelete;
            }
        }
        return this.index.remove(key);
    }

    @Override
    public final synchronized Row.Entry removeOne() throws IOException {
        this.checkMissSpace();
        Row.Entry entry2 = this.index.removeOne();
        if (entry2 == null) {
            return null;
        }
        byte[] key = entry2.getPrimaryKeyBytes();
        if (this.checkMissSpace()) {
            try {
                Row.Entry dummy = this.readMissCache.replace(this.readMissCache.row().newEntry(key));
                if (dummy == null) {
                    ++this.hasnotUnique;
                } else {
                    ++this.hasnotDouble;
                }
            }
            catch (SpaceExceededException e) {
                this.clearCache();
            }
        }
        if (this.readHitCache != null && this.readHitCache.delete(key)) {
            ++this.cacheDelete;
        }
        return entry2;
    }

    @Override
    public synchronized List<Row.Entry> top(int count) throws IOException {
        return this.index.top(count);
    }

    @Override
    public synchronized List<Row.Entry> random(int count) throws IOException {
        return this.index.random(count);
    }

    @Override
    public final synchronized Row row() {
        return this.index.row();
    }

    @Override
    public final synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        return this.index.keys(up, firstKey);
    }

    @Override
    public final synchronized CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) throws IOException {
        return this.index.rows(up, firstKey);
    }

    @Override
    public final Iterator<Row.Entry> iterator() {
        try {
            return this.rows();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final synchronized CloneableIterator<Row.Entry> rows() throws IOException {
        return this.index.rows();
    }

    @Override
    public final int size() {
        return this.index.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public final String filename() {
        return this.index.filename();
    }

    @Override
    public final void clear() throws IOException {
        this.index.clear();
        this.init();
    }

    @Override
    public final void deleteOnExit() {
        this.index.deleteOnExit();
    }

    public static enum StatKeys {
        objectHitChunkSize,
        objectHitCacheCount,
        objectHitMem,
        objectHitCacheReadHit,
        objectHitCacheReadMiss,
        objectHitCacheWriteUnique,
        objectHitCacheWriteDouble,
        objectHitCacheDeletes,
        objectHitCacheFlushes,
        objectMissChunkSize,
        objectMissCacheCount,
        objectMissMem,
        objectMissCacheReadHit,
        objectMissCacheReadMiss,
        objectMissCacheWriteUnique,
        objectMissCacheWriteDouble,
        objectMissCacheDeletes,
        objectMissCacheFlushes;

    }
}

