/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Stack;

public class Stacks {
    File stacksLocation;
    String stacksPrefix;
    private final ConcurrentHashMap<String, StackInstance> stacks;

    public Stacks(File stacksLocation, String stacksPrefix) {
        String[] sl;
        if (!stacksLocation.exists()) {
            stacksLocation.mkdirs();
        }
        assert (stacksLocation.isDirectory());
        this.stacksLocation = stacksLocation;
        this.stacksPrefix = stacksPrefix;
        this.stacks = new ConcurrentHashMap();
        for (String s : sl = this.stacksLocation.list()) {
            if (!s.startsWith(this.stacksPrefix + "_")) continue;
            try {
                StackInstance si = new StackInstance(new File(this.stacksLocation, s));
                this.stacks.put(si.name, si);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    private Stack getStack(String stack) {
        StackInstance si = this.stacks.get(stack);
        if (si == null) {
            try {
                si = new StackInstance(stack);
                this.stacks.put(stack, si);
                return si.stack;
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }
        return si.stack;
    }

    public int size() {
        return this.stacks.size();
    }

    public Iterator<String> stacks() {
        return ((ConcurrentHashMap.KeySetView)this.stacks.keySet()).iterator();
    }

    public int size(String stack) {
        Stack s = this.getStack(stack);
        if (s == null) {
            return -1;
        }
        return s.size();
    }

    public synchronized Iterator<Long> handles(String stack) throws IOException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return null;
        }
        return s.handles();
    }

    public long push(String stack, byte[] b) throws IOException, SpaceExceededException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return -1L;
        }
        return s.push(b);
    }

    protected void push(String stack, Stack.Entry e) throws IOException, SpaceExceededException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return;
        }
        s.push(e);
    }

    public byte[] get(String stack, long handle) throws IOException, SpaceExceededException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return null;
        }
        return s.get(handle);
    }

    public byte[] remove(String stack, long handle) throws IOException, SpaceExceededException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return null;
        }
        return s.remove(handle);
    }

    public Stack.Entry pop(String stack) throws IOException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return null;
        }
        return s.pop();
    }

    public Stack.Entry top(String stack) throws IOException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return null;
        }
        return s.top();
    }

    public Stack.Entry pot(String stack) throws IOException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return null;
        }
        return s.pot();
    }

    public Stack.Entry bot(String stack) throws IOException {
        Stack s = this.getStack(stack);
        if (s == null) {
            return null;
        }
        return s.bot();
    }

    public synchronized void close() {
        for (StackInstance se : this.stacks.values()) {
            se.stack.close();
        }
    }

    private class StackInstance {
        public String name;
        public Stack stack;

        public StackInstance(File location) throws IOException {
            String filename = location.getName();
            assert (filename.startsWith(Stacks.this.stacksPrefix + "_"));
            assert (filename.endsWith(".bstack"));
            this.name = filename.substring(Stacks.this.stacksPrefix.length() + 1, filename.length() - 7);
            this.stack = new Stack(location);
        }

        public StackInstance(String stack) throws IOException {
            this.name = stack;
            this.stack = new Stack(new File(Stacks.this.stacksLocation, Stacks.this.stacksPrefix + "_" + stack + ".bstack"));
        }
    }
}

