/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.sorting.ConcurrentScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.MapColumnIndex;
import net.yacy.kelondro.blob.MapHeap;

public class MapDataMining
extends MapHeap {
    private static final Long LONG0;
    private static final Float FLOAT0;
    private final String[] sortfields;
    private final String[] longaccfields;
    private final String[] floataccfields;
    private Map<String, ScoreMap<String>> sortClusterMap;
    private Map<String, Long> accLong;
    private Map<String, Float> accFloat;
    private final MapColumnIndex columnIndex;
    private static final long minutemillis = 60000L;
    private static long date2000;
    private static final byte[] plainByteArray;

    public MapDataMining(File heapFile, int keylength, ByteOrder ordering, int buffermax, int cachesize, String[] sortfields, String[] longaccfields, String[] floataccfields) throws IOException {
        super(heapFile, keylength, ordering, buffermax, cachesize, ' ');
        int i;
        this.sortfields = sortfields;
        this.longaccfields = longaccfields;
        this.floataccfields = floataccfields;
        this.columnIndex = new MapColumnIndex();
        ScoreMap[] cluster = null;
        if (sortfields == null) {
            this.sortClusterMap = null;
        } else {
            this.sortClusterMap = new ConcurrentHashMap<String, ScoreMap<String>>();
            cluster = (ScoreMap[])Array.newInstance(ScoreMap.class, sortfields.length);
            for (int i2 = 0; i2 < sortfields.length; ++i2) {
                cluster[i2] = new ConcurrentScoreMap();
            }
        }
        Long[] longaccumulator = null;
        Float[] floataccumulator = null;
        if (longaccfields == null) {
            this.accLong = null;
        } else {
            this.accLong = new ConcurrentHashMap<String, Long>();
            longaccumulator = new Long[longaccfields.length];
            for (i = 0; i < longaccfields.length; ++i) {
                longaccumulator[i] = LONG0;
            }
        }
        if (floataccfields == null) {
            this.accFloat = null;
        } else {
            this.accFloat = new ConcurrentHashMap<String, Float>();
            floataccumulator = new Float[floataccfields.length];
            for (i = 0; i < floataccfields.length; ++i) {
                floataccumulator[i] = FLOAT0;
            }
        }
        if (sortfields != null || longaccfields != null || floataccfields != null) {
            try {
                CloneableIterator<byte[]> it = super.keys(true, false);
                while (it.hasNext()) {
                    Map<String, String> map;
                    byte[] mapnameb = (byte[])it.next();
                    try {
                        map = super.get(mapnameb);
                    }
                    catch (SpaceExceededException e) {
                        ConcurrentLog.warn("KELONDRO", "MapDataMining: " + e.getMessage());
                        break;
                    }
                    if (map != null) {
                        String cell;
                        int i3;
                        if (sortfields != null && cluster != null) {
                            for (i3 = 0; i3 < sortfields.length; ++i3) {
                                cell = map.get(sortfields[i3]);
                                if (cell == null) continue;
                                cluster[i3].set(UTF8.String(mapnameb), MapDataMining.object2score(cell));
                            }
                        }
                        if (longaccfields != null && longaccumulator != null) {
                            for (i3 = 0; i3 < longaccfields.length; ++i3) {
                                cell = map.get(longaccfields[i3]);
                                long valuel = 0L;
                                if (cell == null) continue;
                                try {
                                    valuel = Long.parseLong(cell);
                                    longaccumulator[i3] = longaccumulator[i3] + valuel;
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (floataccfields == null || floataccumulator == null) continue;
                        for (i3 = 0; i3 < floataccfields.length; ++i3) {
                            cell = map.get(floataccfields[i3]);
                            float valued = 0.0f;
                            if (cell == null) continue;
                            try {
                                valued = Float.parseFloat(cell);
                                floataccumulator[i3] = Float.valueOf(floataccumulator[i3].floatValue() + valued);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException it) {
                // empty catch block
            }
        }
        if (sortfields != null && cluster != null) {
            for (int i4 = 0; i4 < sortfields.length; ++i4) {
                this.sortClusterMap.put(sortfields[i4], cluster[i4]);
            }
        }
        if (longaccfields != null && longaccumulator != null) {
            for (int i5 = 0; i5 < longaccfields.length; ++i5) {
                this.accLong.put(longaccfields[i5], longaccumulator[i5]);
            }
        }
        if (floataccfields != null && floataccumulator != null) {
            for (int i6 = 0; i6 < floataccfields.length; ++i6) {
                this.accFloat.put(floataccfields[i6], floataccumulator[i6]);
            }
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.sortfields == null) {
            this.sortClusterMap = null;
        } else {
            this.sortClusterMap = new HashMap<String, ScoreMap<String>>();
            for (String sortfield : this.sortfields) {
                this.sortClusterMap.put(sortfield, new ConcurrentScoreMap());
            }
        }
        if (this.longaccfields == null) {
            this.accLong = null;
        } else {
            this.accLong = new HashMap<String, Long>();
            for (String longaccfield : this.longaccfields) {
                this.accLong.put(longaccfield, LONG0);
            }
        }
        if (this.floataccfields == null) {
            this.accFloat = null;
        } else {
            this.accFloat = new HashMap<String, Float>();
            for (String floataccfield : this.floataccfields) {
                this.accFloat.put(floataccfield, FLOAT0);
            }
        }
        this.columnIndex.clear();
    }

    @Override
    public synchronized void insert(byte[] key, Map<String, String> newMap) throws IOException, SpaceExceededException {
        assert (key != null);
        assert (key.length > 0);
        assert (newMap != null);
        if (this.longaccfields != null || this.floataccfields != null) {
            Map<String, String> oldMap = super.get(key, false);
            if (oldMap != null) {
                this.updateAcc(oldMap, false);
            }
            this.updateAcc(newMap, true);
        }
        super.insert(key, newMap);
        if (this.sortClusterMap != null) {
            this.updateSortCluster(UTF8.String(key), newMap);
        }
        this.columnIndex.update(key, newMap);
    }

    private void updateAcc(Map<String, String> map, boolean add) {
        String value;
        if (this.longaccfields != null) {
            for (String longaccfield : this.longaccfields) {
                value = map.get(longaccfield);
                if (value == null) continue;
                try {
                    long valuel = Long.parseLong(value);
                    Long longaccumulator = this.accLong.get(longaccfield);
                    if (add) {
                        this.accLong.put(longaccfield, longaccumulator + valuel);
                        continue;
                    }
                    this.accLong.put(longaccfield, longaccumulator - valuel);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.floataccfields != null) {
            for (String floataccfield : this.floataccfields) {
                value = map.get(floataccfield);
                if (value == null) continue;
                try {
                    float valued = Float.parseFloat(value);
                    Float floataccumulator = this.accFloat.get(floataccfield);
                    if (add) {
                        this.accFloat.put(floataccfield, Float.valueOf(floataccumulator.floatValue() + valued));
                        continue;
                    }
                    this.accFloat.put(floataccfield, Float.valueOf(floataccumulator.floatValue() - valued));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void updateSortCluster(String key, Map<String, String> map) {
        for (String sortfield : this.sortfields) {
            String cell = map.get(sortfield);
            if (cell == null) continue;
            ScoreMap<String> cluster = this.sortClusterMap.get(sortfield);
            cluster.set(key, MapDataMining.object2score(cell));
            this.sortClusterMap.put(sortfield, cluster);
        }
    }

    @Override
    public synchronized void delete(byte[] key) throws IOException {
        if (key == null) {
            return;
        }
        if (this.sortfields != null || this.longaccfields != null || this.floataccfields != null) {
            try {
                Map<String, String> map = super.get(key, false);
                if (map != null) {
                    if (this.longaccfields != null || this.floataccfields != null) {
                        this.updateAcc(map, false);
                    }
                    if (this.sortfields != null) {
                        this.deleteSortCluster(UTF8.String(key));
                    }
                }
            }
            catch (SpaceExceededException e) {
                Object map = null;
                ConcurrentLog.logException(e);
            }
        }
        super.delete(key);
        this.columnIndex.delete(key);
    }

    private void deleteSortCluster(String key) {
        if (key == null) {
            return;
        }
        for (String sortfield : this.sortfields) {
            ScoreMap<String> cluster = this.sortClusterMap.get(sortfield);
            cluster.delete(key);
            this.sortClusterMap.put(sortfield, cluster);
        }
    }

    private synchronized Iterator<byte[]> keys(boolean up, String field) {
        if (this.sortClusterMap == null) {
            return null;
        }
        ScoreMap<String> cluster = this.sortClusterMap.get(field);
        if (cluster == null) {
            return null;
        }
        return new string2bytearrayIterator(cluster.keys(up));
    }

    private synchronized Iterator<byte[]> keys() throws IOException {
        return super.keys(true, null);
    }

    public synchronized Collection<byte[]> select(String whereKey, String isValue) throws IOException {
        Collection<byte[]> idx2 = null;
        try {
            idx2 = this.columnIndex.getIndex(whereKey, isValue);
        }
        catch (UnsupportedOperationException e) {
            this.columnIndex.init(whereKey, isValue, new MapHeap.FullMapIterator(this, this.keys()));
            idx2 = this.columnIndex.getIndex(whereKey, isValue);
        }
        return idx2;
    }

    public synchronized Iterator<Map.Entry<byte[], Map<String, String>>> entries(boolean up, String field) {
        return new MapHeap.FullMapIterator(this, this.keys(up, field));
    }

    public synchronized long getLongAcc(String field) {
        Long accumulator = this.accLong.get(field);
        if (accumulator == null) {
            return -1L;
        }
        return accumulator;
    }

    public synchronized float getFloatAcc(String field) {
        Float accumulator = this.accFloat.get(field);
        if (accumulator == null) {
            return -1.0f;
        }
        return accumulator.floatValue();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public synchronized void close() {
        if (this.sortClusterMap != null) {
            for (String sortfield : this.sortfields) {
                this.sortClusterMap.remove(sortfield);
            }
            this.sortClusterMap = null;
        }
        super.close();
    }

    private static int object2score(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            long l = (Long)o;
            if (l < Integer.MAX_VALUE) {
                return (int)l;
            }
            return (int)(l & Integer.MAX_VALUE);
        }
        if (o instanceof Float) {
            double d = 1000.0f * ((Float)o).floatValue();
            return (int)Math.round(d);
        }
        if (o instanceof Double) {
            double d = 1000.0 * (Double)o;
            return (int)Math.round(d);
        }
        String s = null;
        if (o instanceof String) {
            s = (String)o;
        }
        if (o instanceof byte[]) {
            s = UTF8.String((byte[])o);
        }
        if (s == null || s.isEmpty() || s.charAt(0) == '-') {
            return 0;
        }
        try {
            long l = 0L;
            if (s.length() == "yyyyMMddHHmmss".length()) {
                l = (LocalDateTime.parse(s, GenericFormatter.FORMAT_SHORT_SECOND).toInstant(ZoneOffset.UTC).toEpochMilli() - date2000) / 60000L;
                if (l < 0L) {
                    l = 0L;
                }
            } else {
                l = Long.parseLong(s);
            }
            if (l > Integer.MAX_VALUE) {
                return (int)(l & Integer.MAX_VALUE);
            }
            if (l < 0L) {
                System.out.println("string2score: negative score for input " + s);
                return 0;
            }
            return (int)l;
        }
        catch (Throwable e) {
            int i;
            int len = s.length();
            if (len > 5) {
                len = 5;
            }
            int c = 0;
            for (i = 0; i < len; ++i) {
                c <<= 6;
                c += plainByteArray[(byte)s.charAt(i)];
            }
            for (i = len; i < 5; ++i) {
                c <<= 6;
            }
            if (c < 0) {
                System.out.println("string2score: negative score for input " + s);
                return 0;
            }
            return c;
        }
    }

    public static void main(String[] args) {
        try {
            File f = new File("/tmp/MapDataMinig.test.db");
            f.delete();
            MapDataMining db = new MapDataMining(f, 12, Base64Order.enhancedCoder, 524288, 500, new String[]{"X"}, new String[]{"X"}, new String[0]);
            HashMap<String, String> m1 = new HashMap<String, String>();
            long t = System.currentTimeMillis();
            m1.put("X", Long.toString(t));
            db.put("abcdefghijk1".getBytes(), (Map<String, String>)m1);
            HashMap<String, String> m2 = new HashMap<String, String>();
            m2.put("X", Long.toString(t - 1000L));
            db.put("abcdefghijk2".getBytes(), (Map<String, String>)m2);
            HashMap<String, String> m3 = new HashMap<String, String>();
            m3.put("X", Long.toString(t + 2000L));
            db.put("abcdefghijk3".getBytes(), (Map<String, String>)m3);
            Iterator<byte[]> i1 = db.keys(true, "X");
            while (i1.hasNext()) {
                byte[] k = i1.next();
                System.out.println(new String(k));
            }
            Iterator<Map.Entry<byte[], Map<String, String>>> i2 = db.entries(false, "X");
            while (i2.hasNext()) {
                Map.Entry<byte[], Map<String, String>> e = i2.next();
                System.out.println(UTF8.String(e.getKey()) + ":" + String.valueOf(e.getValue()));
            }
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        int i;
        LONG0 = 0L;
        FLOAT0 = Float.valueOf(0.0f);
        date2000 = 0L;
        try {
            date2000 = ZonedDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        catch (DateTimeException dateTimeException) {
            // empty catch block
        }
        plainByteArray = new byte[256];
        for (i = 0; i < 32; ++i) {
            MapDataMining.plainByteArray[i] = (byte)i;
        }
        for (i = 32; i < 96; ++i) {
            MapDataMining.plainByteArray[i] = (byte)(i - 32);
        }
        for (i = 96; i < 128; ++i) {
            MapDataMining.plainByteArray[i] = (byte)(i - 64);
        }
        for (i = 128; i < 256; ++i) {
            MapDataMining.plainByteArray[i] = (byte)(i & 0x20);
        }
    }

    private static class string2bytearrayIterator
    implements Iterator<byte[]> {
        private final Iterator<String> s;

        private string2bytearrayIterator(Iterator<String> s) {
            this.s = s;
        }

        @Override
        public boolean hasNext() {
            return this.s.hasNext();
        }

        @Override
        public byte[] next() {
            String r = this.s.next();
            if (r == null) {
                return null;
            }
            return UTF8.getBytes(r);
        }

        @Override
        public void remove() {
            this.s.remove();
        }
    }
}

