/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http.servlets;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ChunkedBytes;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.BadTransactionException;
import net.yacy.data.InvalidURLLicenceException;
import net.yacy.http.servlets.DisallowedMethodException;
import net.yacy.http.servlets.TemplateProcessingException;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.peers.Seed;
import net.yacy.peers.graphics.EncodedImage;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.search.Switchboard;
import net.yacy.server.http.HTTPDFileHandler;
import net.yacy.server.http.TemplateEngine;
import net.yacy.server.serverClassLoader;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.server.servletProperties;
import net.yacy.visualization.RasterPlotter;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.eclipse.jetty.util.MultiPartOutputStream;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;

public class YaCyDefaultServlet
extends HttpServlet {
    private static final long serialVersionUID = 4900000000000001110L;
    protected ServletContext _servletContext;
    protected boolean _acceptRanges = true;
    protected boolean _dirAllowed = true;
    protected Resource _resourceBase;
    protected MimeTypes _mimeTypes;
    protected String[] _welcomes;
    protected File _htLocalePath;
    protected File _htDocsPath;
    protected static final serverClassLoader provider = new serverClassLoader();
    protected ConcurrentHashMap<String, Method> templateMethodCache = null;
    protected static final File TMPDIR = new File(System.getProperty("java.io.tmpdir"));
    protected static final int SIZE_FILE_THRESHOLD = 0x40000000;
    protected static final FileItemFactory DISK_FILE_ITEM_FACTORY = new DiskFileItemFactory(0x40000000, TMPDIR);

    public void init() throws UnavailableException {
        Switchboard sb = Switchboard.getSwitchboard();
        this._htDocsPath = sb.htDocsPath;
        this._htLocalePath = sb.getDataPath("locale.translated_html", "DATA/LOCALE/htroot");
        this._servletContext = this.getServletContext();
        this._mimeTypes = new MimeTypes();
        String tmpstr = this.getServletContext().getInitParameter("welcomeFile");
        this._welcomes = tmpstr == null ? HTTPDFileHandler.defaultFiles : new String[]{tmpstr, "index.html"};
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        Resource.setDefaultUseCaches((boolean)false);
        String rb = this.getInitParameter("resourceBase");
        try {
            this._resourceBase = rb != null ? Resource.newResource((String)rb) : Resource.newResource((String)sb.getConfig("htRootPath", "htroot"));
        }
        catch (IOException e) {
            ConcurrentLog.severe("FILEHANDLER", "YaCyDefaultServlet: resource base (htRootPath) missing");
            ConcurrentLog.logException(e);
            throw new UnavailableException(e.toString());
        }
        if (ConcurrentLog.isFine("FILEHANDLER")) {
            ConcurrentLog.fine("FILEHANDLER", "YaCyDefaultServlet: resource base = " + String.valueOf(this._resourceBase));
        }
        this.templateMethodCache = new ConcurrentHashMap();
    }

    protected boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    public Resource getResource(String pathInContext) {
        Resource r = null;
        try {
            if (this._resourceBase != null) {
                r = this._resourceBase.addPath(pathInContext);
            } else {
                URL u = this._servletContext.getResource(pathInContext);
                r = Resource.newResource((URL)u);
            }
            if (ConcurrentLog.isFine("FILEHANDLER")) {
                ConcurrentLog.fine("FILEHANDLER", "YaCyDefaultServlet: Resource " + pathInContext + "=" + String.valueOf(r));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return r;
    }

    protected boolean hasDefinedRange(Enumeration<String> reqRanges) {
        return reqRanges != null && reqRanges.hasMoreElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block40: {
            String pathInfo;
            boolean included;
            Enumeration reqRanges = null;
            boolean bl = included = request.getAttribute("javax.servlet.include.request_uri") != null;
            if (included) {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pathInfo == null) {
                    pathInfo = request.getPathInfo();
                }
            } else {
                pathInfo = request.getPathInfo();
                reqRanges = request.getHeaders("Range");
                if (!this.hasDefinedRange(reqRanges)) {
                    reqRanges = null;
                }
            }
            Object pathInContext = pathInfo == null ? "/" : pathInfo;
            boolean endsWithSlash = ((String)pathInContext).endsWith("/");
            try (Resource resource = null;){
                int p;
                boolean hasClass = false;
                if (reqRanges == null && !endsWithSlash && (p = ((String)pathInContext).lastIndexOf(46)) >= 0) {
                    Method rewriteMethod = this.rewriteMethod((String)pathInContext);
                    if (rewriteMethod != null) {
                        hasClass = true;
                    } else {
                        String pathofClass = ((String)pathInContext).substring(0, p) + ".class";
                        Resource classresource = this._resourceBase.addPath(pathofClass);
                        if (classresource != null && classresource.exists() && !classresource.isDirectory()) {
                            hasClass = true;
                        }
                    }
                }
                resource = this.getResource((String)pathInContext);
                if (!(hasClass || resource != null && resource.exists() || ((String)pathInContext).contains(".."))) {
                    if (resource != null) {
                        resource.close();
                    }
                    resource = Resource.newResource((File)new File(this._htDocsPath, (String)pathInContext));
                }
                if (ConcurrentLog.isFine("FILEHANDLER")) {
                    ConcurrentLog.fine("FILEHANDLER", "YaCyDefaultServlet: uri=" + request.getRequestURI() + " resource=" + String.valueOf(resource));
                }
                if (!(hasClass || resource != null && resource.exists())) {
                    if (included) {
                        throw new FileNotFoundException("!" + (String)pathInContext);
                    }
                    response.sendError(404);
                    break block40;
                }
                if (!resource.isDirectory()) {
                    if (endsWithSlash && ((String)pathInContext).length() > 1) {
                        String q = request.getQueryString();
                        pathInContext = ((String)pathInContext).substring(0, ((String)pathInContext).length() - 1);
                        if (q != null && q.length() != 0) {
                            pathInContext = (String)pathInContext + "?" + q;
                        }
                        response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths((String)this._servletContext.getContextPath(), (String)pathInContext)));
                    } else if (hasClass) {
                        this.handleTemplate(pathInfo, request, response);
                    } else if (included || this.passConditionalHeaders(request, response, resource)) {
                        this.sendData(request, response, included, resource, reqRanges);
                    }
                    break block40;
                }
                if (!endsWithSlash) {
                    StringBuffer buf;
                    StringBuffer stringBuffer = buf = request.getRequestURL();
                    synchronized (stringBuffer) {
                        int param = buf.lastIndexOf(";");
                        if (param < 0) {
                            buf.append('/');
                        } else {
                            buf.insert(param, '/');
                        }
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            buf.append('?');
                            buf.append(q);
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
                        break block40;
                    }
                }
                String welcome = this.getWelcomeFile((String)pathInContext);
                if (null != welcome) {
                    ConcurrentLog.fine("FILEHANDLER", "welcome={}" + welcome);
                    RequestDispatcher dispatcher = request.getRequestDispatcher(welcome);
                    if (dispatcher != null) {
                        if (included) {
                            dispatcher.include((ServletRequest)request, (ServletResponse)response);
                        } else {
                            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                        }
                    }
                } else if (included || this.passConditionalHeaders(request, response, resource)) {
                    this.sendDirectory(request, response, resource, (String)pathInContext);
                }
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String body;
        Object requestForGet = request;
        if (this.shouldWrapBody(request) && (body = this.readRequestBody(request)) != null && !body.isEmpty()) {
            requestForGet = new BodyParameterRequestWrapper(request, body);
        }
        this.doGet((HttpServletRequest)requestForGet, response);
    }

    private boolean shouldWrapBody(HttpServletRequest request) {
        String method = request.getMethod();
        if (method == null || !HttpMethod.POST.asString().equalsIgnoreCase(method)) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        String normalizedType = contentType.toLowerCase(Locale.ROOT);
        if (normalizedType.contains("multipart/form-data")) {
            return false;
        }
        if (normalizedType.contains("application/x-www-form-urlencoded")) {
            return false;
        }
        return request.getContentLengthLong() != 0L || request.getHeader("Transfer-Encoding") != null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readRequestBody(HttpServletRequest request) {
        try (ServletInputStream inputStream = request.getInputStream();){
            String string;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int read;
                byte[] tmp = new byte[4096];
                while ((read = inputStream.read(tmp)) != -1) {
                    buffer.write(tmp, 0, read);
                }
                string = buffer.toString(StandardCharsets.UTF_8.name());
            }
            return string;
        }
        catch (IOException e) {
            ConcurrentLog.warn("FILEHANDLER", "Failed to read POST body: " + e.getMessage());
            return null;
        }
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    protected String getWelcomeFile(String pathInContext) {
        if (this._welcomes == null) {
            return null;
        }
        for (String _welcome : this._welcomes) {
            String welcome_in_context = URIUtil.addPaths((String)pathInContext, (String)_welcome);
            Resource welcome = this.getResource(welcome_in_context);
            if (welcome == null || !welcome.exists()) continue;
            return _welcome;
        }
        return null;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        try {
            if (!request.getMethod().equals(HttpMethod.HEAD.asString())) {
                long ifmsl;
                String ifms = request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                if (ifms != null && (ifmsl = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString())) != -1L && resource.lastModified() / 1000L <= ifmsl / 1000L) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
                long date = request.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString());
                if (date != -1L && resource.lastModified() / 1000L > date / 1000L) {
                    response.sendError(412);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            if (!response.isCommitted()) {
                response.sendError(400, iae.getMessage());
                return false;
            }
            throw iae;
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        String base = URIUtil.addEncodedPaths((String)request.getRequestURI(), (String)"/");
        String dir = resource.getListHTML(base, pathInContext.length() > 1, request.getQueryString());
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        byte[] data = dir.getBytes(StandardCharsets.UTF_8);
        response.setContentType(MimeTypes.Type.TEXT_HTML_UTF_8.asString());
        response.setContentLength(data.length);
        response.setHeader("Cache-Control", "no-cache, no-store");
        response.setDateHeader("Expires", System.currentTimeMillis() + 10000L);
        response.setDateHeader("Last-Modified", resource.lastModified());
        response.getOutputStream().write(data);
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, Enumeration<String> reqRanges) throws IOException {
        ServletOutputStream out;
        long content_length = resource.length();
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream((Writer)response.getWriter());
        }
        if (response.containsHeader("Last-Modified")) {
            response.getHeaders("Last-Modified").clear();
        }
        response.setHeader("Cache-Control", "public, max-age=" + Integer.toString(600));
        if (reqRanges == null || !reqRanges.hasMoreElements() || content_length < 0L) {
            if (include) {
                resource.writeTo((OutputStream)out, 0L, content_length);
            } else {
                this.writeHeaders(response, resource, content_length);
                resource.writeTo((OutputStream)out, 0L, content_length);
            }
        } else {
            InclusiveByteRange ibr;
            int i;
            List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, (long)content_length);
            if (ranges == null || ranges.isEmpty()) {
                this.writeHeaders(response, resource, content_length);
                response.setStatus(416);
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), InclusiveByteRange.to416HeaderRangeString((long)content_length));
                resource.writeTo((OutputStream)out, 0L, content_length);
                out.close();
                return;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.iterator().next();
                long singleLength = singleSatisfiableRange.getSize();
                this.writeHeaders(response, resource, singleLength);
                response.setStatus(206);
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, singleSatisfiableRange.getFirst(), singleLength);
                out.close();
                return;
            }
            this.writeHeaders(response, resource, -1L);
            String mimetype = response.getContentType();
            if (mimetype == null) {
                ConcurrentLog.warn("FILEHANDLER", "YaCyDefaultServlet: Unknown mimetype for " + request.getRequestURI());
            }
            MultiPartOutputStream multi = new MultiPartOutputStream((OutputStream)out);
            response.setStatus(206);
            String ctp = request.getHeader(HttpHeader.REQUEST_RANGE.asString()) != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            int length = 0;
            String[] header = new String[ranges.size()];
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                header[i] = ibr.toHeaderRangeString(content_length);
                length = (int)((long)length + ((long)((i > 0 ? 2 : 0) + 2 + multi.getBoundary().length() + 2 + (mimetype == null ? 0 : "Content-Type".length() + 2 + mimetype.length()) + 2 + "Content-Range".length() + 2 + header[i].length() + 2 + 2) + (ibr.getLast() - ibr.getFirst()) + 1L));
            }
            response.setContentLength(length += 4 + multi.getBoundary().length() + 2 + 2);
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                multi.startPart(mimetype, new String[]{"Content-Range: " + header[i]});
                long start = ibr.getFirst();
                long size = ibr.getSize();
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    FileUtils.copy(in, (OutputStream)multi, size);
                    pos += size;
                    continue;
                }
                resource.writeTo((OutputStream)multi, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
    }

    protected void writeHeaders(HttpServletResponse response, Resource resource, long count) {
        String extensionmime;
        if (response.getContentType() == null && (extensionmime = this._mimeTypes.getMimeByExtension(resource.getName())) != null) {
            response.setContentType(extensionmime);
        }
        if (count != -1L) {
            if (count < Integer.MAX_VALUE) {
                response.setContentLength((int)count);
            } else {
                response.setHeader("Content-Length", Long.toString(count));
            }
        }
        if (this._acceptRanges) {
            response.setHeader("Accept-Ranges", "bytes");
        }
    }

    protected Object invokeServlet(Method targetMethod, RequestHeader request, serverObjects args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return targetMethod.invoke(null, request, args, Switchboard.getSwitchboard());
    }

    public static String getContext(RequestHeader header, Switchboard sb) {
        String protocol = "http";
        Object hostAndPort = null;
        if (header != null) {
            hostAndPort = header.get("Host");
            protocol = header.getScheme();
        }
        if (hostAndPort == null) {
            hostAndPort = sb != null ? "localhost:" + sb.getConfigInt("port", 8090) : "localhost:8090";
        }
        if (header != null) {
            String protocolHeader = header.getScheme();
            if ("http".equals(protocolHeader) || "https".equals(protocolHeader)) {
                protocol = protocolHeader.toLowerCase(Locale.ROOT);
            } else if (protocolHeader != null && !protocolHeader.isEmpty()) {
                ConcurrentLog.warn("FILEHANDLER", "YaCyDefaultServlet: illegal protocol scheme header value : " + protocolHeader);
            }
            protocolHeader = header.get("X-Forwarded-Proto".toString(), "").toLowerCase(Locale.ROOT);
            if ("https".equals(protocolHeader)) {
                protocol = protocolHeader;
            } else if (!protocolHeader.isEmpty()) {
                ConcurrentLog.warn("FILEHANDLER", "YaCyDefaultServlet: illegal " + "X-Forwarded-Proto".toString() + " header value : " + protocolHeader);
            }
        }
        return protocol + "://" + (String)hostAndPort;
    }

    private RequestHeader generateLegacyRequestHeader(HttpServletRequest request, String target, String targetExt) {
        RequestHeader legacyRequestHeader = new RequestHeader(request);
        legacyRequestHeader.put("PATH", target);
        legacyRequestHeader.put("EXT", targetExt);
        return legacyRequestHeader;
    }

    public File getLocalizedFile(String path, String localeSelection) throws IOException {
        File localePath;
        if (!localeSelection.equals("default") && (localePath = new File(this._htLocalePath, localeSelection + "/" + path)).exists()) {
            return localePath;
        }
        File docsPath = new File(this._htDocsPath, path);
        if (docsPath.exists()) {
            return docsPath;
        }
        return this._resourceBase.addPath(path).getFile();
    }

    private final Method rewriteMethod(String target) {
        assert (target.charAt(0) == '/');
        Method cachedMethod = this.templateMethodCache.get(target);
        if (cachedMethod != null) {
            return cachedMethod;
        }
        int p = target.lastIndexOf(46);
        if (p < 0) {
            return null;
        }
        String classname = "net.yacy.htroot" + target.substring(0, p).replace('/', '.');
        try {
            Class<?> servletClass = Class.forName(classname);
            Method rewriteMethod = YaCyDefaultServlet.rewriteMethod(servletClass);
            this.templateMethodCache.put(target, rewriteMethod);
            return rewriteMethod;
        }
        catch (ClassNotFoundException | InvocationTargetException e) {
            try {
                Class<?> servletClass = Class.forName(classname + "_");
                Method rewriteMethod = YaCyDefaultServlet.rewriteMethod(servletClass);
                this.templateMethodCache.put(target, rewriteMethod);
                return rewriteMethod;
            }
            catch (ClassNotFoundException | InvocationTargetException ee) {
                return null;
            }
        }
    }

    private static final Method rewriteMethod(Class<?> rewriteClass) throws InvocationTargetException {
        Class[] params = (Class[])Array.newInstance(Class.class, 3);
        params[0] = RequestHeader.class;
        params[1] = serverObjects.class;
        params[2] = serverSwitch.class;
        try {
            Method m = rewriteClass.getMethod("respond", params);
            return m;
        }
        catch (NoSuchMethodException e) {
            ConcurrentLog.severe("FILEHANDLER", "YaCyDefaultServlet: method 'respond' not found in class " + rewriteClass.getName() + ": " + e.getMessage());
            throw new InvocationTargetException(e, "method 'respond' not found in class " + rewriteClass.getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTemplate(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Switchboard sb = Switchboard.getSwitchboard();
        String localeSelection = sb.getConfig("locale.language", "browser");
        if (localeSelection.endsWith("browser")) {
            String lng = request.getLocale().getLanguage();
            localeSelection = lng.equalsIgnoreCase("en") ? "default" : lng;
        }
        File targetLocalizedFile = this.getLocalizedFile(target, localeSelection);
        Method targetMethod = this.rewriteMethod(target);
        String targetExt = target.substring(target.lastIndexOf(46) + 1);
        long now = System.currentTimeMillis();
        if (target.endsWith(".css")) {
            response.setDateHeader("Last-Modified", now);
            response.setDateHeader("Expires", now + 3600000L);
        } else if (target.endsWith(".png")) {
            if (response.containsHeader("Last-Modified")) {
                response.getHeaders("Last-Modified").clear();
            }
            response.setHeader("Cache-Control", "public, max-age=" + Integer.toString(60));
        } else {
            response.setDateHeader("Last-Modified", now);
            response.setDateHeader("Expires", now);
        }
        if (target.endsWith(".json")) {
            response.setHeader("Access-Control-Allow-Origin", "*");
        }
        if (targetMethod != null) {
            servletProperties templatePatterns;
            Object tmp;
            serverObjects args = new serverObjects();
            Enumeration argNames = request.getParameterNames();
            while (argNames.hasMoreElements()) {
                String argName = (String)argNames.nextElement();
                args.put(argName, request.getParameter(argName));
            }
            RequestHeader legacyRequestHeader = this.generateLegacyRequestHeader(request, target, targetExt);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                this.parseMultipart(request, args);
            }
            try {
                tmp = args.isEmpty() ? this.invokeServlet(targetMethod, legacyRequestHeader, null) : this.invokeServlet(targetMethod, legacyRequestHeader, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof InvalidURLLicenceException) {
                    response.sendError(400, e.getCause().getMessage());
                    return;
                }
                if (e.getCause() instanceof BadTransactionException) {
                    response.sendError(400, e.getCause().getMessage() + " If you sent this request with a web browser, please refresh the origin page.");
                    return;
                }
                if (e.getCause() instanceof TemplateProcessingException) {
                    response.sendError(((TemplateProcessingException)e.getCause()).getStatus(), e.getCause().getMessage());
                    return;
                }
                if (e.getCause() instanceof DisallowedMethodException) {
                    response.sendError(405, e.getCause().getMessage());
                    return;
                }
                ConcurrentLog.logException(e);
                throw new ServletException(targetLocalizedFile.getAbsolutePath());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ConcurrentLog.logException(e);
                throw new ServletException(targetLocalizedFile.getAbsolutePath());
            }
            if (tmp instanceof RasterPlotter || tmp instanceof EncodedImage || tmp instanceof Image) {
                Object yp;
                ByteBuffer result = null;
                if (tmp instanceof RasterPlotter) {
                    yp = (RasterPlotter)tmp;
                    result = RasterPlotter.exportImage(((RasterPlotter)yp).getImage(), "png");
                } else if (tmp instanceof EncodedImage) {
                    yp = (EncodedImage)tmp;
                    result = ((EncodedImage)yp).getImage();
                    if (result == null || result.length() == 0) {
                        response.setStatus(500);
                        if (result != null) {
                            result.close();
                        }
                        return;
                    }
                    if (((EncodedImage)yp).isStatic()) {
                        response.setDateHeader("Expires", now + 3600000L);
                    }
                } else if (tmp instanceof Image) {
                    int height;
                    Image i = (Image)tmp;
                    int width = i.getWidth(null);
                    if (width < 0) {
                        width = 96;
                    }
                    if ((height = i.getHeight(null)) < 0) {
                        height = 96;
                    }
                    BufferedImage bi = new BufferedImage(width, height, 2);
                    bi.createGraphics().drawImage(i, 0, 0, width, height, null);
                    result = RasterPlotter.exportImage(bi, targetExt);
                }
                this.updateRespHeadersForImages(target, response);
                String mimeType = Classification.ext2mime(targetExt, MimeTypes.Type.TEXT_HTML.asString());
                response.setContentType(mimeType);
                response.setContentLength(result.length());
                response.setStatus(200);
                result.writeTo((OutputStream)response.getOutputStream());
                result.close();
                return;
            }
            if (tmp instanceof InputStream) {
                this.updateRespHeadersForImages(target, response);
                this.writeInputStream(response, targetExt, (InputStream)tmp);
                return;
            }
            if (tmp == null) {
                templatePatterns = new servletProperties();
            } else if (tmp instanceof servletProperties) {
                templatePatterns = (servletProperties)tmp;
                if (templatePatterns.getOutgoingHeader() != null) {
                    ResponseHeader tmpouthdr = templatePatterns.getOutgoingHeader();
                    for (String hdrkey : tmpouthdr.keySet()) {
                        if ("STATUS_CODE".equals(hdrkey)) continue;
                        String val = (String)tmpouthdr.get(hdrkey);
                        if (response.containsHeader(hdrkey) || val == null) continue;
                        response.setHeader(hdrkey, (String)tmpouthdr.get(hdrkey));
                    }
                    if (tmpouthdr.getCookiesEntries() != null) {
                        for (Cookie c : tmpouthdr.getCookiesEntries()) {
                            response.addCookie(c);
                        }
                    }
                }
            } else {
                templatePatterns = new servletProperties((serverObjects)tmp);
            }
            if (templatePatterns.containsKey("transactionToken")) {
                response.setHeader("X-YaCy-Transaction-Token", templatePatterns.get("transactionToken"));
            }
            if (templatePatterns.containsKey("AUTHENTICATE")) {
                if (!request.authenticate(response)) {
                    return;
                }
            } else if (templatePatterns.containsKey("LOCATION")) {
                String location = templatePatterns.get("LOCATION", "");
                if (location.isEmpty()) {
                    location = request.getPathInfo();
                }
                response.setHeader("Location", location);
                response.setStatus(302);
                return;
            }
            if (targetLocalizedFile.exists() && targetLocalizedFile.isFile() && targetLocalizedFile.canRead()) {
                sb.setConfig("server.servlets.called", this.appendPath(sb.getConfig("server.servlets.called", ""), target));
                if (args != null && !args.isEmpty()) {
                    sb.setConfig("server.servlets.submitted", this.appendPath(sb.getConfig("server.servlets.submitted", ""), target));
                }
                templatePatterns.put("version", yacyBuildProperties.getVersion());
                templatePatterns.put("uptime", (System.currentTimeMillis() - sb.startupTime) / 1000L / 60L);
                templatePatterns.putHTML("clientname", sb.peers.mySeed().getName());
                templatePatterns.putHTML("clientid", sb.peers.myID());
                templatePatterns.put("mytime", GenericFormatter.SHORT_SECOND_FORMATTER.format());
                templatePatterns.put("relativeBase", YaCyDefaultServlet.getRelativeBase(target));
                templatePatterns.put("referrer.meta.policy", sb.getConfig("referrer.meta.policy", "origin-when-cross-origin"));
                Seed myPeer = sb.peers.mySeed();
                templatePatterns.put("newpeer", myPeer.getAge() >= 1 ? 0L : 1L);
                templatePatterns.putHTML("newpeer_peerhash", myPeer.hash);
                boolean authorized = sb.adminAuthenticated(legacyRequestHeader) >= 2;
                templatePatterns.put("authorized", authorized ? 1L : 0L);
                templatePatterns.put("simpleheadernavbar", sb.getConfig("decoration.simpleheadernavbar", "navbar-default"));
                templatePatterns.put("navigation-p2p", sb.getConfigBool("network.unit.dht", true) || !sb.isRobinsonMode() ? 1L : 0L);
                templatePatterns.put("navigation-p2p_authorized", authorized ? 1L : 0L);
                String submitted = sb.getConfig("server.servlets.submitted", "");
                boolean crawler_enabled = true;
                boolean advanced_enabled = true;
                templatePatterns.put("navigation-crawlmonitor", true);
                templatePatterns.put("navigation-crawlmonitor_authorized", authorized ? 1L : 0L);
                templatePatterns.put("navigation-advanced", advanced_enabled);
                templatePatterns.put("navigation-advanced_authorized", authorized ? 1L : 0L);
                templatePatterns.put("navigation-showChatLink", sb.getConfigBool("ai.shield.show-chat-link", false) ? "1" : "0");
                templatePatterns.put("promoteSearchPageGreeting.homepage", sb.getConfig("promoteSearchPageGreeting.homepage", ""));
                templatePatterns.put("promoteSearchPageGreeting.smallImage", sb.getConfig("promoteSearchPageGreeting.smallImage", ""));
                templatePatterns.put("promoteSearchPageGreeting.imageAlt", sb.getConfig("promoteSearchPageGreeting.imageAlt", ""));
                templatePatterns.put("clientlanguage", localeSelection);
                String mimeType = Classification.ext2mime(targetExt, MimeTypes.Type.TEXT_HTML.asString());
                long fileSize = targetLocalizedFile.length();
                InputStream fis = fileSize <= Math.min(0x4B4000L, MemoryControl.available() / 100L) ? new ByteArrayInputStream(FileUtils.read(targetLocalizedFile)) : new BufferedInputStream(new FileInputStream(targetLocalizedFile));
                response.setContentType(mimeType);
                response.setStatus(200);
                ByteArrayOutputStream bas = new ByteArrayOutputStream(4096);
                try {
                    TemplateEngine.writeTemplate(targetLocalizedFile.getName(), fis, bas, templatePatterns);
                    this.parseSSI(bas.toByteArray(), request, response);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ignored) {
                        ConcurrentLog.warn("FILEHANDLER", "YaCyDefaultServlet: could not close target file " + targetLocalizedFile.getName());
                    }
                    try {
                        bas.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected static String getRelativeBase(String targetPath) {
        StringBuilder relativeBase = new StringBuilder();
        if (targetPath != null) {
            if (targetPath.startsWith("/")) {
                targetPath = targetPath.substring(1, targetPath.length());
            }
            int slashIndex = targetPath.indexOf(47, 0);
            while (slashIndex >= 0) {
                relativeBase.append("../");
                slashIndex = targetPath.indexOf(47, slashIndex + 1);
            }
        }
        return relativeBase.toString();
    }

    private void updateRespHeadersForImages(String target, HttpServletResponse response) {
        if (target.equals("/ViewImage.png") || target.equals("/ViewFavicon.png")) {
            if (response.containsHeader("Last-Modified")) {
                response.getHeaders("Last-Modified").clear();
            }
            response.setHeader("Cache-Control", "public, max-age=" + Integer.toString(600));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInputStream(HttpServletResponse response, String targetExt, InputStream inStream) throws IOException {
        String mimeType = Classification.ext2mime(targetExt, MimeTypes.Type.TEXT_HTML.asString());
        response.setContentType(mimeType);
        response.setStatus(200);
        byte[] buffer = new byte[4096];
        int size = 0;
        try {
            int l;
            while ((l = inStream.read(buffer)) > 0) {
                response.getOutputStream().write(buffer, 0, l);
                size += l;
            }
            response.setContentLength(size);
        }
        catch (IOException e) {
            ConcurrentLog.fine("FILEHANDLER", "YaCyDefaultServlet: resource content stream could not be written to response.");
            response.setStatus(500);
            return;
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String appendPath(String proplist, String path) {
        if (proplist.length() == 0) {
            return path;
        }
        if (proplist.contains(path)) {
            return proplist;
        }
        return proplist + "," + path;
    }

    protected void parseSSI(byte[] in, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int end;
        ByteBuffer buffer = new ByteBuffer(in);
        ServletOutputStream out = response.getOutputStream();
        byte[] inctxt = "<!--#include virtual=\"".getBytes();
        int offset = 0;
        int p = buffer.indexOf(inctxt, offset);
        while (p >= 0 && (end = buffer.indexOf("-->".getBytes(), p + 24)) > 0) {
            out.write(in, offset, p - offset);
            out.flush();
            int rightquote = buffer.indexOf("\"".getBytes(), p + 23);
            if (rightquote > 0 && rightquote < end) {
                String path = buffer.toString(p + 22, rightquote - p - 22);
                RequestDispatcher dispatcher = request.getRequestDispatcher(path);
                try {
                    dispatcher.include((ServletRequest)request, (ServletResponse)response);
                }
                catch (IOException ex) {
                    if (path.indexOf("yacysearch") < 0) {
                        ConcurrentLog.warn("FILEHANDLER", "YaCyDefaultServlet: parseSSI dispatcher problem - " + ex.getMessage() + ": " + path);
                    }
                }
            } else {
                ConcurrentLog.warn("FILEHANDLER", "YaCyDefaultServlet: parseSSI closing quote missing " + buffer.toString(p, end - p) + " in " + request.getPathInfo());
            }
            offset = end + 3;
            p = buffer.indexOf(inctxt, offset);
        }
        out.write(in, offset, in.length - offset);
        buffer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseMultipart(HttpServletRequest request, serverObjects args) throws IOException {
        if (!MemoryControl.request(request.getContentLength() * 3, false)) {
            throw new IOException("not enough memory available for request. request.getContentLength() = " + request.getContentLength() + ", MemoryControl.available() = " + MemoryControl.available());
        }
        ServletFileUpload upload = new ServletFileUpload(DISK_FILE_ITEM_FACTORY);
        upload.setFileSizeMax(-1L);
        try {
            List fileItems = upload.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    if (item.getContentType() == null || !item.getContentType().contains("charset")) {
                        args.add(item.getFieldName(), item.getString(StandardCharsets.UTF_8.name()));
                        continue;
                    }
                    args.add(item.getFieldName(), item.getString());
                    continue;
                }
                args.add(item.getFieldName(), item.getName());
                InputStream filecontent = null;
                try {
                    filecontent = item.getInputStream();
                    String filename = item.getFieldName() + "$file";
                    args.put(filename, new ChunkedBytes(filecontent));
                }
                catch (IOException e) {
                    ConcurrentLog.info("FILEHANDLER", e.getMessage());
                }
                finally {
                    if (filecontent == null) continue;
                    try {
                        filecontent.close();
                    }
                    catch (IOException e) {
                        ConcurrentLog.info("FILEHANDLER", e.getMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            ConcurrentLog.info("FILEHANDLER", ex.getMessage());
        }
    }

    private static final class BodyParameterRequestWrapper
    extends HttpServletRequestWrapper {
        private static final String BODY_PARAMETER_NAME = "BODY";
        private final Map<String, String[]> additionalParameters = new HashMap<String, String[]>();

        BodyParameterRequestWrapper(HttpServletRequest request, String bodyContent) {
            super(request);
            this.additionalParameters.put(BODY_PARAMETER_NAME, new String[]{bodyContent});
        }

        public String getParameter(String name) {
            String[] values = this.getParameterValues(name);
            return values == null || values.length == 0 ? null : values[0];
        }

        public String[] getParameterValues(String name) {
            if (name == null) {
                return null;
            }
            String[] override = this.additionalParameters.get(name);
            if (override != null) {
                return (String[])override.clone();
            }
            String[] base = super.getParameterValues(name);
            return base == null ? null : (String[])base.clone();
        }

        public Enumeration<String> getParameterNames() {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            Enumeration upstream = super.getParameterNames();
            while (upstream.hasMoreElements()) {
                names.add((String)upstream.nextElement());
            }
            names.addAll(this.additionalParameters.keySet());
            return Collections.enumeration(names);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> base = new HashMap<String, String[]>();
            Map upstream = super.getParameterMap();
            if (upstream != null) {
                for (Map.Entry<Object, Object> entry2 : upstream.entrySet()) {
                    base.put((String)entry2.getKey(), entry2.getValue() == null ? null : (String[])((String[])entry2.getValue()).clone());
                }
            }
            for (Map.Entry<Object, Object> entry3 : this.additionalParameters.entrySet()) {
                base.put((String)entry3.getKey(), (String[])((String[])entry3.getValue()).clone());
            }
            return base;
        }
    }
}

