/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.ai.LLM;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.federate.solr.connector.EmbeddedSolrConnector;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.ranking.RankingProfile;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.snippet.TextSnippet;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.servlet.cache.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class RAGProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 3411544789759643137L;
    public static final String LLM_SYSTEM_PROMPT_DEFAULT = "You are a smart and helpful chatbot. If possible, use friendly emojies.";
    private static final String LLM_SYSTEM_PREFIX_DEFAULT = "\n\nYou may receive additional expert knowledge in the user prompt after a 'Additional Information' headline to enhance your knowledge. Use it only if applicable.";
    private static final String LLM_USER_PREFIX_DEFAULT = "\n\nAdditional Information:\n\nbelow you find a collection of texts that might be useful to generate a response. Do not discuss these documents, just use them to answer the question above.\n\n";
    private static final String LLM_QUERY_GENERATOR_PREFIX_DEFAULT = "Make a list of search words with low document frequency for the following prompt; use a JSON Array: ";
    public static final Deque<AbstractMap.SimpleEntry<Long, String>> ACCESS_LOG = new ConcurrentLinkedDeque<AbstractMap.SimpleEntry<Long, String>>();
    public static final long ONE_MINUTE_MS = 60000L;
    public static final long ONE_HOUR_MS = 3600000L;
    public static final long ONE_DAY_MS = 86400000L;

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        String line;
        boolean allowNonLocal;
        response.setContentType("application/json;charset=utf-8");
        HttpServletResponse hresponse = (HttpServletResponse)response;
        HttpServletRequest hrequest = (HttpServletRequest)request;
        hresponse.setHeader("Access-Control-Allow-Origin", "*");
        hresponse.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        hresponse.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        Switchboard sb = Switchboard.getSwitchboard();
        String clientIP = hrequest.getRemoteAddr();
        boolean localhostAccess = Domains.isLocalhost(clientIP);
        if (!localhostAccess && !(allowNonLocal = sb.getConfigBool("ai.shield.allow-nonlocalhost", false))) {
            hresponse.sendError(403);
            return;
        }
        if (RAGProxyServlet.isRateLimited(sb, clientIP, localhostAccess)) {
            hresponse.sendError(429, "Too Many Requests");
            return;
        }
        RAGProxyServlet.recordAccess(clientIP);
        Method reqMethod = Method.getMethod((String)hrequest.getMethod());
        if (reqMethod == Method.OTHER) {
            hresponse.setStatus(200);
            return;
        }
        if (reqMethod != Method.POST) {
            hresponse.sendError(405);
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        BufferedReader reader = request.getReader();
        StringBuilder bodyBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            bodyBuilder.append(line);
        }
        String body = bodyBuilder.toString();
        try {
            JSONObject bodyObject = new JSONObject(body);
            String model = bodyObject.optString("model", LLM.LLMUsage.chat.name());
            LLM.LLMUsage usage = LLM.LLMUsage.chat;
            try {
                usage = LLM.LLMUsage.valueOf(model);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            LLM.LLMModel llm4Chat = LLM.llmFromUsage(usage);
            LLM.LLMModel llm4tldr = LLM.llmFromUsage(LLM.LLMUsage.tldr);
            bodyObject.put("model", llm4Chat.model);
            JSONArray messages = bodyObject.optJSONArray("messages");
            String systemPrefix = sb.getConfig("ai.llm-system-prefix", LLM_SYSTEM_PREFIX_DEFAULT);
            String userPrefix = sb.getConfig("ai.llm-user-prefix", LLM_USER_PREFIX_DEFAULT);
            for (int i = 0; i < messages.length(); ++i) {
                JSONObject message2 = messages.getJSONObject(i);
                if (!message2.optString("role", "").equals("user")) continue;
                UserObject userObject = new UserObject(message2);
                userObject.attachAttachment(userPrefix);
            }
            UserObject userObject = new UserObject(messages.getJSONObject(messages.length() - 1));
            Object user = userObject.getContentText();
            String userPrompt = user;
            String ragMode = userObject.getSearchMode();
            ConcurrentLog.info("RAGProxy", "ragMode=" + ragMode + " userChars=" + (user == null ? 0 : ((String)user).length()));
            String searchResultQuery = "";
            String searchResultMarkdown = "";
            if (!"no".equals(ragMode)) {
                String queryPrefix = sb.getConfig("ai.llm-query-generator-prefix", LLM_QUERY_GENERATOR_PREFIX_DEFAULT);
                long queryStart = System.currentTimeMillis();
                searchResultQuery = this.searchWordsForPrompt(llm4tldr.llm, llm4tldr.model, queryPrefix + (String)user);
                if (searchResultQuery == null || searchResultQuery.length() == 0) {
                    searchResultQuery = user;
                }
                long queryElapsed = System.currentTimeMillis() - queryStart;
                Set<String> boostTerms = RAGProxyServlet.intersectTokens(userPrompt, searchResultQuery, 8);
                long searchStart = System.currentTimeMillis();
                searchResultMarkdown = RAGProxyServlet.searchResultsAsMarkdown(searchResultQuery, 10, "global".equals(ragMode), boostTerms);
                long searchElapsed = System.currentTimeMillis() - searchStart;
                ConcurrentLog.info("RAGProxy", "searchQuery=\"" + searchResultQuery + "\" queryMs=" + queryElapsed + " searchMs=" + searchElapsed + " markdownChars=" + searchResultMarkdown.length() + " boostTerms=" + boostTerms.size());
                user = (String)user + userPrefix;
                user = (String)user + searchResultMarkdown;
                userObject.setContentText((String)user);
            }
            body = bodyObject.toString();
            URL url = new URI(llm4Chat.llm.hoststub + "/v1/chat/completions").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            if (!llm4Chat.llm.api_key.isEmpty()) {
                conn.setRequestProperty("Authorization", "Bearer " + llm4Chat.llm.api_key);
            }
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(body.getBytes());
                os.flush();
            }
            int status = conn.getResponseCode();
            hresponse.setStatus(status);
            if (status == 200) {
                LinkedBlockingQueue inputQueue = new LinkedBlockingQueue();
                String POISON = "POISON";
                Thread readerThread = new Thread(() -> {
                    try {
                        String inputLine;
                        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        while ((inputLine = in.readLine()) != null) {
                            inputQueue.put(inputLine);
                        }
                        in.close();
                        inputQueue.put("POISON");
                    }
                    catch (IOException | InterruptedException exception) {
                    }
                    finally {
                        try {
                            inputQueue.put("POISON");
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                });
                readerThread.start();
                try {
                    Object inputLine;
                    int count = 0;
                    while (!((String)(inputLine = (String)inputQueue.take())).equals("POISON")) {
                        int p;
                        if (count == 0 && searchResultMarkdown.length() > 0 && (p = ((String)inputLine).indexOf(123)) > 0) {
                            JSONObject j = new JSONObject(new JSONTokener(((String)inputLine).substring(p)));
                            j.put("search-filename", "search_result_" + searchResultQuery.replace(' ', '_') + ".md");
                            j.put("search-text-base64", new String(Base64.getEncoder().encode(searchResultMarkdown.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                            inputLine = ((String)inputLine).substring(0, p) + j.toString();
                        }
                        out.println((String)inputLine);
                        out.flush();
                        ++count;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            out.close();
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static JSONArray searchResults(String query2, int count, boolean includeSnippet) {
        return RAGProxyServlet.searchResults(query2, count, includeSnippet, new LinkedHashSet<String>());
    }

    public static JSONArray searchResults(String query2, int count, boolean includeSnippet, Set<String> boostTerms) {
        JSONArray results = new JSONArray();
        if (query2 == null || query2.length() == 0 || count == 0) {
            return results;
        }
        Switchboard sb = Switchboard.getSwitchboard();
        EmbeddedSolrConnector connector = sb.index.fulltext().getDefaultEmbeddedConnector();
        SolrQuery params = new SolrQuery();
        params.setQuery(query2);
        params.set("defType", new String[]{"edismax"});
        params.set("qf", new String[]{CollectionSchema.title.getSolrFieldName() + "^3 " + CollectionSchema.text_t.getSolrFieldName() + "^1 " + CollectionSchema.sku.getSolrFieldName() + "^0.5 " + CollectionSchema.h1_txt.getSolrFieldName() + "^2"});
        params.set("pf", new String[]{CollectionSchema.title.getSolrFieldName() + "^5 " + CollectionSchema.text_t.getSolrFieldName() + "^2"});
        ArrayList<CallSite> bqParts = new ArrayList<CallSite>();
        if (boostTerms != null && !boostTerms.isEmpty()) {
            for (String term : boostTerms) {
                if (term == null || term.isEmpty()) continue;
                bqParts.add((CallSite)((Object)(CollectionSchema.title.getSolrFieldName() + ":" + term + "^0.5")));
                bqParts.add((CallSite)((Object)(CollectionSchema.h1_txt.getSolrFieldName() + ":" + term + "^0.4")));
                bqParts.add((CallSite)((Object)(CollectionSchema.text_t.getSolrFieldName() + ":" + term + "^0.2")));
            }
        }
        bqParts.add((CallSite)((Object)("(" + CollectionSchema.url_file_ext_s.getSolrFieldName() + ":(zip rar 7z tar gz bz2 xz tgz))^0.1")));
        params.set("bq", new String[]{String.join((CharSequence)" ", bqParts)});
        params.setRows(Integer.valueOf(count));
        params.setStart(Integer.valueOf(0));
        params.setFacet(false);
        params.clearSorts();
        params.setFields(new String[]{CollectionSchema.sku.getSolrFieldName(), CollectionSchema.title.getSolrFieldName(), CollectionSchema.text_t.getSolrFieldName(), CollectionSchema.description_txt.getSolrFieldName(), CollectionSchema.keywords.getSolrFieldName(), CollectionSchema.synonyms_sxt.getSolrFieldName(), CollectionSchema.h1_txt.getSolrFieldName(), CollectionSchema.h2_txt.getSolrFieldName(), CollectionSchema.h3_txt.getSolrFieldName(), CollectionSchema.h4_txt.getSolrFieldName(), CollectionSchema.h5_txt.getSolrFieldName(), CollectionSchema.h6_txt.getSolrFieldName()});
        params.setIncludeScore(true);
        params.set("df", new String[]{CollectionSchema.text_t.getSolrFieldName()});
        try {
            SolrDocumentList sdl = connector.getDocumentListByParams((ModifiableSolrParams)params);
            Iterator i = sdl.iterator();
            while (i.hasNext()) {
                try {
                    SolrDocument doc = (SolrDocument)i.next();
                    JSONObject result = new JSONObject(true);
                    String url = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                    result.put("url", url == null ? "" : url.trim());
                    String title = RAGProxyServlet.getOneString(doc, CollectionSchema.title);
                    result.put("title", title == null ? "" : title.trim());
                    if (includeSnippet) {
                        String text = (String)doc.getFieldValue(CollectionSchema.text_t.getSolrFieldName());
                        result.put("text", RAGProxyServlet.limitSnippet(text == null ? "" : text.trim(), 2000));
                    }
                    results.put(result);
                }
                catch (JSONException jSONException) {}
            }
            return results;
        }
        catch (IOException | SolrException e) {
            return results;
        }
    }

    public static String searchResultsAsMarkdown(String query2, int count, boolean global) {
        return RAGProxyServlet.searchResultsAsMarkdown(query2, count, global, new LinkedHashSet<String>());
    }

    public static String searchResultsAsMarkdown(String query2, int count, boolean global, Set<String> boostTerms) {
        long searchStart = System.currentTimeMillis();
        JSONArray searchResults = global ? RAGProxyServlet.searchResultsGlobal(query2, count, true) : RAGProxyServlet.searchResults(query2, count, true, boostTerms);
        ConcurrentLog.info("RAGProxy", "searchResults=" + searchResults.length() + " global=" + global + " searchMs=" + (System.currentTimeMillis() - searchStart));
        StringBuilder sb = new StringBuilder();
        ArrayList<Snippet> results = new ArrayList<Snippet>();
        for (int i = 0; i < searchResults.length(); ++i) {
            try {
                Snippet snippet;
                JSONObject r = searchResults.getJSONObject(i);
                String title = r.optString("title", "");
                String url = r.optString("url", "");
                String text = r.optString("text", "");
                if (title.isEmpty()) {
                    title = url;
                }
                if (text.isEmpty()) {
                    text = title;
                }
                if (title.length() <= 0 || text.length() <= 0 || (snippet = new Snippet(query2, text, url, title, 256)).getText().length() <= 0) continue;
                results.add(snippet);
                continue;
            }
            catch (JSONException r) {
                // empty catch block
            }
        }
        results.sort(Comparator.comparingDouble(Snippet::getScore));
        int limit = results.size() / 2;
        if (results.size() > 0 && limit == 0) {
            limit = 1;
        }
        for (int i = 0; i < limit; ++i) {
            Snippet snippet = (Snippet)results.get(i);
            sb.append("## ").append(snippet.getTitle()).append("\n");
            sb.append(snippet.text).append("\n");
            if (snippet.getURL().length() > 0) {
                sb.append("Source: ").append(snippet.getURL()).append("\n");
            }
            sb.append("\n\n");
        }
        ConcurrentLog.info("RAGProxy", "markdownChars=" + sb.length() + " snippetCount=" + results.size());
        return sb.toString();
    }

    public static JSONArray searchResultsGlobal(String query2, int count, boolean includeSnippet) {
        URIMetadataNode node;
        JSONArray results = new JSONArray();
        if (query2 == null || query2.length() == 0 || count == 0) {
            return results;
        }
        Switchboard sb = Switchboard.getSwitchboard();
        RankingProfile ranking = sb.getRanking();
        boolean timezoneOffset = false;
        QueryModifier modifier = new QueryModifier(0);
        String querystring = modifier.parse(query2);
        if (querystring.length() == 0) {
            String string = querystring = query2 == null ? "" : query2.trim();
        }
        if (querystring.length() == 0) {
            return results;
        }
        QueryGoal qg = new QueryGoal(querystring);
        QueryParams theQuery = new QueryParams(qg, modifier, 0, "", Classification.ContentDomain.TEXT, "", 0, new HashSet<Tagging.Metatag>(), CacheStrategy.IFFRESH, count, 0, ".*", null, null, QueryParams.Searchdom.GLOBAL, null, true, DigestURL.hosthashess(sb.getConfig("search.excludehosth", "")), 255, null, false, sb.index, ranking, ClientIdentification.yacyIntranetCrawlerAgent.userAgent(), 0.0, 0.0, 0.0, sb.getConfigSet("search.navigation"));
        SearchEvent theSearch = SearchEventCache.getEvent(theQuery, sb.peers, sb.tables, sb.isRobinsonMode() ? sb.clusterhashes : null, false, sb.loader, (int)sb.getConfigLong("remotesearch.maxcount", sb.getConfigLong("network.unit.remotesearch.maxcount", 10L)), sb.getConfigLong("remotesearch.maxtime", sb.getConfigLong("network.unit.remotesearch.maxtime", 3000L)));
        long timeout = sb.getConfigLong("remotesearch.maxtime", sb.getConfigLong("network.unit.remotesearch.maxtime", 3000L));
        RAGProxyServlet.waitForFeedingAndResort(theSearch, timeout);
        for (int i = 0; i < count && (node = theSearch.oneResult(i, timeout)) != null; ++i) {
            try {
                JSONObject result = new JSONObject(true);
                result.put("url", node.urlstring());
                result.put("title", node.title());
                if (includeSnippet) {
                    TextSnippet snippet;
                    String text = node.snippet();
                    if ((text == null || text.isEmpty()) && (snippet = node.textSnippet()) != null && snippet.exists() && !snippet.getErrorCode().fail()) {
                        text = snippet.getLineRaw();
                    }
                    if (text == null || text.isEmpty()) {
                        text = RAGProxyServlet.firstFieldString(node.getFieldValue(CollectionSchema.description_txt.getSolrFieldName()));
                    }
                    if (text == null || text.isEmpty()) {
                        text = RAGProxyServlet.firstFieldString(node.getFieldValue(CollectionSchema.text_t.getSolrFieldName()));
                    }
                    result.put("text", RAGProxyServlet.limitSnippet(text == null ? "" : text.trim(), 2000));
                }
                results.put(result);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return results;
    }

    private static String limitSnippet(String text, int maxChars) {
        if (text == null) {
            return "";
        }
        if (maxChars <= 0 || text.length() <= maxChars) {
            return text;
        }
        return text.substring(0, maxChars);
    }

    private static String firstFieldString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                if (item == null) continue;
                return item.toString();
            }
            return "";
        }
        return value.toString();
    }

    private static void waitForFeedingAndResort(SearchEvent search2, long timeoutMs) {
        if (search2 == null || timeoutMs <= 0L) {
            return;
        }
        long end = System.currentTimeMillis() + timeoutMs;
        while (!search2.isFeedingFinished() && System.currentTimeMillis() < end) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        search2.resortCachedResults();
    }

    public static List<String> slicer(String text, int len) {
        ArrayList<String> result = new ArrayList<String>();
        if (text == null || len <= 0) {
            return result;
        }
        int start = 0;
        while (start < text.length()) {
            char ch;
            int end;
            for (end = Math.min(start + len, text.length()); end < text.length() && ((ch = text.charAt(end - 1)) != '.' && ch != '?' && ch != '!' || !Character.isWhitespace(text.charAt(end))); ++end) {
            }
            result.add(text.substring(start, end));
            start = end;
        }
        return result;
    }

    private static String getOneString(SolrDocument doc, CollectionSchema field) {
        assert (field.isMultiValued());
        assert (field.getType() == SolrType.string || field.getType() == SolrType.text_general);
        Object r = doc.getFieldValue(field.getSolrFieldName());
        if (r == null) {
            return "";
        }
        if (r instanceof ArrayList) {
            return (String)((ArrayList)r).get(0);
        }
        return r.toString();
    }

    private String searchWordsForPrompt(LLM llm, String model, String prompt) {
        String question;
        String string = question = prompt == null ? "" : prompt;
        if (llm == null || model == null || model.isEmpty()) {
            return null;
        }
        try {
            LLM.Context context = new LLM.Context(LLM_SYSTEM_PREFIX_DEFAULT);
            context.addPrompt(question);
            LinkedHashSet<String> singlewords = new LinkedHashSet<String>();
            String[] a = LLM.stringsFromChat(llm.chat(model, context, LLM.listSchema, 200));
            if (a == null || a.length == 0) {
                return null;
            }
            for (String s : a) {
                if (s == null) continue;
                for (String t : s.split(" ")) {
                    if (t.isEmpty()) continue;
                    singlewords.add(t.toLowerCase());
                }
            }
            if (singlewords.isEmpty()) {
                return null;
            }
            StringBuilder query2 = new StringBuilder();
            for (String s : singlewords) {
                query2.append(s).append(' ');
            }
            String querys = query2.toString().trim();
            if (querys.length() == 0) {
                return null;
            }
            return querys;
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Set<String> querySet(String query2) {
        Set<String> queryWordSet = Arrays.stream(query2.trim().toLowerCase().split("\\s+")).map(String::toLowerCase).filter(word -> !word.isEmpty()).collect(Collectors.toSet());
        return queryWordSet;
    }

    private static Set<String> intersectTokens(String originalPrompt, String computedQuery, int maxTerms) {
        Set<String> promptTerms = RAGProxyServlet.querySet(originalPrompt == null ? "" : originalPrompt);
        Set<String> queryTerms = RAGProxyServlet.querySet(computedQuery == null ? "" : computedQuery);
        LinkedHashSet<String> intersection = new LinkedHashSet<String>();
        for (String term : promptTerms) {
            String cleaned;
            if (!queryTerms.contains(term) || (cleaned = RAGProxyServlet.cleanToken(term)).isEmpty()) continue;
            intersection.add(cleaned);
            if (maxTerms <= 0 || intersection.size() < maxTerms) continue;
            break;
        }
        return intersection;
    }

    private static String cleanToken(String term) {
        if (term == null) {
            return "";
        }
        String cleaned = term.replaceAll("[^A-Za-z0-9]", "");
        if (cleaned.length() < 2) {
            return "";
        }
        return cleaned.toLowerCase();
    }

    private static JSONObject responseLine(String payload) {
        JSONObject j = new JSONObject(true);
        try {
            j.put("id", "log");
            j.put("object", "chat.completion.chunk");
            j.put("created", System.currentTimeMillis() / 1000L);
            j.put("model", "log");
            j.put("system_fingerprint", "YaCy");
            JSONArray choices = new JSONArray();
            JSONObject choice = new JSONObject(true);
            choice.put("index", 0);
            JSONObject delta = new JSONObject(true);
            delta.put("role", "assistant");
            delta.put("content", payload);
            choice.put("delta", delta);
            choices.put(choice);
            j.put("choices", choices);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return j;
    }

    public static void pruneOldEntries(long now) {
        AbstractMap.SimpleEntry<Long, String> head;
        while ((head = ACCESS_LOG.peekFirst()) != null && now - head.getKey() > 86400000L) {
            ACCESS_LOG.pollFirst();
        }
    }

    public static void recordAccess(String ip) {
        long now = System.currentTimeMillis();
        RAGProxyServlet.pruneOldEntries(now);
        ACCESS_LOG.addLast(new AbstractMap.SimpleEntry<Long, String>(now, ip));
    }

    public static long countAccess(String ip, long windowMillis, long now) {
        return ACCESS_LOG.stream().filter(e -> (ip == null || ((String)e.getValue()).equals(ip)) && now - (Long)e.getKey() <= windowMillis).count();
    }

    public static boolean isRateLimited(Switchboard sb, String ip, boolean localhostAccess) {
        long now = System.currentTimeMillis();
        RAGProxyServlet.pruneOldEntries(now);
        boolean allow_nonlocalhost = sb.getConfigBool("ai.shield.allow-nonlocalhost", false);
        boolean limit_all = sb.getConfigBool("ai.shield.limit-all", false);
        if (!localhostAccess) {
            long perDayLimit;
            long perMinuteLimit = allow_nonlocalhost ? RAGProxyServlet.parseLimit(sb.getConfig("ai.shield.rate.per-minute", "0")) : 0L;
            long perHourLimit = allow_nonlocalhost ? RAGProxyServlet.parseLimit(sb.getConfig("ai.shield.rate.per-hour", "0")) : 0L;
            long l = perDayLimit = allow_nonlocalhost ? RAGProxyServlet.parseLimit(sb.getConfig("ai.shield.rate.per-day", "0")) : 0L;
            if (perMinuteLimit > 0L && RAGProxyServlet.countAccess(ip, 60000L, now) >= perMinuteLimit) {
                return true;
            }
            if (perHourLimit > 0L && RAGProxyServlet.countAccess(ip, 3600000L, now) >= perHourLimit) {
                return true;
            }
            if (perDayLimit > 0L && RAGProxyServlet.countAccess(ip, 86400000L, now) >= perDayLimit) {
                return true;
            }
        }
        if (localhostAccess && limit_all) {
            long allMinute = RAGProxyServlet.parseLimit(sb.getConfig("ai.shield.all.per-minute", "0"));
            long allHour = RAGProxyServlet.parseLimit(sb.getConfig("ai.shield.all.per-hour", "0"));
            long allDay = RAGProxyServlet.parseLimit(sb.getConfig("ai.shield.all.per-day", "0"));
            if (allMinute > 0L && RAGProxyServlet.countAccess(null, 60000L, now) >= allMinute) {
                return true;
            }
            if (allHour > 0L && RAGProxyServlet.countAccess(null, 3600000L, now) >= allHour) {
                return true;
            }
            if (allDay > 0L && RAGProxyServlet.countAccess(null, 86400000L, now) >= allDay) {
                return true;
            }
        }
        return false;
    }

    private static long parseLimit(String value) {
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static final class UserObject {
        private JSONObject userObject;

        public UserObject(JSONObject userObject) {
            this.userObject = userObject;
        }

        public void attachAttachment(String prefix) {
            List<DataURL> data_urls = this.getContentAttachments();
            for (DataURL data_url : data_urls) {
                if (!data_url.getMimetype().startsWith("text/")) continue;
                Object user = this.getContentText();
                String attachment = new String(data_url.getData(), StandardCharsets.UTF_8);
                user = (String)user + prefix;
                user = (String)user + attachment;
                this.setContentText((String)user);
                this.removeContentAttachment(data_url);
            }
            this.normalize();
        }

        public String getSearchMode() {
            Object raw = this.userObject.opt("search");
            if (raw instanceof Boolean) {
                return (Boolean)raw != false ? "local" : "no";
            }
            String search2 = this.userObject.optString("search", "").trim().toLowerCase();
            if (search2.isEmpty() || "no".equals(search2) || "false".equals(search2)) {
                return "no";
            }
            if ("local".equals(search2) || "global".equals(search2)) {
                return search2;
            }
            return "no";
        }

        public String getContentText() {
            Object content = this.userObject.opt("content");
            assert (content != null);
            if (content instanceof JSONArray) {
                JSONArray array = (JSONArray)content;
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject j = array.optJSONObject(i);
                    String ctype = j.optString("type");
                    if (ctype == null || !ctype.equals("text")) continue;
                    String text = j.optString("text", "");
                    return text;
                }
                return "";
            }
            assert (content instanceof String);
            return (String)content;
        }

        public List<DataURL> getContentAttachments() {
            ArrayList<DataURL> list2 = new ArrayList<DataURL>();
            Object content = this.userObject.opt("content");
            assert (content != null);
            if (content instanceof JSONArray) {
                JSONArray array = (JSONArray)content;
                for (int i = 0; i < array.length(); ++i) {
                    String data_url;
                    JSONObject image_url;
                    JSONObject j = array.optJSONObject(i);
                    String ctype = j.optString("type");
                    if (ctype == null || !ctype.equals("image_url") || (image_url = j.optJSONObject("image_url")) == null || (data_url = image_url.optString("url", "")).length() <= 0) continue;
                    DataURL dataurl = new DataURL(data_url);
                    list2.add(dataurl);
                }
            }
            return list2;
        }

        public void removeContentAttachment(DataURL delete_data_url) {
            Object content = this.userObject.opt("content");
            assert (content != null);
            if (content instanceof JSONArray) {
                JSONArray array = (JSONArray)content;
                for (int i = 0; i < array.length(); ++i) {
                    DataURL dataurl;
                    String data_url;
                    JSONObject image_url;
                    JSONObject j = array.optJSONObject(i);
                    String ctype = j.optString("type");
                    if (ctype == null || !ctype.equals("image_url") || (image_url = j.optJSONObject("image_url")) == null || (data_url = image_url.optString("url", "")).length() <= 0 || (dataurl = new DataURL(data_url)).getSiganture() != delete_data_url.getSiganture()) continue;
                    array.remove(i);
                    break;
                }
                this.normalize();
            }
        }

        public void normalize() {
            Object content = this.userObject.opt("content");
            assert (content != null);
            if (content instanceof String) {
                return;
            }
            assert (content instanceof JSONArray);
            JSONArray array = (JSONArray)content;
            assert (array.length() > 0);
            if (array.length() != 1) {
                return;
            }
            JSONObject j = array.optJSONObject(0);
            String ctype = j.optString("type");
            assert (ctype != null);
            assert (ctype.equals("text"));
            if (!ctype.equals("text")) {
                return;
            }
            String text = j.optString("text", "");
            try {
                this.userObject.putOpt("content", text);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }

        public void setContentText(String text) {
            Object content = this.userObject.opt("content");
            assert (content != null);
            if (content instanceof String) {
                try {
                    this.userObject.put("content", text);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return;
            }
            assert (content instanceof JSONArray);
            JSONArray array = (JSONArray)content;
            for (int i = 0; i < array.length(); ++i) {
                JSONObject j = array.optJSONObject(i);
                String ctype = j.optString("type");
                if (ctype == null || !ctype.equals("text")) continue;
                try {
                    j.putOpt("text", text);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public static class Snippet {
        private String text;
        private String url;
        private String title;
        private double score;

        public Snippet(String query2, String text, String url, String title, int maxChunkLength) {
            this.url = url;
            this.title = title;
            this.score = 0.0;
            if (text == null || text.isEmpty() || maxChunkLength <= 0 || query2 == null) {
                this.text = "";
                return;
            }
            List<String> chunks = RAGProxyServlet.slicer(text, maxChunkLength);
            if (chunks.isEmpty()) {
                this.text = "";
                return;
            }
            ArrayList<String> chunksLowerCase = new ArrayList<String>(chunks.size());
            for (String chunk : chunks) {
                chunksLowerCase.add(chunk.toLowerCase());
            }
            Set<String> queryWordSet = RAGProxyServlet.querySet(query2);
            if (queryWordSet.isEmpty()) {
                this.text = "";
                return;
            }
            int totalChunks = chunksLowerCase.size();
            HashMap<String, Double> idf = new HashMap<String, Double>();
            for (String word : queryWordSet) {
                int docFreq = 0;
                for (String chunk : chunksLowerCase) {
                    if (!chunk.contains(word)) continue;
                    ++docFreq;
                }
                idf.put(word, Math.log((double)totalChunks / (double)(docFreq + 1)) + 1.0);
            }
            HashMap<Integer, Double> chunkScores = new HashMap<Integer, Double>();
            for (int i = 0; i < chunksLowerCase.size(); ++i) {
                String chunk = (String)chunksLowerCase.get(i);
                double score = 0.0;
                HashMap<String, Integer> tf = new HashMap<String, Integer>();
                String[] wordsInChunk = chunk.split("\\s+");
                for (String w : wordsInChunk) {
                    String cleanWord = w.replaceAll("[.,!?;:]", "");
                    if (cleanWord.length() <= 0 || !queryWordSet.contains(cleanWord)) continue;
                    tf.put(cleanWord, tf.getOrDefault(cleanWord, 0) + 1);
                }
                for (String word : queryWordSet) {
                    int tfValue = tf.getOrDefault(word, 0);
                    double tfIdf = (double)tfValue * idf.getOrDefault(word, 1.0);
                    score += tfIdf;
                }
                chunkScores.put(i, score);
            }
            int topChunkIndex = -1;
            for (Map.Entry entry2 : chunkScores.entrySet()) {
                if (!((Double)entry2.getValue() > this.score)) continue;
                this.score = (Double)entry2.getValue();
                topChunkIndex = (Integer)entry2.getKey();
            }
            if (topChunkIndex < 0) {
                this.text = "";
                this.score = 0.0;
                return;
            }
            ArrayList<String> snippetChunks = new ArrayList<String>();
            if (topChunkIndex > 0) {
                snippetChunks.add(chunks.get(topChunkIndex - 1));
            }
            snippetChunks.add(chunks.get(topChunkIndex));
            if (topChunkIndex < chunks.size() - 1) {
                snippetChunks.add(chunks.get(topChunkIndex + 1));
            }
            this.text = String.join((CharSequence)" ", snippetChunks);
        }

        public double getScore() {
            return this.score;
        }

        public String getText() {
            return this.text;
        }

        public String getURL() {
            return this.url;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static final class DataURL {
        private String mimetype;
        private byte[] data;
        private int signature;

        public DataURL(String data_url) {
            if (data_url == null || !data_url.startsWith("data:")) {
                throw new IllegalArgumentException("data url not valid: it must start with 'data:'");
            }
            int commaIndex = data_url.indexOf(44);
            if (commaIndex == -1) {
                throw new IllegalArgumentException("data url not valid: it must contain a comma");
            }
            String header = data_url.substring(5, commaIndex);
            String base64Data = data_url.substring(commaIndex + 1);
            String[] headerParts = header.split(";");
            this.mimetype = headerParts[0];
            this.data = Base64.getDecoder().decode(base64Data);
            this.signature = base64Data.hashCode();
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getSiganture() {
            return this.signature;
        }
    }
}

