/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.FederateSearchManager;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.geo.GeoLocation;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.BookmarksDB;
import net.yacy.data.DidYouMean;
import net.yacy.data.UserDB;
import net.yacy.document.LibraryProvider;
import net.yacy.http.servlets.TemplateProcessingException;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.ISO639;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.SetTools;
import net.yacy.peers.EventChannel;
import net.yacy.peers.graphics.ProfilingGraph;
import net.yacy.repository.Blacklist;
import net.yacy.repository.BlacklistHelper;
import net.yacy.search.EventTracker;
import net.yacy.search.SearchAccessRateConstants;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.query.AccessTracker;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.query.SearchEventType;
import net.yacy.search.ranking.RankingProfile;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.server.servletProperties;
import net.yacy.utils.crypt;

public class yacysearch {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Classification.ContentDomain contentdom;
        boolean intranetMode;
        Bitfield constraint;
        Object prefermask;
        boolean stealthmode;
        Switchboard sb = (Switchboard)env;
        sb.localSearchLastAccess = System.currentTimeMillis();
        String authenticatedUserName = null;
        boolean adminAuthenticated = sb.verifyAuthentication(header);
        boolean searchAllowed = sb.getConfigBool("publicSearchpage", true) || adminAuthenticated;
        boolean extendedSearchRights = adminAuthenticated;
        boolean bookmarkRights = false;
        if (adminAuthenticated) {
            authenticatedUserName = sb.getConfig("adminAccountUserName", "admin");
        } else {
            UserDB.Entry user;
            UserDB.Entry entry2 = user = sb.userDB != null ? sb.userDB.getUser(header) : null;
            if (user != null) {
                extendedSearchRights = user.hasRight(UserDB.AccessRight.EXTENDED_SEARCH_RIGHT);
                authenticatedUserName = user.getUserName();
                bookmarkRights = user.hasRight(UserDB.AccessRight.BOOKMARK_RIGHT);
            }
        }
        boolean localhostAccess = header.accessFromLocalhost();
        String promoteSearchPageGreeting = env.getConfigBool("promoteSearchPageGreeting.useNetworkName", false) ? env.getConfig("network.unit.description", "") : env.getConfig("promoteSearchPageGreeting", "");
        String client = header.getRemoteAddr();
        if (extendedSearchRights && sb.getThread("50_localcrawl").getJobCount() > 0) {
            sb.index.fulltext().commit(true);
        }
        boolean focus = post == null ? true : post.get("focus", "1").equals("1");
        String originalquerystring = post == null ? "" : post.get("query", post.get("search", "")).trim();
        originalquerystring = originalquerystring.replace('<', ' ').replace('>', ' ');
        Object querystring = originalquerystring;
        CacheStrategy snippetFetchStrategy = post == null ? null : CacheStrategy.parse(post.get("verify", sb.getConfig("search.verify", "")));
        servletProperties prop = new servletProperties();
        prop.put("topmenu", sb.getConfigBool("publicTopmenu", true) ? 1L : 0L);
        prop.put("authSearch", authenticatedUserName != null);
        Collection<Tagging> vocabularies = LibraryProvider.autotagging.getVocabularies();
        int j = 0;
        for (Tagging v : vocabularies) {
            prop.put("sidebarVocabulary_" + j + "_vocabulary", v.getName());
            ++j;
        }
        prop.put("sidebarVocabulary", j);
        Segment indexSegment = sb.index;
        String EXT = header.get("EXT", "");
        boolean rss = "rss.atom".contains(EXT);
        boolean json = EXT.equals("json");
        prop.put("promoteSearchPageGreeting", promoteSearchPageGreeting);
        String peerContext = YaCyDefaultServlet.getContext(header, sb);
        prop.put("searchBaseURL", peerContext + "/yacysearch.html");
        prop.put("rssYacyImageURL", peerContext + "/env/grafics/yacy.png");
        prop.put("thisaddress", peerContext);
        boolean clustersearch = sb.isRobinsonMode() && sb.getConfig("cluster.mode", "").equals("publiccluster");
        boolean indexReceiveGranted = sb.getConfigBool("allowReceiveIndex.search", true) || clustersearch;
        boolean p2pmode = sb.peers != null && sb.peers.sizeConnected() > 0 && indexReceiveGranted;
        boolean global = post == null || !post.get("resource-switch", post.get("resource", "global")).equals("local") && p2pmode;
        boolean bl = stealthmode = p2pmode && !global;
        if (post == null || indexSegment == null || env == null || !searchAllowed) {
            if (indexSegment == null) {
                ConcurrentLog.info("yacysearch", "indexSegment == null");
            }
            prop.put("searchagain", "0");
            prop.put("former", "");
            prop.put("count", "10");
            prop.put("offset", "0");
            prop.put("resource", "global");
            prop.put("urlmaskfilter", post == null ? ".*" : post.get("urlmaskfilter", ".*"));
            prop.put("prefermaskfilter", post == null ? "" : post.get("prefermaskfilter", ""));
            prop.put("indexof", "off");
            prop.put("constraint", "");
            prop.put("depth", "0");
            prop.put("localQuery", "0");
            prop.put("search.verify", post == null ? sb.getConfig("search.verify", "iffresh") : post.get("verify", "iffresh"));
            prop.put("search.navigation", post == null ? sb.getConfig("search.navigation", "all") : post.get("nav", "all"));
            prop.put("contentdom", "text");
            prop.put("strictContentDom", "false");
            prop.put("contentdomCheckText", "1");
            prop.put("contentdomCheckAudio", "0");
            prop.put("contentdomCheckVideo", "0");
            prop.put("contentdomCheckImage", "0");
            prop.put("contentdomCheckApp", "0");
            prop.put("excluded", "0");
            prop.put("results", "");
            prop.put("resultTable", "0");
            prop.put("num-results", searchAllowed ? "0" : "4");
            prop.put("num-results_totalcount", 0L);
            prop.put("num-results_offset", 0L);
            prop.put("num-results_itemsPerPage", 10L);
            prop.put("geoinfo", "0");
            prop.put("rss_queryenc", "");
            prop.put("meanCount", 5L);
            prop.put("eventID", "");
            return prop;
        }
        if (post.containsKey("auth") && authenticatedUserName == null) {
            prop.authenticationRequired();
            return prop;
        }
        if (post.containsKey("callback")) {
            String jsonp = post.get("callback") + "([";
            prop.put("jsonp-start", jsonp);
            prop.put("jsonp-end", "])");
        } else {
            prop.put("jsonp-start", "");
            prop.put("jsonp-end", "");
        }
        if (rss) {
            ResponseHeader outgoingHeader = new ResponseHeader(200);
            outgoingHeader.put("Access-Control-Allow-Origin", "*");
            prop.setOutgoingHeader(outgoingHeader);
        }
        int timezoneOffset = post.getInt("timezoneOffset", 0);
        int defaultItemsPerPage = sb.getConfigInt("search.items", 10);
        boolean itemsPerPageExplicit = post != null && (post.containsKey("maximumRecords") || post.containsKey("count") || post.containsKey("rows"));
        int itemsPerPage = post.getInt("maximumRecords", post.getInt("count", post.getInt("rows", defaultItemsPerPage)));
        if (itemsPerPage > defaultItemsPerPage && itemsPerPage > 100) {
            itemsPerPage = Math.max(snippetFetchStrategy != null && snippetFetchStrategy.isAllowedToFetchOnline() ? 100 : 1000, defaultItemsPerPage);
        }
        int startRecord = post.getInt("startRecord", post.getInt("offset", post.getInt("start", 0)));
        boolean indexof = post != null && post.get("indexof", "").equals("on");
        Object object = prefermask = post == null ? "" : post.get("prefermaskfilter", "");
        if (!((String)prefermask).isEmpty() && ((String)prefermask).indexOf(".*", 0) < 0) {
            prefermask = ".*" + (String)prefermask + ".*";
        }
        Bitfield bitfield = constraint = post != null && post.containsKey("constraint") && !post.get("constraint", "").isEmpty() ? new Bitfield(4, post.get("constraint", "______")) : null;
        if (indexof) {
            constraint = new Bitfield(4);
            constraint.set(0, true);
        }
        boolean bl2 = intranetMode = sb.isIntranetMode() || sb.isAllIPMode();
        if (!global) {
            if (extendedSearchRights) {
                ++sb.searchQueriesRobinsonFromLocal;
            } else {
                ++sb.searchQueriesRobinsonFromRemote;
            }
        }
        Classification.ContentDomain contentDomain = contentdom = post == null || !post.containsKey("contentdom") ? Classification.ContentDomain.ALL : Classification.ContentDomain.contentdomParser(post.get("contentdom", "all"));
        if (contentdom == Classification.ContentDomain.IMAGE && itemsPerPage == defaultItemsPerPage) {
            itemsPerPage = 20;
        }
        boolean strictContentDom = !Boolean.FALSE.toString().equalsIgnoreCase(post.get("strictContentDom", sb.getConfig("search.strictContentDom", String.valueOf(false))));
        int meanMax = post.getInt("meanCount", 0);
        boolean jsResort = global && (contentdom == Classification.ContentDomain.ALL || contentdom == Classification.ContentDomain.TEXT) && sb.getConfigBool("search.jsresort", false);
        TreeSet<Long> trackerHandles = sb.localSearchTracker.get(client);
        if (trackerHandles == null) {
            trackerHandles = new TreeSet();
        }
        boolean block = false;
        if (Domains.matchesList(client, sb.networkWhitelist)) {
            ConcurrentLog.info("LOCAL_SEARCH", "ACCESS CONTROL: WHITELISTED CLIENT FROM " + client + " gets no search restrictions");
        } else if (Domains.matchesList(client, sb.networkBlacklist)) {
            global = false;
            if (snippetFetchStrategy != null) {
                snippetFetchStrategy = null;
            }
            block = true;
            prop.put("num-results_blockReason", 1L);
            ConcurrentLog.warn("LOCAL_SEARCH", "ACCESS CONTROL: BLACKLISTED CLIENT FROM " + client + " gets no permission to search");
            if (!"html".equals(EXT)) {
                throw new TemplateProcessingException("You are not allowed to search the web with this peer.", 403);
            }
        } else if (!(extendedSearchRights || localhostAccess || intranetMode)) {
            int accInTenMinutes;
            int accInOneMinute;
            int accInThreeSeconds;
            TreeSet<Long> treeSet = trackerHandles;
            synchronized (treeSet) {
                accInThreeSeconds = trackerHandles.tailSet(System.currentTimeMillis() - 3000L).size();
                accInOneMinute = trackerHandles.tailSet(System.currentTimeMillis() - 60000L).size();
                accInTenMinutes = trackerHandles.tailSet(System.currentTimeMillis() - 600000L).size();
            }
            if (global) {
                if (accInTenMinutes >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_P2P_ACCESS_10MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_P2P_ACCESS_10MN.getDefaultValue()) || accInOneMinute >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_P2P_ACCESS_1MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_P2P_ACCESS_1MN.getDefaultValue()) || accInThreeSeconds >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_P2P_ACCESS_3S.getKey(), SearchAccessRateConstants.PUBLIC_MAX_P2P_ACCESS_3S.getDefaultValue())) {
                    global = false;
                    jsResort = false;
                    ConcurrentLog.warn("LOCAL_SEARCH", "ACCESS CONTROL: CLIENT FROM " + client + ": " + accInThreeSeconds + "/3s, " + accInOneMinute + "/60s, " + accInTenMinutes + "/600s,  requests, disallowed global search");
                } else if (accInTenMinutes >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_P2P_JSRESORT_ACCESS_10MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_P2P_JSRESORT_ACCESS_10MN.getDefaultValue()) || accInOneMinute >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_P2P_JSRESORT_ACCESS_1MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_P2P_JSRESORT_ACCESS_1MN.getDefaultValue()) || accInThreeSeconds >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_P2P_JSRESORT_ACCESS_3S.getKey(), SearchAccessRateConstants.PUBLIC_MAX_P2P_JSRESORT_ACCESS_3S.getDefaultValue())) {
                    jsResort = false;
                    ConcurrentLog.warn("LOCAL_SEARCH", "ACCESS CONTROL: CLIENT FROM " + client + ": " + accInThreeSeconds + "/3s, " + accInOneMinute + "/60s, " + accInTenMinutes + "/600s,  requests, disallowed JavaScript resorting of global search results");
                }
            }
            if (snippetFetchStrategy != null && snippetFetchStrategy.isAllowedToFetchOnline() && (accInTenMinutes >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_REMOTE_SNIPPET_ACCESS_10MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_REMOTE_SNIPPET_ACCESS_10MN.getDefaultValue()) || accInOneMinute >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_REMOTE_SNIPPET_ACCESS_1MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_REMOTE_SNIPPET_ACCESS_1MN.getDefaultValue()) || accInThreeSeconds >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_REMOTE_SNIPPET_ACCESS_3S.getKey(), SearchAccessRateConstants.PUBLIC_MAX_REMOTE_SNIPPET_ACCESS_3S.getDefaultValue()))) {
                snippetFetchStrategy = CacheStrategy.CACHEONLY;
                ConcurrentLog.warn("LOCAL_SEARCH", "ACCESS CONTROL: CLIENT FROM " + client + ": " + accInThreeSeconds + "/3s, " + accInOneMinute + "/60s, " + accInTenMinutes + "/600s,  requests, disallowed remote snippet loading");
            }
            String timePeriodMsg = "";
            if (accInTenMinutes >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_ACCESS_10MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_ACCESS_10MN.getDefaultValue())) {
                block = true;
                timePeriodMsg = "ten minutes";
                prop.put("num-results_blockReason", 2L);
            } else if (accInOneMinute >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_ACCESS_1MN.getKey(), SearchAccessRateConstants.PUBLIC_MAX_ACCESS_1MN.getDefaultValue())) {
                block = true;
                timePeriodMsg = "one minute";
                prop.put("num-results_blockReason", 3L);
            } else if (accInThreeSeconds >= sb.getConfigInt(SearchAccessRateConstants.PUBLIC_MAX_ACCESS_3S.getKey(), SearchAccessRateConstants.PUBLIC_MAX_ACCESS_3S.getDefaultValue())) {
                block = true;
                timePeriodMsg = "three seconds";
                prop.put("num-results_blockReason", 4L);
            }
            if (block) {
                ConcurrentLog.warn("LOCAL_SEARCH", "ACCESS CONTROL: CLIENT FROM " + client + ": " + accInThreeSeconds + "/3s, " + accInOneMinute + "/60s, " + accInTenMinutes + "/600s,  requests, disallowed search");
                if (!"html".equals(EXT)) {
                    throw new TemplateProcessingException("You have reached the maximum allowed number of accesses to this search service within " + timePeriodMsg + ". Please try again later or log in as administrator or as a user with extended search right.", 429);
                }
            }
        }
        if (block) {
            prop.put("num-results", 5L);
        } else {
            String language;
            int heuristicOS;
            int inlinkp;
            int inurlp;
            Object urlmask = post == null ? ".*" : post.get("urlmaskfilter", ".*");
            String tld = null;
            String inlink = null;
            if (!MemoryControl.request(8000000L, false)) {
                indexSegment.clearCaches();
                SearchEventCache.cleanupEvents(false);
            }
            RankingProfile ranking = sb.getRanking();
            QueryModifier modifier = new QueryModifier(timezoneOffset);
            querystring = modifier.parse((String)querystring);
            if (modifier.sitehost != null && modifier.sitehost.length() > 0 && ((String)querystring).length() == 0) {
                querystring = "*";
            }
            modifier.collection = post.get("collection", modifier.collection);
            int stp = ((String)querystring).indexOf(42);
            if (stp >= 0) {
                querystring = ((String)querystring).length() == 1 ? "yacyall" : ((String)querystring).replaceAll("\\* ", "yacyall ").replace(" \\*", " yacyall");
            }
            if (((String)querystring).indexOf("/near", 0) >= 0) {
                querystring = ((String)querystring).replace("/near", "");
                ranking.allZero();
                ranking.coeff_worddistance = 15;
                modifier.add("/near");
            }
            if (((String)querystring).indexOf("/date", 0) >= 0) {
                querystring = ((String)querystring).replace("/date", "");
                ranking.allZero();
                ranking.coeff_date = 15;
                modifier.add("/date");
            }
            if (((String)querystring).indexOf("/location", 0) >= 0) {
                querystring = ((String)querystring).replace("/location", "");
                if (constraint == null) {
                    constraint = new Bitfield(4);
                }
                constraint.set(19, true);
                modifier.add("/location");
            }
            if ((inurlp = ((String)querystring).indexOf("inurl:", 0)) >= 0) {
                int ftb = ((String)querystring).indexOf(32, inurlp);
                if (ftb == -1) {
                    ftb = ((String)querystring).length();
                }
                String urlstr = ((String)querystring).substring(inurlp + 6, ftb);
                querystring = ((String)querystring).replace("inurl:" + urlstr, "");
                if (!urlstr.isEmpty()) {
                    urlmask = urlmask == null || ((String)urlmask).equals(".*") ? ".*" + urlstr + ".*" : urlmask;
                }
                modifier.add("inurl:" + urlstr);
            }
            if ((inlinkp = ((String)querystring).indexOf("inlink:", 0)) >= 0) {
                int ftb = ((String)querystring).indexOf(32, inlinkp);
                if (ftb == -1) {
                    ftb = ((String)querystring).length();
                }
                inlink = ((String)querystring).substring(inlinkp + 7, ftb);
                querystring = ((String)querystring).replace("inlink:" + inlink, "");
                modifier.add("inlink:" + inlink);
            }
            int voc = 0;
            ArrayList<Tagging.Metatag> metatags = new ArrayList<Tagging.Metatag>(1);
            while ((voc = ((String)querystring).indexOf("/vocabulary/", 0)) >= 0) {
                String v;
                String k;
                Tagging.Metatag mt;
                String vocabulary = "";
                int ve = ((String)querystring).indexOf(32, voc + 12);
                if (ve < 0) {
                    vocabulary = ((String)querystring).substring(voc);
                    querystring = ((String)querystring).substring(0, voc).trim();
                } else {
                    vocabulary = ((String)querystring).substring(voc, ve);
                    querystring = ((String)querystring).substring(0, voc) + ((String)querystring).substring(ve);
                }
                modifier.add(vocabulary);
                int p = (vocabulary = vocabulary.substring(12)).indexOf(47);
                if (p <= 0 || (mt = LibraryProvider.autotagging.metatag(k = vocabulary.substring(0, p), v = vocabulary.substring(p + 1))) == null) continue;
                metatags.add(mt);
            }
            int radius = 0;
            double lon = 0.0;
            double lat = 0.0;
            double rad = 0.0;
            radius = ((String)querystring).indexOf("/radius/");
            if (radius >= 0) {
                int ve = ((String)querystring).indexOf(32, radius + 8);
                String geo = "";
                if (ve < 0) {
                    geo = ((String)querystring).substring(radius);
                    querystring = ((String)querystring).substring(0, radius).trim();
                } else {
                    geo = ((String)querystring).substring(radius, ve);
                    querystring = ((String)querystring).substring(0, radius) + ((String)querystring).substring(ve);
                }
                geo = geo.substring(8);
                String[] sp = geo.split("/");
                if (sp.length == 3) {
                    try {
                        lat = Double.parseDouble(sp[0]);
                        lon = Double.parseDouble(sp[1]);
                        rad = Double.parseDouble(sp[2]);
                    }
                    catch (NumberFormatException e) {
                        lon = 0.0;
                        lat = 0.0;
                        rad = 0.0;
                    }
                }
            }
            if ((heuristicOS = ((String)querystring).indexOf("/heuristic", 0)) >= 0) {
                querystring = ((String)querystring).replace("/heuristic", "");
                modifier.add("/heuristic");
            }
            String tldModifierPrefix = "tld:";
            int tldp = ((String)querystring).indexOf("tld:", 0);
            if (tldp >= 0) {
                int ftb = ((String)querystring).indexOf(32, tldp);
                if (ftb == -1) {
                    ftb = ((String)querystring).length();
                }
                tld = ((String)querystring).substring(tldp + "tld:".length(), ftb);
                querystring = ((String)querystring).replace("tld:" + tld, "");
                modifier.add("tld:" + tld);
                while (tld.length() > 0 && tld.charAt(0) == '.') {
                    tld = tld.substring(1);
                }
                if (tld.length() == 0) {
                    tld = null;
                } else {
                    try {
                        tld = IDN.toASCII(tld, 0);
                    }
                    catch (IllegalArgumentException e) {
                        ConcurrentLog.warn("LOCAL_SEARCH", "Failed to convert tld modifier value " + tld + "to ASCII Compatible Encoding (ACE)", e);
                    }
                    tld = tld.toLowerCase(Locale.ROOT);
                }
            }
            if (urlmask == null || ((String)urlmask).isEmpty()) {
                urlmask = ".*";
            }
            String string = language = post == null ? null : post.get("lr");
            if (language != null && language.startsWith("lang_")) {
                language = language.substring(5);
                if (modifier.language == null) {
                    modifier.language = language;
                }
            }
            if (language == null || !ISO639.exists(language)) {
                String agent = header.get("Accept-Language");
                if (agent == null) {
                    agent = System.getProperty("user.language");
                }
                String string2 = language = agent == null ? "en" : ISO639.userAgentLanguageDetection(agent);
                if (language == null) {
                    language = "en";
                }
            }
            QueryGoal qg = new QueryGoal(((String)querystring).trim());
            int maxDistance = ((String)querystring).indexOf(34, 0) >= 0 ? qg.getIncludeHashes().size() - 1 : Integer.MAX_VALUE;
            SortedSet<String> filtered = SetTools.joinConstructiveByTest(qg.getIncludeWords(), Switchboard.stopwords);
            qg.removeIncludeWords(filtered);
            if (post != null && post.containsKey("deleteref")) {
                try {
                    if (!sb.verifyAuthentication(header)) {
                        prop.authenticationRequired();
                        return prop;
                    }
                    String delHash = post.get("deleteref", "");
                    if (indexSegment.termIndex() != null) {
                        indexSegment.termIndex().remove(qg.getIncludeHashes(), delHash.getBytes());
                    }
                    indexSegment.fulltext().remove(delHash.getBytes());
                    if (!sb.isRobinsonMode()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("urlhash", delHash);
                        map.put("vote", "negative");
                        map.put("refid", "");
                        sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "stippavt", map);
                    }
                    SearchEventCache.delete(delHash);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            if (post != null && post.containsKey("recommendref")) {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
                String recommendHash = post.get("recommendref", "");
                URIMetadataNode urlentry = indexSegment.fulltext().getMetadata(UTF8.getBytes(recommendHash));
                if (urlentry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("url", urlentry.url().toNormalform(true).replace(',', '|'));
                    map.put("title", urlentry.dc_title().replace(',', ' '));
                    map.put("description", urlentry.getDescription().isEmpty() ? urlentry.dc_title().replace(',', ' ') : urlentry.getDescription().get(0).replace(',', ' '));
                    map.put("author", urlentry.dc_creator());
                    map.put("tags", urlentry.dc_subject().replace(',', ' '));
                    sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "stippadd", map);
                }
            }
            if (post != null && post.containsKey("bookmarkref")) {
                BookmarksDB.Bookmark bmk;
                if (!sb.verifyAuthentication(header) && !bookmarkRights) {
                    prop.authenticationRequired();
                    return prop;
                }
                String urlstr = crypt.simpleDecode(post.get("bookmarkurl"));
                if (urlstr != null && (bmk = sb.bookmarksDB.createorgetBookmark(urlstr, "admin")) != null) {
                    bmk.setProperty("bookmarkQuery", (String)querystring);
                    bmk.addTag("/search");
                    bmk.addTag("searchresult");
                    String urlhash = post.get("bookmarkref");
                    URIMetadataNode urlentry = indexSegment.fulltext().getMetadata(UTF8.getBytes(urlhash));
                    if (urlentry != null && !urlentry.dc_title().isEmpty()) {
                        bmk.setProperty("bookmarkTitle", urlentry.dc_title());
                    }
                    sb.bookmarksDB.saveBookmark(bmk);
                }
            }
            if (post != null && post.containsKey("blacklisturl")) {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
                String blacklisturl = crypt.simpleDecode(post.get("blacklisturl", ""));
                try {
                    MultiProtocolURL mpurl = new MultiProtocolURL(blacklisturl);
                    BlacklistHelper.addBlacklistEntry(Blacklist.defaultBlacklist(sb.listsPath), mpurl.getHost() + "/.*");
                }
                catch (MalformedURLException mpurl) {
                    // empty catch block
                }
            }
            try {
                Pattern.compile((String)urlmask);
            }
            catch (PatternSyntaxException ex) {
                SearchEvent.log.warn("Illegal URL mask, not a valid regex: " + (String)urlmask);
                prop.put("urlmaskerror", 1L);
                prop.putHTML("urlmaskerror_urlmask", (String)urlmask);
                urlmask = ".*";
            }
            try {
                Pattern.compile((String)prefermask);
            }
            catch (PatternSyntaxException ex) {
                SearchEvent.log.warn("Illegal prefer mask, not a valid regex: " + (String)prefermask);
                prop.put("prefermaskerror", 1L);
                prop.putHTML("prefermaskerror_prefermask", (String)prefermask);
                prefermask = "";
            }
            QueryParams theQuery = new QueryParams(qg, modifier, maxDistance, (String)prefermask, contentdom, language, timezoneOffset, metatags, snippetFetchStrategy, itemsPerPage, startRecord, (String)urlmask, tld, inlink, clustersearch && global ? QueryParams.Searchdom.CLUSTER : (global && indexReceiveGranted ? QueryParams.Searchdom.GLOBAL : QueryParams.Searchdom.LOCAL), constraint, true, DigestURL.hosthashess(sb.getConfig("search.excludehosth", "")), 255, client, extendedSearchRights, indexSegment, ranking, header.get("User-Agent", ""), lat, lon, rad, sb.getConfigSet("search.navigation"));
            theQuery.setStrictContentDom(strictContentDom);
            theQuery.setMaxSuggestions(meanMax);
            theQuery.setStandardFacetsMaxCount(sb.getConfigInt("search.navigation.maxcount", 100));
            theQuery.setDateFacetMaxCount(sb.getConfigInt("search.navigation.dates.maxcount", 640));
            EventTracker.delete(EventTracker.EClass.SEARCH);
            EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(theQuery.id(true), SearchEventType.INITIALIZATION, "", 0, 0L), false);
            sb.intermissionAllThreads(3000L);
            theQuery.getQueryGoal().filterOut(Switchboard.blueList);
            ConcurrentLog.info("LOCAL_SEARCH", "INIT WORD SEARCH: " + theQuery.getQueryGoal().getQueryString(false) + ":" + QueryParams.hashSet2hashString(theQuery.getQueryGoal().getIncludeHashes()) + " - " + theQuery.neededResults() + " links to be computed, " + theQuery.itemsPerPage() + " lines to be displayed");
            EventChannel.channels(EventChannel.LOCALSEARCH).addMessage(new RSSMessage("Local Search Request", theQuery.getQueryGoal().getQueryString(false), ""));
            long timestamp = System.currentTimeMillis();
            SearchEvent cachedEvent = SearchEventCache.getEvent(theQuery.id(false));
            if (cachedEvent == null) {
                theQuery.setOffset(0);
                startRecord = 0;
            }
            ConcurrentLog.info("LOCAL_SEARCH", "SEARCH EVENT: id=" + theQuery.id(false) + " cached=" + (cachedEvent != null) + " query=" + theQuery.getQueryGoal().getQueryString(false) + " startRecord=" + startRecord + " itemsPerPage=" + theQuery.itemsPerPage());
            SearchEvent theSearch = SearchEventCache.getEvent(theQuery, sb.peers, sb.tables, sb.isRobinsonMode() ? sb.clusterhashes : null, false, sb.loader, (int)sb.getConfigLong("remotesearch.maxcount", sb.getConfigLong("network.unit.remotesearch.maxcount", 10L)), sb.getConfigLong("remotesearch.maxtime", sb.getConfigLong("network.unit.remotesearch.maxtime", 3000L)));
            if (post.getBoolean("resortCachedResults") && cachedEvent == theSearch) {
                theSearch.resortCachedResults();
            }
            if (startRecord == 0 && extendedSearchRights && !stealthmode) {
                if (modifier.sitehost != null && sb.getConfigBool("heuristic.site", false)) {
                    sb.heuristicSite(theSearch, modifier.sitehost);
                }
                if (heuristicOS >= 0 || sb.getConfigBool("heuristic.opensearch", false)) {
                    FederateSearchManager.getManager().search(theSearch);
                }
            }
            ConcurrentLog.info("LOCAL_SEARCH", "EXIT WORD SEARCH: " + theQuery.getQueryGoal().getQueryString(false) + " - local_rwi_available(" + theSearch.local_rwi_available.get() + "), local_rwi_stored(" + theSearch.local_rwi_stored.get() + "), remote_rwi_available(" + theSearch.remote_rwi_available.get() + "), remote_rwi_stored(" + theSearch.remote_rwi_stored.get() + "), remote_rwi_peerCount(" + theSearch.remote_rwi_peerCount.get() + "), local_solr_evicted(" + theSearch.local_solr_evicted.get() + "), local_solr_stored(" + theSearch.local_solr_stored.get() + "), remote_solr_available(" + theSearch.remote_solr_available.get() + "), remote_solr_stored(" + theSearch.remote_solr_stored.get() + "), remote_solr_peerCount(" + theSearch.remote_solr_peerCount.get() + "), " + (System.currentTimeMillis() - timestamp) + " ms");
            theQuery.searchtime = System.currentTimeMillis() - timestamp;
            theQuery.urlretrievaltime = theSearch.getURLRetrievalTime();
            theQuery.snippetcomputationtime = theSearch.getSnippetComputationTime();
            AccessTracker.add(AccessTracker.Location.local, theQuery, theSearch.getResultCount());
            prop.put("meanCount", meanMax);
            if (meanMax > 0 && startRecord == 0 && !json && !rss) {
                int meanCount;
                DidYouMean didYouMean = new DidYouMean(indexSegment, (String)querystring);
                Iterator<StringBuilder> meanIt = didYouMean.getSuggestions(100L, 5, sb.index.fulltext().collectionSize() < 2000000L).iterator();
                try {
                    for (meanCount = 0; meanCount < meanMax && meanIt.hasNext(); ++meanCount) {
                        try {
                            String suggestion = meanIt.next().toString();
                            prop.put("didYouMean_suggestions_" + meanCount + "_word", suggestion);
                            prop.put("didYouMean_suggestions_" + meanCount + "_url", QueryParams.navUrlWithNewQueryString(RequestHeader.FileType.HTML, 0, theQuery, suggestion, authenticatedUserName != null));
                            prop.put("didYouMean_suggestions_" + meanCount + "_sep", "|");
                            continue;
                        }
                        catch (ConcurrentModificationException e) {
                            ConcurrentLog.logException(e);
                            break;
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    ConcurrentLog.logException(e);
                }
                prop.put("didYouMean_suggestions_" + (meanCount - 1) + "_sep", "");
                prop.put("didYouMean", meanCount > 0 ? 1L : 0L);
                prop.put("didYouMean_suggestions", meanCount);
            } else {
                prop.put("didYouMean", 0L);
            }
            TreeSet<GeoLocation> coordinates = LibraryProvider.geoLoc.find(originalquerystring, false);
            if (coordinates == null || coordinates.isEmpty() || startRecord > 0) {
                prop.put("geoinfo", "0");
            } else {
                int i = 0;
                for (GeoLocation c : coordinates) {
                    prop.put("geoinfo_loc_" + i + "_lon", (float)Math.round(c.lon() * 10000.0) / 10000.0f);
                    prop.put("geoinfo_loc_" + i + "_lat", (float)Math.round(c.lat() * 10000.0) / 10000.0f);
                    prop.put("geoinfo_loc_" + i + "_name", c.getName());
                    if (++i < 10) continue;
                    break;
                }
                prop.put("geoinfo_loc", i);
                prop.put("geoinfo", "1");
            }
            try {
                TreeSet<Long> i = trackerHandles;
                synchronized (i) {
                    trackerHandles.add(theQuery.starttime);
                    while (trackerHandles.size() > 600 && trackerHandles.remove(trackerHandles.first())) {
                    }
                }
                sb.localSearchTracker.put(client, trackerHandles);
                if (sb.localSearchTracker.size() > 100) {
                    sb.localSearchTracker.remove(sb.localSearchTracker.keys().nextElement());
                }
                if (MemoryControl.shortStatus()) {
                    sb.localSearchTracker.clear();
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            prop.put("num-results_offset", startRecord);
            prop.put("num-results_itemscount", Formatter.number(startRecord + theSearch.query.itemsPerPage > theSearch.getResultCount() ? (long)(startRecord + theSearch.getResultCount() % theSearch.query.itemsPerPage) : (long)(startRecord + theSearch.query.itemsPerPage), true));
            prop.put("num-results_itemsPerPage", Formatter.number(itemsPerPage));
            prop.put("num-results_totalcount", Formatter.number(theSearch.getResultCount()));
            prop.put("num-results_globalresults", global && (indexReceiveGranted || clustersearch) ? "1" : "0");
            prop.put("num-results_globalresults_localIndexCount", Formatter.number(theSearch.local_rwi_stored.get() + theSearch.local_solr_stored.get(), true));
            prop.put("num-results_globalresults_remoteResourceSize", Formatter.number(theSearch.remote_rwi_stored.get() + theSearch.remote_solr_stored.get(), true));
            prop.put("num-results_globalresults_remoteIndexCount", Formatter.number(theSearch.remote_rwi_available.get() + theSearch.remote_solr_available.get(), true));
            prop.put("num-results_globalresults_remotePeerCount", Formatter.number(theSearch.remote_rwi_peerCount.get() + theSearch.remote_solr_peerCount.get(), true));
            if (theSearch.getResultCount() == 0 && ((String)querystring).length() > 0) {
                ConcurrentLog.info("LOCAL_SEARCH", "ZERO RESULTS: id=" + theQuery.id(false) + " query=" + theQuery.getQueryGoal().getQueryString(false) + " localAvailable=" + (theSearch.local_rwi_available.get() + theSearch.local_solr_stored.get()) + " localStored=" + (theSearch.local_rwi_stored.get() + theSearch.local_solr_stored.get()) + " remoteAvailable=" + (theSearch.remote_rwi_available.get() + theSearch.remote_solr_available.get()) + " remoteStored=" + (theSearch.remote_rwi_stored.get() + theSearch.remote_solr_stored.get()) + " feedRunning=" + !theSearch.isFeedingFinished());
            }
            prop.put("jsResort", jsResort);
            prop.put("num-results_jsResort", jsResort);
            prop.put("resortEnabled", !jsResort && global && !stealthmode && theSearch.resortCacheAllowed.availablePermits() > 0 ? 1L : 0L);
            prop.put("resortEnabled_url", QueryParams.navurlBase(RequestHeader.FileType.HTML, theQuery, null, true, authenticatedUserName != null).append("&startRecord=").append(startRecord).append("&resortCachedResults=true").toString());
            for (int i = 0; i < theQuery.itemsPerPage(); ++i) {
                prop.put("results_" + i + "_item", startRecord + i);
                prop.put("results_" + i + "_eventID", theQuery.id(false));
                prop.put("jsResort_results_" + i + "_item", startRecord + i);
                prop.put("jsResort_results_" + i + "_eventID", theQuery.id(false));
            }
            prop.put("results", theQuery.itemsPerPage());
            prop.put("jsResort_results", theQuery.itemsPerPage());
            prop.put("resultTable", contentdom == Classification.ContentDomain.APP || contentdom == Classification.ContentDomain.VIDEO ? 1L : (long)(contentdom == Classification.ContentDomain.AUDIO ? 2 : 0));
            prop.put("resultTable_embed", contentdom == Classification.ContentDomain.AUDIO && extendedSearchRights);
            prop.put("eventID", theQuery.id(false));
            prop.put("jsResort_eventID", theQuery.id(false));
            if (!filtered.isEmpty()) {
                prop.put("excluded", "1");
                prop.putHTML("excluded_stopwords", filtered.toString());
            } else {
                prop.put("excluded", "0");
            }
            if (prop.isEmpty() || ((String)querystring).length() == 0) {
                if (((String)querystring).length() == 0) {
                    prop.put("num-results", "2");
                } else {
                    prop.put("num-results", "1");
                }
            } else {
                prop.put("num-results", "3");
            }
            prop.put("depth", "0");
            prop.put("localQuery", theSearch.query.isLocal() ? "1" : "0");
            prop.put("jsResort_localQuery", theSearch.query.isLocal() ? "1" : "0");
            boolean showLogin = sb.getConfigBool("search.publicTopNavBar.login", true);
            if (showLogin) {
                if (authenticatedUserName != null) {
                    prop.put("showLogin", 1L);
                    prop.put("showLogin_userName", authenticatedUserName);
                } else {
                    prop.put("showLogin", 2L);
                    prop.put("showLogin_loginURL", QueryParams.navurlBase(RequestHeader.FileType.HTML, theQuery, null, true, true).toString());
                }
            } else {
                prop.put("showLogin", 0L);
            }
        }
        prop.put("focus", focus ? 1L : 0L);
        prop.put("searchagain", global ? "1" : "0");
        String former = originalquerystring.replaceAll("yacyall", "*");
        prop.putHTML("former", former);
        try {
            prop.put("formerEncoded", URLEncoder.encode(former, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            ConcurrentLog.warn("LOCAL_SEARCH", "Unsupported UTF-8 encoding!");
            prop.put("formerEncoded", former);
        }
        prop.put("count", itemsPerPage);
        prop.put("offset", startRecord);
        prop.put("resource", global ? "global" : "local");
        prop.putHTML("prefermaskfilter", (String)prefermask);
        prop.put("indexof", indexof ? "on" : "off");
        prop.put("constraint", constraint == null ? "" : constraint.exportB64());
        prop.put("search.verify", snippetFetchStrategy == null ? sb.getConfig("search.verify", "iffresh") : snippetFetchStrategy.toName());
        prop.put("search.navigation", post == null ? sb.getConfig("search.navigation", "all") : post.get("nav", "all"));
        prop.putHTML("contentdom", post == null ? "text" : post.get("contentdom", "text"));
        prop.putHTML("strictContentDom", String.valueOf(strictContentDom));
        prop.putXML("rss_query", originalquerystring);
        prop.putXML("rss_queryenc", originalquerystring.replace(' ', '+'));
        sb.localSearchLastAccess = System.currentTimeMillis();
        return prop;
    }
}

