/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.io.IOException;
import java.net.MalformedURLException;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Fulltext;
import net.yacy.search.schema.HyperlinkEdge;
import net.yacy.search.schema.HyperlinkGraph;
import net.yacy.search.schema.HyperlinkType;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.server.servletProperties;

public class linkstructure {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        servletProperties prop = new servletProperties();
        String ext = header.get("EXT", "");
        boolean xml = ext.equals("xml");
        Switchboard sb = (Switchboard)env;
        Fulltext fulltext = sb.index.fulltext();
        if (post == null) {
            return prop;
        }
        boolean authenticated = sb.adminAuthenticated(header) >= 2;
        int maxtime = Math.min(post.getInt("maxtime", 60000), authenticated ? 300000 : 1000);
        int maxnodes = Math.min(post.getInt("maxnodes", 10000), authenticated ? 10000000 : 100);
        HyperlinkGraph hlg = new HyperlinkGraph();
        int maxdepth = 0;
        if (post.get("about", "").length() > 0) {
            try {
                String about = post.get("about", "");
                DigestURL url = null;
                String hostname = null;
                if (about.length() == 12 && Base64Order.enhancedCoder.wellformed(ASCII.getBytes(about))) {
                    byte[] urlhash = ASCII.getBytes(about);
                    try {
                        String u = authenticated ? sb.getURL(urlhash) : null;
                        url = u == null ? null : new DigestURL(u);
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                } else if (url == null && about.length() > 0) {
                    url = new DigestURL((String)(about.indexOf("://") >= 0 ? about : "http://" + about));
                    hostname = url.getHost();
                }
                if (hostname == null) {
                    return prop;
                }
                hlg.fill(fulltext.getDefaultConnector(), hostname, null, maxtime, maxnodes);
                maxdepth = hlg.findLinkDepth();
            }
            catch (MalformedURLException about) {}
        } else if (post.get("to", "").length() > 0) {
            try {
                DigestURL to = new DigestURL(post.get("to", ""), null);
                DigestURL from = post.get("from", "").length() == 0 ? null : new DigestURL(post.get("from", ""));
                hlg.path(sb.index, from, to, maxtime, maxnodes);
            }
            catch (MalformedURLException to) {
                // empty catch block
            }
        }
        linkstructure.writeGraph(prop, hlg, maxdepth);
        if (xml) {
            ResponseHeader outgoingHeader = new ResponseHeader(200);
            outgoingHeader.put("Access-Control-Allow-Origin", "*");
            prop.setOutgoingHeader(outgoingHeader);
        }
        return prop;
    }

    private static void writeGraph(servletProperties prop, HyperlinkGraph hlg, int maxdepth) {
        int c = 0;
        for (HyperlinkEdge e : hlg) {
            prop.putJSON("edges_" + c + "_source", e.source.getPath());
            prop.putJSON("edges_" + c + "_target", e.target.type.equals((Object)HyperlinkType.Outbound) ? e.target.toNormalform(true) : e.target.getPath());
            prop.putJSON("edges_" + c + "_type", e.target.type.name());
            Integer depth_source = hlg.getDepth(e.source);
            Integer depth_target = hlg.getDepth(e.target);
            prop.put("edges_" + c + "_depthSource", depth_source == null ? -1L : (long)depth_source.intValue());
            prop.put("edges_" + c + "_depthTarget", depth_target == null ? -1L : (long)depth_target.intValue());
            ++c;
        }
        prop.put("edges", c);
        prop.put("maxdepth", maxdepth);
    }
}

