/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.storage.ConcurrentARC;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.workflow.WorkflowProcessor;
import net.yacy.peers.graphics.EncodedImage;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.visualization.ImageViewer;

public class ViewFavicon {
    private static final ImageViewer VIEWER = new ImageViewer();
    private static Map<String, byte[]> pngIconCache = new ConcurrentARC<String, byte[]>(1000, Math.max(10, Math.min(32, WorkflowProcessor.availableCPU * 2)));
    private static final String defaulticon = "htroot/env/grafics/dfltfvcn.ico";
    private static byte[] defaultPNGEncodedIcon = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        String ext = header.get("EXT", null);
        boolean isPNGTarget = "png".equalsIgnoreCase(ext);
        ImageInputStream imageInStream = null;
        InputStream inStream = null;
        byte[] resultBytes = null;
        try {
            if (MemoryControl.shortStatus()) {
                pngIconCache.clear();
            }
            boolean auth = ImageViewer.hasFullViewingRights(header, sb);
            DigestURL url = VIEWER.parseURL(post, auth);
            String normalizedURL = url.toNormalform(false);
            if (isPNGTarget) {
                resultBytes = pngIconCache.get(normalizedURL);
            }
            if (resultBytes == null) {
                String urlExt = MultiProtocolURL.getFileExtension(url.getFileName());
                if (ext != null && ext.equalsIgnoreCase(urlExt) && ImageViewer.isBrowserRendered(urlExt)) {
                    InputStream inputStream = VIEWER.openInputStream(post, sb.loader, auth, url);
                    return inputStream;
                }
                if (url.isFile()) {
                    imageInStream = ImageIO.createImageInputStream(url.getFSFile());
                } else {
                    inStream = VIEWER.openInputStream(post, sb.loader, auth, url);
                    imageInStream = ImageIO.createImageInputStream(inStream);
                }
                EncodedImage encodedIcon = VIEWER.parseAndScale(post, auth, url, ext, imageInStream);
                if (encodedIcon != null && !encodedIcon.getImage().isEmpty()) {
                    resultBytes = encodedIcon.getImage().getBytes();
                    if (isPNGTarget && encodedIcon.getImage().length() <= 10240) {
                        pngIconCache.put(normalizedURL, resultBytes);
                    }
                }
            }
        }
        catch (IOException e) {
            ConcurrentLog.fine("ViewFavicon", "Error loading favicon, default one wille be used : " + String.valueOf(e));
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            if (resultBytes == null) {
                if (ext == null || isPNGTarget) {
                    if (defaultPNGEncodedIcon == null) {
                        defaultPNGEncodedIcon = ViewFavicon.loadDefaultIcon(post, sb, ext);
                    }
                    resultBytes = defaultPNGEncodedIcon;
                } else {
                    resultBytes = ViewFavicon.loadDefaultIcon(post, sb, ext);
                }
            }
        }
        return new ByteArrayInputStream(resultBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadDefaultIcon(serverObjects post, Switchboard sb, String ext) {
        byte[] resultBytes;
        byte[] defaultBytes = new byte[]{};
        try {
            defaultBytes = FileUtils.read(new File(sb.getAppPath(), defaulticon));
        }
        catch (IOException initicon) {
            defaultBytes = new byte[]{};
        }
        finally {
            resultBytes = new EncodedImage(defaultBytes, ext, post.getBoolean("isStatic")).getImage().getBytes();
        }
        return resultBytes;
    }
}

