/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.TransactionManager;
import net.yacy.data.WorkTables;
import net.yacy.kelondro.blob.Tables;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryParams;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Table_API_p {
    private static final int DEFAULT_MAX_RECORDS = 25;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Tables.SortDirection sortDir;
        String sortColumn;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        SimpleDateFormat dateFormat = GenericFormatter.newSimpleDateFormat();
        prop.put("showexec", 0L);
        prop.put("showtable", 0L);
        int startRecord = 0;
        int maximumRecords = 25;
        Pattern query2 = QueryParams.catchall_pattern;
        if (post != null && post.containsKey("startRecord")) {
            startRecord = post.getInt("startRecord", 0);
        }
        if (post != null && post.containsKey("maximumRecords")) {
            maximumRecords = post.getInt("maximumRecords", 0);
        }
        String queryParam = "";
        if (post != null && post.containsKey("query") && !post.get("query", "").isEmpty()) {
            queryParam = post.get("query", "");
            query2 = Pattern.compile(".*" + queryParam + ".*");
        }
        boolean inline = post != null && post.getBoolean("inline");
        prop.put("inline", inline ? 1L : 0L);
        Pattern typefilter = QueryParams.catchall_pattern;
        if (post != null && post.containsKey("filter") && post.get("filter", "").length() > 0) {
            typefilter = Pattern.compile(post.get("filter", ".*"));
        }
        String sortParam = "date_recording";
        if (post != null) {
            sortParam = post.get("sort", "date_recording").trim();
        }
        if (sortParam.startsWith("-")) {
            sortColumn = sortParam.substring(1);
            sortDir = Tables.SortDirection.DESC;
        } else {
            sortColumn = sortParam;
            sortDir = Tables.SortDirection.ASC;
        }
        boolean scheduleeventaction = false;
        String current_pk = "";
        if (post != null && post.containsKey("scheduleeventaction")) {
            scheduleeventaction = post.get("scheduleeventaction", "false").equalsIgnoreCase("true");
            prop.put("scheduleeventaction", "false");
            current_pk = post.get("current_pk", "");
        }
        if (post != null && scheduleeventaction && !current_pk.isEmpty()) {
            TransactionManager.checkPostTransaction(header, post);
            try {
                Tables.Row row = sb.tables.select("api", current_pk.getBytes());
                if (row != null) {
                    String kind;
                    String action;
                    if (post.containsKey("event_select_" + current_pk) && post.get("event_select_" + current_pk, "off").equals("on")) {
                        row.put("apicall_event_kind", "regular");
                        row.put("apicall_event_action", "startup");
                    }
                    if (post.containsKey("event_kind_" + current_pk)) {
                        action = post.get("event_kind_" + current_pk, "off");
                        if ("off".equals(action)) {
                            row.put("date_next_exec", "");
                        }
                        row.put("apicall_event_kind", action);
                    }
                    if (post.containsKey("event_action_" + current_pk)) {
                        row.put("apicall_event_action", post.get("event_action_" + current_pk, "startup"));
                    }
                    if (post.containsKey("repeat_select_" + current_pk) && post.get("repeat_select_" + current_pk, "off").equals("on")) {
                        row.put("apicall_schedule_time", 7);
                        row.put("apicall_schedule_unit", "days");
                    }
                    if (post.containsKey("repeat_time_" + current_pk)) {
                        action = post.get("repeat_time_" + current_pk, "off");
                        if ("off".equals(action)) {
                            row.put("apicall_schedule_time", 0);
                        } else {
                            row.put("apicall_schedule_time", Integer.parseInt(action));
                        }
                    }
                    if (post.containsKey("repeat_unit_" + current_pk)) {
                        action = post.get("repeat_unit_" + current_pk, "seldays");
                        int time = row.get("apicall_schedule_time", 1);
                        row.put("apicall_schedule_unit", action.substring(3));
                        if (action.equals("selminutes") && time > 0 && time < 10) {
                            row.put("apicall_schedule_time", 10);
                        }
                        if (action.equals("selminutes") && time > 59) {
                            row.put("apicall_schedule_time", 59);
                        }
                        if (action.equals("selhours") && time > 23) {
                            row.put("apicall_schedule_time", 23);
                        }
                        if (action.equals("seldays") && time > 30) {
                            row.put("apicall_schedule_time", 30);
                        }
                    }
                    if ("regular".equals(kind = row.get("apicall_event_kind", "off"))) {
                        row.put("apicall_schedule_time", 0);
                    }
                    WorkTables.calculateAPIScheduler(row, false);
                    sb.tables.update("api", row);
                }
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
        }
        HashMap<String, String> invalidNextExecDateFormats = new HashMap<String, String>();
        HashMap<String, String> nextExecDatesBeforeNow = new HashMap<String, String>();
        if (post != null && post.containsKey("submitNextExecDates")) {
            TransactionManager.checkPostTransaction(header, post);
            String dateNexExecPrefix = "date_next_exec_";
            Date date = new Date();
            for (Map.Entry<String, String> entry2 : post.entrySet()) {
                if (!entry2.getKey().startsWith("date_next_exec_") || entry2.getValue() == null) continue;
                try {
                    String rowPkStr = entry2.getKey().substring("date_next_exec_".length());
                    Tables.Row row = sb.tables.select("api", rowPkStr.getBytes(StandardCharsets.UTF_8));
                    if (row == null) continue;
                    int time = row.get("apicall_schedule_time", 0);
                    String dateNextExecStr = entry2.getValue().trim();
                    try {
                        Date dateNextExec = dateFormat.parse(dateNextExecStr);
                        if (time == 0) continue;
                        if (dateNextExec.before(date)) {
                            nextExecDatesBeforeNow.put(rowPkStr, dateNextExecStr);
                            continue;
                        }
                        row.put("date_next_exec", dateNextExec);
                        sb.tables.update("api", row);
                    }
                    catch (ParseException e) {
                        invalidNextExecDateFormats.put(rowPkStr, dateNextExecStr);
                    }
                }
                catch (IOException | SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        if (post != null && !post.get("deleterows", "").isEmpty()) {
            TransactionManager.checkPostTransaction(header, post);
            for (Map.Entry entry2 : post.entrySet()) {
                if (!((String)entry2.getValue()).startsWith("mark_")) continue;
                try {
                    sb.tables.delete("api", ((String)entry2.getValue()).substring(5).getBytes());
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        if (post != null && !post.get("deleteold", "").isEmpty()) {
            TransactionManager.checkPostTransaction(header, post);
            int days = post.getInt("deleteoldtime", 365);
            try {
                Iterator<Tables.Row> iterator = sb.tables.iterator("api");
                Date now2 = new Date();
                Date limit = new Date(now2.getTime() - 86400000L * (long)days);
                ArrayList<byte[]> pkl = new ArrayList<byte[]>();
                while (iterator.hasNext()) {
                    Tables.Row row = iterator.next();
                    Date d = row.get("date_recording", now2);
                    if (!d.before(limit)) continue;
                    pkl.add(row.getPK());
                }
                for (byte[] pk : pkl) {
                    sb.tables.delete("api", pk);
                }
                Iterator ei = post.getSolrParams().getMap().entrySet().iterator();
                while (ei.hasNext()) {
                    Map.Entry entry4 = ei.next();
                    if (((String)entry4.getKey()).startsWith("event_select")) {
                        ei.remove();
                    }
                    if (!((String)entry4.getKey()).startsWith("repeat_select")) continue;
                    ei.remove();
                }
                sb.tables.recordAPICall(post, "Table_API_p.html", "steering", "delete API calls older than " + days + " days");
            }
            catch (IOException iOException) {
                ConcurrentLog.logException(iOException);
            }
        }
        if (post != null && !post.get("execrows", "").isEmpty()) {
            TransactionManager.checkPostTransaction(header, post);
            TreeSet<String> pks = new TreeSet<String>();
            for (Map.Entry<String, String> entry5 : post.entrySet()) {
                if (!entry5.getValue().startsWith("mark_")) continue;
                pks.add(entry5.getValue().substring(5));
            }
            Map<String, Integer> map = sb.tables.execAPICalls("localhost", sb.getLocalPort(), pks, sb.getConfig("adminAccountUserName", "admin"), sb.getConfig("adminAccountBase64MD5", ""));
            prop.put("showexec", map.isEmpty() ? 0L : 1L);
            Iterator<Map.Entry<String, Integer>> resultIterator = map.entrySet().iterator();
            int count = 0;
            boolean dark = true;
            while (resultIterator.hasNext()) {
                Map.Entry<String, Integer> record = resultIterator.next();
                if (record == null) continue;
                prop.put("showexec_list_" + count + "_dark", dark ? 1 : 0);
                dark = !dark;
                prop.put("showexec_list_" + count + "_status", record.getValue().intValue());
                prop.put("showexec_list_" + count + "_url", record.getKey());
                ++count;
            }
            prop.put("showexec_list", count);
        }
        prop.put("showtable", 1L);
        prop.put("showtable_inline", inline ? 1L : 0L);
        String nextTransactionToken = TransactionManager.getTransactionToken(header);
        prop.put("transactionToken", nextTransactionToken);
        prop.put("showtable_transactionToken", nextTransactionToken);
        Date date = new Date();
        ArrayList<Tables.Row> table = new ArrayList<Tables.Row>(maximumRecords);
        int count = 0;
        int tablesize = 0;
        int filteredSize = 0;
        try {
            boolean hasFilter;
            tablesize = sb.tables.size("api");
            Iterator<Tables.Row> plainIterator = sb.tables.iterator("api");
            Iterator<Tables.Row> mapIterator = sortColumn.isEmpty() ? plainIterator : ("apicall_count".equals(sortColumn) || "apicall_schedule_time".equals(sortColumn) ? Tables.orderByInt(plainIterator, sortColumn, 0, sortDir).iterator() : ("date".equals(sortColumn) || "date_recording".equals(sortColumn) || "date_last_exec".equals(sortColumn) || "date_next_exec".equals(sortColumn) ? Tables.orderByDate(plainIterator, sortColumn, date, sortDir).iterator() : Tables.orderByString(plainIterator, sortColumn, "", sortDir).iterator()));
            boolean dark = true;
            boolean scheduledactions = false;
            int matchCount = 0;
            boolean bl = hasFilter = typefilter != QueryParams.catchall_pattern || query2 != QueryParams.catchall_pattern;
            while (mapIterator.hasNext()) {
                byte[] commentb;
                String type;
                byte[] typeb;
                Tables.Row r = mapIterator.next();
                if (r == null || (typeb = (byte[])r.get("type")) == null || !typefilter.matcher(type = UTF8.String(typeb)).matches() || (commentb = (byte[])r.get("comment")) == null) continue;
                String comment = UTF8.String(commentb);
                byte[] urlb = (byte[])r.get("url");
                if (urlb == null) continue;
                String url = UTF8.String(urlb);
                if (!inline ? !query2.matcher(comment).matches() && !query2.matcher(url).matches() : !query2.matcher(comment).matches()) continue;
                if (matchCount >= startRecord && table.size() < maximumRecords) {
                    table.add(r);
                }
                ++matchCount;
                if (table.size() < maximumRecords || hasFilter) continue;
            }
            filteredSize = hasFilter ? matchCount : tablesize;
            for (Tables.Row row : table) {
                String rowPKStr = UTF8.String(row.getPK());
                Date date2 = row.containsKey("date") ? row.get("date", date) : null;
                Date date_recording = row.get("date_recording", date2);
                Date date_last_exec = row.get("date_last_exec", date2);
                Date date_next_exec = row.get("date_next_exec", (Date)null);
                int callcount = row.get("apicall_count", 1);
                int time = row.get("apicall_schedule_time", 0);
                prop.put("showtable_list_" + count + "_inline", inline ? 1L : 0L);
                prop.put("showtable_list_" + count + "_dark", dark ? 1L : 0L);
                dark = !dark;
                prop.put("showtable_list_" + count + "_pk", UTF8.String(row.getPK()));
                prop.put("showtable_list_" + count + "_count", count);
                prop.put("showtable_list_" + count + "_callcount", callcount);
                prop.put("showtable_list_" + count + "_dateRecording", date_recording == null ? "-" : dateFormat.format(date_recording));
                prop.put("showtable_list_" + count + "_dateLastExec", date_last_exec == null ? "-" : dateFormat.format(date_last_exec));
                prop.put("showtable_list_" + count + "_editableDateNext", time != 0);
                String enteredDateBeforeNow = (String)nextExecDatesBeforeNow.get(rowPKStr);
                prop.put("showtable_list_" + count + "_editableDateNext_dateBeforeNowError", enteredDateBeforeNow != null);
                if (enteredDateBeforeNow != null) {
                    prop.put("showtable_list_" + count + "_editableDateNext_dateBeforeNowError_invalidDate", enteredDateBeforeNow);
                }
                String invalidEnteredDate = (String)invalidNextExecDateFormats.get(rowPKStr);
                prop.put("showtable_list_" + count + "_editableDateNext_dateFormatError", invalidEnteredDate != null);
                if (invalidEnteredDate != null) {
                    prop.put("showtable_list_" + count + "_editableDateNext_dateFormatError_invalidDate", invalidEnteredDate);
                }
                prop.put("showtable_list_" + count + "_editableDateNext_dateLastExecPattern", "[0-9]{4}/(0[1-9]|1[012])/(0[1-9]|1[0-9]|2[0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3])(:[0-5][0-9]){2}");
                prop.put("showtable_list_" + count + "_editableDateNext_dateNextExec", date_next_exec == null ? "-" : dateFormat.format(date_next_exec));
                prop.put("showtable_list_" + count + "_editableDateNext_pk", rowPKStr);
                prop.put("showtable_list_" + count + "_type", (byte[])row.get("type"));
                prop.putHTML("showtable_list_" + count + "_comment", (byte[])row.get("comment"));
                if (prop.get("showtable_list_" + count + "_type", "").equals("crawler") && prop.get("showtable_list_" + count + "_comment", "").startsWith("crawl start for")) {
                    String editUrl = UTF8.String((byte[])row.get("url")).replace("Crawler_p", "CrawlStartExpert");
                    if (editUrl.length() > 1000) {
                        MultiProtocolURL u = new MultiProtocolURL("http://localhost:8090" + editUrl);
                        prop.put("showtable_list_" + count + "_isCrawlerStart", 2L);
                        prop.put("showtable_list_" + count + "_isCrawlerStart_pk", rowPKStr);
                        prop.put("showtable_list_" + count + "_isCrawlerStart_servlet", "CrawlStartExpert.html");
                        Map<String, String> attr = u.getAttributes();
                        int ac = 0;
                        for (Map.Entry<String, String> entry6 : attr.entrySet()) {
                            prop.put("showtable_list_" + count + "_isCrawlerStart_attr_" + ac + "_key", entry6.getKey());
                            prop.put("showtable_list_" + count + "_isCrawlerStart_attr_" + ac + "_value", entry6.getValue());
                            ++ac;
                        }
                        prop.put("showtable_list_" + count + "_isCrawlerStart_attr", ac);
                    } else {
                        prop.put("showtable_list_" + count + "_isCrawlerStart", 1L);
                        prop.put("showtable_list_" + count + "_isCrawlerStart_url", editUrl.startsWith("/") ? editUrl.substring(1, editUrl.length()) : editUrl);
                    }
                } else {
                    prop.put("showtable_list_" + count + "_isCrawlerStart", 0L);
                }
                prop.putHTML("showtable_list_" + count + "_inline_url", UTF8.String((byte[])row.get("url")));
                prop.put("showtable_list_" + count + "_scheduler_inline", inline ? "true" : "false");
                prop.put("showtable_list_" + count + "_scheduler_filter", typefilter.pattern());
                prop.put("showtable_list_" + count + "_scheduler_query", query2.pattern());
                prop.put("showtable_list_" + count + "_scheduler_startRecord", startRecord);
                prop.put("showtable_list_" + count + "_scheduler_maximumRecords", maximumRecords);
                String kind = row.get("apicall_event_kind", "off");
                String action = row.get("apicall_event_action", "startup");
                prop.put("showtable_list_" + count + "_event_pk", rowPKStr);
                boolean schedulerDisabled = "regular".equals(kind);
                if ("off".equals(kind)) {
                    prop.put("showtable_list_" + count + "_event", 0L);
                } else {
                    prop.put("showtable_list_" + count + "_event", 1L);
                    prop.put("showtable_list_" + count + "_event_selectedoff", "off".equals(kind) ? 1L : 0L);
                    prop.put("showtable_list_" + count + "_event_selectedonce", "once".equals(kind) ? 1L : 0L);
                    prop.put("showtable_list_" + count + "_event_selectedregular", "regular".equals(kind) ? 1L : 0L);
                    prop.put("showtable_list_" + count + "_event_selectedstartup", "startup".equals(action) ? 1L : 0L);
                    for (int i = 0; i < 24; ++i) {
                        Object is = Integer.toString(i);
                        if (((String)is).length() == 1) {
                            is = "0" + (String)is;
                        }
                        is = (String)is + "00";
                        prop.put("showtable_list_" + count + "_event_selected" + (String)is, ((String)is).equals(action) ? 1L : 0L);
                    }
                }
                String unit = row.get("apicall_schedule_unit", "days");
                prop.put("showtable_list_" + count + "_selectedMinutes", unit.equals("minutes") ? 1L : 0L);
                prop.put("showtable_list_" + count + "_selectedHours", unit.equals("hours") ? 1L : 0L);
                prop.put("showtable_list_" + count + "_selectedDays", unit.isEmpty() || unit.equals("days") ? 1L : 0L);
                prop.put("showtable_list_" + count + "_scheduler_pk", rowPKStr);
                prop.put("showtable_list_" + count + "_scheduler_disabled", schedulerDisabled ? 1L : 0L);
                prop.put("showtable_list_" + count + "_repeatTime", time);
                if (time == 0) {
                    prop.put("showtable_list_" + count + "_scheduler", 0L);
                } else {
                    scheduledactions = true;
                    prop.put("showtable_list_" + count + "_scheduler", 1L);
                    prop.put("showtable_list_" + count + "_scheduler_scale_0_time", "off");
                    prop.put("showtable_list_" + count + "_scheduler_selectedMinutes", 0L);
                    prop.put("showtable_list_" + count + "_scheduler_selectedHours", 0L);
                    prop.put("showtable_list_" + count + "_scheduler_selectedDays", 0L);
                    if (unit.equals("minutes")) {
                        for (int i = 1; i <= 5; ++i) {
                            prop.put("showtable_list_" + count + "_scheduler_scale_" + i + "_time", i * 10);
                            prop.put("showtable_list_" + count + "_scheduler_scale_" + i + "_selected", 0L);
                        }
                        prop.put("showtable_list_" + count + "_scheduler_scale_" + time / 10 + "_selected", 1L);
                        prop.put("showtable_list_" + count + "_scheduler_scale", 6L);
                        prop.put("showtable_list_" + count + "_scheduler_selectedMinutes", 1L);
                    } else if (unit.equals("hours")) {
                        for (int i = 1; i <= 23; ++i) {
                            prop.put("showtable_list_" + count + "_scheduler_scale_" + i + "_time", i);
                            prop.put("showtable_list_" + count + "_scheduler_scale_" + i + "_selected", 0L);
                        }
                        prop.put("showtable_list_" + count + "_scheduler_scale_" + time + "_selected", 1L);
                        prop.put("showtable_list_" + count + "_scheduler_scale", 24L);
                        prop.put("showtable_list_" + count + "_scheduler_selectedHours", 1L);
                    } else {
                        for (int i = 1; i <= 30; ++i) {
                            prop.put("showtable_list_" + count + "_scheduler_scale_" + i + "_time", i);
                            prop.put("showtable_list_" + count + "_scheduler_scale_" + i + "_selected", 0L);
                        }
                        prop.put("showtable_list_" + count + "_scheduler_scale_" + time + "_selected", 1L);
                        prop.put("showtable_list_" + count + "_scheduler_scale", 31L);
                        prop.put("showtable_list_" + count + "_scheduler_selectedDays", 1L);
                    }
                }
                ++count;
            }
            prop.put("showtable_hasEditableNextExecDate", scheduledactions);
            if (scheduledactions) {
                prop.put("showschedulerhint", 1L);
                prop.put("showschedulerhint_tfminutes", sb.getConfigLong("90_cleanup_busysleep", 300000L) / 60000L);
            } else {
                prop.put("showschedulerhint", 0L);
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        prop.put("showtable_list", count);
        prop.put("showtable_num", count);
        prop.put("showtable_startRecord", startRecord);
        prop.put("showtable_maximumRecords", maximumRecords);
        prop.put("showtable_inline", inline ? 1L : 0L);
        prop.put("showtable_filter", typefilter.pattern());
        prop.put("showtable_query", queryParam);
        prop.put("showtable_sort", sortParam);
        Table_API_p.putTableSortProperties(prop, sortDir, sortColumn);
        if (filteredSize > maximumRecords) {
            prop.put("showtable_navigation", 1L);
            prop.put("showtable_navigation_startRecord", startRecord);
            prop.put("showtable_navigation_to", Math.min(filteredSize, startRecord + table.size()));
            prop.put("showtable_navigation_of", filteredSize);
            prop.put("showtable_navigation_left", startRecord == 0 ? 0L : 1L);
            prop.put("showtable_navigation_left_startRecord", Math.max(0, startRecord - maximumRecords));
            prop.put("showtable_navigation_left_maximumRecords", maximumRecords);
            prop.put("showtable_navigation_left_inline", inline ? 1L : 0L);
            prop.put("showtable_navigation_left_filter", typefilter.pattern());
            prop.put("showtable_navigation_left_query", queryParam);
            prop.put("showtable_navigation_left_sort", sortParam);
            prop.put("showtable_navigation_left", startRecord == 0 ? 0L : 1L);
            prop.put("showtable_navigation_filter", typefilter.pattern());
            prop.put("showtable_navigation_right", startRecord + maximumRecords >= filteredSize ? 0L : 1L);
            prop.put("showtable_navigation_right_startRecord", startRecord + maximumRecords);
            prop.put("showtable_navigation_right_maximumRecords", maximumRecords);
            prop.put("showtable_navigation_right_inline", inline ? 1L : 0L);
            prop.put("showtable_navigation_right_filter", typefilter.pattern());
            prop.put("showtable_navigation_right_query", queryParam);
            prop.put("showtable_navigation_right_sort", sortParam);
        } else {
            prop.put("showtable_navigation", 0L);
        }
        return prop;
    }

    private static void putTableSortProperties(serverObjects prop, Tables.SortDirection sortDir, String sortColumn) {
        boolean sortedByAsc = "type".equals(sortColumn) && sortDir == Tables.SortDirection.ASC;
        prop.put("showtable_sortedByType", "type".equals(sortColumn));
        prop.put("showtable_sortedByType_asc", sortedByAsc);
        prop.put("showtable_nextSortTypeDesc", sortedByAsc);
        sortedByAsc = "comment".equals(sortColumn) && sortDir == Tables.SortDirection.ASC;
        prop.put("showtable_sortedByComment", "comment".equals(sortColumn));
        prop.put("showtable_sortedByComment_asc", sortedByAsc);
        prop.put("showtable_nextSortCommentDesc", sortedByAsc);
        sortedByAsc = "apicall_count".equals(sortColumn) && sortDir == Tables.SortDirection.ASC;
        prop.put("showtable_sortedByApiCallCount", "apicall_count".equals(sortColumn));
        prop.put("showtable_sortedByApiCallCount_asc", sortedByAsc);
        prop.put("showtable_nextSortApiCallCountDesc", sortedByAsc);
        sortedByAsc = "date_recording".equals(sortColumn) && sortDir == Tables.SortDirection.ASC;
        prop.put("showtable_sortedByDateRecording", "date_recording".equals(sortColumn));
        prop.put("showtable_sortedByDateRecording_asc", sortedByAsc);
        prop.put("showtable_nextSortDateRecordingDesc", sortedByAsc);
        sortedByAsc = "date_last_exec".equals(sortColumn) && sortDir == Tables.SortDirection.ASC;
        prop.put("showtable_sortedByDateLastExec", "date_last_exec".equals(sortColumn));
        prop.put("showtable_sortedByDateLastExec_asc", sortedByAsc);
        prop.put("showtable_nextSortDateLastExecDesc", sortedByAsc);
        sortedByAsc = "date_next_exec".equals(sortColumn) && sortDir == Tables.SortDirection.ASC;
        prop.put("showtable_sortedByDateNextExec", "date_next_exec".equals(sortColumn));
        prop.put("showtable_sortedByDateNextExec_asc", sortedByAsc);
        prop.put("showtable_nextSortDateNextExecDesc", sortedByAsc);
    }
}

