/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ConcurrentScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.index.Row;
import net.yacy.peers.NewsDB;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;
import net.yacy.utils.nxTools;

public class Supporter {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        boolean authenticated = sb.adminAuthenticated(header) >= 2;
        int display = post == null || !authenticated ? 0 : post.getInt("display", 0);
        prop.put("display", display);
        boolean showScore = post != null && post.containsKey("score");
        boolean publicPage = sb.getConfigBool("publicSurftips", true);
        boolean authorizedAccess = sb.verifyAuthentication(header);
        if (publicPage || authorizedAccess) {
            HashMap<String, String> map;
            String hash;
            if (post != null && (hash = post.get("voteNegative", "")).length() > 0) {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
                if (!sb.isRobinsonMode()) {
                    map = new HashMap();
                    map.put("urlhash", hash);
                    map.put("vote", "negative");
                    map.put("refid", post.get("refid", ""));
                    sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "stippavt", map);
                }
            }
            if (post != null && (hash = post.get("votePositive", "")).length() > 0) {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
                map = new HashMap<String, String>();
                map.put("urlhash", hash);
                map.put("url", crypt.simpleDecode(post.get("url", "")));
                map.put("title", crypt.simpleDecode(post.get("title", "")));
                map.put("description", crypt.simpleDecode(post.get("description", "")));
                map.put("vote", "positive");
                map.put("refid", post.get("refid", ""));
                map.put("comment", post.get("comment", ""));
                sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "stippavt", map);
            }
            HashMap<String, Integer> negativeHashes = new HashMap<String, Integer>();
            HashMap<String, Integer> positiveHashes = new HashMap<String, Integer>();
            Supporter.accumulateVotes(sb, negativeHashes, positiveHashes, 0);
            ConcurrentScoreMap<String> ranking = new ConcurrentScoreMap<String>();
            Row rowdef = new Row("String url-255, String title-120, String description-120, String refid-" + ("yyyyMMddHHmmss".length() + 12), NaturalOrder.naturalOrder);
            HashMap<String, Row.Entry> Supporter2 = new HashMap<String, Row.Entry>();
            Supporter.accumulateSupporter(sb, Supporter2, ranking, rowdef, negativeHashes, positiveHashes, 0);
            Iterator k = ranking.keys(false);
            int i = 0;
            while (k.hasNext()) {
                Row.Entry row;
                String urlhash = (String)k.next();
                if (urlhash == null || (row = Supporter2.get(urlhash)) == null) continue;
                String url = row.getPrimaryKeyUTF8().trim();
                try {
                    if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.SURFTIPS, new DigestURL(url, urlhash.getBytes()))) {
                    }
                }
                catch (MalformedURLException e) {}
                continue;
                String title = row.getColUTF8(1);
                String description = row.getColUTF8(2);
                if (url == null || title == null || description == null) continue;
                String refid = row.getColUTF8(3);
                boolean voted = sb.peers.newsPool.getSpecific(2, "stippavt", "refid", refid) != null || sb.peers.newsPool.getSpecific(3, "stippavt", "refid", refid) != null;
                prop.put("supporter_results_" + i + "_authorized", authenticated ? "1" : "0");
                prop.put("supporter_results_" + i + "_authorized_recommend", voted ? "0" : "1");
                prop.put("supporter_results_" + i + "_authorized_recommend_urlhash", urlhash);
                prop.put("supporter_results_" + i + "_authorized_recommend_refid", refid);
                prop.put("supporter_results_" + i + "_authorized_recommend_url", crypt.simpleEncode(url, null, 'b'));
                prop.putHTML("supporter_results_" + i + "_authorized_recommend_title", crypt.simpleEncode(title, null, 'b'));
                prop.putHTML("supporter_results_" + i + "_authorized_recommend_description", crypt.simpleEncode(description, null, 'b'));
                prop.put("supporter_results_" + i + "_authorized_recommend_display", display);
                prop.put("supporter_results_" + i + "_authorized_recommend_showScore", showScore ? "1" : "0");
                prop.put("supporter_results_" + i + "_authorized_urlhash", urlhash);
                prop.put("supporter_results_" + i + "_url", url);
                prop.put("supporter_results_" + i + "_urlname", nxTools.shortenURLString(url, 60));
                prop.put("supporter_results_" + i + "_urlhash", urlhash);
                prop.putHTML("supporter_results_" + i + "_title", (String)(showScore ? "(" + ranking.get(urlhash) + ") " + title : title));
                prop.putHTML("supporter_results_" + i + "_description", description);
                if (++i < 50) continue;
            }
            prop.put("supporter_results", i);
            prop.put("supporter", "1");
        } else {
            prop.put("supporter", "0");
        }
        return prop;
    }

    private static int timeFactor(Date created) {
        return (int)Math.max(0L, 10L - (System.currentTimeMillis() - created.getTime()) / 24L / 60L / 60L / 1000L);
    }

    private static void accumulateVotes(Switchboard sb, HashMap<String, Integer> negativeHashes, HashMap<String, Integer> positiveHashes, int dbtype) {
        int maxCount = Math.min(1000, sb.peers.newsPool.size(dbtype));
        Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(dbtype);
        int j = 0;
        while (recordIterator.hasNext() && j++ < maxCount) {
            Integer i;
            int factor;
            NewsDB.Record record = recordIterator.next();
            if (record == null || !record.category().equals("stippavt")) continue;
            String urlhash = record.attribute("urlhash", "");
            String vote = record.attribute("vote", "");
            int n = factor = dbtype == 2 || dbtype == 3 ? 2 : 1;
            if (vote.equals("negative")) {
                i = negativeHashes.get(urlhash);
                if (i == null) {
                    negativeHashes.put(urlhash, factor);
                } else {
                    negativeHashes.put(urlhash, i + factor);
                }
            }
            if (!vote.equals("positive")) continue;
            i = positiveHashes.get(urlhash);
            if (i == null) {
                positiveHashes.put(urlhash, factor);
                continue;
            }
            positiveHashes.put(urlhash, i + factor);
        }
    }

    private static void accumulateSupporter(Switchboard sb, HashMap<String, Row.Entry> Supporter2, ScoreMap<String> ranking, Row rowdef, HashMap<String, Integer> negativeHashes, HashMap<String, Integer> positiveHashes, int dbtype) {
        int maxCount = Math.min(1000, sb.peers.newsPool.size(dbtype));
        Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(dbtype);
        int j = 0;
        String url = "";
        int score = 0;
        while (recordIterator.hasNext() && j++ < maxCount) {
            String urlhash;
            Seed seed;
            NewsDB.Record record = recordIterator.next();
            if (record == null) continue;
            Row.Entry entry2 = null;
            if (record.category().equals("prfleupd") && (seed = sb.peers.getConnected(record.originator())) != null) {
                url = record.attribute("homepage", "");
                if (url.length() < 12) continue;
                entry2 = rowdef.newEntry(new byte[][]{url.getBytes(), url.getBytes(), UTF8.getBytes("Home Page of " + seed.getName()), record.id().getBytes()});
                score = 1 + Supporter.timeFactor(record.created());
            }
            if (record.category().equals("prflecst") && (seed = sb.peers.getConnected(record.originator())) != null) {
                url = record.attribute("homepage", "");
                if (url.length() < 12) continue;
                entry2 = rowdef.newEntry(new byte[][]{url.getBytes(), url.getBytes(), UTF8.getBytes("Home Page of " + seed.getName()), record.id().getBytes()});
                score = 1 + Supporter.timeFactor(record.created());
            }
            if (entry2 == null) continue;
            try {
                urlhash = ASCII.String(new DigestURL(url).hash());
            }
            catch (MalformedURLException e) {
                urlhash = null;
            }
            if (urlhash == null) {
                try {
                    urlhash = ASCII.String(new DigestURL("http://" + url).hash());
                }
                catch (MalformedURLException e) {
                    urlhash = null;
                }
            }
            if (urlhash == null) {
                ConcurrentLog.info("Supporter", "bad url '" + url + "' from news record " + record.toString());
                continue;
            }
            Integer vote = negativeHashes.get(urlhash);
            if (vote != null) {
                score = Math.max(0, score - vote);
            }
            if ((vote = positiveHashes.get(urlhash)) != null) {
                score += 2 * vote;
            }
            if (Supporter2.containsKey(urlhash)) {
                ranking.inc(urlhash, score);
                continue;
            }
            ranking.set(urlhash, score);
            Supporter2.put(urlhash, entry2);
        }
    }
}

