/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.Translator;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.translation.TranslatorXliff;

public class ConfigLanguage_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        File langPath = new File(sb.getAppPath("locale.source", "locales").getAbsolutePath());
        prop.put("status", "0");
        List<String> langFiles = Translator.langFiles(langPath);
        if (langFiles == null) {
            return prop;
        }
        if (post != null) {
            String selectedLanguage = post.get("language");
            ((Switchboard)env).tables.recordAPICall(post, "ConfigLanguage_p.html", "configuration", "language settings: " + selectedLanguage);
            if (post.containsKey("use_button") && selectedLanguage != null) {
                if (langFiles.contains(selectedLanguage) || selectedLanguage.startsWith("default") || selectedLanguage.startsWith("browser")) {
                    new TranslatorXliff().changeLang(env, langPath, selectedLanguage);
                }
            } else if (post.containsKey("delete")) {
                if (langFiles.contains(selectedLanguage)) {
                    File langfile = new File(langPath, selectedLanguage);
                    FileUtils.deletedelete(langfile);
                    new TranslatorXliff().getScratchFile(langfile).delete();
                }
            } else if (post.containsKey("url")) {
                String url = post.get("url");
                try {
                    DigestURL u = new DigestURL(url);
                    Iterator<String> it = FileUtils.strings(u.get(ClientIdentification.yacyInternetCrawlerAgent, null, null));
                    TranslatorXliff tx = new TranslatorXliff();
                    File langFile = tx.getScratchFile(new File(langPath, u.getFileName()));
                    try {
                        try (OutputStreamWriter bw = new OutputStreamWriter((OutputStream)new FileOutputStream(langFile), StandardCharsets.UTF_8.name());){
                            while (it.hasNext()) {
                                bw.write(it.next() + "\n");
                            }
                        }
                        String ext = Files.getFileExtension((String)langFile.getName());
                        if (ext.equalsIgnoreCase("xlf") || ext.equalsIgnoreCase("xliff")) {
                            Map<String, Map<String, String>> lng = tx.loadTranslationsListsFromXliff(langFile);
                            langFile = new File(langPath, Files.getNameWithoutExtension((String)langFile.getName()) + ".lng");
                            tx.saveAsLngFile(null, langFile, lng);
                        }
                        if (post.containsKey("use_lang") && "on".equals(post.get("use_lang"))) {
                            tx.changeLang(env, langPath, langFile.getName());
                        }
                    }
                    catch (IOException e) {
                        prop.put("status", "2");
                    }
                }
                catch (IOException e) {
                    prop.put("status", "1");
                    prop.put("status_url", url);
                }
            }
        }
        langFiles = Translator.langFiles(langPath);
        Collections.sort(langFiles);
        Map<String, String> langNames = Translator.langMap(env);
        String sellang = env.getConfig("locale.language", "default");
        prop.put("langlist_0_file", "browser");
        prop.put("langlist_0_name", langNames.get("browser") == null ? "browser" : langNames.get("browser"));
        prop.put("langlist_0_selected", sellang.equals("browser") ? "selected=\"selected\"" : " ");
        prop.put("langlist_1_file", "default");
        prop.put("langlist_1_name", langNames.get("default") == null ? "default" : langNames.get("default"));
        prop.put("langlist_1_selected", sellang.equals("default") ? "selected=\"selected\"" : " ");
        int count = 2;
        for (String langFile : langFiles) {
            String langKey = langFile.substring(0, langFile.length() - 4);
            String langName = langNames.get(langKey);
            prop.put("langlist_" + count + "_file", langFile);
            prop.put("langlist_" + count + "_name", langName == null ? langKey : langName);
            if (sellang.equals(langKey)) {
                prop.put("langlist_" + count + "_selected", "selected=\"selected\"");
            } else {
                prop.put("langlist_" + count + "_selected", " ");
            }
            ++count;
        }
        prop.put("langlist", count);
        return prop;
    }
}

