/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import net.yacy.cora.protocol.RequestHeader;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class AILab {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        boolean hasEngine = false;
        boolean hasModel = false;
        boolean hasRagRole = false;
        String productionModelJson = sb.getConfig("ai.production_models", "[]");
        try {
            JSONArray productionModels = new JSONArray(new JSONTokener(productionModelJson));
            for (int i = 0; i < productionModels.length(); ++i) {
                JSONObject row = productionModels.getJSONObject(i);
                if (!hasEngine) {
                    boolean bl = hasEngine = !row.optString("hoststub", "").isEmpty();
                }
                if (!hasModel) {
                    boolean bl = hasModel = !row.optString("model", "").isEmpty();
                }
                if (!hasRagRole) {
                    boolean bl = hasRagRole = row.optBoolean("search", false) || row.optBoolean("query", false) || row.optBoolean("qapairs", false);
                }
                if (!(hasEngine && hasModel && hasRagRole)) {
                    continue;
                }
                break;
            }
        }
        catch (JSONException productionModels) {
            // empty catch block
        }
        if (!hasEngine) {
            String inferenceJson = sb.getConfig("ai.inference_system", "{}");
            try {
                JSONObject inference = new JSONObject(new JSONTokener(inferenceJson));
                String hoststub = inference.optString("hoststub", "").trim();
                if (!hoststub.isEmpty()) {
                    hasEngine = true;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        long indexDocs = sb.index.fulltext().collectionSize();
        long indexNeeded = 1000L;
        boolean hasIndex = indexDocs >= 1000L;
        boolean ragVisited = "true".equalsIgnoreCase(sb.getConfig("ui.RAGConfig_p.visited", "false"));
        boolean hasShield = "true".equalsIgnoreCase(sb.getConfig("ui.AIShield_p.visited", "false"));
        boolean frontPageLinkActivated = sb.getConfigBool("ai.shield.show-chat-link", false);
        prop.put("ailab_inference_status", hasEngine ? "ready" : "pending");
        prop.put("ailab_model_status", hasEngine && hasModel ? "ready" : "pending");
        prop.put("ailab_inference_configured", hasEngine ? "1" : "0");
        prop.put("ailab_index_status", hasIndex ? "ready" : "pending");
        prop.putNum("ailab_index_count", indexDocs);
        prop.putNum("ailab_index_needed", 1000L);
        prop.put("ailab_rag_status", hasEngine && hasModel && (hasRagRole || ragVisited) ? "ready" : "pending");
        prop.put("ailab_shield_status", hasEngine && hasModel && hasShield && frontPageLinkActivated ? "ready" : "pending");
        return prop;
    }
}

