/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Condenser;
import net.yacy.document.Document;
import net.yacy.document.LibraryProvider;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.util.BDecoder;
import net.yacy.kelondro.util.FileUtils;

public class torrentParser
extends AbstractParser
implements Parser {
    public torrentParser() {
        super("Torrent Metadata Parser");
        this.SUPPORTED_EXTENSIONS.add("torrent");
        this.SUPPORTED_MIME_TYPES.add("application/x-bittorrent");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        byte[] b = null;
        try {
            b = FileUtils.read(source);
        }
        catch (IOException e1) {
            throw new Parser.Failure(e1.toString(), location);
        }
        BDecoder bd = new BDecoder(b);
        BDecoder.BObject bo = bd.parse();
        if (bo == null) {
            throw new Parser.Failure("BDecoder.parse returned null", location);
        }
        if (bo.getType() != BDecoder.BType.dictionary) {
            throw new Parser.Failure("BDecoder object is not a dictionary", location);
        }
        Map<String, BDecoder.BObject> map = bo.getMap();
        BDecoder.BObject commento = map.get("comment");
        String comment = commento == null ? "" : UTF8.String(commento.getString());
        BDecoder.BObject infoo = map.get("info");
        StringBuilder filenames = new StringBuilder(80);
        String title = "";
        if (infoo != null) {
            BDecoder.BObject nameo;
            Map<String, BDecoder.BObject> info = infoo.getMap();
            BDecoder.BObject fileso = info.get("files");
            if (fileso != null) {
                List<BDecoder.BObject> filelist = fileso.getList();
                for (BDecoder.BObject fo : filelist) {
                    BDecoder.BObject patho = fo.getMap().get("path");
                    if (patho == null) continue;
                    List<BDecoder.BObject> l = patho.getList();
                    for (BDecoder.BObject fl : l) {
                        filenames.append(fl.toString()).append(" ");
                    }
                }
            }
            if ((nameo = info.get("name")) != null) {
                title = UTF8.String(nameo.getString());
            }
        }
        if (title == null || title.isEmpty()) {
            title = MultiProtocolURL.unescape(location.getFileName());
        }
        return new Document[]{new Document(location, mimeType, charset, this, null, null, torrentParser.singleList(title), comment, location.getHost(), null, null, 0.0, 0.0, filenames.toString(), null, null, null, false, new Date())};
    }

    public static void main(String[] args) {
        try {
            byte[] b = FileUtils.read(new File(args[0]));
            torrentParser parser = new torrentParser();
            Document[] d = parser.parse(new DigestURL("http://localhost/test.torrent"), null, StandardCharsets.UTF_8.name(), new VocabularyScraper(), 0, new ByteArrayInputStream(b));
            Condenser c = new Condenser(d[0], null, true, true, LibraryProvider.dymLib, false, false, 0);
            Map<String, Word> w = c.words();
            for (Map.Entry<String, Word> e : w.entrySet()) {
                System.out.println("Word: " + e.getKey() + " - " + e.getValue().posInText);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Parser.Failure e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

