/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.CrawlStacker;
import net.yacy.document.content.DCEntry;
import net.yacy.search.schema.CollectionConfiguration;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPackReader
extends DefaultHandler
implements Runnable {
    public static final String SURROGATES_MAIN_ELEMENT_NAME = "surrogates";
    public static final String SURROGATES_MAIN_ELEMENT_OPEN = "<surrogates xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:yacy=\"http://yacy.net/\" xmlns:geo=\"http://www.w3.org/2003/01/geo/wgs84_pos#\">";
    public static final String SURROGATES_MAIN_ELEMENT_CLOSE = "</surrogates>";
    public static final SolrInputDocument POISON_DOCUMENT = new SolrInputDocument();
    private static final int PUSHBACK_SIZE = 1024;
    private final StringBuilder buffer;
    private boolean parsingValue;
    private DCEntry dcEntry;
    private String elementName;
    private final BlockingQueue<Object> surrogates;
    private SAXParser saxParser;
    private final PushbackInputStream inputStream;
    private final CrawlStacker crawlStacker;
    private final CollectionConfiguration configuration;
    private final int concurrency;
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    public XMLPackReader(InputStream stream, int queueSize, CrawlStacker crawlStacker, CollectionConfiguration configuration, int concurrency) throws IOException {
        this(new PushbackInputStream(stream, 1024), queueSize, crawlStacker, configuration, concurrency);
    }

    public XMLPackReader(PushbackInputStream stream, int queueSize, CrawlStacker crawlStacker, CollectionConfiguration configuration, int concurrency) throws IOException {
        this.crawlStacker = crawlStacker;
        this.configuration = configuration;
        this.concurrency = concurrency;
        this.buffer = new StringBuilder(300);
        this.parsingValue = false;
        this.dcEntry = null;
        this.elementName = null;
        this.surrogates = new ArrayBlockingQueue<Object>(queueSize);
        this.inputStream = stream;
        try {
            this.saxParser = XMLPackReader.getParser();
        }
        catch (SAXException e) {
            ConcurrentLog.logException(e);
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)this.inputStream, StandardCharsets.UTF_8));
            if (this.isSolrDump()) {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("<doc>")) continue;
                    try {
                        NamedList nl = new XMLResponseParser().processResponse((Reader)new StringReader("<result>" + line + "</result>"));
                        SolrDocument doc = (SolrDocument)((Map.Entry)nl.iterator().next()).getValue();
                        String u = (String)doc.getFieldValue("sku");
                        if (u == null) continue;
                        try {
                            DigestURL url = new DigestURL(u);
                            String urlRejectReason = this.crawlStacker.urlInAcceptedDomain(url);
                            if (urlRejectReason != null) continue;
                            this.surrogates.put(this.configuration.toSolrInputDocument(doc));
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                InputSource inputSource = new InputSource(br);
                inputSource.setEncoding(StandardCharsets.UTF_8.name());
                this.saxParser.parse(inputSource, (DefaultHandler)this);
            }
        }
        catch (SAXParseException e) {
            ConcurrentLog.logException(e);
        }
        catch (SAXException e) {
            ConcurrentLog.logException(e);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            for (int i = 0; i < this.concurrency; ++i) {
                try {
                    this.surrogates.put(POISON_DOCUMENT);
                    continue;
                }
                catch (InterruptedException e1) {
                    ConcurrentLog.logException(e1);
                }
            }
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSolrDump() {
        boolean res = false;
        byte[] b = new byte[1024];
        int nbRead = -1;
        try {
            nbRead = this.inputStream.read(b);
            if (nbRead > 0) {
                String s = new String(b, 0, nbRead, StandardCharsets.UTF_8);
                if (s.contains("format=\"yacy.index.export.solr.xml\"")) {
                    res = true;
                } else if (s.contains("<response>") && s.contains("<result>") || s.startsWith("<doc>")) {
                    res = true;
                }
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (nbRead > 0) {
                try {
                    this.inputStream.unread(b, 0, nbRead);
                }
                catch (IOException e2) {
                    ConcurrentLog.logException(e2);
                }
            }
        }
        return res;
    }

    @Override
    public void startElement(String uri, String name, String tag, Attributes atts) throws SAXException {
        if (tag == null) {
            return;
        }
        if ("record".equals(tag = tag.toLowerCase(Locale.ROOT)) || "document".equals(tag) || "doc".equals(tag)) {
            this.dcEntry = new DCEntry();
        } else if ("element".equals(tag) || "str".equals(tag) || "int".equals(tag) || "bool".equals(tag) || "long".equals(tag)) {
            this.elementName = atts.getValue("name");
            this.parsingValue = true;
        } else if ("value".equals(tag)) {
            this.buffer.setLength(0);
            this.parsingValue = true;
        } else if (tag.startsWith("dc:") || tag.startsWith("geo:") || tag.startsWith("md:")) {
            this.elementName = tag;
            this.parsingValue = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String name, String tag) {
        if (tag == null) {
            return;
        }
        if ("record".equals(tag = tag.toLowerCase(Locale.ROOT)) || "document".equals(tag) || "doc".equals(tag)) {
            try {
                String urlRejectReason = this.crawlStacker.urlInAcceptedDomain(this.dcEntry.getIdentifier(true));
                if (urlRejectReason != null) return;
                this.surrogates.put((Object)this.dcEntry);
                return;
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
                return;
            }
            finally {
                this.dcEntry = null;
                this.buffer.setLength(0);
                this.parsingValue = false;
            }
        } else if ("element".equals(tag)) {
            this.buffer.setLength(0);
            this.parsingValue = false;
            return;
        } else if ("str".equals(tag) || "int".equals(tag) || "bool".equals(tag) || "long".equals(tag)) {
            String value = this.buffer.toString().trim();
            if (this.elementName != null) {
                this.dcEntry.getMap().put(this.elementName, new String[]{value});
            }
            this.buffer.setLength(0);
            this.parsingValue = false;
            return;
        } else if ("value".equals(tag)) {
            String value = this.buffer.toString().trim();
            if (this.elementName != null) {
                this.dcEntry.getMap().put(this.elementName, new String[]{value});
            }
            this.buffer.setLength(0);
            this.parsingValue = false;
            return;
        } else {
            if (!tag.startsWith("dc:") && !tag.startsWith("geo:") && !tag.startsWith("md:")) return;
            String value = this.buffer.toString().trim();
            if (this.elementName != null && tag.equals(this.elementName)) {
                Map map = this.dcEntry.getMap();
                String[] oldcontent = (String[])map.get(this.elementName);
                if (oldcontent == null || oldcontent.length == 0) {
                    map.put(this.elementName, new String[]{value});
                } else {
                    String[] newcontent = new String[oldcontent.length + 1];
                    System.arraycopy(oldcontent, 0, newcontent, 0, oldcontent.length);
                    newcontent[oldcontent.length] = value;
                    map.put(this.elementName, newcontent);
                }
            }
            this.buffer.setLength(0);
            this.parsingValue = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.parsingValue) {
            this.buffer.append(ch, start, length);
        }
    }

    public Object take() {
        try {
            return this.surrogates.take();
        }
        catch (InterruptedException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }
}

