/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data.wiki;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.MapHeap;

public class WikiBoard {
    public static final int keyLength = 64;
    private static final String DATE_FORMAT = "yyyyMMddHHmmss";
    private static final String ANONYMOUS = "anonymous";
    private static final SimpleDateFormat SimpleFormatter = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    private MapHeap datbase = null;
    private MapHeap bkpbase = null;
    private static final Map<String, String> AUTHORS;

    public WikiBoard(File actpath, File bkppath) throws IOException {
        new File(actpath.getParent()).mkdirs();
        if (this.datbase == null) {
            this.datbase = new MapHeap(actpath, 64, NaturalOrder.naturalOrder, 65536, 500, '_');
        }
        new File(bkppath.getParent()).mkdirs();
        if (this.bkpbase == null) {
            this.bkpbase = new MapHeap(bkppath, 64 + DATE_FORMAT.length(), NaturalOrder.naturalOrder, 65536, 500, '_');
        }
    }

    public int sizeOfTwo() {
        return this.datbase.size() + this.bkpbase.size();
    }

    public int size() {
        return this.datbase.size();
    }

    public synchronized void close() {
        this.datbase.close();
        this.bkpbase.close();
    }

    static String dateString() {
        return WikiBoard.dateString(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateString(Date date) {
        SimpleDateFormat simpleDateFormat = SimpleFormatter;
        synchronized (simpleDateFormat) {
            return SimpleFormatter.format(date);
        }
    }

    private static String normalize(String key) {
        return key != null ? key.trim().toLowerCase() : "null";
    }

    public static String webalize(String key) {
        return key != null ? CommonPattern.SPACE.matcher(WikiBoard.normalize(key)).replaceAll("%20") : "null";
    }

    public static String guessAuthor(String ip) {
        String author = AUTHORS.get(ip);
        return author;
    }

    public static void setAuthor(String ip, String author) {
        AUTHORS.put(ip, author);
    }

    public Entry newEntry(String subject, String author, String ip, String reason, byte[] page) throws IOException {
        return new Entry(WikiBoard.normalize(subject), author, ip, reason, page);
    }

    public String write(Entry entry2) {
        String key = null;
        try {
            Entry oldEntry = this.read(entry2.key);
            Date oldDate = oldEntry.date();
            entry2.setAncestorDate(oldDate);
            oldEntry.setChild(entry2.subject());
            this.bkpbase.insert(UTF8.getBytes(entry2.key + WikiBoard.dateString(oldDate)), oldEntry.record);
            this.datbase.insert(UTF8.getBytes(entry2.key), entry2.record);
            key = entry2.key;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
        return key;
    }

    public Entry read(String key) {
        return this.read(key, this.datbase);
    }

    Entry read(String key, MapHeap base) {
        Entry ret = null;
        try {
            Map<String, String> record;
            String copyOfKey = WikiBoard.normalize(key);
            if (copyOfKey.length() > 64) {
                copyOfKey = copyOfKey.substring(0, 64);
            }
            ret = (record = base.get(UTF8.getBytes(copyOfKey))) == null ? this.newEntry(copyOfKey, ANONYMOUS, "localhost", "New Page", UTF8.getBytes("")) : new Entry(copyOfKey, record);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return ret;
    }

    public Entry readBkp(String key) {
        return this.read(key, this.bkpbase);
    }

    public Iterator<byte[]> keys(boolean up) throws IOException {
        return this.datbase.keys(up, false);
    }

    public Iterator<byte[]> keysBkp(boolean up) throws IOException {
        return this.bkpbase.keys(up, false);
    }

    static {
        SimpleFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        AUTHORS = new HashMap<String, String>();
    }

    public class Entry {
        private static final String ANONYMOUS = "anonymous";
        private final String key;
        private final Map<String, String> record;

        public Entry(String subject, String author, String ip, String reason, byte[] page) throws IOException {
            this.record = new HashMap<String, String>();
            this.key = subject.substring(0, Math.min(subject != null ? subject.length() : 0, 64));
            this.record.put("date", WikiBoard.dateString());
            this.record.put("author", Base64Order.enhancedCoder.encodeString(author != null && author.length() > 0 ? author : "anonymous"));
            this.record.put("ip", ip != null && ip.length() > 0 ? ip : "");
            this.record.put("reason", Base64Order.enhancedCoder.encodeString(reason != null && reason.length() > 0 ? reason : ""));
            this.record.put("page", page != null ? Base64Order.enhancedCoder.encode(page) : "");
            AUTHORS.put(ip, author);
        }

        Entry(String key, Map<String, String> record) {
            this.key = key;
            this.record = record;
        }

        public String subject() {
            return this.key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date date() {
            Date ret;
            block6: {
                try {
                    String c = this.record.get("date");
                    if (c == null) {
                        System.out.println("DEBUG - ERROR: date field missing in wikiBoard");
                        ret = new Date();
                        break block6;
                    }
                    SimpleDateFormat simpleDateFormat = SimpleFormatter;
                    synchronized (simpleDateFormat) {
                        ret = SimpleFormatter.parse(c);
                    }
                }
                catch (ParseException e) {
                    ret = new Date();
                }
            }
            return ret;
        }

        public String author() {
            byte[] b;
            String a = this.record.get("author");
            return a != null && (b = Base64Order.enhancedCoder.decode(a)) != null ? UTF8.String(b) : "anonymous";
        }

        public String reason() {
            byte[] b;
            String r = this.record.get("reason");
            String ret = r != null ? ((b = Base64Order.enhancedCoder.decode(r)) != null ? UTF8.String(b) : "unknown") : "";
            return ret;
        }

        public byte[] page() {
            byte[] b;
            String m = this.record.get("page");
            return m != null && (b = Base64Order.enhancedCoder.decode(m)) != null ? b : new byte[]{};
        }

        void setAncestorDate(Date date) {
            this.record.put("bkp", WikiBoard.dateString(date));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Date getAncestorDate() {
            Date ret;
            block5: {
                ret = null;
                try {
                    String c = this.record.get("date");
                    if (c == null) break block5;
                    SimpleDateFormat simpleDateFormat = SimpleFormatter;
                    synchronized (simpleDateFormat) {
                        ret = SimpleFormatter.parse(c);
                    }
                }
                catch (ParseException e) {
                    ret = null;
                }
            }
            return ret;
        }

        public Entry getAncestor() {
            Date ancDate = this.getAncestorDate();
            return ancDate == null ? null : WikiBoard.this.read(this.key + WikiBoard.dateString(ancDate), WikiBoard.this.bkpbase);
        }

        void setChild(String subject) {
            this.record.put("child", Base64Order.enhancedCoder.encode(UTF8.getBytes(subject)));
        }

        private String getChildName() {
            byte[] subject;
            String c = this.record.get("child");
            return c != null && (subject = Base64Order.enhancedCoder.decode(c)) != null ? ASCII.String(subject) : null;
        }

        public boolean hasChild() {
            String c = this.record.get("child");
            return c != null && Base64Order.enhancedCoder.decode(c) != null;
        }

        public Entry getChild() {
            String childName = this.getChildName();
            return childName == null ? null : WikiBoard.this.read(childName, WikiBoard.this.datbase);
        }
    }
}

