/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;

public class StreamResponse
implements Closeable {
    private static final ConcurrentLog log = new ConcurrentLog(StreamResponse.class.getSimpleName());
    private InputStream contentStream;
    private Response response;

    public StreamResponse(Response response, InputStream contentStream) {
        if (response == null) {
            throw new IllegalArgumentException("response parameter must not be null");
        }
        this.response = response;
        this.contentStream = contentStream;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public void close() throws IOException {
        if (this.contentStream != null) {
            this.contentStream.close();
        }
    }

    public Document[] parse() throws Parser.Failure {
        return this.parseWithLimits(Integer.MAX_VALUE, Long.MAX_VALUE, this.response.lastModified() == null ? null : this.response.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document[] parseWithLimits(int maxLinks, long maxBytes, Date lastModified) throws Parser.Failure {
        String supportError = TextParser.supports(this.response.url(), this.response.getResponseHeader() == null ? null : this.response.getResponseHeader().getContentType());
        if (supportError != null) {
            throw new Parser.Failure("no parser support:" + supportError, this.response.url());
        }
        try {
            String mimeType = this.response.getResponseHeader() == null ? null : this.response.getResponseHeader().getContentType();
            String charsetName = this.response.getResponseHeader() == null ? StandardCharsets.UTF_8.name() : this.response.getResponseHeader().getCharacterEncoding();
            Document[] documentArray = TextParser.parseWithLimits(this.response.url(), mimeType, charsetName, this.response.getRequest().timezoneOffset(), this.response.getRequest().depth(), this.response.size(), this.contentStream, maxLinks, maxBytes, lastModified);
            return documentArray;
        }
        catch (Parser.Failure e) {
            throw e;
        }
        catch (Exception e) {
            Document[] documentArray = null;
            return documentArray;
        }
        finally {
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (IOException ignored) {
                    log.warn("Could not close content stream on url " + String.valueOf(this.response.url()));
                }
            }
        }
    }
}

