/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.util.LinkedHashMap;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.storage.SizeLimitedSet;
import net.yacy.document.Document;
import net.yacy.document.parser.html.ImageEntry;
import net.yacy.kelondro.util.MemoryControl;

public class ResultImages {
    private static final Queue<OriginEntry> privateImageQueueHigh = new LinkedBlockingQueue<OriginEntry>();
    private static final Queue<OriginEntry> privateImageQueueLow = new LinkedBlockingQueue<OriginEntry>();
    private static final Queue<OriginEntry> publicImageQueueHigh = new LinkedBlockingQueue<OriginEntry>();
    private static final Queue<OriginEntry> publicImageQueueLow = new LinkedBlockingQueue<OriginEntry>();
    private static final Set<String> doubleCheck = new SizeLimitedSet<String>(10000);

    public static void registerImages(DigestURL source, Document document, boolean privateEntry) {
        if (document == null) {
            return;
        }
        if (source == null) {
            return;
        }
        if (MemoryControl.shortStatus()) {
            ResultImages.clearQueues();
        }
        ResultImages.limitQueues(1000);
        LinkedHashMap<DigestURL, ImageEntry> images = document.getImages();
        for (ImageEntry image : images.values()) {
            String url;
            if (image == null || image.url() == null || doubleCheck.contains(url = image.url().toNormalform(true))) continue;
            doubleCheck.add(url);
            boolean good = false;
            if (image.width() > 120 && image.height() > 100 && image.width() < 1200 && image.height() < 1000 && !"gif".equals(MultiProtocolURL.getFileExtension(image.url().getFileName()))) {
                good = true;
                float ratio = image.width() > image.height() ? (float)image.width() / (float)image.height() : (float)image.height() / (float)image.width();
                boolean bl = good = !(ratio < 1.0f) && !(ratio > 2.0f);
            }
            if (good) {
                if (privateEntry) {
                    privateImageQueueHigh.add(new OriginEntry(image, source));
                    continue;
                }
                publicImageQueueHigh.add(new OriginEntry(image, source));
                continue;
            }
            if (privateEntry) {
                privateImageQueueLow.add(new OriginEntry(image, source));
                continue;
            }
            publicImageQueueLow.add(new OriginEntry(image, source));
        }
    }

    public static OriginEntry next(boolean privateEntryOnly) {
        OriginEntry e = null;
        if (privateEntryOnly) {
            e = privateImageQueueHigh.poll();
            if (e == null) {
                e = privateImageQueueLow.poll();
            }
        } else {
            e = publicImageQueueHigh.poll();
            if (e == null) {
                e = privateImageQueueHigh.poll();
            }
            if (e == null) {
                e = publicImageQueueLow.poll();
            }
            if (e == null) {
                e = privateImageQueueLow.poll();
            }
        }
        return e;
    }

    public static int queueSize(boolean privateEntryOnly) {
        int publicSize = 0;
        if (!privateEntryOnly) {
            publicSize = publicImageQueueHigh.size() + publicImageQueueLow.size();
        }
        return privateImageQueueHigh.size() + privateImageQueueLow.size() + publicSize;
    }

    public static int privateQueueHighSize() {
        return privateImageQueueHigh.size();
    }

    public static int privateQueueLowSize() {
        return privateImageQueueLow.size();
    }

    public static int publicQueueHighSize() {
        return publicImageQueueHigh.size();
    }

    public static int publicQueueLowSize() {
        return publicImageQueueLow.size();
    }

    public static void clearQueues() {
        privateImageQueueHigh.clear();
        privateImageQueueLow.clear();
        publicImageQueueHigh.clear();
        publicImageQueueLow.clear();
        doubleCheck.clear();
    }

    public static void limitQueues(int limit) {
        while (privateImageQueueHigh.size() > limit) {
            privateImageQueueHigh.poll();
        }
        while (privateImageQueueLow.size() > limit) {
            privateImageQueueLow.poll();
        }
        while (publicImageQueueHigh.size() > limit) {
            publicImageQueueHigh.poll();
        }
        while (publicImageQueueLow.size() > limit) {
            publicImageQueueLow.poll();
        }
    }

    public static class OriginEntry {
        public ImageEntry imageEntry;
        public MultiProtocolURL baseURL;

        public OriginEntry(ImageEntry imageEntry, MultiProtocolURL baseURL) {
            this.imageEntry = imageEntry;
            this.baseURL = baseURL;
        }
    }
}

