/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.json.JSONException;
import org.json.JSONObject;

public final class MessageStacks {
    public static final String ATTR_ID = "id";
    public static final String ATTR_QUEUE = "queue";
    public static final String ATTR_OBJECT = "object";
    public static final String ATTR_OP = "op";
    public static final String ATTR_CREATED_AT = "createdAt";
    public static final String ATTR_DELETED_AT = "deletedAt";
    private final Path dataDir;
    private final Path pushLog;
    private final Path deleteLog;
    private final Path pushBackup;
    private final Path deleteBackup;
    private final ConcurrentMap<String, ArrayDeque<Message>> stacks = new ConcurrentHashMap<String, ArrayDeque<Message>>();
    private final ConcurrentMap<String, ReentrantLock> stackLocks = new ConcurrentHashMap<String, ReentrantLock>();
    private final ReentrantLock pushLogLock = new ReentrantLock();
    private final ReentrantLock deleteLogLock = new ReentrantLock();
    private final ReadWriteLock stacksDictLock = new ReentrantReadWriteLock();

    private static final String uuid() {
        return UUID.randomUUID().toString();
    }

    private static final String isoNow() {
        return OffsetDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
    }

    public MessageStacks(String dir, boolean rewriteLogOnStart, boolean keepBackup) throws JSONException {
        this.dataDir = Paths.get(dir, new String[0]);
        try {
            Files.createDirectories(this.dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create data dir: " + dir, e);
        }
        this.pushLog = this.dataDir.resolve("push_log.jsonl");
        this.deleteLog = this.dataDir.resolve("delete_log.jsonl");
        this.pushBackup = this.dataDir.resolve("push_log.backup");
        this.deleteBackup = this.dataDir.resolve("delete_log.backup");
        this.replay();
        if (rewriteLogOnStart) {
            this.rewriteLog(keepBackup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ReentrantLock getStackLock(String queue) {
        ReentrantLock l = (ReentrantLock)this.stackLocks.get(queue);
        if (l != null) {
            return l;
        }
        this.stacksDictLock.writeLock().lock();
        try {
            ReentrantLock reentrantLock = this.stackLocks.computeIfAbsent(queue, k -> new ReentrantLock());
            return reentrantLock;
        }
        finally {
            this.stacksDictLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayDeque<Message> getStack(String queue) {
        ArrayDeque s = (ArrayDeque)this.stacks.get(queue);
        if (s != null) {
            return s;
        }
        this.stacksDictLock.writeLock().lock();
        try {
            ArrayDeque arrayDeque = this.stacks.computeIfAbsent(queue, k -> new ArrayDeque());
            return arrayDeque;
        }
        finally {
            this.stacksDictLock.writeLock().unlock();
        }
    }

    private void appendJsonLine(Path file, JSONObject json, ReentrantLock lock) throws JSONException {
        byte[] bytes = (json.toString() + "\n").getBytes(StandardCharsets.UTF_8);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        lock.lock();
        try (SeekableByteChannel ch = Files.newByteChannel(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            while (buf.hasRemaining()) {
                ch.write(buf);
            }
            if (ch instanceof FileChannel) {
                ((FileChannel)ch).force(true);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void replay() {
        String id;
        String line;
        BufferedReader br2;
        HashSet<String> deleted = new HashSet<String>();
        if (Files.isRegularFile(this.deleteLog, new LinkOption[0])) {
            try {
                br2 = Files.newBufferedReader(this.deleteLog, StandardCharsets.UTF_8);
                try {
                    while ((line = br2.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        try {
                            JSONObject obj = new JSONObject(line);
                            id = obj.optString(ATTR_ID, null);
                            if (id == null) continue;
                            deleted.add(id);
                        }
                        catch (JSONException e) {
                            System.out.println("MessageStacks.replay: ignoring invalid JSON line in delete log: " + line);
                        }
                    }
                }
                finally {
                    if (br2 != null) {
                        br2.close();
                    }
                }
            }
            catch (IOException br2) {
                // empty catch block
            }
        }
        if (!Files.isRegularFile(this.pushLog, new LinkOption[0])) return;
        try {
            br2 = Files.newBufferedReader(this.pushLog, StandardCharsets.UTF_8);
            try {
                while ((line = br2.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    try {
                        Message meta = new Message(line);
                        id = meta.optString(ATTR_ID, null);
                        String queue = meta.optString(ATTR_QUEUE, null);
                        if (id == null || queue == null || deleted.contains(id)) continue;
                        ArrayDeque<Message> stack = this.getStack(queue);
                        stack.add(meta);
                    }
                    catch (JSONException e) {
                        System.out.println("MessageStacks.replay: ignoring invalid JSON line in push log: " + line);
                    }
                }
                return;
            }
            finally {
                if (br2 != null) {
                    br2.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rewriteLog(boolean keepBackup) throws JSONException {
        block21: {
            if (keepBackup) {
                this.tryAppend(this.pushLog, this.pushBackup);
                this.tryAppend(this.deleteLog, this.deleteBackup);
            }
            try {
                Files.writeString(this.deleteLog, (CharSequence)"", StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Path tmp = null;
            try {
                tmp = Files.createTempFile(this.dataDir, "push_log.tmp.", ".jsonl", new FileAttribute[0]);
                try (BufferedWriter bw = Files.newBufferedWriter(tmp, StandardCharsets.UTF_8, new OpenOption[0]);){
                    ArrayList names = new ArrayList(this.stacks.keySet());
                    Collections.sort(names);
                    for (String q : names) {
                        ArrayDeque<Message> stack = this.getStack(q);
                        ReentrantLock sl = this.getStackLock(q);
                        sl.lock();
                        try {
                            for (Message m : stack) {
                                bw.write(m.toString());
                                bw.write("\n");
                            }
                        }
                        finally {
                            sl.unlock();
                        }
                    }
                    bw.flush();
                }
                try {
                    Files.move(tmp, this.pushLog, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(tmp, this.pushLog, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException ignored) {
                if (tmp == null) break block21;
                try {
                    Files.deleteIfExists(tmp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private final void tryAppend(Path src, Path dst) {
        if (!Files.isRegularFile(src, new LinkOption[0])) {
            return;
        }
        try (InputStream in = Files.newInputStream(src, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(dst, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            in.transferTo(out);
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message push(String queue, JSONObject object) throws JSONException {
        Message meta = new Message(MessageStacks.uuid(), queue, object);
        this.appendJsonLine(this.pushLog, meta, this.pushLogLock);
        ArrayDeque<Message> stack = this.getStack(queue);
        ReentrantLock sl = this.getStackLock(queue);
        sl.lock();
        try {
            stack.addLast(meta);
        }
        finally {
            sl.unlock();
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message pop(String queue) throws JSONException {
        ArrayDeque<Message> stack = this.getStack(queue);
        ReentrantLock sl = this.getStackLock(queue);
        sl.lock();
        try {
            if (stack.isEmpty()) {
                Message message2 = null;
                return message2;
            }
            Message meta = stack.peekLast();
            if (meta == null) {
                Message message3 = null;
                return message3;
            }
            Del del = meta.toDel("pop");
            this.appendJsonLine(this.deleteLog, del, this.deleteLogLock);
            stack.removeLast();
            Message message4 = meta;
            return message4;
        }
        finally {
            sl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message pot(String queue) throws JSONException {
        ArrayDeque<Message> stack = this.getStack(queue);
        ReentrantLock sl = this.getStackLock(queue);
        sl.lock();
        try {
            if (stack.isEmpty()) {
                Message message2 = null;
                return message2;
            }
            Message meta = stack.peekFirst();
            if (meta == null) {
                Message message3 = null;
                return message3;
            }
            Del del = meta.toDel("pot");
            this.appendJsonLine(this.deleteLog, del, this.deleteLogLock);
            stack.removeFirst();
            Message message4 = meta;
            return message4;
        }
        finally {
            sl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Message> top(String queue, int n) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        ArrayDeque<Message> stack = this.getStack(queue);
        ReentrantLock sl = this.getStackLock(queue);
        ArrayList<Message> res = new ArrayList<Message>();
        sl.lock();
        try {
            int c = Math.min(stack.size(), n);
            Iterator<Message> i = stack.descendingIterator();
            while (i.hasNext() && c-- > 0) {
                Message m = i.next();
                res.add(m);
            }
        }
        finally {
            sl.unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Message> bot(String queue, int n) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        ArrayDeque<Message> stack = this.getStack(queue);
        ReentrantLock sl = this.getStackLock(queue);
        ArrayList<Message> res = new ArrayList<Message>();
        sl.lock();
        try {
            int c = Math.min(stack.size(), n);
            Iterator<Message> i = stack.iterator();
            while (i.hasNext() && c-- > 0) {
                Message m = i.next();
                res.add(m);
            }
        }
        finally {
            sl.unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> queuesJson() {
        ArrayList names = new ArrayList(this.stacks.keySet());
        Collections.sort(names);
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (String q : names) {
            ReentrantLock sl = this.getStackLock(q);
            sl.lock();
            try {
                ArrayDeque s = (ArrayDeque)this.stacks.get(q);
                map.put(q, s == null ? 0 : s.size());
            }
            finally {
                sl.unlock();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSONObject queueStats(String queue) throws JSONException {
        int size;
        ArrayDeque<Message> s = this.getStack(queue);
        ReentrantLock sl = this.getStackLock(queue);
        String oldest = null;
        String newest = null;
        sl.lock();
        try {
            size = s.size();
            if (size > 0) {
                oldest = s.peekFirst().getString(ATTR_CREATED_AT);
                newest = s.peekLast().getString(ATTR_CREATED_AT);
            }
        }
        finally {
            sl.unlock();
        }
        JSONObject stats = new JSONObject();
        stats.put("name", queue);
        stats.put("size", size);
        stats.put("oldest_created_at", oldest);
        stats.put("newest_created_at", newest);
        return stats;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("MessageStacks mass test starting\u2026");
        Path tmp = Files.createTempDirectory("messagestacks-test-", new FileAttribute[0]);
        String dir = tmp.toString();
        System.out.println("Using data dir: " + dir);
        int QUEUES = 8;
        int PHASE1_PUSH_PER_Q = 1000;
        int PHASE2_PRODUCERS = 6;
        int PHASE2_PUSH_PER_PRODUCER = 2000;
        long RANDOM_SEED = 42L;
        ArrayList<CallSite> queueNames = new ArrayList<CallSite>();
        for (int i = 0; i < 8; ++i) {
            queueNames.add((CallSite)((Object)("q" + i)));
        }
        MessageStacks ms1 = new MessageStacks(dir, false, false);
        System.out.println("Phase 1: deterministic single-thread exercises\u2026");
        for (String string : queueNames) {
            for (int i = 0; i < 1000; ++i) {
                JSONObject payload = new JSONObject().put("n", i).put(ATTR_QUEUE, string).put("phase", 1);
                ms1.push(string, payload);
            }
        }
        for (String string : queueNames) {
            int size = ms1.queuesJson().get(string);
            MessageStacks.assertEquals(1000, size, "Phase1 size after push for " + string);
        }
        for (String string : queueNames) {
            List<Message> top5 = ms1.top(string, 5);
            MessageStacks.assertEquals(5, top5.size(), "top(5) size");
            int n0 = top5.get(0).getJSONObject(ATTR_OBJECT).getInt("n");
            int n4 = top5.get(4).getJSONObject(ATTR_OBJECT).getInt("n");
            MessageStacks.assertTrue(n0 == 999 && n4 == 995, "top order");
            List<Message> bot5 = ms1.bot(string, 5);
            MessageStacks.assertEquals(5, bot5.size(), "bot(5) size");
            int b0 = bot5.get(0).getJSONObject(ATTR_OBJECT).getInt("n");
            int b4 = bot5.get(4).getJSONObject(ATTR_OBJECT).getInt("n");
            MessageStacks.assertTrue(b0 == 0 && b4 == 4, "bot order");
        }
        for (String string : queueNames) {
            Message mTop = ms1.pop(string);
            Message mBot = ms1.pot(string);
            MessageStacks.assertNotNull(mTop, "pop returned null");
            MessageStacks.assertNotNull(mBot, "pot returned null");
        }
        for (String string : queueNames) {
            int size = ms1.queuesJson().get(string);
            MessageStacks.assertEquals(998, size, "Phase1 size after pop+pot for " + string);
        }
        System.out.println("Phase 2: multithreaded producers\u2026");
        int totalPhase2Push = 12000;
        Thread[] threadArray = new Thread[6];
        AtomicIntegerArray perQueueAdds = new AtomicIntegerArray(8);
        for (int p2 = 0; p2 < 6; ++p2) {
            int pid = p2;
            threadArray[p2] = new Thread(() -> {
                Random rnd = new Random(42L + (long)pid);
                for (int i = 0; i < 2000; ++i) {
                    String q = (String)queueNames.get(rnd.nextInt(8));
                    try {
                        JSONObject payload = new JSONObject().put("producer", pid).put("i", i).put("phase", 2);
                        ms1.push(q, payload);
                        perQueueAdds.incrementAndGet(queueNames.indexOf(q));
                        continue;
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, "producer-" + p2);
            threadArray[p2].start();
        }
        for (Thread t : threadArray) {
            t.join();
        }
        int sumAdds = 0;
        for (int i = 0; i < 8; ++i) {
            sumAdds += perQueueAdds.get(i);
        }
        MessageStacks.assertEquals(12000, sumAdds, "Phase2 total pushes accounted for");
        Map<String, Integer> sizes = ms1.queuesJson();
        for (int i = 0; i < 8; ++i) {
            String q = (String)queueNames.get(i);
            int expected = 998 + perQueueAdds.get(i);
            MessageStacks.assertEquals(expected, sizes.get(q), "Phase2 size for " + q);
        }
        int expectedTotalAfterP2 = 19984;
        int actualTotalAfterP2 = sizes.values().stream().mapToInt(Integer::intValue).sum();
        MessageStacks.assertEquals(expectedTotalAfterP2, actualTotalAfterP2, "Phase2 global size");
        System.out.println("Phase 3: restart & replay check\u2026");
        MessageStacks ms3 = new MessageStacks(dir, false, false);
        Map<String, Integer> sizesAfterReplay = ms3.queuesJson();
        for (String string : queueNames) {
            MessageStacks.assertEquals(sizes.get(string), sizesAfterReplay.get(string), "Replay size matches for " + string);
        }
        int actualTotalAfterReplay = sizesAfterReplay.values().stream().mapToInt(Integer::intValue).sum();
        MessageStacks.assertEquals(expectedTotalAfterP2, actualTotalAfterReplay, "Replay preserves global size");
        System.out.println("Phase 4: rewrite-on-start (keep backups)\u2026");
        MessageStacks messageStacks = new MessageStacks(dir, true, true);
        Map<String, Integer> sizesAfterRewrite = messageStacks.queuesJson();
        for (String string : queueNames) {
            MessageStacks.assertEquals(sizesAfterReplay.get(string), sizesAfterRewrite.get(string), "Rewrite size matches for " + string);
        }
        int actualTotalAfterRewrite = sizesAfterRewrite.values().stream().mapToInt(Integer::intValue).sum();
        MessageStacks.assertEquals(expectedTotalAfterP2, actualTotalAfterRewrite, "Rewrite preserves global size");
        HashSet hashSet = new HashSet();
        try (Stream<Path> sDir = Files.list(tmp);){
            sDir.forEach(p -> names.add(p.getFileName().toString()));
        }
        MessageStacks.assertTrue(hashSet.contains("push_log.jsonl"), "push_log.jsonl exists");
        MessageStacks.assertTrue(hashSet.contains("delete_log.jsonl"), "delete_log.jsonl exists");
        MessageStacks.assertTrue(hashSet.contains("push_log.backup"), "push_log.backup exists (keepBackup)");
        MessageStacks.assertTrue(hashSet.contains("delete_log.backup"), "delete_log.backup exists (keepBackup)");
        System.out.println("Phase 5: parallel drain (mix pop/pot)\u2026");
        int consumers = Math.max(4, Runtime.getRuntime().availableProcessors());
        AtomicInteger drained = new AtomicInteger(0);
        int initialTotal = sizesAfterRewrite.values().stream().mapToInt(Integer::intValue).sum();
        Thread[] workers = new Thread[consumers];
        for (int c = 0; c < consumers; ++c) {
            int cid = c;
            workers[c] = new Thread(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }, "consumer-" + c);
            workers[c].start();
        }
        for (Thread t : workers) {
            t.join();
        }
        int remaining = messageStacks.queuesJson().values().stream().mapToInt(Integer::intValue).sum();
        MessageStacks.assertEquals(0, remaining, "all queues empty after drain");
        MessageStacks.assertEquals(initialTotal, drained.get(), "drained count equals initial total");
        System.out.println("Phase 6: edge cases\u2026");
        List<Message> emptyTop = messageStacks.top((String)queueNames.get(0), 5);
        List<Message> emptyBot = messageStacks.bot((String)queueNames.get(0), 5);
        MessageStacks.assertTrue(emptyTop.isEmpty(), "top on empty returns empty");
        MessageStacks.assertTrue(emptyBot.isEmpty(), "bot on empty returns empty");
        MessageStacks.assertTrue(messageStacks.top((String)queueNames.get(0), 0).isEmpty(), "top(0) empty");
        MessageStacks.assertTrue(messageStacks.bot((String)queueNames.get(0), -10).isEmpty(), "bot(-10) empty");
        System.out.println("All tests passed \u2705");
        System.out.println("Data dir kept at: " + dir);
    }

    private static void assertEquals(int expected, int actual, String msg) {
        if (expected != actual) {
            throw new AssertionError((Object)(msg + " | expected=" + expected + " actual=" + actual));
        }
    }

    private static void assertTrue(boolean cond, String msg) {
        if (!cond) {
            throw new AssertionError((Object)msg);
        }
    }

    private static void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new AssertionError((Object)msg);
        }
    }

    public static final class Message
    extends JSONObject {
        public Message(String jsonString) throws JSONException {
            super(jsonString);
        }

        public Message(String id, String queue, JSONObject object, String createdAt) throws JSONException {
            this.put(MessageStacks.ATTR_ID, id);
            this.put(MessageStacks.ATTR_QUEUE, queue);
            this.put(MessageStacks.ATTR_CREATED_AT, createdAt);
            this.put(MessageStacks.ATTR_OBJECT, object);
        }

        public Message(String id, String queue, JSONObject object) throws JSONException {
            this(id, queue, object, MessageStacks.isoNow());
        }

        private final Del toDel(String op) throws JSONException {
            return new Del(this.getString(MessageStacks.ATTR_ID), this.getString(MessageStacks.ATTR_QUEUE), op);
        }
    }

    private static final class Del
    extends JSONObject {
        private Del(String id, String queue, String op) throws JSONException {
            this.put(MessageStacks.ATTR_ID, id);
            this.put(MessageStacks.ATTR_QUEUE, queue);
            this.put(MessageStacks.ATTR_OP, op);
            this.put(MessageStacks.ATTR_DELETED_AT, MessageStacks.isoNow());
        }
    }
}

