/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.SimpleARC;

public final class ComparableARC<K, V>
extends SimpleARC<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>>,
ARC<K, V> {
    public ComparableARC(int cacheSize, Comparator<? super K> comparator) {
        this.cacheSize = cacheSize / 2;
        this.levelA = new LimitedTreeMap(this.cacheSize, comparator);
        this.levelB = new LimitedTreeMap(this.cacheSize, comparator);
    }

    private static class LimitedTreeMap<K, V>
    extends TreeMap<K, V> {
        private static final long serialVersionUID = -2276429187676080820L;
        int limit;
        LinkedList<K> keys;

        public LimitedTreeMap(int cacheSize, Comparator<? super K> comparator) {
            super(comparator);
            this.limit = cacheSize;
            this.keys = new LinkedList();
        }

        @Override
        public synchronized V get(Object k) {
            return super.get(k);
        }

        @Override
        public synchronized V put(K k, V v) {
            V r = super.put(k, v);
            if (r == null) {
                this.keys.add(k);
            }
            if (this.keys.size() > this.limit) {
                K w = this.keys.removeFirst();
                assert (w != null);
                Object t = super.remove(w);
                assert (t != null) : "keys.size() = " + this.keys.size() + ", limit = " + this.limit;
            }
            return r;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry2 : map.entrySet()) {
                this.put(entry2.getKey(), entry2.getValue());
            }
        }

        @Override
        public synchronized V remove(Object k) {
            Object r = super.remove(k);
            if (r == null) {
                return null;
            }
            boolean removed = this.removeFromKeys(k);
            assert (removed);
            return r;
        }

        @Override
        public synchronized Map.Entry<K, V> pollFirstEntry() {
            Map.Entry entry2 = super.pollFirstEntry();
            boolean removed = this.removeFromKeys(entry2.getKey());
            assert (removed);
            return entry2;
        }

        @Override
        public synchronized Map.Entry<K, V> pollLastEntry() {
            Map.Entry entry2 = super.pollLastEntry();
            boolean removed = this.removeFromKeys(entry2.getKey());
            assert (removed);
            return entry2;
        }

        @Override
        public synchronized void clear() {
            super.clear();
            this.keys.clear();
        }

        private boolean removeFromKeys(K k) {
            assert (k != null);
            Iterator i = this.keys.iterator();
            while (i.hasNext()) {
                Object x = i.next();
                if (super.comparator().compare(k, x) != 0) continue;
                i.remove();
                return true;
            }
            return false;
        }
    }
}

