/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffType;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.logging.Hex;

public class AiffFileHeader {
    private static final String FORM = "FORM";
    private static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff.AudioFileHeader");

    public long readHeader(RandomAccessFile raf, AiffAudioHeader aiffAudioHeader) throws IOException, CannotReadException {
        ByteBuffer headerData = ByteBuffer.allocateDirect(IffHeaderChunk.HEADER_LENGTH);
        headerData.order(ByteOrder.BIG_ENDIAN);
        int bytesRead = raf.getChannel().read(headerData);
        headerData.position(0);
        if (bytesRead < IffHeaderChunk.HEADER_LENGTH) {
            throw new IOException("AIFF:Unable to read required number of databytes read:" + bytesRead + ":required:" + IffHeaderChunk.HEADER_LENGTH);
        }
        String signature = Utils.readFourBytesAsChars(headerData);
        if (FORM.equals(signature)) {
            long chunkSize = headerData.getInt();
            logger.severe("Reading AIFF header size:" + chunkSize + " (" + Hex.asHex(chunkSize) + ")");
            this.readFileType(headerData, aiffAudioHeader);
            return chunkSize - (long)IffHeaderChunk.TYPE_LENGTH;
        }
        throw new CannotReadException("Not an AIFF file: incorrect signature " + signature);
    }

    private void readFileType(ByteBuffer bytes, AiffAudioHeader aiffAudioHeader) throws IOException, CannotReadException {
        String type = Utils.readFourBytesAsChars(bytes);
        if (AiffType.AIFF.getCode().equals(type)) {
            aiffAudioHeader.setFileType(AiffType.AIFF);
        } else if (AiffType.AIFC.getCode().equals(type)) {
            aiffAudioHeader.setFileType(AiffType.AIFC);
        } else {
            throw new CannotReadException("Invalid AIFF file: Incorrect file type info " + type);
        }
    }
}

