/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class SpectralAnalyzerStripPlotter
extends RasterPlotter {
    private final double[][] bands;
    private final Random random = new Random(1590149342L);

    public SpectralAnalyzerStripPlotter(int width, int height, int segments, int bandsPerSegment) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 17L);
        this.bands = new double[segments][bandsPerSegment];
        for (int s = 0; s < segments; ++s) {
            for (int b = 0; b < bandsPerSegment; ++b) {
                this.bands[s][b] = this.random.nextDouble();
            }
        }
    }

    public void renderFrame() {
        this.clear();
        this.drawBackground();
        int segments = this.bands.length;
        int segmentWidth = this.getWidth() / segments;
        for (int s = 0; s < segments; ++s) {
            this.updateSegment(s);
            this.drawSegment(s * segmentWidth, segmentWidth, this.bands[s]);
        }
        this.drawOverlay();
    }

    private void drawBackground() {
        this.setColor(6440L);
        for (int y = 0; y < this.getHeight(); y += 4) {
            this.line(0, y, this.getWidth(), y, 15);
        }
    }

    private void updateSegment(int segment) {
        double[] values = this.bands[segment];
        for (int i = 0; i < values.length; ++i) {
            double next = values[i] + (this.random.nextDouble() - 0.5) * 0.3;
            next = Math.max(0.05, Math.min(1.0, next));
            values[i] = next * 0.7 + values[i] * 0.3;
        }
    }

    private void drawSegment(int left, int width, double[] values) {
        int bottom = this.getHeight() - 24;
        int top = 28;
        int bandCount = values.length;
        int bandWidth = Math.max(2, (width - 12) / bandCount);
        for (int i = 0; i < bandCount; ++i) {
            double value = values[i];
            int height = (int)(value * (double)(bottom - 28));
            int x = left + 6 + i * bandWidth;
            long color = this.colorForBand(value, i);
            this.setColor(color);
            for (int y = bottom; y > bottom - height; y -= 2) {
                this.line(x, y, x + bandWidth - 2, y, 75);
            }
            this.setColor(SpectralAnalyzerStripPlotter.lighten(color, 1.4));
            this.line(x, bottom - height, x + bandWidth - 2, bottom - height, 90);
        }
        this.setColor(20335L);
        this.line(left + 4, 28, left + width - 4, 28, 30);
        this.line(left + 4, bottom, left + width - 4, bottom, 30);
    }

    private long colorForBand(double value, int index2) {
        int hueShift = index2 * 20 % 120;
        double base = Math.min(1.0, value + (double)hueShift / 160.0);
        int r = (int)(base * 255.0);
        int g = (int)((0.5 + value / 2.0) * 180.0);
        int b = (int)((1.0 - base) * 180.0 + 60.0);
        return r << 16 | g << 8 | b;
    }

    private void drawOverlay() {
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 6, 12, 0, "SPECTRAL ANALYZER", -1, 80);
        this.setColor(65450L);
        PrintTool.print5(this, 6, this.getHeight() - 10, 0, "HZ" + this.random.nextInt(8000), -1, 60);
        this.setColor(48127L);
        PrintTool.print5(this, this.getWidth() - 6, 12, 0, "GAIN" + this.random.nextInt(30), 1, 70);
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        SpectralAnalyzerStripPlotter plotter = new SpectralAnalyzerStripPlotter(640, 220, 12, 24);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderFrame();
            File out = new File(dir, String.format("spectral_strip_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write spectral frame", e);
            }
        }
    }
}

