/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.util.HashMap;
import java.util.Map;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.utils.loaderProcess;

public class loaderThreads {
    protected int timeout;
    protected String user;
    protected String password;
    private final Map<String, Thread> threads;
    private int completed;
    private int failed;

    public loaderThreads() {
        this(10000, null, null);
    }

    public loaderThreads(int timeout, String user, String password) {
        this.timeout = timeout;
        this.user = user;
        this.password = password;
        this.threads = new HashMap<String, Thread>();
        this.completed = 0;
        this.failed = 0;
    }

    public void newThread(String name, DigestURL url, loaderProcess process, ClientIdentification.Agent agent) {
        loaderThread t = new loaderThread(url, process, agent);
        this.threads.put(name, t);
        t.start();
    }

    public void terminateThread(String name) {
        loaderThread t = (loaderThread)this.threads.get(name);
        if (t == null) {
            throw new RuntimeException("no such thread: " + name);
        }
        t.terminate();
    }

    public int threadCompleted(String name) {
        loaderThread t = (loaderThread)this.threads.get(name);
        if (t == null) {
            throw new RuntimeException("no such thread: " + name);
        }
        return t.completed();
    }

    public int threadStatus(String name) {
        loaderThread t = (loaderThread)this.threads.get(name);
        if (t == null) {
            throw new RuntimeException("no such thread: " + name);
        }
        return t.status();
    }

    public int completed() {
        return this.completed;
    }

    public int failed() {
        return this.failed;
    }

    public int count() {
        return this.threads.size();
    }

    public Exception threadError(String name) {
        loaderThread t = (loaderThread)this.threads.get(name);
        if (t == null) {
            throw new RuntimeException("no such thread: " + name);
        }
        return t.error();
    }

    protected class loaderThread
    extends Thread {
        private final DigestURL url;
        private Exception error;
        private final loaderProcess process;
        private byte[] page;
        private boolean loaded;
        final ClientIdentification.Agent agent;

        public loaderThread(DigestURL url, loaderProcess process, ClientIdentification.Agent agent) {
            super("loaderThreads.loaderThread");
            this.url = url;
            this.process = process;
            this.error = null;
            this.page = null;
            this.loaded = false;
            this.agent = agent;
        }

        @Override
        public void run() {
            try {
                this.page = this.url.get(this.agent, null, null);
                this.loaded = true;
                this.process.feed(this.page);
                if (this.process.status() == 3) {
                    this.error = this.process.error();
                }
                if (this.process.status() == 4 || this.process.status() == 9) {
                    ++loaderThreads.this.completed;
                }
                if (this.process.status() == 2 || this.process.status() == 3) {
                    ++loaderThreads.this.failed;
                }
            }
            catch (Exception e) {
                this.error = e;
                ++loaderThreads.this.failed;
            }
        }

        public void terminate() {
            this.process.terminate();
        }

        public boolean loaded() {
            return this.loaded;
        }

        public int completed() {
            if (this.process.status() == 0) {
                return 1;
            }
            if (this.process.status() == 1) {
                return 9 + this.process.completed() * 9 / 10;
            }
            if (this.process.status() == 4) {
                return 100;
            }
            return 0;
        }

        public int status() {
            return this.process.status();
        }

        public Exception error() {
            return this.error;
        }
    }
}

