/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.yacy.cora.protocol.Domains;

public class serverAccessTracker {
    private static final long cleanupCycle = 60000L;
    private static long maxTrackingTime = 3600000L;
    private static int maxTrackingCount = 1000;
    private static int maxHostCount = 100;
    private static final ConcurrentHashMap<String, Queue<Track>> accessTracker = new ConcurrentHashMap();
    private static long lastCleanup;
    private static long lastLocalhostAccess;

    public static void init(long mtt, int mtc, int mthc) {
        maxTrackingTime = mtt;
        maxTrackingCount = mtc;
        maxHostCount = mthc;
    }

    private static void cleanupAccessTracker() {
        String key;
        if (System.currentTimeMillis() - lastCleanup < 60000L) {
            return;
        }
        lastCleanup = System.currentTimeMillis();
        Iterator<Map.Entry<String, Queue<Track>>> i = accessTracker.entrySet().iterator();
        block2: while (i.hasNext()) {
            Queue<Track> track = i.next().getValue();
            serverAccessTracker.clearTooOldAccess(track);
            if (track.isEmpty()) {
                i.remove();
                continue;
            }
            while (track.size() > maxTrackingCount) {
                try {
                    track.remove();
                }
                catch (NoSuchElementException e) {
                    continue block2;
                }
            }
        }
        while (accessTracker.size() > maxHostCount && (key = accessTracker.keys().nextElement()) != null) {
            accessTracker.remove(key);
        }
    }

    public static int latestAccessCount(String host, long delta) {
        Collection<Track> timeList = serverAccessTracker.accessTrack(host);
        if (timeList == null) {
            return 0;
        }
        long time = System.currentTimeMillis() - delta;
        int c = 0;
        for (Track l : timeList) {
            if (l == null || l.getTime() <= time) continue;
            ++c;
        }
        return c;
    }

    private static void clearTooOldAccess(Queue<Track> access) {
        long time = System.currentTimeMillis() - maxTrackingTime;
        Iterator e = access.iterator();
        int max = access.size();
        while (e.hasNext() && max-- > 0) {
            Track l = (Track)e.next();
            if (l.getTime() > time) continue;
            e.remove();
        }
    }

    public static void track(String host, String accessPath) {
        Queue<Track> track;
        if (System.currentTimeMillis() - lastCleanup > 60000L) {
            serverAccessTracker.cleanupAccessTracker();
        }
        if (accessPath == null) {
            accessPath = "NULL";
        }
        if ((track = accessTracker.get(host)) == null) {
            track = new LinkedBlockingQueue<Track>();
            track.add(new Track(System.currentTimeMillis(), accessPath));
            accessTracker.put(host, track);
        } else {
            track.add(new Track(System.currentTimeMillis(), accessPath));
            serverAccessTracker.clearTooOldAccess(track);
        }
        if (Domains.isLocalhost(host)) {
            lastLocalhostAccess = System.currentTimeMillis();
        }
    }

    public static Collection<Track> accessTrack(String host) {
        Queue<Track> access = accessTracker.get(host);
        if (access == null) {
            return null;
        }
        serverAccessTracker.clearTooOldAccess(access);
        if (access.isEmpty()) {
            accessTracker.remove(host);
        }
        return access;
    }

    public static Iterator<String> accessHosts() {
        ConcurrentHashMap<String, Queue<Track>> accessTrackerClone = new ConcurrentHashMap<String, Queue<Track>>();
        accessTrackerClone.putAll(accessTracker);
        return accessTrackerClone.keySet().iterator();
    }

    public static long timeSinceAccessFromLocalhost() {
        return System.currentTimeMillis() - lastLocalhostAccess;
    }

    static {
        lastLocalhostAccess = 0L;
    }

    public static class Track {
        private final long time;
        private final String path;

        public Track(long time, String path) {
            this.time = time;
            this.path = path;
        }

        public long getTime() {
            return this.time;
        }

        public String getPath() {
            return this.path;
        }
    }
}

