/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.schema;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.search.schema.HyperlinkEdge;
import net.yacy.search.schema.HyperlinkType;

public class HyperlinkEdges
implements Iterable<HyperlinkEdge> {
    private final Map<MultiProtocolURL, Targets> edges = new LinkedHashMap<MultiProtocolURL, Targets>();
    private final Map<MultiProtocolURL, Integer> singletonDepth = new HashMap<MultiProtocolURL, Integer>();

    public void add(HyperlinkEdge edge) {
        this.addEdge(edge.source, edge.target);
    }

    public void addEdge(MultiProtocolURL source, HyperlinkEdge.Target target) {
        Integer e;
        Targets targets = this.edges.get(source);
        Integer d = this.singletonDepth.get(source);
        if (d == null) {
            d = -1;
        } else {
            this.singletonDepth.remove(source);
        }
        if (target.type == HyperlinkType.Inbound && (e = this.singletonDepth.remove(target)) != null && d == -1) {
            d = e - 1;
        }
        if (targets == null) {
            targets = new Targets(d);
            this.edges.put(source, targets);
        }
        targets.targets.add(target);
    }

    public int size() {
        int s = 0;
        for (Targets t : this.edges.values()) {
            s += t.targets.size();
        }
        return s;
    }

    public void addAll(HyperlinkEdges oe) {
        for (Map.Entry<MultiProtocolURL, Targets> edges : oe.edges.entrySet()) {
            for (HyperlinkEdge.Target t : edges.getValue().targets) {
                this.addEdge(edges.getKey(), t);
            }
        }
    }

    public void updateDepth(MultiProtocolURL url, int newdepth) {
        Targets targets = this.edges.get(url);
        if (targets == null) {
            this.singletonDepth.put(url, newdepth);
            return;
        }
        targets.depth = targets.depth == -1 ? newdepth : Math.min(targets.depth, newdepth);
    }

    public int getDepth(MultiProtocolURL url) {
        Targets targets = this.edges.get(url);
        if (targets != null) {
            return targets.depth;
        }
        Integer d = this.singletonDepth.get(url);
        if (d != null) {
            return d;
        }
        String targetHost = url.getHost();
        for (Map.Entry<MultiProtocolURL, Targets> e : this.edges.entrySet()) {
            String sourceHost;
            if (!e.getValue().targets.contains(url) || ((sourceHost = e.getKey().getHost()) != null || targetHost != null) && (sourceHost == null || targetHost == null || !sourceHost.equals(targetHost))) continue;
            return e.getValue().depth + 1;
        }
        return -1;
    }

    @Override
    public Iterator<HyperlinkEdge> iterator() {
        final Iterator<Map.Entry<MultiProtocolURL, Targets>> i = this.edges.entrySet().iterator();
        final Iterator[] tc = (Iterator[])Array.newInstance(Iterator.class, 1);
        tc[0] = null;
        final MultiProtocolURL[] su = new MultiProtocolURL[]{null};
        return new Iterator<HyperlinkEdge>(){

            @Override
            public boolean hasNext() {
                return i.hasNext() || tc[0] != null && tc[0].hasNext();
            }

            @Override
            public HyperlinkEdge next() {
                while (tc[0] == null || !tc[0].hasNext()) {
                    Map.Entry entry2 = (Map.Entry)i.next();
                    tc[0] = ((Targets)entry2.getValue()).targets.iterator();
                    su[0] = (MultiProtocolURL)entry2.getKey();
                }
                if (!tc[0].hasNext()) {
                    return null;
                }
                return new HyperlinkEdge(su[0], (HyperlinkEdge.Target)tc[0].next());
            }

            @Override
            public void remove() {
                tc[0].remove();
            }
        };
    }

    public static class Targets {
        public Set<HyperlinkEdge.Target> targets = new LinkedHashSet<HyperlinkEdge.Target>();
        public int depth;

        public Targets(int depth) {
            this.depth = depth;
        }
    }
}

