/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.Collection;
import java.util.Map;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.StringNavigator;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;

public class HostNavigator
extends StringNavigator
implements Navigator {
    public HostNavigator(String title, CollectionSchema field, NavigatorSort sort) {
        super(title, field, sort);
    }

    @Override
    public void incFacet(Map<String, ReversibleScoreMap<String>> facets) {
        ReversibleScoreMap<String> fcts;
        if (this.field != null && facets != null && !facets.isEmpty() && (fcts = facets.get(this.field.getSolrFieldName())) != null) {
            for (String host : fcts) {
                int hc = fcts.get(host);
                if (hc == 0) continue;
                if (host.startsWith("www.")) {
                    host = host.substring(4);
                }
                this.inc(host, hc);
            }
        }
    }

    @Override
    public void incDoc(URIMetadataNode doc) {
        Object val;
        if (this.field != null && (val = doc.getFieldValue(this.field.getSolrFieldName())) != null) {
            if (val instanceof Collection) {
                Collection ll = (Collection)val;
                for (Object obj : ll) {
                    if (!(obj instanceof String)) continue;
                    String s = (String)obj;
                    if (s.startsWith("www.")) {
                        s = s.substring(4);
                    }
                    this.inc(s);
                }
            } else {
                String host = (String)val;
                if (host.startsWith("www.")) {
                    host = host.substring(4);
                }
                this.inc(host);
            }
        }
    }

    @Override
    public String getQueryModifier(String key) {
        return "site:" + key;
    }

    @Override
    public boolean modifieractive(QueryModifier modifier, String name) {
        if (modifier.sitehost != null) {
            return modifier.sitehost.contains(name);
        }
        return false;
    }
}

