/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search;

import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.WordCache;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.feed.RSSReader;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.FailCategory;
import net.yacy.cora.federate.solr.Ranking;
import net.yacy.cora.federate.solr.connector.ShardSelection;
import net.yacy.cora.federate.solr.instance.EmbeddedInstance;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.Scanner;
import net.yacy.cora.protocol.TimeoutRequest;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.protocol.http.ProxySettings;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Memory;
import net.yacy.crawler.CrawlStacker;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.HarvestProcess;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.CrawlQueues;
import net.yacy.crawler.data.NoticedURL;
import net.yacy.crawler.data.ResultImages;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.crawler.data.Transactions;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.data.BlogBoard;
import net.yacy.data.BlogBoardComments;
import net.yacy.data.BookmarkHelper;
import net.yacy.data.BookmarksDB;
import net.yacy.data.ListManager;
import net.yacy.data.MessageBoard;
import net.yacy.data.UserDB;
import net.yacy.data.WorkTables;
import net.yacy.data.wiki.WikiBoard;
import net.yacy.data.wiki.WikiCode;
import net.yacy.data.wiki.WikiParser;
import net.yacy.document.Condenser;
import net.yacy.document.Document;
import net.yacy.document.LibraryProvider;
import net.yacy.document.Parser;
import net.yacy.document.ProbabilisticClassifier;
import net.yacy.document.TextParser;
import net.yacy.document.Tokenizer;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.content.DCEntry;
import net.yacy.document.content.XMLPackReader;
import net.yacy.document.importer.JsonListImporter;
import net.yacy.document.importer.OAIListFriendsLoader;
import net.yacy.document.importer.WarcImporter;
import net.yacy.document.importer.ZimImporter;
import net.yacy.document.parser.audioTagParser;
import net.yacy.document.parser.html.Evaluation;
import net.yacy.document.parser.pdfParser;
import net.yacy.gui.Audio;
import net.yacy.gui.Tray;
import net.yacy.http.YaCyHttpServer;
import net.yacy.kelondro.blob.ArrayStack;
import net.yacy.kelondro.blob.BEncodedHeap;
import net.yacy.kelondro.blob.Tables;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.logging.GuiHandler;
import net.yacy.kelondro.logging.ThreadDump;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.OS;
import net.yacy.kelondro.util.SetTools;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.kelondro.workflow.InstantBusyThread;
import net.yacy.kelondro.workflow.OneTimeBusyThread;
import net.yacy.kelondro.workflow.WorkflowProcessor;
import net.yacy.kelondro.workflow.WorkflowThread;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.Dispatcher;
import net.yacy.peers.EventChannel;
import net.yacy.peers.Network;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.peers.graphics.NetworkGraph;
import net.yacy.peers.graphics.WebStructureGraph;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.peers.operation.yacyRelease;
import net.yacy.peers.operation.yacyUpdateLocation;
import net.yacy.repository.Blacklist;
import net.yacy.repository.FilterEngine;
import net.yacy.repository.LoaderDispatcher;
import net.yacy.search.EventTracker;
import net.yacy.search.IndexingQueueEntry;
import net.yacy.search.MemoryTracker;
import net.yacy.search.ResourceObserver;
import net.yacy.search.Shutdown;
import net.yacy.search.SwitchboardConstants;
import net.yacy.search.index.Fulltext;
import net.yacy.search.index.Segment;
import net.yacy.search.index.SingleDocumentMatcher;
import net.yacy.search.query.AccessTracker;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.ranking.RankingProfile;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.schema.WebgraphConfiguration;
import net.yacy.search.snippet.TextSnippet;
import net.yacy.server.http.RobotsTxtConfig;
import net.yacy.server.serverCore;
import net.yacy.server.serverSwitch;
import net.yacy.utils.CryptoLib;
import net.yacy.utils.crypt;
import net.yacy.utils.upnp.UPnP;
import net.yacy.visualization.CircleTool;
import net.yacy.yacy;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SyntaxError;

public final class Switchboard
extends serverSwitch {
    static final String SOLR_COLLECTION_CONFIGURATION_NAME_OLD = "solr.keys.default.list";
    public static final String SOLR_COLLECTION_CONFIGURATION_NAME = "solr.collection.schema";
    public static final String SOLR_WEBGRAPH_CONFIGURATION_NAME = "solr.webgraph.schema";
    public static long lastPPMUpdate = System.currentTimeMillis() - 30000L;
    private static final int dhtMaxContainerCount = 500;
    private int dhtMaxReferenceCount = 1000;
    public static SortedSet<String> badwords = new TreeSet<String>(NaturalOrder.naturalComparator);
    public static SortedSet<String> stopwords = new TreeSet<String>(NaturalOrder.naturalComparator);
    public static SortedSet<String> blueList = null;
    public static SortedSet<byte[]> stopwordHashes = null;
    public static Blacklist urlBlacklist = null;
    public static WikiParser wikiParser = null;
    public final File dictionariesPath;
    public final File classificationPath;
    public File listsPath;
    public File htDocsPath;
    public File htRootPath;
    public File htCachePath;
    public File workPath;
    public File releasePath;
    public File networkRoot;
    public File queuesRoot;
    public File packsHoldPath;
    public File packsLivePath;
    public File packsLoadPath;
    public File packsLoadedPath;
    public File packsUnloadPath;
    public Segment index;
    public LoaderDispatcher loader;
    public CrawlSwitchboard crawler;
    public CrawlQueues crawlQueues;
    public CrawlStacker crawlStacker;
    public MessageBoard messageDB;
    public WikiBoard wikiDB;
    public BlogBoard blogDB;
    public BlogBoardComments blogCommentDB;
    public RobotsTxt robots;
    public Map<String, Object[]> outgoingCookies;
    public Map<String, Object[]> incomingCookies;
    public volatile long proxyLastAccess;
    public volatile long localSearchLastAccess;
    public volatile long remoteSearchLastAccess;
    public volatile long adminAuthenticationLastAccess;
    public volatile long optimizeLastRun;
    public Network yc;
    public ResourceObserver observer;
    public UserDB userDB;
    public BookmarksDB bookmarksDB;
    public WebStructureGraph webStructure;
    public ConcurrentHashMap<String, TreeSet<Long>> localSearchTracker;
    public ConcurrentHashMap<String, TreeSet<Long>> remoteSearchTracker;
    public int searchQueriesRobinsonFromLocal = 0;
    public int searchQueriesRobinsonFromRemote = 0;
    public float searchQueriesGlobal = 0.0f;
    public SortedSet<byte[]> clusterhashes;
    public List<Pattern> networkWhitelist;
    public List<Pattern> networkBlacklist;
    public FilterEngine domainList;
    private Dispatcher dhtDispatcher;
    public LinkedBlockingQueue<String> trail;
    public SeedDB peers;
    public Set<String> localcluster_scan;
    public WorkTables tables;
    public Tray tray;
    private long lastStats = 0L;
    public WorkflowProcessor<IndexingQueueEntry> indexingDocumentProcessor;
    public WorkflowProcessor<IndexingQueueEntry> indexingCondensementProcessor;
    public WorkflowProcessor<IndexingQueueEntry> indexingAnalysisProcessor;
    public WorkflowProcessor<IndexingQueueEntry> indexingStorageProcessor;
    public RobotsTxtConfig robotstxtConfig = null;
    public boolean useTailCache;
    public boolean exceed134217727;
    public final long startupTime = System.currentTimeMillis();
    private final Semaphore shutdownSync = new Semaphore(0);
    private boolean terminate = false;
    private boolean startupAction = true;
    private static Switchboard sb;
    public HashMap<String, Object[]> crawlJobsStatus = new HashMap();
    private static long indeSizeCache;
    private static long indexSizeTime;

    public Switchboard(File dataPath, File appPath, String initPath, String configPath) {
        super(dataPath, appPath, initPath, configPath);
        String[] settingsList;
        boolean timeoutrequests;
        sb = this;
        int port = this.getLocalPort();
        if (TimeoutRequest.ping("localhost", port, 500)) {
            throw new RuntimeException("a server is already running on the YaCy port " + port + "; possibly another YaCy process has not terminated yet. Please stop YaCy before running a new instance.");
        }
        MemoryTracker.startSystemProfiling();
        this.setLog(new ConcurrentLog("SWITCHBOARD"));
        AccessTracker.setDumpFile(new File(dataPath, "DATA/LOG/queries.log"));
        TimeoutRequest.enable = timeoutrequests = this.getConfigBool("timeoutrequests", true);
        if (this.getConfigBool("upnp.enabled", false)) {
            new OneTimeBusyThread("UPnP.addPortMappings"){

                @Override
                public boolean jobImpl() throws Exception {
                    UPnP.addPortMappings();
                    return true;
                }
            }.start();
        }
        this.tray = new Tray(this);
        this.initRemoteProxy();
        long tableCachingLimit = this.getConfigLong("tableCachingLimit", 0x19000000L);
        if (MemoryControl.available() > tableCachingLimit) {
            this.useTailCache = true;
        }
        this.exceed134217727 = this.getConfigBool("exceed134217727", true);
        if (MemoryControl.available() > 0x80000000L) {
            this.exceed134217727 = true;
        }
        File indexPath = this.getDataPath("indexPrimaryPath", "DATA/INDEX");
        this.log.config("Index Primary Path: " + indexPath.toString());
        File archivePath = this.getDataPath("indexArchivePath", "DATA/ARCHIVE");
        this.log.config("Index Archive Path: " + archivePath.toString());
        this.listsPath = this.getDataPath("listsPath", "DATA/LISTS");
        this.log.config("Lists Path:     " + this.listsPath.toString());
        this.htRootPath = this.getDataPath("htRootPath", "htroot");
        this.log.config("HTROOT Path:    " + this.htRootPath.toString());
        this.htDocsPath = this.getDataPath("htDocsPath", "DATA/HTDOCS");
        yacy.mkdirIfNeseccary(this.htDocsPath);
        this.log.config("HTDOCS Path:    " + this.htDocsPath.toString());
        this.workPath = this.getDataPath("workPath", "DATA/WORK");
        this.workPath.mkdirs();
        File defaultWorkPath = new File(appPath, "defaults/data/work");
        if (defaultWorkPath.list() != null) {
            for (String fs : defaultWorkPath.list()) {
                File wf = new File(this.workPath, fs);
                if (wf.exists()) continue;
                try {
                    Files.copy((File)new File(defaultWorkPath, fs), (File)wf);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        this.log.config("Work Path:    " + this.workPath.toString());
        this.dictionariesPath = this.getDataPath("dictionaries", "DATA/DICTIONARIES");
        this.log.config("Dictionaries Path:" + this.dictionariesPath.toString());
        if (!this.dictionariesPath.exists()) {
            this.dictionariesPath.mkdirs();
        }
        this.classificationPath = this.getDataPath("classification", "DATA/CLASSIFICATION");
        this.log.config("Classification Path:" + this.classificationPath.toString());
        if (!this.classificationPath.exists()) {
            this.classificationPath.mkdirs();
        }
        CollectionConfiguration.UNIQUE_HEURISTIC_PREFER_HTTPS = this.getConfigBool("search.ranking.uniqueheuristic.preferhttps", false);
        CollectionConfiguration.UNIQUE_HEURISTIC_PREFER_WWWPREFIX = this.getConfigBool("search.ranking.uniqueheuristic.preferwwwprefix", true);
        this.log.config("initializing libraries");
        new Thread("LibraryProvider.initialize"){

            @Override
            public void run() {
                LibraryProvider.initialize(Switchboard.this.dictionariesPath);
                Set<String> omit = Switchboard.this.getConfigSet("search.result.show.vocabulary.omit");
                for (String o : omit) {
                    Tagging t = LibraryProvider.autotagging.getVocabulary(o);
                    if (t != null) {
                        t.setFacet(false);
                        continue;
                    }
                    Switchboard.this.log.config("search.result.show.vocabulary.omit configuration value contains an unknown vocabulary name : " + o);
                }
                Set<String> linkedDataVocs = Switchboard.this.getConfigSet("vocabularies.matchLinkedData.names");
                for (String vocName : linkedDataVocs) {
                    Tagging t = LibraryProvider.autotagging.getVocabulary(vocName);
                    if (t != null) {
                        t.setMatchFromLinkedData(true);
                        continue;
                    }
                    Switchboard.this.log.config("vocabularies.matchLinkedData.names configuration value contains an unknown vocabulary name : " + vocName);
                }
                Thread.currentThread().setName("ProbabilisticClassification.initialize");
                ProbabilisticClassifier.initialize(Switchboard.this.classificationPath);
            }
        }.start();
        this.log.config("Loading language profiles");
        try {
            DetectorFactory.loadProfile((String)new File(appPath, "langdetect").toString());
        }
        catch (LangDetectException e) {
            ConcurrentLog.logException(e);
        }
        Domains.init(new File(this.workPath, "globalhosts.list"));
        String sessionidNamesFile = this.getConfig("sessionidNamesFile", "defaults/sessionid.names");
        this.log.config("Loading sessionid file " + sessionidNamesFile);
        MultiProtocolURL.initSessionIDNames(FileUtils.loadList(new File(this.getAppPath(), sessionidNamesFile)));
        this.tables = new WorkTables(this.workPath);
        int wordCacheMaxCount = (int)this.getConfigLong("wordCacheMaxCount", 20000L);
        this.setConfig("wordCacheMaxCount", Integer.toString(wordCacheMaxCount));
        this.initOutgoingConnectionSettings();
        this.initOutgoingConnectionPools();
        try {
            this.overwriteNetworkDefinition(this.getSysinfo());
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        ClientIdentification.generateCustomBot(this.getConfig("crawler.userAgent.name", ""), this.getConfig("crawler.userAgent.string", ""), (int)this.getConfigLong("crawler.userAgent.minimumdelta", 500L), (int)this.getConfigLong("crawler.userAgent.clienttimeout", 1000L));
        this.log.config("Starting Indexing Management");
        String networkName = this.getConfig("network.unit.name", "");
        long fileSizeMax = OS.isWindows ? this.getConfigLong("filesize.max.win", Integer.MAX_VALUE) : this.getConfigLong("filesize.max.other", Integer.MAX_VALUE);
        int redundancy = (int)this.getConfigLong("network.unit.dhtredundancy.senior", 1L);
        int partitionExponent = (int)this.getConfigLong("network.unit.dht.partitionExponent", 0L);
        this.networkRoot = new File(new File(indexPath, networkName), "NETWORK");
        this.queuesRoot = new File(new File(indexPath, networkName), "QUEUES");
        this.networkRoot.mkdirs();
        this.queuesRoot.mkdirs();
        File solrCollectionConfigurationInitFile = new File(this.getAppPath(), "defaults/solr.collection.schema");
        File solrCollectionConfigurationWorkFile = new File(this.getDataPath(), "DATA/SETTINGS/solr.collection.schema");
        File solrWebgraphConfigurationInitFile = new File(this.getAppPath(), "defaults/solr.webgraph.schema");
        File solrWebgraphConfigurationWorkFile = new File(this.getDataPath(), "DATA/SETTINGS/solr.webgraph.schema");
        CollectionConfiguration solrCollectionConfigurationWork = null;
        WebgraphConfiguration solrWebgraphConfigurationWork = null;
        File solrCollectionConfigurationWorkOldFile = new File(this.getDataPath(), "DATA/SETTINGS/solr.keys.default.list");
        if (solrCollectionConfigurationWorkOldFile.exists() && !solrCollectionConfigurationWorkFile.exists()) {
            solrCollectionConfigurationWorkOldFile.renameTo(solrCollectionConfigurationWorkFile);
        }
        if (!solrCollectionConfigurationWorkFile.exists()) {
            try {
                Files.copy((File)solrCollectionConfigurationInitFile, (File)solrCollectionConfigurationWorkFile);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        boolean solrlazy = this.getConfigBool("federated.service.solr.indexing.lazy", true);
        try {
            CollectionConfiguration solrCollectionConfigurationInit = new CollectionConfiguration(solrCollectionConfigurationInitFile, solrlazy);
            solrCollectionConfigurationWork = new CollectionConfiguration(solrCollectionConfigurationWorkFile, solrlazy);
            solrCollectionConfigurationWork.fill(solrCollectionConfigurationInit, true);
            solrCollectionConfigurationWork.commit();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        if (!solrWebgraphConfigurationWorkFile.exists()) {
            try {
                Files.copy((File)solrWebgraphConfigurationInitFile, (File)solrWebgraphConfigurationWorkFile);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        try {
            WebgraphConfiguration solrWebgraphConfigurationInit = new WebgraphConfiguration(solrWebgraphConfigurationInitFile, solrlazy);
            solrWebgraphConfigurationWork = new WebgraphConfiguration(solrWebgraphConfigurationWorkFile, solrlazy);
            solrWebgraphConfigurationWork.fill(solrWebgraphConfigurationInit, true);
            solrWebgraphConfigurationWork.commit();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        if (this.firstInit) {
            float numberOfCores2 = 2.0f * (float)Runtime.getRuntime().availableProcessors();
            sb.setConfig("50_localcrawl_loadprereq", numberOfCores2);
            sb.setConfig("70_packs_loadprereq", numberOfCores2);
        }
        Ranking.setMinTokenLen(this.getConfigInt("search.ranking.solr.doubledetection.minlength", 3));
        Ranking.setQuantRate(this.getConfigFloat("search.ranking.solr.doubledetection.quantrate", 0.5f));
        for (int i = 0; i <= 3; ++i) {
            Ranking r = solrCollectionConfigurationWork.getRanking(i);
            String name = this.getConfig("search.ranking.solr.collection.boostname.tmpa." + i, "_dummy" + i);
            String boosts = this.getConfig("search.ranking.solr.collection.boostfields.tmpa." + i, "text_t^1.0");
            String fq = this.getConfig("search.ranking.solr.collection.filterquery.tmpa." + i, "");
            String bq = this.getConfig("search.ranking.solr.collection.boostquery.tmpa." + i, "");
            String bf = this.getConfig("search.ranking.solr.collection.boostfunction.tmpb." + i, "");
            if (bf.equals("product(recip(rord(last_modified),1,1000,1000),div(product(log(product(references_external_i,references_exthosts_i)),div(references_internal_i,host_extent_i)),add(crawldepth_i,1)))") || bf.equals("scale(cr_host_norm_i,1,20)")) {
                bf = "";
            }
            if (bf.equals("recip(rord(last_modified),1,1000,1000)")) {
                bf = "recip(ms(NOW,last_modified),3.16e-11,1,1)";
            }
            if (i == 0 && bq.equals("fuzzy_signature_unique_b:true^100000.0")) {
                bq = "crawldepth_i:0^0.8 crawldepth_i:1^0.4";
            }
            if (bq.equals("crawldepth_i:0^0.8 crawldepth_i:1^0.4")) {
                bq = "crawldepth_i:0^0.8\ncrawldepth_i:1^0.4";
            }
            if (boosts.equals("url_paths_sxt^1000.0,synonyms_sxt^1.0,title^10000.0,text_t^2.0,h1_txt^1000.0,h2_txt^100.0,host_organization_s^100000.0")) {
                boosts = "url_paths_sxt^3.0,synonyms_sxt^0.5,title^5.0,text_t^1.0,host_s^6.0,h1_txt^5.0,url_file_name_tokens_t^4.0,h2_txt^2.0";
            }
            r.setName(name);
            r.updateBoosts(boosts);
            r.setFilterQuery(fq);
            r.setBoostQuery(bq);
            r.setBoostFunction(bf);
        }
        ReferenceContainer.maxReferences = this.getConfigInt("index.maxReferences", 0);
        File segmentsPath = new File(new File(indexPath, networkName), "SEGMENTS");
        try {
            this.index = new Segment(this.log, segmentsPath, archivePath, solrCollectionConfigurationWork, solrWebgraphConfigurationWork);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        if (this.getConfigBool("core.service.rwi.tmp", true)) {
            try {
                this.index.connectRWI(wordCacheMaxCount, fileSizeMax);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (this.getConfigBool("core.service.citation.tmp", true)) {
            try {
                this.index.connectCitation(wordCacheMaxCount, fileSizeMax);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (this.getConfigBool("core.service.fulltext", true)) {
            try {
                this.index.fulltext().connectLocalSolr();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        this.index.fulltext().setUseWebgraph(this.getConfigBool("core.service.webgraph.tmp", false));
        String solrurls = this.getConfig("federated.service.solr.indexing.url", "http://127.0.0.1:8983/solr");
        boolean usesolr = this.getConfigBool("federated.service.solr.indexing.enabled", false) & solrurls.length() > 0;
        int solrtimeout = this.getConfigInt("federated.service.solr.indexing.timeout", 60000);
        boolean writeEnabled = this.getConfigBool("federated.service.solr.indexing.writeEnabled", true);
        boolean trustSelfSignedOnAuthenticatedServer = Switchboard.getSwitchboard().getConfigBool("federated.service.solr.indexing.authenticated.allowSelfSigned", false);
        if (usesolr && solrurls != null && solrurls.length() > 0) {
            try {
                ArrayList<RemoteInstance> instances = RemoteInstance.getShardInstances(solrurls, null, null, solrtimeout, trustSelfSignedOnAuthenticatedServer);
                String shardMethodName = this.getConfig("federated.service.solr.indexing.sharding", ShardSelection.Method.MODULO_HOST_MD5.name());
                ShardSelection.Method shardMethod = ShardSelection.Method.valueOf(shardMethodName);
                this.index.fulltext().connectRemoteSolr(instances, shardMethod, writeEnabled);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        File mySeedFile = new File(this.networkRoot, "mySeed.txt");
        this.peers = new SeedDB(this.networkRoot, "seed.new.heap", "seed.old.heap", "seed.pot.heap", mySeedFile, redundancy, partitionExponent, false, this.exceed134217727);
        String agent = this.getConfig("network.unit.agent", "");
        if (!agent.isEmpty()) {
            this.peers.setMyName(agent);
        }
        this.localcluster_scan = Collections.newSetFromMap(new ConcurrentHashMap());
        if (this.getConfigBool("scan.enabled", false)) {
            new OneTimeBusyThread("Switchboard.scanForOtherYaCyInIntranet"){

                @Override
                public boolean jobImpl() throws Exception {
                    Switchboard.this.localcluster_scan.addAll(Scanner.scanForOtherYaCyInIntranet());
                    return true;
                }
            }.start();
        }
        try {
            this.domainList = null;
            if (!this.getConfig("network.unit.domainlist", "").equals("")) {
                Reader r = this.getConfigFileFromWebOrLocally(this.getConfig("network.unit.domainlist", ""), this.getAppPath().getAbsolutePath(), new File(this.networkRoot, "domainlist.txt"));
                this.domainList = new FilterEngine();
                BufferedReader br = new BufferedReader(r);
                this.domainList.loadList(br, null);
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            this.log.severe("CONFIG: domainlist not found: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.severe("CONFIG: error while retrieving domainlist: " + e.getMessage());
        }
        this.crawler = new CrawlSwitchboard(this);
        this.log.config("Starting YaCy Protocol Core");
        this.yc = new Network(this);
        new OneTimeBusyThread("Switchboard.loadSeedLists"){

            @Override
            public boolean jobImpl() throws Exception {
                Switchboard.this.loadSeedLists();
                return true;
            }
        }.start();
        this.dhtDispatcher = this.peers.sizeConnected() == 0 ? null : new Dispatcher(this, true, 10000);
        this.robotstxtConfig = RobotsTxtConfig.init(this);
        this.proxyLastAccess = System.currentTimeMillis() - 10000L;
        this.localSearchLastAccess = System.currentTimeMillis() - 10000L;
        this.remoteSearchLastAccess = System.currentTimeMillis() - 10000L;
        this.adminAuthenticationLastAccess = 0L;
        this.optimizeLastRun = System.currentTimeMillis();
        this.webStructure = new WebStructureGraph(new File(this.queuesRoot, "webStructure.map"));
        if (!this.listsPath.exists()) {
            this.listsPath.mkdirs();
        }
        if (blueList == null) {
            String f = this.getConfig("plasmaBlueList", SwitchboardConstants.LIST_BLUE_DEFAULT);
            File plasmaBlueListFile = new File(f);
            blueList = f != null ? SetTools.loadList(plasmaBlueListFile, NaturalOrder.naturalComparator) : new TreeSet<String>();
            this.log.config("loaded blue-list from file " + plasmaBlueListFile.getName() + ", " + blueList.size() + " entries, " + Switchboard.ppRamString(plasmaBlueListFile.length() / 1024L));
        }
        this.log.config("Loading blacklist ...");
        File blacklistsPath = this.getDataPath("listsPath", "DATA/LISTS");
        urlBlacklist = new Blacklist(blacklistsPath);
        ListManager.switchboard = this;
        ListManager.listsPath = blacklistsPath;
        ListManager.reloadBlacklists();
        String lng = this.getConfig("locale.language", "en");
        if (!"browser".equals(lng) && !"default".equals(lng)) {
            Locale.setDefault(Locale.forLanguageTag(lng));
        } else {
            lng = "en";
        }
        if (badwords == null || badwords.isEmpty()) {
            File badwordsFile = new File(appPath, "DATA/SETTINGS/yacy.badwords");
            if (!badwordsFile.exists()) {
                badwordsFile = new File(appPath, "defaults/yacy.badwords");
            }
            badwords = SetTools.loadList(badwordsFile, NaturalOrder.naturalComparator);
            this.log.config("loaded badwords from file " + badwordsFile.getName() + ", " + badwords.size() + " entries, " + Switchboard.ppRamString(badwordsFile.length() / 1024L));
        }
        if (stopwords == null || stopwords.isEmpty()) {
            File stopwordsFile = new File(dataPath, "DATA/SETTINGS/yacy.stopwords");
            if (!stopwordsFile.exists()) {
                stopwordsFile = new File(appPath, "defaults/yacy.stopwords");
            }
            stopwords = SetTools.loadList(stopwordsFile, NaturalOrder.naturalComparator);
            File stopwordsFilelocale = new File(dataPath, "DATA/SETTINGS/" + stopwordsFile.getName() + "." + lng);
            if (!stopwordsFilelocale.exists()) {
                stopwordsFilelocale = new File(appPath, "defaults/" + stopwordsFile.getName() + "." + lng);
            }
            if (stopwordsFilelocale.exists()) {
                stopwords.addAll(SetTools.loadList(stopwordsFilelocale, NaturalOrder.naturalComparator));
                this.log.config("append stopwords from file " + stopwordsFilelocale.getName());
            } else {
                stopwordsFilelocale = new File(appPath, "defaults/solr/lang/stopwords_" + lng + ".txt");
                if (stopwordsFilelocale.exists()) {
                    stopwords.addAll(SetTools.loadList(stopwordsFilelocale, NaturalOrder.naturalComparator));
                    this.log.config("append stopwords from file " + stopwordsFilelocale.getName());
                }
            }
        }
        this.log.config("Starting HT Cache Manager");
        this.htCachePath = this.getDataPath("proxyCache", "DATA/HTCACHE");
        this.log.info("HTCACHE Path = " + this.htCachePath.getAbsolutePath());
        long maxCacheSize = 0x100000L * Long.parseLong(this.getConfig("proxyCacheSize", "2"));
        Cache.init(this.htCachePath, this.peers.mySeed().hash, maxCacheSize, this.getConfigLong("proxyCache.sync.lockTimeout", 2000L), this.getConfigInt("proxyCache.compressionLevel", 9));
        File transactiondir = new File(this.htCachePath, "snapshots");
        Transactions.init(transactiondir, this.getConfigLong("snapshots.wkhtmltopdf.timeout", 30L));
        this.packsHoldPath = this.getDataPath("packs.hold", "DATA/PACKS/hold");
        this.packsHoldPath.mkdirs();
        this.log.info("packs.hold Path = " + this.packsHoldPath.getAbsolutePath());
        this.packsLivePath = this.getDataPath("packs.live", "DATA/PACKS/live");
        this.packsLivePath.mkdirs();
        this.log.info("packs.live Path = " + this.packsLivePath.getAbsolutePath());
        this.packsLoadPath = this.getDataPath("packs.load", "DATA/PACKS/load");
        this.packsLoadPath.mkdirs();
        this.log.info("packs.load Path = " + this.packsLoadPath.getAbsolutePath());
        this.packsLoadedPath = this.getDataPath("packs.loaded", "DATA/PACKS/loaded");
        this.packsLoadedPath.mkdirs();
        this.log.info("packs.loaded Path = " + this.packsLoadedPath.getAbsolutePath());
        this.packsUnloadPath = this.getDataPath("packs.unload", "DATA/PACKS/unload");
        this.packsUnloadPath.mkdirs();
        this.log.info("packs.unload Path = " + this.packsUnloadPath.getAbsolutePath());
        File osdConfig = new File(this.getDataPath(), "DATA/SETTINGS/heuristicopensearch.conf");
        if (!osdConfig.exists()) {
            File osdDefaultConfig = new File(appPath, "defaults/heuristicopensearch.conf");
            this.log.info("heuristic.opensearch list Path = " + osdDefaultConfig.getAbsolutePath());
            try {
                Files.copy((File)osdDefaultConfig, (File)osdConfig);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.releasePath = this.getDataPath("releases", "DATA/RELEASE");
        this.releasePath.mkdirs();
        this.log.info("RELEASE Path = " + this.releasePath.getAbsolutePath());
        try {
            this.initMessages();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        try {
            this.initWiki();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        try {
            this.initBlog();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        this.log.config("Loading User DB");
        File userDbFile = new File(this.getDataPath(), "DATA/SETTINGS/user.heap");
        try {
            this.userDB = new UserDB(userDbFile);
            this.log.config("Loaded User DB from file " + userDbFile.getName() + ", " + this.userDB.size() + " entries, " + Switchboard.ppRamString(userDbFile.length() / 1024L));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        File parserPropertiesPath = new File(appPath, "defaults/");
        for (String l : settingsList = parserPropertiesPath.list()) {
            if (!l.startsWith("parser.") || !l.endsWith(".properties")) continue;
            try {
                Evaluation.add(new File(parserPropertiesPath, l));
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        parserPropertiesPath = new File(this.getDataPath(), "DATA/SETTINGS/");
        for (String l : settingsList = parserPropertiesPath.list()) {
            if (!l.startsWith("parser.") || !l.endsWith(".properties")) continue;
            try {
                Evaluation.add(new File(parserPropertiesPath, l));
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        new Thread("Switchboard.initBookmarks"){

            @Override
            public void run() {
                try {
                    Switchboard.this.initBookmarks();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }.start();
        this.log.config("Parser: Initializing Mime Type deny list");
        boolean enableAudioTags = this.getConfigBool("parser.enableAudioTags", false);
        this.log.config("Parser: parser.enableAudioTags= " + enableAudioTags);
        Set<String> denyExt = this.getConfigSet("parser.extensions.deny");
        Set<String> denyMime = this.getConfigSet("parser.mime.deny");
        if (!enableAudioTags) {
            denyExt.addAll(audioTagParser.SupportedAudioFormat.getAllFileExtensions());
            denyMime.addAll(audioTagParser.SupportedAudioFormat.getAllMediaTypes());
            this.setConfig("parser.extensions.deny", denyExt);
            this.setConfig("parser.mime.deny", denyMime);
            this.setConfig("parser.enableAudioTags", true);
        }
        TextParser.setDenyMime(this.getConfig("parser.mime.deny", ""));
        TextParser.setDenyExtension(this.getConfig("parser.extensions.deny", ""));
        this.log.config("Starting Crawl Loader");
        this.loader = new LoaderDispatcher(this);
        new Thread("yacy.importDonationIFrame"){

            @Override
            public void run() {
                ClientIdentification.Agent agent = ClientIdentification.getAgent("YaCy Internet (cautious)");
                try {
                    Response documentResponse = Switchboard.this.loader.load(Switchboard.this.loader.request(new DigestURL(Switchboard.this.getConfig("donation.iframesource", "")), false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, agent);
                    if (documentResponse != null) {
                        FileUtils.copy(documentResponse.getContent(), new File(Switchboard.this.htDocsPath, Switchboard.this.getConfig("donation.iframetarget", "")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        Map<String, File> oaiFriends = OAIListFriendsLoader.loadListFriendsSources(new File(appPath, "defaults/oaiListFriendsSource.xml"), this.getDataPath());
        OAIListFriendsLoader.init(this.loader, oaiFriends, ClientIdentification.yacyInternetCrawlerAgent);
        this.log.config("Initializing robots.txt DB");
        this.robots = new RobotsTxt(this.tables, this.loader, this.getConfigInt("robots.txt.MaxActiveThreads", 200));
        try {
            this.log.config("Loaded robots.txt DB: " + this.robots.size() + " entries");
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        this.crawlQueues = new CrawlQueues(this, this.queuesRoot);
        this.setConfig("50_localcrawl_isPaused", "false");
        this.setConfig("50_localcrawl_isPaused_cause", "");
        this.setConfig("62_remotetriggeredcrawl_isPaused", "false");
        this.setConfig("62_remotetriggeredcrawl_isPaused_cause", "");
        this.setConfig("60_remotecrawlloader_isPaused", "false");
        this.setConfig("60_remotecrawlloader_isPaused_cause", "");
        this.crawlJobsStatus.put("50_localcrawl", new Object[]{new Object(), false});
        this.crawlJobsStatus.put("62_remotetriggeredcrawl", new Object[]{new Object(), false});
        this.crawlJobsStatus.put("60_remotecrawlloader", new Object[]{new Object(), false});
        this.log.config("Starting Cookie Monitor");
        this.outgoingCookies = new ConcurrentHashMap<String, Object[]>();
        this.incomingCookies = new ConcurrentHashMap<String, Object[]>();
        this.localSearchTracker = new ConcurrentHashMap();
        this.remoteSearchTracker = new ConcurrentHashMap();
        File notifierSource = new File(this.htRootPath.getAbsolutePath() + "/env/grafics/empty.gif");
        File notifierDest = new File(this.htDocsPath, "notifier.gif");
        try {
            Files.copy((File)notifierSource, (File)notifierDest);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Domains.setNoCachingPatterns(this.getConfig("httpc.nameCacheNoCachingPatterns", ""));
        }
        catch (PatternSyntaxException pse) {
            ConcurrentLog.severe("Switchboard", "Invalid regular expression in httpc.nameCacheNoCachingPatterns property: " + pse.getMessage());
            System.exit(-1);
        }
        this.log.config("Initializing Snippet Cache");
        TextSnippet.statistics.setEnabled(this.getConfigBool("debug.snippets.statistics.enabled", false));
        wikiParser = new WikiCode();
        final ResourceObserver resourceObserver = this.observer = new ResourceObserver(this);
        new OneTimeBusyThread("ResourceObserver.resourceObserverJob"){

            @Override
            public boolean jobImpl() throws Exception {
                resourceObserver.resourceObserverJob();
                return true;
            }
        }.start();
        this.crawlStacker = new CrawlStacker(this.robots, this.crawlQueues, this.crawler, this.index, this.peers, this.isIntranetMode(), this.isGlobalMode(), this.domainList);
        Domains.setNoLocalCheck(this.isAllIPMode());
        if (!this.getConfigBool("adminAccountForLocalhost", false) && this.getConfig("adminAccountBase64MD5", "").startsWith("0000")) {
            this.setConfig("adminAccountBase64MD5", "");
            this.log.info("RANDOM PASSWORD REMOVED! User must set a new password");
        }
        this.dhtMaxReferenceCount = (int)this.getConfigLong("indexDistribution.startChunkSize", 50L);
        this.clusterhashes = this.peers.clusterHashes(this.getConfig("cluster.peers.yacydomain", ""));
        this.indexingStorageProcessor = new WorkflowProcessor<IndexingQueueEntry>("storeDocumentIndex", "This is the sequencing step of the indexing queue. Files are written as streams, too much councurrency would destroy IO performance. In this process the words are written to the RWI cache, which flushes if it is full.", new String[]{"RWI/Cache/Collections"}, in -> {
            this.storeDocumentIndex((IndexingQueueEntry)in);
            return null;
        }, 2, null, 1);
        this.indexingAnalysisProcessor = new WorkflowProcessor<IndexingQueueEntry>("webStructureAnalysis", "This just stores the link structure of the document into a web structure database.", new String[]{"storeDocumentIndex"}, this::webStructureAnalysis, WorkflowProcessor.availableCPU + 1, this.indexingStorageProcessor, WorkflowProcessor.availableCPU);
        this.indexingCondensementProcessor = new WorkflowProcessor<IndexingQueueEntry>("condenseDocument", "This does a structural analysis of plain texts: markup of headlines, slicing into phrases (i.e. sentences), markup with position, counting of words, calculation of term frequency.", new String[]{"webStructureAnalysis"}, this::condenseDocument, WorkflowProcessor.availableCPU + 1, this.indexingAnalysisProcessor, WorkflowProcessor.availableCPU);
        this.indexingDocumentProcessor = new WorkflowProcessor<IndexingQueueEntry>("parseDocument", "This does the parsing of the newly loaded documents from the web. The result is not only a plain text document, but also a list of URLs that are embedded into the document. The urls are handed over to the CrawlStacker. This process has two child process queues!", new String[]{"condenseDocument", "CrawlStacker"}, this::parseDocument, Math.max(20, WorkflowProcessor.availableCPU * 2), this.indexingCondensementProcessor, WorkflowProcessor.availableCPU);
        this.log.config("Starting Threads");
        MemoryControl.gc(10000, "plasmaSwitchboard, help for profiler");
        this.deployThread("90_cleanup", "Cleanup", "cleaning process", null, new InstantBusyThread("Switchboard.cleanupJob", 30000L, 10000L){

            @Override
            public boolean jobImpl() throws Exception {
                return Switchboard.this.cleanupJob();
            }

            @Override
            public int getJobCount() {
                return Switchboard.this.cleanupJobSize();
            }

            @Override
            public void freememImpl() {
            }
        }, 60000L);
        this.deployThread("85_scheduler", "Scheduler", "starts scheduled processes from the API Processing table", null, new InstantBusyThread("Switchboard.schedulerJob", 30000L, 10000L){

            @Override
            public boolean jobImpl() throws Exception {
                return Switchboard.this.schedulerJob();
            }

            @Override
            public int getJobCount() {
                return Switchboard.this.schedulerJobSize();
            }

            @Override
            public void freememImpl() {
            }
        }, 60000L);
        this.deployThread("70_packs", "Packs", "A thread that polls the PACKS path and puts all Documents in one surroagte file into the indexing queue.", null, new InstantBusyThread("Switchboard.packProcess", 20000L, 0L){

            @Override
            public boolean jobImpl() throws Exception {
                return Switchboard.this.packProcess();
            }

            @Override
            public int getJobCount() {
                return Switchboard.this.packsInLoad().size();
            }

            @Override
            public void freememImpl() {
            }
        }, 10000L);
        this.initRemoteCrawler(this.getConfigBool("crawlResponse", false));
        this.initAutocrawl(this.getConfigBool("autocrawl", false));
        final CrawlQueues crawlQueue = this.crawlQueues;
        this.deployThread("50_localcrawl", "Local Crawl", "thread that performes a single crawl step from the local crawl queue", "/IndexCreateQueues_p.html?stack=LOCAL", new InstantBusyThread("CrawlQueues.coreCrawlJob", 0L, 0L){

            @Override
            public boolean jobImpl() throws Exception {
                return crawlQueue.coreCrawlJob();
            }

            @Override
            public int getJobCount() {
                return crawlQueue.coreCrawlJobSize();
            }

            @Override
            public void freememImpl() {
                crawlQueue.freemem();
            }
        }, 10000L);
        final Network net = this.yc;
        this.deployThread("40_peerseedcycle", "Seed-List Upload", "task that a principal peer performes to generate and upload a seed-list to a ftp account", null, new InstantBusyThread("Network.publishSeedList", 600000L, 300000L){

            @Override
            public boolean jobImpl() throws Exception {
                net.publishSeedList();
                return true;
            }
        }, 180000L);
        this.deployThread("30_peerping", "YaCy Core", "this is the p2p-control and peer-ping task", null, new InstantBusyThread("Network.peerPing", 30000L, 30000L){

            @Override
            public boolean jobImpl() throws Exception {
                net.peerPing();
                return true;
            }
        }, 10000L);
        this.deployThread("20_dhtdistribution", "DHT Distribution", "selection, transfer and deletion of index entries that are not searched on your peer, but on others", null, new InstantBusyThread("Switchboard.dhtTransferJob", 10000L, 1000L){

            @Override
            public boolean jobImpl() throws Exception {
                return Switchboard.this.dhtTransferJob();
            }
        }, 60000L, Long.parseLong(this.getConfig("20_dhtdistribution_idlesleep", "5000")), Long.parseLong(this.getConfig("20_dhtdistribution_busysleep", "0")), Long.parseLong(this.getConfig("20_dhtdistribution_memprereq", "1000000")), Double.parseDouble(this.getConfig("20_dhtdistribution_loadprereq", "9.0")));
        if (this.firstInit) {
            this.setRemotecrawlPPM(Math.max(1, (int)this.getConfigLong("network.unit.remotecrawl.speed", 60L)));
        }
        this.trail = new LinkedBlockingQueue();
        this.log.config("Finished Switchboard Initialization");
    }

    public void initOutgoingConnectionSettings() {
        String systemEnableSniExt = System.getProperty("jsse.enableSNIExtension");
        if (systemEnableSniExt == null) {
            HTTPClient.ENABLE_SNI_EXTENSION.set(this.getConfigBool("http.outgoing.general.tls.sniExtension.enabled", true));
            RemoteInstance.ENABLE_SNI_EXTENSION.set(this.getConfigBool("http.outgoing.remoteSolr.tls.sniExtension.enabled", true));
        }
    }

    private void initOutgoingConnectionPools() {
        int generalPoolMaxTotal = this.getConfigInt("http.outgoing.pool.general.maxTotal", 200);
        if (generalPoolMaxTotal <= 0) {
            generalPoolMaxTotal = 200;
            this.setConfig("http.outgoing.pool.general.maxTotal", generalPoolMaxTotal);
        }
        HTTPClient.initPoolMaxConnections(HTTPClient.CONNECTION_MANAGER, generalPoolMaxTotal);
        int remoteSolrPoolMaxTotal = this.getConfigInt("http.outgoing.pool.remoteSolr.maxTotal", 100);
        if (remoteSolrPoolMaxTotal <= 0) {
            remoteSolrPoolMaxTotal = 100;
            this.setConfig("http.outgoing.pool.remoteSolr.maxTotal", remoteSolrPoolMaxTotal);
        }
        RemoteInstance.initPoolMaxConnections(RemoteInstance.CONNECTION_MANAGER, remoteSolrPoolMaxTotal);
    }

    final String getSysinfo() {
        return this.getConfig("network.unit.name", "") + (this.isRobinsonMode() ? "-" : "/") + this.getConfig("network.unit.domain", "global");
    }

    @Override
    public void setHttpServer(YaCyHttpServer server) {
        super.setHttpServer(server);
        new Thread("Switchboard.setHttpServer"){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Switchboard.this.schedulerJob();
            }
        }.start();
    }

    public int getIndexingProcessorsQueueSize() {
        return this.indexingDocumentProcessor.getQueueSize() + this.indexingCondensementProcessor.getQueueSize() + this.indexingAnalysisProcessor.getQueueSize() + this.indexingStorageProcessor.getQueueSize();
    }

    public void overwriteNetworkDefinition(String sysinfo) throws FileNotFoundException, IOException {
        String networkUnitDefinition = this.getConfig("network.unit.definition", "defaults/yacy.network.freeworld.unit");
        if (networkUnitDefinition.isEmpty()) {
            networkUnitDefinition = "defaults/yacy.network.freeworld.unit";
        }
        if (networkUnitDefinition.equals("yacy.network.unit")) {
            networkUnitDefinition = "defaults/yacy.network.freeworld.unit";
            this.setConfig("network.unit.definition", networkUnitDefinition);
        }
        Iterator<String> ki = this.configKeys();
        ArrayList<String> d = new ArrayList<String>();
        while (ki.hasNext()) {
            String k = ki.next();
            if (!k.startsWith("network.unit.update.location") && !k.startsWith("network.unit.bootstrap")) continue;
            d.add(k);
        }
        for (String s : d) {
            this.removeConfig(s);
        }
        Reader netDefReader = this.getConfigFileFromWebOrLocally(networkUnitDefinition, this.getAppPath().getAbsolutePath(), new File(this.workPath, "network.definition.backup"));
        ConcurrentHashMap<String, String> initProps = FileUtils.table(netDefReader);
        this.setConfig(initProps);
        int i = 0;
        try {
            String location;
            CryptoLib cryptoLib = new CryptoLib();
            while (!(location = this.getConfig("network.unit.update.location" + i, "")).isEmpty()) {
                DigestURL locationURL;
                try {
                    locationURL = new DigestURL(location);
                }
                catch (MalformedURLException e) {
                    break;
                }
                PublicKey publicKey = null;
                try {
                    String publicKeyString = this.getConfig("network.unit.update.location" + i + ".key", null);
                    if (publicKeyString != null) {
                        byte[] publicKeyBytes = Base64Order.standardCoder.decode(publicKeyString.trim());
                        publicKey = cryptoLib.getPublicKeyFromBytes(publicKeyBytes);
                    }
                }
                catch (InvalidKeySpecException e) {
                    ConcurrentLog.logException(e);
                }
                yacyUpdateLocation updateLocation = new yacyUpdateLocation(locationURL, publicKey);
                yacyRelease.latestReleaseLocations.add(updateLocation);
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e1) {
            ConcurrentLog.logException(e1);
        }
        this.networkWhitelist = Domains.makePatterns(this.getConfig("network.unit.access.whitelist", ""));
        this.networkBlacklist = Domains.makePatterns(this.getConfig("network.unit.access.blacklist", ""));
        ClientIdentification.generateYaCyBot(sysinfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchNetwork(String networkDefinition) throws FileNotFoundException, IOException {
        boolean rcp;
        this.log.info("SWITCH NETWORK: switching to '" + networkDefinition + "'");
        boolean lcp = this.crawlJobIsPaused("50_localcrawl");
        if (!lcp) {
            this.pauseCrawlJob("50_localcrawl", "network switch to " + networkDefinition);
        }
        if (!(rcp = this.crawlJobIsPaused("62_remotetriggeredcrawl"))) {
            this.pauseCrawlJob("62_remotetriggeredcrawl", "network switch to " + networkDefinition);
        }
        this.proxyLastAccess = System.currentTimeMillis() + 3000L;
        this.log.info("SWITCH NETWORK: SHUT DOWN OF OLD INDEX DATABASE...");
        SearchEventCache.cleanupEvents(true);
        Switchboard switchboard = this;
        synchronized (switchboard) {
            CollectionConfiguration collectionConfiguration = this.index.fulltext().getDefaultConfiguration();
            WebgraphConfiguration webgraphConfiguration = this.index.fulltext().getWebgraphConfiguration();
            this.crawler.close();
            if (this.dhtDispatcher != null) {
                this.dhtDispatcher.close();
            }
            this.crawlStacker.announceClose();
            this.crawlStacker.close();
            this.index.close();
            this.webStructure.close();
            this.log.info("SWITCH NETWORK: START UP OF NEW INDEX DATABASE...");
            this.setConfig("network.unit.definition", networkDefinition);
            this.overwriteNetworkDefinition(this.getSysinfo());
            File indexPrimaryPath = this.getDataPath("indexPrimaryPath", "DATA/INDEX");
            int wordCacheMaxCount = (int)this.getConfigLong("wordCacheMaxCount", 20000L);
            long fileSizeMax = OS.isWindows ? this.getConfigLong("filesize.max.win", Integer.MAX_VALUE) : this.getConfigLong("filesize.max.other", Integer.MAX_VALUE);
            int redundancy = (int)this.getConfigLong("network.unit.dhtredundancy.senior", 1L);
            int partitionExponent = (int)this.getConfigLong("network.unit.dht.partitionExponent", 0L);
            String networkName = this.getConfig("network.unit.name", "");
            this.networkRoot = new File(new File(indexPrimaryPath, networkName), "NETWORK");
            this.queuesRoot = new File(new File(indexPrimaryPath, networkName), "QUEUES");
            this.networkRoot.mkdirs();
            this.queuesRoot.mkdirs();
            ResultURLs.clearStacks();
            this.setConfig("heuristic.site", false);
            this.setConfig("heuristic.opensearch", false);
            this.peers.relocate(this.networkRoot, redundancy, partitionExponent, this.useTailCache, this.exceed134217727);
            File segmentsPath = new File(new File(indexPrimaryPath, networkName), "SEGMENTS");
            File archivePath = this.getDataPath("indexArchivePath", "DATA/ARCHIVE");
            this.index = new Segment(this.log, segmentsPath, archivePath, collectionConfiguration, webgraphConfiguration);
            if (this.getConfigBool("core.service.rwi.tmp", true)) {
                this.index.connectRWI(wordCacheMaxCount, fileSizeMax);
            }
            if (this.getConfigBool("core.service.citation.tmp", true)) {
                this.index.connectCitation(wordCacheMaxCount, fileSizeMax);
            }
            if (this.getConfigBool("core.service.fulltext", true)) {
                this.index.fulltext().connectLocalSolr();
            }
            this.index.fulltext().setUseWebgraph(this.getConfigBool("core.service.webgraph.tmp", false));
            String solrurls = this.getConfig("federated.service.solr.indexing.url", "http://127.0.0.1:8983/solr");
            boolean usesolr = this.getConfigBool("federated.service.solr.indexing.enabled", false) & solrurls.length() > 0;
            int solrtimeout = this.getConfigInt("federated.service.solr.indexing.timeout", 60000);
            boolean writeEnabled = this.getConfigBool("federated.service.solr.indexing.writeEnabled", true);
            boolean trustSelfSignedOnAuthenticatedServer = Switchboard.getSwitchboard().getConfigBool("federated.service.solr.indexing.authenticated.allowSelfSigned", false);
            if (usesolr && solrurls != null && solrurls.length() > 0) {
                try {
                    ArrayList<RemoteInstance> instances = RemoteInstance.getShardInstances(solrurls, null, null, solrtimeout, trustSelfSignedOnAuthenticatedServer);
                    String shardMethodName = this.getConfig("federated.service.solr.indexing.sharding", ShardSelection.Method.MODULO_HOST_MD5.name());
                    ShardSelection.Method shardMethod = ShardSelection.Method.valueOf(shardMethodName);
                    this.index.fulltext().connectRemoteSolr(instances, shardMethod, writeEnabled);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            this.crawlQueues.relocate(this.queuesRoot);
            this.crawler = new CrawlSwitchboard(this);
            this.dhtDispatcher = this.peers.sizeConnected() == 0 ? null : new Dispatcher(this, true, 10000);
            this.webStructure = new WebStructureGraph(new File(this.queuesRoot, "webStructure.map"));
            try {
                this.domainList = null;
                if (!this.getConfig("network.unit.domainlist", "").equals("")) {
                    Reader r = this.getConfigFileFromWebOrLocally(this.getConfig("network.unit.domainlist", ""), this.getAppPath().getAbsolutePath(), new File(this.networkRoot, "domainlist.txt"));
                    this.domainList = new FilterEngine();
                    BufferedReader br = new BufferedReader(r);
                    this.domainList.loadList(br, null);
                    br.close();
                }
            }
            catch (FileNotFoundException e) {
                this.log.severe("CONFIG: domainlist not found: " + e.getMessage());
            }
            catch (IOException e) {
                this.log.severe("CONFIG: error while retrieving domainlist: " + e.getMessage());
            }
            this.crawlStacker = new CrawlStacker(this.robots, this.crawlQueues, this.crawler, this.index, this.peers, "local.any".indexOf(this.getConfig("network.unit.domain", "global")) >= 0, "global.any".indexOf(this.getConfig("network.unit.domain", "global")) >= 0, this.domainList);
        }
        Domains.setNoLocalCheck(this.isAllIPMode());
        this.continueCrawlJob("50_localcrawl");
        this.continueCrawlJob("62_remotetriggeredcrawl");
        this.log.info("SWITCH NETWORK: FINISHED START UP, new network is now '" + networkDefinition + "'.");
        this.setRemotecrawlPPM(Math.max(1, (int)this.getConfigLong("network.unit.remotecrawl.speed", 60L)));
    }

    public void setRemotecrawlPPM(int ppm) {
        long newBusySleep = Math.max(100, 60000 / ppm);
        BusyThread rct = this.getThread("62_remotetriggeredcrawl");
        this.setConfig("62_remotetriggeredcrawl_busysleep", newBusySleep);
        this.setConfig("62_remotetriggeredcrawl_idlesleep", Math.min(10000L, newBusySleep * 10L));
        if (rct != null) {
            rct.setBusySleep(this.getConfigLong("62_remotetriggeredcrawl_busysleep", 1000L));
            rct.setIdleSleep(this.getConfigLong("62_remotetriggeredcrawl_idlesleep", 10000L));
        }
        BusyThread rcl = this.getThread("60_remotecrawlloader");
        this.setConfig("60_remotecrawlloader_busysleep", newBusySleep * 4L);
        this.setConfig("60_remotecrawlloader_idlesleep", Math.min(10000L, newBusySleep * 20L));
        if (rcl != null) {
            rcl.setBusySleep(this.getConfigLong("60_remotecrawlloader_busysleep", 1000L));
            rcl.setIdleSleep(this.getConfigLong("60_remotecrawlloader_idlesleep", 10000L));
        }
    }

    public void initRemoteCrawler(boolean activate) {
        this.setConfig("crawlResponse", activate);
        this.peers.mySeed().setFlagAcceptRemoteCrawl(activate);
        if (activate) {
            this.crawlQueues.initRemoteCrawlQueues();
            final CrawlQueues queues = this.crawlQueues;
            BusyThread rct = this.getThread("62_remotetriggeredcrawl");
            if (rct == null) {
                this.deployThread("62_remotetriggeredcrawl", "Remote Crawl Job", "thread that performes a single crawl/indexing step triggered by a remote peer", "/IndexCreateQueues_p.html?stack=REMOTE", new InstantBusyThread("CrawlQueues.remoteTriggeredCrawlJob", 0L, 0L){

                    @Override
                    public boolean jobImpl() throws Exception {
                        return queues.remoteTriggeredCrawlJob();
                    }

                    @Override
                    public int getJobCount() {
                        return queues.remoteTriggeredCrawlJobSize();
                    }
                }, 10000L);
                rct = this.getThread("62_remotetriggeredcrawl");
            }
            rct.setBusySleep(this.getConfigLong("62_remotetriggeredcrawl_busysleep", 1000L));
            rct.setIdleSleep(this.getConfigLong("62_remotetriggeredcrawl_idlesleep", 10000L));
            BusyThread rcl = this.getThread("60_remotecrawlloader");
            if (rcl == null) {
                this.deployThread("60_remotecrawlloader", "Remote Crawl URL Loader", "thread that loads remote crawl lists from other peers", null, new InstantBusyThread("CrawlQueues.remoteCrawlLoaderJob", 10000L, 10000L){

                    @Override
                    public boolean jobImpl() throws Exception {
                        return queues.remoteCrawlLoaderJob();
                    }
                }, 10000L);
                rcl = this.getThread("60_remotecrawlloader");
            }
            rcl.setBusySleep(this.getConfigLong("60_remotecrawlloader_busysleep", 1000L));
            rcl.setIdleSleep(this.getConfigLong("60_remotecrawlloader_idlesleep", 10000L));
        } else {
            this.terminateThread("60_remotecrawlloader", true);
            this.terminateThread("62_remotetriggeredcrawl", true);
        }
    }

    public void initAutocrawl(boolean activate) {
        this.setConfig("autocrawl", activate);
        if (activate) {
            BusyThread acr = this.getThread("55_autocrawl");
            if (acr == null) {
                final CrawlQueues queues = this.crawlQueues;
                this.deployThread("55_autocrawl", "Autocrawl", "Thread that selects and automatically adds crawling jobs to the local queue", null, new InstantBusyThread("CrawlQueues.autocrawlJob", 10000L, 10000L){

                    @Override
                    public boolean jobImpl() throws Exception {
                        return queues.autocrawlJob();
                    }
                }, 10000L);
                acr = this.getThread("55_autocrawl");
            }
            acr.setBusySleep(this.getConfigLong("55_autocrawl_busysleep", 10000L));
            acr.setIdleSleep(this.getConfigLong("55_autocrawl_idlesleep", 10000L));
        }
    }

    public void initMessages() throws IOException {
        this.log.config("Starting Message Board");
        File messageDbFile = new File(this.workPath, "message.heap");
        this.messageDB = new MessageBoard(messageDbFile);
        this.log.config("Loaded Message Board DB from file " + messageDbFile.getName() + ", " + this.messageDB.size() + " entries, " + Switchboard.ppRamString(messageDbFile.length() / 1024L));
    }

    public void initWiki() throws IOException {
        this.log.config("Starting Wiki Board");
        File wikiDbFile = new File(this.workPath, "wiki.heap");
        this.wikiDB = new WikiBoard(wikiDbFile, new File(this.workPath, "wiki-bkp.heap"));
        this.log.config("Loaded Wiki Board DB from file " + wikiDbFile.getName() + ", " + this.wikiDB.size() + " entries, " + Switchboard.ppRamString(wikiDbFile.length() / 1024L));
    }

    public void initBlog() throws IOException {
        this.log.config("Starting Blog");
        File blogDbFile = new File(this.workPath, "blog.heap");
        this.blogDB = new BlogBoard(blogDbFile);
        this.log.config("Loaded Blog DB from file " + blogDbFile.getName() + ", " + this.blogDB.size() + " entries, " + Switchboard.ppRamString(blogDbFile.length() / 1024L));
        File blogCommentDbFile = new File(this.workPath, "blogComment.heap");
        this.blogCommentDB = new BlogBoardComments(blogCommentDbFile);
        this.log.config("Loaded Blog-Comment DB from file " + blogCommentDbFile.getName() + ", " + this.blogCommentDB.size() + " entries, " + Switchboard.ppRamString(blogCommentDbFile.length() / 1024L));
    }

    public void initBookmarks() throws IOException {
        this.log.config("Loading Bookmarks DB");
        File bookmarksFile = new File(this.workPath, "bookmarks.heap");
        File tagsFile = new File(this.workPath, "bookmarkTags.heap");
        File datesFile = new File(this.workPath, "bookmarkDates.heap");
        tagsFile.delete();
        this.bookmarksDB = new BookmarksDB(bookmarksFile, datesFile);
        this.log.config("Loaded Bookmarks DB from files " + bookmarksFile.getName() + ", " + tagsFile.getName());
        this.log.config(this.bookmarksDB.tagsSize() + " Tag, " + this.bookmarksDB.bookmarksSize() + " Bookmarks");
    }

    public static Switchboard getSwitchboard() {
        return sb;
    }

    public boolean isP2PMode() {
        return this.getConfig("network.unit.bootstrap.seedlist0", null) != null;
    }

    public boolean isIntranetMode() {
        return "local.any".indexOf(this.getConfig("network.unit.domain", "global")) >= 0;
    }

    public boolean isGlobalMode() {
        return "global.any".indexOf(this.getConfig("network.unit.domain", "global")) >= 0;
    }

    public boolean isAllIPMode() {
        return "any".indexOf(this.getConfig("network.unit.domain", "global")) >= 0;
    }

    public boolean isIPNoCheckMode() {
        return this.isAllIPMode() && this.getConfigBool("network.unit.domain.nocheck", false);
    }

    public boolean isRobinsonMode() {
        return this.peers != null && this.peers.sizeConnected() == 0 || !this.getConfigBool("allowDistributeIndex", false) && !this.getConfigBool("allowReceiveIndex", false);
    }

    public boolean isPublicRobinson() {
        String clustermode = this.getConfig("cluster.mode", "publicpeer");
        return clustermode.equals("publiccluster") || clustermode.equals("publicpeer");
    }

    public boolean isInMyCluster(String peer) {
        if (peer == null) {
            return false;
        }
        if (!this.isRobinsonMode()) {
            return false;
        }
        String clustermode = this.getConfig("cluster.mode", "publicpeer");
        if (clustermode.equals("publiccluster")) {
            return this.clusterhashes.contains(ASCII.getBytes(peer));
        }
        return false;
    }

    public boolean isInMyCluster(Seed seed) {
        if (seed == null) {
            return false;
        }
        if (!this.isRobinsonMode()) {
            return false;
        }
        String clustermode = this.getConfig("cluster.mode", "publicpeer");
        if (clustermode.equals("publiccluster")) {
            return this.clusterhashes.contains(ASCII.getBytes(seed.hash));
        }
        return false;
    }

    public HarvestProcess getHarvestProcess(String hash) {
        if (this.index.fulltext().getDefaultConnector().exists(hash)) {
            return HarvestProcess.LOADED;
        }
        HarvestProcess hp = this.crawlQueues.exists(ASCII.getBytes(hash));
        if (hp != null) {
            return hp;
        }
        return null;
    }

    public void urlRemove(Segment segment, byte[] hash) {
        segment.fulltext().remove(hash);
        ResultURLs.remove(ASCII.String(hash));
        this.crawlQueues.removeURL(hash);
    }

    public String getURL(byte[] urlhash) throws IOException {
        if (urlhash == null) {
            return null;
        }
        if (urlhash.length == 0) {
            return null;
        }
        String url = this.index.fulltext().getURL(ASCII.String(urlhash));
        if (url != null) {
            return url;
        }
        DigestURL returl = this.crawlQueues.getURL(urlhash);
        if (returl != null) {
            return returl.toNormalform(true);
        }
        return null;
    }

    public String getURL(String urlhash) throws IOException {
        if (urlhash == null) {
            return null;
        }
        if (urlhash.length() == 0) {
            return null;
        }
        String url = this.index.fulltext().getURL(urlhash);
        if (url != null) {
            return url;
        }
        DigestURL returl = this.crawlQueues.getURL(urlhash.getBytes());
        if (returl != null) {
            return returl.toNormalform(true);
        }
        return null;
    }

    public RankingProfile getRanking() {
        return this.getConfig("search.ranking.rwi.profile", "").isEmpty() ? new RankingProfile(Classification.ContentDomain.TEXT) : new RankingProfile("", crypt.simpleDecode(this.getConfig("search.ranking.rwi.profile", "")));
    }

    public String onlineCaution() {
        if (System.currentTimeMillis() - this.proxyLastAccess < (long)Integer.parseInt(this.getConfig("crawlPause.proxy", "100"))) {
            return "proxy";
        }
        if (System.currentTimeMillis() - this.localSearchLastAccess < (long)Integer.parseInt(this.getConfig("crawlPause.localsearch", "1000"))) {
            return "localsearch";
        }
        if (System.currentTimeMillis() - this.remoteSearchLastAccess < (long)Integer.parseInt(this.getConfig("crawlPause.remotesearch", "500"))) {
            return "remotesearch";
        }
        return null;
    }

    private static String ppRamString(long bytes) {
        if (bytes < 1024L) {
            return bytes + " KByte";
        }
        if ((bytes /= 1024L) < 1024L) {
            return bytes + " MByte";
        }
        if ((bytes /= 1024L) < 1024L) {
            return bytes + " GByte";
        }
        return bytes / 1024L + "TByte";
    }

    public boolean cleanProfiles() throws InterruptedException {
        if (this.getIndexingProcessorsQueueSize() > 0 || this.crawlQueues.activeWorkerEntries().size() > 0 || this.crawlQueues.coreCrawlJobSize() > 0 || this.crawlQueues.limitCrawlJobSize() > 0 || this.crawlQueues.remoteTriggeredCrawlJobSize() > 0 || this.crawlQueues.noloadCrawlJobSize() > 0 || this.crawlStacker != null && !this.crawlStacker.isEmpty() || !this.crawlQueues.noticeURL.isEmpty()) {
            return false;
        }
        return this.crawler.clear();
    }

    public synchronized void close() {
        this.log.config("SWITCHBOARD SHUTDOWN STEP 1: sending termination signal to managed threads:");
        System.out.println("SWITCHBOARD Performing shutdown steps...");
        MemoryTracker.stopSystemProfiling();
        this.terminateAllThreads(true);
        net.yacy.gui.framework.Switchboard.shutdown();
        this.log.config("SWITCHBOARD SHUTDOWN STEP 2: sending termination signal to threaded indexing");
        this.crawlStacker.announceClose();
        this.crawlStacker.close();
        this.crawlQueues.close();
        this.robots.close();
        this.indexingDocumentProcessor.shutdown();
        this.indexingCondensementProcessor.shutdown();
        this.indexingAnalysisProcessor.shutdown();
        this.indexingStorageProcessor.shutdown();
        if (this.dhtDispatcher != null) {
            this.dhtDispatcher.close();
        }
        this.wikiDB.close();
        this.blogDB.close();
        this.blogCommentDB.close();
        this.userDB.close();
        if (this.bookmarksDB != null) {
            this.bookmarksDB.close();
        }
        this.messageDB.close();
        this.webStructure.close();
        this.crawler.close();
        this.log.config("SWITCHBOARD SHUTDOWN STEP 3: sending termination signal to database manager (stand by...)");
        this.index.close();
        this.peers.close();
        Cache.close();
        this.tables.close();
        Domains.close();
        AccessTracker.dumpLog();
        urlBlacklist.close();
        ArrayStack.shutdownDeleteService();
        UPnP.deletePortMappings();
        this.tray.remove();
        try {
            HTTPClient.closeConnectionManager();
        }
        catch (InterruptedException e) {
            ConcurrentLog.logException(e);
        }
        RemoteInstance.closeConnectionManager();
        this.log.config("SWITCHBOARD SHUTDOWN TERMINATED");
        System.out.println("SWITCHBOARD Shutdown steps terminated.");
    }

    public String toIndexer(Response response) {
        assert (response != null);
        if (response == null) {
            if (this.log.isFine()) {
                this.log.fine("deQueue: queue entry is null");
            }
            return "queue entry is null";
        }
        if (response.profile() == null) {
            if (this.log.isFine()) {
                this.log.fine("deQueue: profile is null");
            }
            return "profile is null";
        }
        String noIndexReason = "unspecified indexing error";
        noIndexReason = response.processCase(this.peers.mySeed().hash) == ResultURLs.EventOrigin.PROXY_LOAD ? response.shallIndexCacheForProxy() : response.shallIndexCacheForCrawler();
        if (noIndexReason == null && !response.profile().isIndexNonParseableUrls()) {
            noIndexReason = TextParser.supports(response.url(), response.getMimeType());
        }
        if (noIndexReason == null && response.requestProhibitsIndexing()) {
            noIndexReason = "X-YACY-Index-Control header prohibits indexing";
        }
        if (noIndexReason == null) {
            noIndexReason = this.crawlStacker.urlInAcceptedDomain(response.url());
        }
        if (noIndexReason != null) {
            this.crawlQueues.errorURL.push(response.url(), response.depth(), response.profile(), FailCategory.FINAL_PROCESS_CONTEXT, noIndexReason, -1);
            return "not allowed: " + noIndexReason;
        }
        this.indexingDocumentProcessor.enQueue(new IndexingQueueEntry(response, null, null));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean processPack(String inFileName, String collectionName) {
        boolean moved;
        block118: {
            FilterInputStream is;
            File outfile;
            File infile;
            block113: {
                block114: {
                    infile = new File(this.packsLoadPath, inFileName);
                    if (!(infile.exists() && infile.canWrite() && infile.canRead())) {
                        return false;
                    }
                    outfile = new File(this.packsLoadedPath, inFileName);
                    moved = false;
                    if (inFileName.endsWith("xml.zip")) {
                        ZipInputStream zis = null;
                        try {
                            ZipEntry entry2;
                            BufferedInputStream is2 = new BufferedInputStream(new FileInputStream(infile));
                            zis = new ZipInputStream(is2);
                            while ((entry2 = zis.getNextEntry()) != null) {
                                int size;
                                byte[] buffer = new byte[2048];
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                                    baos.write(buffer, 0, size);
                                }
                                baos.flush();
                                this.processXMLPack(new ByteArrayInputStream(baos.toByteArray()), entry2.getName(), collectionName);
                                baos.close();
                                if (!this.shallTerminate()) continue;
                                break;
                            }
                        }
                        catch (IOException e) {
                            ConcurrentLog.logException(e);
                        }
                        finally {
                            moved = infile.renameTo(outfile);
                            if (zis != null) {
                                try {
                                    zis.close();
                                }
                                catch (IOException e) {
                                    this.log.warn("Could not close zip input stream on file " + String.valueOf(infile));
                                }
                            }
                        }
                        return moved;
                    }
                    if (inFileName.endsWith(".warc") || inFileName.endsWith(".warc.gz")) {
                        try {
                            WarcImporter wri = new WarcImporter(infile, collectionName);
                            wri.start();
                            try {
                                wri.join();
                            }
                            catch (InterruptedException ex) {
                                return moved;
                            }
                            moved = infile.renameTo(outfile);
                        }
                        catch (IOException ex) {
                            this.log.warn("IO Error processing warc file " + String.valueOf(infile));
                        }
                        return moved;
                    }
                    if (inFileName.endsWith(".zim")) {
                        try {
                            ZimImporter wri = new ZimImporter(infile.getAbsolutePath(), collectionName);
                            wri.start();
                            try {
                                wri.join();
                            }
                            catch (InterruptedException ex) {
                                return moved;
                            }
                            moved = infile.renameTo(outfile);
                        }
                        catch (IOException ex) {
                            this.log.warn("IO Error processing zim file " + String.valueOf(infile));
                        }
                        return moved;
                    }
                    if (inFileName.endsWith(".jsonl") || inFileName.endsWith(".jsonl.gz") || inFileName.endsWith(".jsonlist") || inFileName.endsWith(".jsonlist.gz") || inFileName.endsWith(".flatjson") || inFileName.endsWith(".flatjson.gz")) {
                        return this.processPackJson(infile, outfile);
                    }
                    is = null;
                    is = new BufferedInputStream(new FileInputStream(infile));
                    if (inFileName.endsWith(".gz")) {
                        is = new GZIPInputStream((InputStream)is, 65535);
                    }
                    this.processXMLPack(is, infile.getName(), collectionName);
                    if (this.shallTerminate() || !(moved = infile.renameTo(outfile))) break block113;
                    if (outfile.getName().endsWith(".gz")) break block114;
                    String gzname = outfile.getName() + ".gz";
                    File gzfile = new File(outfile.getParentFile(), gzname);
                    try (FileOutputStream fileOutStream = new FileOutputStream(gzfile);
                         BufferedOutputStream os = new BufferedOutputStream(new GZIPOutputStream(fileOutStream, 65536){
                        {
                            this.def.setLevel(9);
                        }
                    });
                         FileInputStream fileInStream = new FileInputStream(outfile);
                         BufferedInputStream bis = new BufferedInputStream(fileInStream);){
                        FileUtils.copy((InputStream)bis, (OutputStream)os);
                        if (gzfile.exists()) {
                            FileUtils.deletedelete(outfile);
                        }
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                this.log.info("processed pack " + String.valueOf(infile));
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    this.log.warn("Could not close input stream on file " + String.valueOf(infile));
                }
            }
            break block118;
            catch (IOException e) {
                block115: {
                    block116: {
                        try {
                            ConcurrentLog.logException(e);
                            if (this.shallTerminate() || !(moved = infile.renameTo(outfile))) break block115;
                            if (outfile.getName().endsWith(".gz")) break block116;
                        }
                        catch (Throwable throwable) {
                            if (!this.shallTerminate() && (moved = infile.renameTo(outfile))) {
                                if (!outfile.getName().endsWith(".gz")) {
                                    String gzname = outfile.getName() + ".gz";
                                    File gzfile = new File(outfile.getParentFile(), gzname);
                                    try (FileOutputStream fileOutStream = new FileOutputStream(gzfile);
                                         BufferedOutputStream os = new BufferedOutputStream(new /* invalid duplicate definition of identical inner class */);
                                         FileInputStream fileInStream = new FileInputStream(outfile);
                                         BufferedInputStream bis = new BufferedInputStream(fileInStream);){
                                        FileUtils.copy((InputStream)bis, (OutputStream)os);
                                        if (gzfile.exists()) {
                                            FileUtils.deletedelete(outfile);
                                        }
                                    }
                                    catch (IOException e2) {
                                        ConcurrentLog.logException(e2);
                                    }
                                }
                                this.log.info("processed pack " + String.valueOf(infile));
                            }
                            if (is != null) {
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException e3) {
                                    this.log.warn("Could not close input stream on file " + String.valueOf(infile));
                                }
                            }
                            throw throwable;
                        }
                        String gzname = outfile.getName() + ".gz";
                        File gzfile = new File(outfile.getParentFile(), gzname);
                        try (FileOutputStream fileOutStream = new FileOutputStream(gzfile);
                             BufferedOutputStream os = new BufferedOutputStream(new /* invalid duplicate definition of identical inner class */);
                             FileInputStream fileInStream = new FileInputStream(outfile);
                             BufferedInputStream bis = new BufferedInputStream(fileInStream);){
                            FileUtils.copy((InputStream)bis, (OutputStream)os);
                            if (gzfile.exists()) {
                                FileUtils.deletedelete(outfile);
                            }
                        }
                        catch (IOException e4) {
                            ConcurrentLog.logException(e4);
                        }
                    }
                    this.log.info("processed pack " + String.valueOf(infile));
                }
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e5) {
                        this.log.warn("Could not close input stream on file " + String.valueOf(infile));
                    }
                }
            }
        }
        return moved;
    }

    private boolean processPackJson(File infile, File outfile) {
        this.log.info("processing json pack " + String.valueOf(infile));
        try {
            JsonListImporter importer = new JsonListImporter(infile, false, false);
            importer.run();
        }
        catch (IOException e) {
            this.log.warn(e);
        }
        boolean moved = infile.renameTo(outfile);
        return moved;
    }

    private void processXMLPack(InputStream is, String name, String collection) throws IOException {
        int t;
        int concurrency = Runtime.getRuntime().availableProcessors();
        final CrawlProfile xmlProfile = (CrawlProfile)Switchboard.getSwitchboard().crawler.defaultPackProfile.clone();
        xmlProfile.setCollections(collection);
        xmlProfile.setHandle();
        final XMLPackReader reader = new XMLPackReader(is, 100, this.crawlStacker, this.index.fulltext().getDefaultConfiguration(), concurrency);
        Thread readerThread = new Thread((Runnable)reader, name);
        readerThread.setPriority(10);
        readerThread.start();
        assert (this.crawlStacker != null);
        Thread[] indexer = new Thread[concurrency];
        for (t = 0; t < concurrency; ++t) {
            indexer[t] = new Thread("Switchboard.processXMLPack-" + t){

                @Override
                public void run() {
                    Object xmlPackObj;
                    VocabularyScraper scraper = new VocabularyScraper();
                    while ((xmlPackObj = reader.take()) != XMLPackReader.POISON_DOCUMENT) {
                        assert (xmlPackObj != null);
                        if (xmlPackObj instanceof SolrInputDocument) {
                            SolrInputDocument pack = (SolrInputDocument)xmlPackObj;
                            try {
                                String id = (String)pack.getFieldValue(CollectionSchema.id.getSolrFieldName());
                                String text = (String)pack.getFieldValue(CollectionSchema.text_t.getSolrFieldName());
                                DigestURL rootURL = new DigestURL((String)pack.getFieldValue(CollectionSchema.sku.getSolrFieldName()), ASCII.getBytes(id));
                                if (text != null && text.length() > 0 && id != null) {
                                    Tokenizer tokenizer = new Tokenizer(rootURL, text, LibraryProvider.dymLib, true, scraper);
                                    Map<String, Set<String>> facets = Document.computeGenericFacets(tokenizer.tags());
                                    Switchboard.this.index.fulltext().getDefaultConfiguration().enrich(pack, tokenizer.synonyms(), facets);
                                }
                                byte[] myPeerHash = ASCII.getBytes(Switchboard.this.peers.mySeed().hash);
                                ResultURLs.stack(ASCII.String(rootURL.hash()), rootURL.getHost(), myPeerHash, myPeerHash, ResultURLs.EventOrigin.PACKS);
                            }
                            catch (MalformedURLException e) {
                                ConcurrentLog.logException(e);
                            }
                            Switchboard.this.index.putDocument(pack);
                        } else if (xmlPackObj instanceof DCEntry) {
                            DCEntry entry2 = (DCEntry)((Object)xmlPackObj);
                            Document document = entry2.document();
                            Request request = new Request(ASCII.getBytes(Switchboard.this.peers.mySeed().hash), entry2.getIdentifier(true), null, "", entry2.getDate(), xmlProfile.handle(), 0, xmlProfile.timezoneOffset());
                            Response response = new Response(request, null, null, xmlProfile, false, null);
                            IndexingQueueEntry queueEntry = new IndexingQueueEntry(response, new Document[]{document}, null);
                            Switchboard.this.indexingCondensementProcessor.enQueue(queueEntry);
                        }
                        if (!Switchboard.this.shallTerminate()) continue;
                        break;
                    }
                }
            };
            indexer[t].setPriority(5);
            indexer[t].start();
        }
        for (t = 0; t < concurrency; ++t) {
            try {
                indexer[t].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isPackFile(String s) {
        return s.endsWith(".xml") || s.endsWith(".xml.gz") || s.endsWith(".xml.zip") || s.endsWith(".warc") || s.endsWith(".warc.gz") || s.endsWith(".jsonl") || s.endsWith(".jsonl.gz") || s.endsWith(".jsonlist") || s.endsWith(".jsonlist.gz") || s.endsWith(".flatjson") || s.endsWith(".flatjson.gz");
    }

    public List<String> packsInHold() {
        String[] packlist = this.packsHoldPath.list();
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : packlist) {
            if (!this.isPackFile(s)) continue;
            list2.add(s);
        }
        return list2;
    }

    public List<String> packsInLive() {
        String[] packlist = this.packsLivePath.list();
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : packlist) {
            if (!this.isPackFile(s)) continue;
            list2.add(s);
        }
        return list2;
    }

    public List<String> packsInLoad() {
        String[] packlist = this.packsLoadPath.list();
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : packlist) {
            if (!this.isPackFile(s)) continue;
            list2.add(s);
        }
        return list2;
    }

    public List<String> packsInLoaded() {
        String[] packlist = this.packsLoadedPath.list();
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : packlist) {
            if (!this.isPackFile(s)) continue;
            list2.add(s);
        }
        return list2;
    }

    public List<String> packsInUnload() {
        String[] packlist = this.packsUnloadPath.list();
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : packlist) {
            if (!this.isPackFile(s)) continue;
            list2.add(s);
        }
        return list2;
    }

    public Map<String, String> packsMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String pack : this.packsInHold()) {
            map.put(pack, "hold");
        }
        for (String pack : this.packsInLive()) {
            map.put(pack, "live");
        }
        for (String pack : this.packsInLoad()) {
            map.put(pack, "load");
        }
        for (String pack : this.packsInLoaded()) {
            map.put(pack, "loaded");
        }
        for (String pack : this.packsInUnload()) {
            map.put(pack, "unload");
        }
        return map;
    }

    public boolean packProcess() {
        String cautionCause = this.onlineCaution();
        if (cautionCause != null) {
            if (this.log.isFine()) {
                this.log.fine("deQueue: online caution for " + cautionCause + ", omitting resource stack processing");
            }
            return false;
        }
        try {
            String[] packlist = this.packsLoadPath.list();
            if (packlist != null && packlist.length > 0) {
                for (String pack : packlist) {
                    this.checkInterruption();
                    if (!this.isPackFile(pack) || !this.processPack(pack, "user")) continue;
                    return true;
                }
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return false;
    }

    public static void clearCaches() {
        pdfParser.clearPdfBoxCaches();
        if (WordCache.sizeCommonWords() > 1000) {
            WordCache.clearCommonWords();
        }
        Word.clearCache();
        ResultImages.clearQueues();
        Cache.commit();
        Digest.cleanup();
        CircleTool.clearcache();
        NetworkGraph.clearcache();
    }

    public int schedulerJobSize() {
        try {
            return this.tables.size("api");
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return 0;
        }
    }

    public boolean schedulerJob() {
        LinkedHashSet<String> pks = new LinkedHashSet<String>();
        Date now = new Date();
        try {
            Iterator<Tables.Row> plainIterator = this.tables.iterator("api");
            for (Tables.Row row : Tables.orderByDate(plainIterator, "date_last_exec", null, Tables.SortDirection.ASC)) {
                String kind;
                if (row == null) continue;
                int stime = row.get("apicall_schedule_time", 0);
                if (stime > 0) {
                    Date date_next_exec = row.get("date_next_exec", (Date)null);
                    if (date_next_exec != null) {
                        if (now.after(date_next_exec)) {
                            pks.add(UTF8.String(row.getPK()));
                        }
                    } else {
                        pks.add(UTF8.String(row.getPK()));
                    }
                }
                if ("off".equals(kind = row.get("apicall_event_kind", "off"))) continue;
                String action = row.get("apicall_event_action", "startup");
                if ("startup".equals(action)) {
                    if (!this.startupAction) continue;
                    pks.add(UTF8.String(row.getPK()));
                    if (!"once".equals(kind)) continue;
                    row.put("apicall_event_kind", "off");
                    Switchboard.sb.tables.update("api", row);
                    continue;
                }
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                    long d = dateFormat.parse(dateFormat.format(new Date()).substring(0, 8) + action).getTime();
                    long cycle = this.getThread("90_cleanup").getBusySleep();
                    if (d >= System.currentTimeMillis() || System.currentTimeMillis() - d >= cycle) continue;
                    pks.add(UTF8.String(row.getPK()));
                    if (!"once".equals(kind)) continue;
                    row.put("apicall_event_kind", "off");
                    row.put("date_next_exec", "");
                    Switchboard.sb.tables.update("api", row);
                }
                catch (ParseException parseException) {}
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        this.startupAction = false;
        Map<String, Integer> callResult = this.tables.execAPICalls("localhost", this.getLocalPort(), pks, this.getConfig("adminAccountUserName", "admin"), this.getConfig("adminAccountBase64MD5", ""));
        for (Map.Entry<String, Integer> call : callResult.entrySet()) {
            this.log.info("Scheduler executed api call, response " + String.valueOf(call.getValue()) + ": " + call.getKey());
        }
        return pks.size() > 0;
    }

    public int cleanupJobSize() {
        int c = 1;
        if (this.crawlQueues.delegatedURL != null && this.crawlQueues.delegatedURL.size() > 1000) {
            ++c;
        }
        if (this.crawlQueues.errorURL.stackSize() > 1000) {
            ++c;
        }
        for (ResultURLs.EventOrigin origin : ResultURLs.EventOrigin.values()) {
            if (ResultURLs.getStackSize(origin) <= 1000) continue;
            ++c;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanupJob() {
        ConcurrentLog.ensureWorkerIsRunning();
        try {
            yacyRelease updateVersion;
            long cs;
            Switchboard.clearCaches();
            try {
                File tdlog = new File(this.dataPath, "DATA/LOG/threaddump.txt");
                PrintWriter out = new PrintWriter(tdlog);
                String threaddump = ThreadDump.threaddump(this, true, 0, false, 0);
                out.println(threaddump);
                out.close();
            }
            catch (IOException e) {
                this.log.info("cannot write threaddump", e);
            }
            if (!MemoryControl.request(128000000L, false)) {
                this.index.clearCaches();
                SearchEventCache.cleanupEvents(false);
                this.trail.clear();
                GuiHandler.clear();
            }
            if (this.getConfigBool("greedylearning.active", false) && (cs = this.index.fulltext().collectionSize()) > (long)this.getConfigInt("greedylearning.limit.doccount", 0)) {
                this.setConfig("greedylearning.active", false);
                this.log.info("finishing greedy learning phase, size=" + cs);
            }
            try {
                for (byte[] handle : this.crawler.getActive()) {
                    CrawlProfile selentry = this.crawler.getActive(handle);
                    if (selentry.handle() == null) {
                        this.crawler.removeActive(handle);
                        continue;
                    }
                    boolean insert = false;
                    if (selentry.name().equals("recrawlJob")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(60L).getTime()));
                        insert = true;
                    }
                    if (selentry.name().equals("proxy")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(1440L).getTime()));
                        insert = true;
                    }
                    if (selentry.name().equals("snippetLocalText")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(43200L).getTime()));
                        insert = true;
                    }
                    if (selentry.name().equals("snippetGlobalText")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(43200L).getTime()));
                        insert = true;
                    }
                    if (selentry.name().equals("snippetGreedyLearningText")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(43200L).getTime()));
                        insert = true;
                    }
                    if (selentry.name().equals("snippetLocalMedia")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(43200L).getTime()));
                        insert = true;
                    }
                    if (selentry.name().equals("snippetGlobalMedia")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(43200L).getTime()));
                        insert = true;
                    }
                    if (selentry.name().equals("packs")) {
                        selentry.put(CrawlProfile.CrawlAttribute.RECRAWL_IF_OLDER.key, Long.toString(CrawlProfile.getRecrawlDate(43200L).getTime()));
                        insert = true;
                    }
                    if (!insert) continue;
                    this.crawler.putActive(UTF8.getBytes(selentry.handle()), selentry);
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            ConnectionInfo.cleanUp();
            this.checkInterruption();
            if (this.crawlQueues.delegatedURL != null && this.crawlQueues.delegatedURL.size() > 1000) {
                if (this.log.isFine()) {
                    this.log.fine("Cleaning Delegated-URLs report stack, " + this.crawlQueues.delegatedURL.size() + " entries on stack");
                }
                this.crawlQueues.delegatedURL.clear();
            }
            this.checkInterruption();
            if (this.crawlQueues.errorURL.stackSize() > 1000) {
                if (this.log.isFine()) {
                    this.log.fine("Cleaning Error-URLs report stack, " + this.crawlQueues.errorURL.stackSize() + " entries on stack");
                }
                this.crawlQueues.errorURL.clearStack();
            }
            for (ResultURLs.EventOrigin origin : ResultURLs.EventOrigin.values()) {
                this.checkInterruption();
                if (ResultURLs.getStackSize(origin) <= 1000) continue;
                if (this.log.isFine()) {
                    this.log.fine("Cleaning Loaded-URLs report stack, " + ResultURLs.getStackSize(origin) + " entries on stack " + origin.getCode());
                }
                ResultURLs.clearStack(origin);
            }
            this.checkInterruption();
            try {
                if (this.log.isFine()) {
                    this.log.fine("Cleaning Incoming News, " + this.peers.newsPool.size(0) + " entries on stack");
                }
                this.peers.newsPool.automaticProcess(this.peers);
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            if (this.getConfigBool("cleanup.deletionProcessedNews", true)) {
                this.peers.newsPool.clear(1);
            }
            if (this.getConfigBool("cleanup.deletionPublishedNews", true)) {
                this.peers.newsPool.clear(3);
            }
            if (this.getConfigBool("routing.deleteOldSeeds.permission", true)) {
                int i;
                long deleteOldSeedsTime = this.getConfigLong("routing.deleteOldSeeds.time", 7L) * 24L * 3600000L;
                Iterator<Seed> e = this.peers.seedsSortedDisconnected(true, "LastSeen");
                Seed seed = null;
                ArrayList<String> deleteQueue = new ArrayList<String>();
                this.checkInterruption();
                while (e.hasNext()) {
                    seed = e.next();
                    if (seed == null) continue;
                    if (!seed.isLastSeenTimeout(deleteOldSeedsTime)) break;
                    deleteQueue.add(seed.hash);
                }
                for (i = 0; i < deleteQueue.size(); ++i) {
                    this.peers.removeDisconnected((String)deleteQueue.get(i));
                }
                deleteQueue.clear();
                e = this.peers.seedsSortedPotential(true, "LastSeen");
                this.checkInterruption();
                while (e.hasNext()) {
                    seed = e.next();
                    if (seed == null) continue;
                    if (!seed.isLastSeenTimeout(deleteOldSeedsTime)) break;
                    deleteQueue.add(seed.hash);
                }
                for (i = 0; i < deleteQueue.size(); ++i) {
                    this.peers.removePotential((String)deleteQueue.get(i));
                }
            }
            if ((updateVersion = yacyRelease.rulebasedUpdateInfo(false)) != null) {
                this.log.info("AUTO-UPDATE: downloading more recent release " + String.valueOf(updateVersion.getUrl()));
                File downloaded = updateVersion.downloadRelease();
                boolean devenvironment = new File(this.getAppPath(), ".git").exists();
                if (devenvironment) {
                    this.log.info("AUTO-UPDATE: omitting update because this is a development environment");
                } else if (downloaded == null || !downloaded.exists() || downloaded.length() == 0L) {
                    this.log.info("AUTO-UPDATE: omitting update because download failed (file cannot be found, is too small or signature is bad)");
                } else if (yacyRelease.deployRelease(downloaded)) {
                    this.terminate(10L, "auto-update to install " + downloaded.getName());
                    this.log.info("AUTO-UPDATE: deploy and restart initiated");
                } else {
                    this.log.info("AUTO-UPDATE: omitting update because an error occurred while trying to deploy the release.");
                }
            }
            if (!this.isRobinsonMode() && this.peers.newsPool.size(2) == 0) {
                Properties profile2 = new Properties();
                File profileFile = new File(this.dataPath, "DATA/SETTINGS/profile.txt");
                FileInputStream fileIn = null;
                try {
                    fileIn = new FileInputStream(profileFile);
                    profile2.load(fileIn);
                }
                catch (IOException e) {
                }
                finally {
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (Exception e) {
                            this.log.warn("Could not close input stream on file " + String.valueOf(profileFile));
                        }
                    }
                }
                String homepage = (String)profile2.get("homepage");
                if (homepage != null && homepage.length() > 10) {
                    Properties news = new Properties();
                    news.put("homepage", profile2.get("homepage"));
                    this.peers.newsPool.publishMyNews(this.peers.mySeed(), "prflecst", news);
                }
            }
            this.clusterhashes = this.peers.clusterHashes(this.getConfig("cluster.peers.yacydomain", ""));
            if (this.getConfigBool("upnp.enabled", false) && this.peers.mySeed().isJunior()) {
                UPnP.addPortMappings();
            }
            this.observer.resourceObserverJob();
            this.checkInterruption();
            boolean allCrawlsFinished = this.crawler.allCrawlsFinished(this.crawlQueues);
            int proccount = 0;
            if (!this.crawlJobIsPaused("50_localcrawl")) {
                boolean postprocessing;
                boolean minimum_load_fullfilled;
                boolean minimum_ram_fullfilled;
                boolean reference_index_exist;
                Fulltext fulltext = this.index.fulltext();
                CollectionConfiguration collection1Configuration = fulltext.getDefaultConfiguration();
                boolean process_key_exist = collection1Configuration.contains(CollectionSchema.process_sxt);
                if (!process_key_exist) {
                    this.log.info("postprocessing deactivated: field process_sxt is not enabled");
                }
                boolean bl = reference_index_exist = this.index.connectedCitation() || fulltext.useWebgraph();
                if (!reference_index_exist) {
                    this.log.info("postprocessing deactivated: no reference index avilable; activate citation index or webgraph");
                }
                boolean bl2 = minimum_ram_fullfilled = MemoryControl.available() > this.getConfigLong("postprocessing.minimum_ram", 0L);
                if (!minimum_ram_fullfilled) {
                    this.log.info("postprocessing deactivated: no enough ram (" + MemoryControl.available() + "), needed " + this.getConfigLong("postprocessing.minimum_ram", 0L) + ", to force change field postprocessing.minimum_ram");
                }
                boolean bl3 = minimum_load_fullfilled = Memory.getSystemLoadAverage() < (double)this.getConfigFloat("postprocessing.maximum_load", 0.0f);
                if (!minimum_load_fullfilled) {
                    this.log.info("postprocessing deactivated: too high load (" + Memory.getSystemLoadAverage() + ") > " + this.getConfigFloat("postprocessing.maximum_load", 0.0f) + ", to force change field postprocessing.maximum_load");
                }
                boolean bl4 = postprocessing = process_key_exist && reference_index_exist && minimum_ram_fullfilled && minimum_load_fullfilled;
                if (!postprocessing) {
                    this.log.info("postprocessing deactivated: constraints violated");
                }
                if (allCrawlsFinished) {
                    SearchEventCache.cleanupEvents(true);
                    Switchboard.sb.index.clearCaches();
                    if (postprocessing) {
                        Segment.ReferenceReportCache rrCache = this.index.getReferenceReportCache();
                        proccount += collection1Configuration.postprocessing(this.index, rrCache, null, this.getConfigBool("postprocessing.partialUpdate", true));
                        this.index.fulltext().commit(true);
                    }
                    this.crawler.cleanProfiles(this.crawler.getActiveProfiles());
                    this.log.info("cleanup post-processed " + proccount + " documents");
                } else {
                    Set<String> deletionCandidates = collection1Configuration.contains(CollectionSchema.harvestkey_s.getSolrFieldName()) ? this.crawler.getFinishedProfiles(this.crawlQueues) : new HashSet<String>();
                    int cleanupByHarvestkey = deletionCandidates.size();
                    if (cleanupByHarvestkey > 0) {
                        if (postprocessing) {
                            Segment.ReferenceReportCache rrCache = this.index.getReferenceReportCache();
                            for (String profileHash : deletionCandidates) {
                                proccount += collection1Configuration.postprocessing(this.index, rrCache, profileHash, this.getConfigBool("postprocessing.partialUpdate", true));
                            }
                            this.index.fulltext().commit(true);
                        }
                        this.crawler.cleanProfiles(deletionCandidates);
                        this.log.info("cleanup removed " + cleanupByHarvestkey + " crawl profiles, post-processed " + proccount + " documents");
                    }
                }
            }
            if (allCrawlsFinished) {
                Domains.clear();
                this.crawlQueues.noticeURL.clear();
            }
            if (System.currentTimeMillis() - this.lastStats > 1500000L) {
                try {
                    BEncodedHeap statTable = this.tables.getHeap("stats");
                    LinkedHashMap<String, byte[]> entry2 = new LinkedHashMap<String, byte[]>();
                    if (this.isP2PMode()) {
                        entry2.put("aM", ASCII.getBytes(Integer.toString(this.peers.sizeActiveSince(43200L))));
                        entry2.put("aW", ASCII.getBytes(Integer.toString(this.peers.sizeActiveSince(10080L))));
                        entry2.put("aD", ASCII.getBytes(Integer.toString(this.peers.sizeActiveSince(1440L))));
                        entry2.put("aH", ASCII.getBytes(Integer.toString(this.peers.sizeActiveSince(60L))));
                        entry2.put("cC", ASCII.getBytes(Integer.toString(this.peers.sizeConnected())));
                        entry2.put("cD", ASCII.getBytes(Integer.toString(this.peers.sizeDisconnected())));
                        entry2.put("cP", ASCII.getBytes(Integer.toString(this.peers.sizePotential())));
                        entry2.put("cR", ASCII.getBytes(Long.toString(this.index.RWICount())));
                    }
                    entry2.put("cI", ASCII.getBytes(Long.toString(this.index.fulltext().collectionSize())));
                    byte[] pk = ASCII.getBytes(GenericFormatter.SHORT_MINUTE_FORMATTER.format());
                    statTable.put(pk, (Map<String, byte[]>)entry2);
                    this.lastStats = System.currentTimeMillis();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (Memory.deadlocks() > 0L) {
                Memory.logDeadlocks();
            }
            System.gc();
            return true;
        }
        catch (InterruptedException e) {
            this.log.info("cleanupJob: Shutdown detected");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseCrawlJob(String jobType, String cause) {
        Object[] status = this.crawlJobsStatus.get(jobType);
        Object object = status[0];
        synchronized (object) {
            status[1] = Boolean.TRUE;
        }
        this.setConfig(jobType + "_isPaused", "true");
        this.setConfig(jobType + "_isPaused_cause", cause);
        this.log.warn("Crawl job '" + jobType + "' is paused: " + cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueCrawlJob(String jobType) {
        Object[] status = this.crawlJobsStatus.get(jobType);
        Object object = status[0];
        synchronized (object) {
            if (((Boolean)status[1]).booleanValue()) {
                status[1] = Boolean.FALSE;
                status[0].notifyAll();
            }
        }
        this.setConfig(jobType + "_isPaused", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean crawlJobIsPaused(String jobType) {
        Object[] status = this.crawlJobsStatus.get(jobType);
        Object object = status[0];
        synchronized (object) {
            return (Boolean)status[1];
        }
    }

    public IndexingQueueEntry parseDocument(IndexingQueueEntry in) {
        in.queueEntry.updateStatus(1);
        Document[] documents = null;
        try {
            documents = this.parseDocument(in.queueEntry);
        }
        catch (Exception e) {
            documents = null;
        }
        if (documents == null) {
            return null;
        }
        return new IndexingQueueEntry(in.queueEntry, documents, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document[] parseDocument(Response response) throws InterruptedException {
        Document[] documents = null;
        ResultURLs.EventOrigin processCase = response.processCase(this.peers.mySeed().hash);
        if (this.log.isFine()) {
            this.log.fine("processResourceStack processCase=" + String.valueOf((Object)processCase) + ", depth=" + response.depth() + ", maxDepth=" + (response.profile() == null ? "null" : Integer.toString(response.profile().depth())) + ", must-match=" + (response.profile() == null ? "null" : response.profile().formattedUrlMustMatchPattern()) + ", must-not-match=" + (response.profile() == null ? "null" : response.profile().urlMustNotMatchPattern().toString()) + ", initiatorHash=" + (response.initiator() == null ? "null" : ASCII.String(response.initiator())) + ", url=" + String.valueOf(response.url()));
        }
        long parsingStartTime = System.currentTimeMillis();
        if (response.getContent() == null) {
            response.setContent(Cache.getContent(response.url().hash()));
            if (response.getContent() == null) {
                this.log.warn("the resource '" + String.valueOf(response.url()) + "' is missing in the cache.");
                this.crawlQueues.errorURL.push(response.url(), response.depth(), response.profile(), FailCategory.FINAL_LOAD_CONTEXT, "missing in cache", -1);
                return null;
            }
        }
        assert (response.getContent() != null);
        try {
            String supportError = TextParser.supports(response.url(), response.getMimeType());
            if (supportError != null) {
                if (!response.profile().isIndexNonParseableUrls()) {
                    this.log.warn("Resource '" + response.url().toNormalform(true) + "' is not supported. " + supportError);
                    this.crawlQueues.errorURL.push(response.url(), response.depth(), response.profile(), FailCategory.FINAL_PROCESS_CONTEXT, supportError, -1);
                    return null;
                }
                documents = TextParser.genericParseSource(new AnchorURL(response.url()), response.getMimeType(), response.getCharacterEncoding(), response.profile().defaultValency(), response.profile().valencySwitchTagNames(), response.profile().scraper(), response.profile().timezoneOffset(), response.depth(), response.getContent(), response.lastModified());
            } else {
                documents = TextParser.parseSource((DigestURL)new AnchorURL(response.url()), response.getMimeType(), response.getCharacterEncoding(), response.profile().defaultValency(), response.profile().valencySwitchTagNames(), response.profile().scraper(), response.profile().timezoneOffset(), response.depth(), response.getContent(), response.lastModified());
            }
            if (documents == null) {
                throw new Parser.Failure("Parser returned null.", response.url());
            }
        }
        catch (Parser.Failure e) {
            this.log.warn("Unable to parse the resource '" + response.url().toNormalform(true) + "'. " + e.getMessage());
            this.crawlQueues.errorURL.push(response.url(), response.depth(), response.profile(), FailCategory.FINAL_PROCESS_CONTEXT, e.getMessage(), -1);
            return null;
        }
        long parsingEndTime = System.currentTimeMillis();
        long stackStartTime = System.currentTimeMillis();
        if (response.profile() != null) {
            ArrayList<Document> newDocs = new ArrayList<Document>();
            for (Document doc : documents) {
                String string = this.crawlStacker.checkAcceptanceChangeable(doc.dc_source(), response.profile(), 1);
                if (string == null) {
                    newDocs.add(doc);
                    continue;
                }
                if (string == null || string.startsWith("double in")) continue;
                this.crawlStacker.nextQueue.errorURL.push(response.url(), response.depth(), response.profile(), FailCategory.FINAL_LOAD_CONTEXT, string, -1);
            }
            if (newDocs.size() != documents.length) {
                documents = (Document[])newDocs.toArray();
            }
        }
        if (processCase != ResultURLs.EventOrigin.PROXY_LOAD) {
            if (processCase != ResultURLs.EventOrigin.LOCAL_CRAWLING) return documents;
        }
        if (response.profile() != null && response.depth() >= response.profile().depth()) {
            if (!response.profile().crawlerNoDepthLimitMatchPattern().matcher(response.url().toNormalform(true)).matches()) return documents;
        }
        Pattern crawlerOriginUrlMustMatch = response.profile().getCrawlerOriginUrlMustMatchPattern();
        Pattern crawlerOriginUrlMustNotMatch = response.profile().getCrawlerOriginUrlMustNotMatchPattern();
        if (crawlerOriginUrlMustMatch != CrawlProfile.MATCH_ALL_PATTERN && !crawlerOriginUrlMustMatch.matcher(response.url().toNormalform(true)).matches() || crawlerOriginUrlMustNotMatch != CrawlProfile.MATCH_NEVER_PATTERN && crawlerOriginUrlMustNotMatch.matcher(response.url().toNormalform(true)).matches()) {
            if (!this.log.isInfo()) return documents;
            this.log.info("CRAWL: Ignored links from document at " + response.url().toNormalform(true) + " : prevented by regular expression on URL origin of links, " + String.valueOf((Object)CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTMATCH) + " = " + crawlerOriginUrlMustMatch.pattern() + ", " + String.valueOf((Object)CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTNOTMATCH) + " = " + crawlerOriginUrlMustNotMatch.pattern());
            return documents;
        }
        for (Document document : documents) {
            document.setDepth(response.depth());
        }
        Map<AnchorURL, String> hl = Document.getHyperlinks(documents, !response.profile().obeyHtmlRobotsNofollow());
        boolean addAllLinksToCrawlStack = response.profile().isIndexNonParseableUrls() || response.profile().isCrawlerAlwaysCheckMediaType();
        for (Map.Entry<DigestURL, String> entry2 : Document.getImagelinks(documents).entrySet()) {
            if (!addAllLinksToCrawlStack && (!response.profile().indexMedia() || TextParser.supportsExtension(entry2.getKey()) != null)) continue;
            hl.put(new AnchorURL(entry2.getKey()), entry2.getValue());
        }
        for (Map.Entry<DigestURL, String> entry3 : Document.getApplinks(documents).entrySet()) {
            if (!addAllLinksToCrawlStack && (!response.profile().indexMedia() || TextParser.supportsExtension(entry3.getKey()) != null)) continue;
            hl.put(new AnchorURL(entry3.getKey()), entry3.getValue());
        }
        for (Map.Entry<DigestURL, String> entry4 : Document.getVideolinks(documents).entrySet()) {
            if (!addAllLinksToCrawlStack && (!response.profile().indexMedia() || TextParser.supportsExtension(entry4.getKey()) != null)) continue;
            hl.put(new AnchorURL(entry4.getKey()), entry4.getValue());
        }
        for (Map.Entry<DigestURL, String> entry5 : Document.getAudiolinks(documents).entrySet()) {
            if (!addAllLinksToCrawlStack && (!response.profile().indexMedia() || TextParser.supportsExtension(entry5.getKey()) != null)) continue;
            hl.put(new AnchorURL(entry5.getKey()), entry5.getValue());
        }
        Iterator<Map.Entry<AnchorURL, String>> iterator = hl.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                long l = System.currentTimeMillis();
                if (!this.log.isInfo()) return documents;
                this.log.info("CRAWL: ADDED " + hl.size() + " LINKS FROM " + response.url().toNormalform(true) + ", STACKING TIME = " + (l - stackStartTime) + ", PARSING TIME = " + (parsingEndTime - parsingStartTime));
                return documents;
            }
            Map.Entry<AnchorURL, String> entry6 = iterator.next();
            this.checkInterruption();
            MultiProtocolURL nextUrl = entry6.getKey();
            String u = nextUrl.toNormalform(true, true);
            if (!u.startsWith("http://") && !u.startsWith("https://") && !u.startsWith("ftp://") && !u.startsWith("smb://") && !u.startsWith("file://")) continue;
            String u0 = LibraryProvider.urlRewriter.apply(u);
            if (!u.equals(u0)) {
                this.log.info("REWRITE of url = \"" + u + "\" to \"" + u0 + "\"");
                u = u0;
            }
            int nextdepth = entry6.getValue() != null && entry6.getValue().equals("canonical") ? response.depth() : response.depth() + 1;
            try {
                this.crawlStacker.enqueueEntry(new Request(response.initiator(), new DigestURL(u), response.url().hash(), entry6.getValue(), new Date(), response.profile().handle(), nextdepth, response.profile().timezoneOffset()));
            }
            catch (MalformedURLException e) {
                ConcurrentLog.logException(e);
                continue;
            }
            break;
        }
    }

    public IndexingQueueEntry condenseDocument(IndexingQueueEntry in) {
        Pattern mustmatchurl;
        in.queueEntry.updateStatus(2);
        CrawlProfile profile2 = in.queueEntry.profile();
        String urls2 = in.queueEntry.url().toNormalform(true);
        if (!profile2.indexText() && !profile2.indexMedia()) {
            if (this.log.isInfo()) {
                this.log.info("Not Condensed Resource '" + urls2 + "': indexing of this media type not wanted by crawl profile");
            }
            return new IndexingQueueEntry(in.queueEntry, in.documents, null);
        }
        if (!profile2.indexMedia()) {
            if (Classification.isMediaExtension(MultiProtocolURL.getFileExtension(in.queueEntry.url().getFileName()))) {
                this.log.info("Not Condensed Resource '" + urls2 + "': indexing of media files not wanted by crawl profile");
                return new IndexingQueueEntry(in.queueEntry, in.documents, null);
            }
            Classification.ContentDomain cd = Classification.getContentDomainFromMime(in.queueEntry.getMimeType());
            if (cd == Classification.ContentDomain.IMAGE || cd == Classification.ContentDomain.VIDEO || cd == Classification.ContentDomain.AUDIO) {
                this.log.info("Not Condensed Resource '" + urls2 + "': indexing of media not wanted by crawl profile");
                return new IndexingQueueEntry(in.queueEntry, in.documents, null);
            }
        }
        if ((mustmatchurl = profile2.indexUrlMustMatchPattern()) != CrawlProfile.MATCH_ALL_PATTERN && !mustmatchurl.matcher(urls2).matches()) {
            String info = "Not Condensed Resource '" + urls2 + "': indexing prevented by regular expression on url; indexUrlMustMatchPattern = " + mustmatchurl.pattern();
            if (this.log.isInfo()) {
                this.log.info(info);
            }
            this.crawlQueues.errorURL.push(in.queueEntry.url(), in.queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, info, -1);
            return new IndexingQueueEntry(in.queueEntry, in.documents, null);
        }
        Pattern mustnotmatchurl = profile2.indexUrlMustNotMatchPattern();
        if (mustnotmatchurl != CrawlProfile.MATCH_NEVER_PATTERN && mustnotmatchurl.matcher(urls2).matches()) {
            String info = "Not Condensed Resource '" + urls2 + "': indexing prevented by regular expression on url; indexUrlMustNotMatchPattern = " + String.valueOf(mustnotmatchurl);
            if (this.log.isInfo()) {
                this.log.info(info);
            }
            this.crawlQueues.errorURL.push(in.queueEntry.url(), in.queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, info, -1);
            return new IndexingQueueEntry(in.queueEntry, in.documents, null);
        }
        ArrayList<Document> doclist = new ArrayList<Document>();
        for (Document document : in.documents) {
            if (profile2.noindexWhenCanonicalUnequalURL()) {
                String source_norm;
                String canonical_norm;
                AnchorURL canonical = document.getCanonical();
                DigestURL source = document.dc_source();
                if (canonical != null && source != null && !(canonical_norm = canonical.toNormalform(true)).equals(source_norm = source.toNormalform(true))) {
                    String info = "Not Condensed Resource '" + urls2 + "': denied, canonical != source; canonical = " + canonical_norm + "; source = " + source_norm;
                    if (this.log.isInfo()) {
                        this.log.info(info);
                    }
                    this.crawlQueues.errorURL.push(in.queueEntry.url(), in.queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, info, -1);
                    continue;
                }
            }
            if (document.indexingDenied() && profile2.obeyHtmlRobotsNoindex() && !this.isIntranetMode()) {
                if (this.log.isInfo()) {
                    this.log.info("Not Condensed Resource '" + urls2 + "': denied by document-attached noindexing rule");
                }
                this.crawlQueues.errorURL.push(in.queueEntry.url(), in.queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, "denied by document-attached noindexing rule", -1);
                continue;
            }
            Pattern mustmatchcontent = profile2.indexContentMustMatchPattern();
            if (mustmatchcontent != CrawlProfile.MATCH_ALL_PATTERN && !mustmatchcontent.matcher(document.getTextString()).matches()) {
                String info = "Not Condensed Resource '" + urls2 + "': indexing prevented by regular expression on content; indexContentMustMatchPattern = " + mustmatchcontent.pattern();
                if (this.log.isInfo()) {
                    this.log.info(info);
                }
                this.crawlQueues.errorURL.push(in.queueEntry.url(), in.queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, info, -1);
                continue;
            }
            Pattern mustnotmatchcontent = profile2.indexContentMustNotMatchPattern();
            if (mustnotmatchcontent != CrawlProfile.MATCH_NEVER_PATTERN && mustnotmatchcontent.matcher(document.getTextString()).matches()) {
                String info = "Not Condensed Resource '" + urls2 + "': indexing prevented by regular expression on content; indexContentMustNotMatchPattern = " + mustnotmatchcontent.pattern();
                if (this.log.isInfo()) {
                    this.log.info(info);
                }
                this.crawlQueues.errorURL.push(in.queueEntry.url(), in.queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, info, -1);
                continue;
            }
            Pattern mustMatchMediaType = profile2.getIndexMediaTypeMustMatchPattern();
            Pattern mustNotMatchMediaType = profile2.getIndexMediaTypeMustNotMatchPattern();
            if (mustMatchMediaType != CrawlProfile.MATCH_ALL_PATTERN && !mustMatchMediaType.matcher(document.dc_format()).matches() || mustNotMatchMediaType != CrawlProfile.MATCH_NEVER_PATTERN && mustNotMatchMediaType.matcher(document.dc_format()).matches()) {
                String failReason = "indexing prevented by regular expression on media type; indexContentMustMatchPattern = " + (Object)((Object)CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTMATCH) + " = " + mustMatchMediaType.pattern() + ", " + (Object)((Object)CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTNOTMATCH) + " = " + mustNotMatchMediaType.pattern();
                if (this.log.isInfo()) {
                    this.log.info("Not Condensed Resource '" + urls2 + " : " + failReason);
                }
                this.crawlQueues.errorURL.push(in.queueEntry.url(), in.queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, failReason, -1);
                continue;
            }
            doclist.add(document);
        }
        if (doclist.isEmpty()) {
            return new IndexingQueueEntry(in.queueEntry, in.documents, null);
        }
        in.documents = doclist.toArray(new Document[doclist.size()]);
        Condenser[] condenser = new Condenser[in.documents.length];
        for (int i = 0; i < in.documents.length; ++i) {
            condenser[i] = new Condenser(in.documents[i], in.queueEntry.profile().scraper(), in.queueEntry.profile().indexText(), in.queueEntry.profile().indexMedia(), LibraryProvider.dymLib, true, this.index.fulltext().getDefaultConfiguration().contains(CollectionSchema.dates_in_content_dts), profile2.timezoneOffset());
            ResultImages.registerImages(in.queueEntry.url(), in.documents[i], profile2 == null ? true : !profile2.remoteIndexing());
        }
        return new IndexingQueueEntry(in.queueEntry, in.documents, condenser);
    }

    public IndexingQueueEntry webStructureAnalysis(IndexingQueueEntry in) {
        in.queueEntry.updateStatus(3);
        for (Document document : in.documents) {
            assert (this.webStructure != null);
            assert (in != null);
            assert (in.queueEntry != null);
            assert (in.documents != null);
            assert (in.queueEntry != null);
            this.webStructure.generateCitationReference(in.queueEntry.url(), document);
        }
        return in;
    }

    public void storeDocumentIndex(IndexingQueueEntry in) {
        in.queueEntry.updateStatus(4);
        if (in.condenser != null) {
            for (int i = 0; i < in.documents.length; ++i) {
                CrawlProfile profile2 = in.queueEntry.profile();
                this.storeDocumentIndex(in.queueEntry, in.queueEntry.profile().collections(), in.documents[i], in.condenser[i], null, profile2 == null ? "crawler" : profile2.handle());
            }
        }
        in.queueEntry.updateStatus(5);
    }

    private void storeDocumentIndex(Response queueEntry, Map<String, Pattern> collections, Document document, Condenser condenser, SearchEvent searchEvent, String sourceName) {
        Seed initiatorPeer;
        String dc_title = document.dc_title();
        DigestURL url = document.dc_source();
        DigestURL referrerURL = queueEntry.referrerURL();
        ResultURLs.EventOrigin processCase = queueEntry.processCase(this.peers.mySeed().hash);
        if (this.crawler != null && queueEntry.profile() == this.crawler.defaultPackProfile) {
            processCase = ResultURLs.EventOrigin.PACKS;
        }
        CrawlProfile profile2 = queueEntry.profile();
        if (condenser == null || document.indexingDenied() && profile2.obeyHtmlRobotsNoindex()) {
            this.crawlQueues.errorURL.push(url, queueEntry.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, "denied by rule in document, process case=" + String.valueOf((Object)processCase), -1);
            return;
        }
        if (profile2 != null && !profile2.indexText() && !profile2.indexMedia()) {
            this.crawlQueues.errorURL.push(url, queueEntry.depth(), profile2, FailCategory.FINAL_LOAD_CONTEXT, "denied by profile rule, process case=" + String.valueOf((Object)processCase) + ", profile name = " + profile2.collectionName(), -1);
            return;
        }
        this.log.info("Excluded " + condenser.excludeWords(stopwords) + " words in URL " + url.toNormalform(true));
        CollectionConfiguration collectionConfig = this.index.fulltext().getDefaultConfiguration();
        String language = Segment.votedLanguage(url, url.toNormalform(true), document, condenser);
        CollectionConfiguration.SolrVector vector = collectionConfig.yacy2solr(this.index, collections, queueEntry.getResponseHeader(), document, condenser, referrerURL, language, profile2.isPushCrawlProfile(), this.index.fulltext().useWebgraph() ? this.index.fulltext().getWebgraphConfiguration() : null, sourceName);
        String profileSolrFilterError = this.checkCrawlProfileSolrFilters(profile2, vector);
        if (profileSolrFilterError != null) {
            this.crawlQueues.errorURL.push(url, queueEntry.depth(), profile2, FailCategory.FINAL_LOAD_CONTEXT, profileSolrFilterError + ", process case=" + String.valueOf((Object)processCase) + ", profile name = " + profile2.collectionName(), -1);
            return;
        }
        SolrInputDocument newEntry = this.index.storeDocument(url, profile2, queueEntry.getResponseHeader(), document, vector, language, condenser, searchEvent, sourceName, this.getConfigBool("network.unit.dht", false), this.getConfigBool("isTransparentProxy", false) ? "http://127.0.0.1:" + sb.getConfigInt("port", 8090) : null, this.getConfig("crawler.http.acceptLanguage", null));
        RSSFeed feed2 = EventChannel.channels(queueEntry.initiator() == null ? EventChannel.PROXY : (Base64Order.enhancedCoder.equal(queueEntry.initiator(), ASCII.getBytes(this.peers.mySeed().hash)) ? EventChannel.LOCALINDEXING : EventChannel.REMOTEINDEXING));
        feed2.addMessage(new RSSMessage("Indexed web page", dc_title, queueEntry.url(), ASCII.String(queueEntry.url().hash())));
        if (this.getConfigBool("decoration.audio", false)) {
            Audio.Soundclip.newdoc.play(-20.0f);
        }
        for (Map.Entry<DigestURL, String> rssEntry : document.getRSS().entrySet()) {
            Tables.Data rssRow = new Tables.Data();
            rssRow.put("referrer", url.hash());
            rssRow.put("url", UTF8.getBytes(rssEntry.getKey().toNormalform(true)));
            rssRow.put("title", UTF8.getBytes(rssEntry.getValue()));
            rssRow.put("recording_date", new Date());
            try {
                this.tables.update("rss", rssEntry.getKey().hash(), rssRow);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        ResultURLs.stack(ASCII.String(url.hash()), url.getHost(), queueEntry.initiator(), UTF8.getBytes(this.peers.mySeed().hash), processCase);
        if (System.currentTimeMillis() - lastPPMUpdate > 20000L) {
            this.updateMySeed();
            EventTracker.update(EventTracker.EClass.PPM, Switchboard.currentPPM(), true);
            lastPPMUpdate = System.currentTimeMillis();
        }
        EventTracker.update(EventTracker.EClass.INDEX, url.toNormalform(true), false);
        if (processCase == ResultURLs.EventOrigin.GLOBAL_CRAWLING && queueEntry.initiator() != null && (initiatorPeer = this.peers.getConnected(queueEntry.initiator())) != null) {
            try {
                SolrDocument sd = this.index.fulltext().getDefaultConfiguration().toSolrDocument(newEntry);
                new Thread((Runnable)new receiptSending(initiatorPeer, new URIMetadataNode(sd)), "sending receipt to " + ASCII.String(queueEntry.initiator())).start();
            }
            catch (MalformedURLException ex) {
                this.log.info("malformed url: " + ex.getMessage());
            }
        }
    }

    private String checkCrawlProfileSolrFilters(CrawlProfile profile2, CollectionConfiguration.SolrVector document) throws IllegalArgumentException {
        if (profile2 != null) {
            String indexFilterQuery = (String)profile2.get(CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTMATCH.key);
            String indexSolrQueryMustNotMatch = (String)profile2.get(CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTNOTMATCH.key);
            if (indexFilterQuery != null && !indexFilterQuery.isEmpty() && !"*:*".equals(indexFilterQuery) || indexSolrQueryMustNotMatch != null && !"".equals(indexSolrQueryMustNotMatch)) {
                boolean embeddedSolrConnected;
                EmbeddedInstance embeddedSolr = this.index.fulltext().getEmbeddedInstance();
                SolrCore embeddedCore = embeddedSolr != null ? embeddedSolr.getDefaultCore() : null;
                boolean bl = embeddedSolrConnected = embeddedSolr != null && embeddedCore != null;
                if (!embeddedSolrConnected) {
                    return "no connected embedded instance for profile Solr query filter";
                }
                if (indexFilterQuery != null && !indexFilterQuery.isEmpty() && !"*:*".equals(indexFilterQuery)) {
                    try {
                        if (!SingleDocumentMatcher.matches(document, indexFilterQuery, embeddedCore)) {
                            return "denied by profile Solr query must-match filter";
                        }
                    }
                    catch (SolrException | SyntaxError e) {
                        return "invalid syntax for profile Solr query must-match filter";
                    }
                    catch (RuntimeException e) {
                        return "could not parse the Solr query must-match filter";
                    }
                }
                if (indexSolrQueryMustNotMatch != null && !"".equals(indexSolrQueryMustNotMatch)) {
                    try {
                        if (SingleDocumentMatcher.matches(document, indexSolrQueryMustNotMatch, embeddedCore)) {
                            return "denied by profile Solr query must-not-match filter";
                        }
                    }
                    catch (SolrException | SyntaxError e) {
                        return "invalid syntax for profile Solr query must-not-match filter";
                    }
                    catch (RuntimeException e) {
                        return "could not parse the Solr query must-not-match filter";
                    }
                }
            }
        }
        return null;
    }

    public final void addAllToIndex(DigestURL url, Map<AnchorURL, String> links, SearchEvent searchEvent, String heuristicName, Map<String, Pattern> collections, boolean doublecheck) {
        ArrayList<DigestURL> urls2 = new ArrayList<DigestURL>();
        if (url != null) {
            urls2.add(url);
        }
        Map<AnchorURL, String> matcher = searchEvent.query.separateMatches(links);
        for (Map.Entry<AnchorURL, String> entry2 : matcher.entrySet()) {
            urls2.add(new DigestURL((MultiProtocolURL)entry2.getKey(), (byte[])null));
        }
        for (Map.Entry<AnchorURL, String> entry2 : links.entrySet()) {
            urls2.add(new DigestURL((MultiProtocolURL)entry2.getKey(), (byte[])null));
        }
        this.addToIndex(urls2, searchEvent, heuristicName, collections, doublecheck);
    }

    public void reload(Collection<String> reloadURLStrings, Map<String, Pattern> collections, boolean doublecheck) {
        ArrayList<DigestURL> reloadURLs = new ArrayList<DigestURL>(reloadURLStrings.size());
        ArrayList<String> deleteIDs = new ArrayList<String>(reloadURLStrings.size());
        for (String u : reloadURLStrings) {
            try {
                DigestURL url = new DigestURL(u);
                reloadURLs.add(url);
                deleteIDs.add(ASCII.String(url.hash()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.remove(deleteIDs);
        if (doublecheck) {
            this.index.fulltext().commit(false);
        }
        this.addToIndex(reloadURLs, null, null, collections, doublecheck);
    }

    public void remove(Collection<String> deleteIDs) {
        this.index.fulltext().remove(deleteIDs);
        for (String id : deleteIDs) {
            byte[] idh = ASCII.getBytes(id);
            this.crawlQueues.removeURL(idh);
            try {
                Cache.delete(idh);
            }
            catch (IOException iOException) {}
        }
    }

    public void remove(byte[] urlhash) {
        this.index.fulltext().remove(urlhash);
        this.crawlQueues.removeURL(urlhash);
        try {
            Cache.delete(urlhash);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stackURLs(Collection<DigestURL> rootURLs, final CrawlProfile profile2, final Set<DigestURL> successurls, final Map<DigestURL, String> failurls) {
        if (rootURLs == null || rootURLs.size() == 0) {
            return;
        }
        if (rootURLs.size() == 1) {
            DigestURL url = rootURLs.iterator().next();
            Switchboard.sb.robots.delete(url);
            try {
                if (url.getHost() != null) {
                    Cache.delete(RobotsTxt.robotsURL(RobotsTxt.getHostPort(url)).hash());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String failreason = this.stackUrl(profile2, url);
            if (failreason == null) {
                successurls.add(url);
            } else {
                failurls.put(url, failreason);
            }
            return;
        }
        int threads = Math.min(rootURLs.size(), Math.min(50, Runtime.getRuntime().availableProcessors() * 2 + 1));
        this.log.info("stackURLs: starting " + threads + " threads for " + rootURLs.size() + " root urls.");
        final ArrayBlockingQueue<DigestURL> rootURLsQueue = new ArrayBlockingQueue<DigestURL>(rootURLs.size());
        for (DigestURL u : rootURLs) {
            try {
                rootURLsQueue.put(u);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < threads; ++i) {
            final String name = "Switchboard.stackURLs-" + i + "-" + profile2.handle();
            Thread t = new Thread(name){

                @Override
                public void run() {
                    DigestURL url;
                    int successc = 0;
                    int failc = 0;
                    while ((url = (DigestURL)rootURLsQueue.poll()) != null) {
                        Switchboard.sb.robots.delete(url);
                        try {
                            if (url.getHost() != null) {
                                Cache.delete(RobotsTxt.robotsURL(RobotsTxt.getHostPort(url)).hash());
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        String failreason = Switchboard.this.stackUrl(profile2, url);
                        if (failreason == null) {
                            successurls.add(url);
                            ++successc;
                        } else {
                            failurls.put(url, failreason);
                            ++failc;
                        }
                        this.setName(name);
                    }
                    Switchboard.this.log.info("stackURLs: terminated stack thread " + name + " with " + successc + " success and " + failc + " fail stackings.");
                }
            };
            t.start();
        }
    }

    public String stackUrl(CrawlProfile profile2, DigestURL url) {
        BookmarksDB.Bookmark bookmark;
        Document scraper;
        byte[] handle = ASCII.getBytes(profile2.handle());
        byte[] urlhash = url.hash();
        this.remove(urlhash);
        int t = 100;
        while (t-- > 0 && this.index.exists(ASCII.String(urlhash))) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConcurrentLog.fine("Switchboard", "STACKURL: waiting for deletion, t=" + t);
            if (t != 1) continue;
            this.index.fulltext().commit(false);
        }
        if (url.isFTP()) {
            try {
                this.crawler.putActive(handle, profile2);
                this.crawlStacker.enqueueEntriesFTP(this.peers.mySeed().hash.getBytes(), profile2, url, false, profile2.timezoneOffset());
                return null;
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                return "problem crawling an ftp site: " + e.getMessage();
            }
        }
        HashSet<String> hosthashes = new HashSet<String>();
        hosthashes.add(url.hosthash());
        this.crawlQueues.errorURL.removeHosts(hosthashes);
        this.index.fulltext().remove(urlhash);
        try {
            scraper = this.loader.loadDocument(url, CacheStrategy.IFFRESH, Blacklist.BlacklistType.CRAWLER, profile2.getAgent());
        }
        catch (IOException e) {
            return "scraper cannot load URL: " + e.getMessage();
        }
        String title = scraper == null ? url.toNormalform(true) : scraper.dc_title();
        String description = scraper.dc_description().length > 0 ? scraper.dc_description()[0] : "";
        this.crawler.removePassive(handle);
        this.crawler.putActive(handle, profile2);
        String reasonString = this.crawlStacker.stackCrawl(new Request(this.peers.mySeed().hash.getBytes(), url, null, "CRAWLING-ROOT", new Date(), profile2.handle(), 0, profile2.timezoneOffset()));
        if (reasonString != null) {
            return reasonString;
        }
        Set<String> tags = ListManager.string2set(BookmarkHelper.cleanTagsString("/crawlStart"));
        tags.add("crawlStart");
        Set<String> keywords = scraper.dc_subject();
        if (keywords != null) {
            for (String k : keywords) {
                String kk = BookmarkHelper.cleanTagsString(k);
                if (kk.length() <= 0) continue;
                tags.add(kk);
            }
        }
        if ((bookmark = this.bookmarksDB.createorgetBookmark(url.toNormalform(true), "admin")) != null) {
            bookmark.setProperty("bookmarkTitle", title);
            bookmark.setProperty("bookmarkDesc", description);
            bookmark.setPublic(false);
            bookmark.setTags(tags, true);
            this.bookmarksDB.saveBookmark(bookmark);
        }
        return null;
    }

    public void addToIndex(Collection<DigestURL> urls2, final SearchEvent searchEvent, final String heuristicName, final Map<String, Pattern> collections, boolean doublecheck) {
        HashMap<String, DigestURL> urlmap = new HashMap<String, DigestURL>();
        for (DigestURL url : urls2) {
            urlmap.put(ASCII.String(url.hash()), url);
        }
        if (searchEvent != null) {
            for (String id : urlmap.keySet()) {
                searchEvent.addHeuristic(ASCII.getBytes(id), heuristicName, true);
            }
        }
        final ArrayList<Request> requests = new ArrayList<Request>();
        for (Map.Entry e : urlmap.entrySet()) {
            String urlName = ((DigestURL)e.getValue()).toNormalform(true);
            if (doublecheck && this.index.exists((String)e.getKey())) {
                this.log.info("addToIndex: double " + urlName);
                continue;
            }
            Request request = this.loader.request((DigestURL)e.getValue(), true, true);
            CrawlProfile profile2 = this.crawler.get(ASCII.getBytes(request.profileHandle()));
            String acceptedError = this.crawlStacker.checkAcceptanceChangeable((DigestURL)e.getValue(), profile2, 0);
            if (acceptedError != null) {
                this.log.warn("addToIndex: cannot load " + urlName + ": " + acceptedError);
                continue;
            }
            requests.add(request);
        }
        new Thread(){

            @Override
            public void run() {
                for (Request request : requests) {
                    DigestURL url = request.url();
                    String urlName = url.toNormalform(true);
                    Thread.currentThread().setName("Switchboard.addToIndex:" + urlName);
                    try {
                        Response response = Switchboard.this.loader.load(request, CacheStrategy.IFFRESH, Blacklist.BlacklistType.CRAWLER, ClientIdentification.yacyIntranetCrawlerAgent);
                        if (response == null) {
                            throw new IOException("response == null");
                        }
                        if (response.getContent() == null) {
                            throw new IOException("content == null");
                        }
                        if (response.getResponseHeader() == null) {
                            throw new IOException("header == null");
                        }
                        Document[] documents = response.parse();
                        if (documents == null) continue;
                        for (Document document : documents) {
                            CrawlProfile profile2 = Switchboard.this.crawler.get(ASCII.getBytes(request.profileHandle()));
                            if (document.indexingDenied() && (profile2 == null || profile2.obeyHtmlRobotsNoindex())) {
                                throw new Parser.Failure("indexing is denied", url);
                            }
                            Condenser condenser = new Condenser(document, null, true, true, LibraryProvider.dymLib, true, Switchboard.this.index.fulltext().getDefaultConfiguration().contains(CollectionSchema.dates_in_content_dts), searchEvent == null ? 0 : searchEvent.query.timezoneOffset);
                            ResultImages.registerImages(url, document, true);
                            Switchboard.this.webStructure.generateCitationReference(url, document);
                            Switchboard.this.storeDocumentIndex(response, collections, document, condenser, searchEvent, "heuristic:" + heuristicName);
                            Switchboard.this.log.info("addToIndex fill of url " + urlName + " finished");
                        }
                    }
                    catch (IOException e) {
                        Switchboard.this.log.warn("addToIndex: failed loading " + urlName + ": " + e.getMessage());
                    }
                    catch (Parser.Failure e) {
                        Switchboard.this.log.warn("addToIndex: failed parsing " + urlName + ": " + e.getMessage());
                    }
                }
            }
        }.start();
    }

    public void addToCrawler(Collection<DigestURL> urls2, boolean asglobal) {
        HashMap<String, DigestURL> urlmap = new HashMap<String, DigestURL>();
        for (DigestURL digestURL : urls2) {
            urlmap.put(ASCII.String(digestURL.hash()), digestURL);
        }
        for (Map.Entry entry2 : urlmap.entrySet()) {
            Request request;
            CrawlProfile profile2;
            if (this.index.exists((String)entry2.getKey())) continue;
            DigestURL url = (DigestURL)entry2.getValue();
            String acceptedError = this.crawlStacker.checkAcceptanceChangeable(url, profile2 = this.crawler.get(ASCII.getBytes((request = this.loader.request(url, true, true)).profileHandle())), 0);
            if (acceptedError == null) {
                acceptedError = this.crawlStacker.checkAcceptanceInitially(url, profile2);
            }
            if (acceptedError != null) {
                this.log.info("addToCrawler: cannot load " + url.toNormalform(true) + ": " + acceptedError);
                continue;
            }
            String s = asglobal ? this.crawlQueues.noticeURL.push(NoticedURL.StackType.GLOBAL, request, profile2, this.robots) : this.crawlQueues.noticeURL.push(NoticedURL.StackType.LOCAL, request, profile2, this.robots);
            if (s == null) continue;
            this.log.info("addToCrawler: failed to add " + url.toNormalform(true) + ": " + s);
        }
    }

    public int adminAuthenticated(RequestHeader requestHeader) {
        String realmValue;
        if (requestHeader.isUserInRole(UserDB.AccessRight.ADMIN_RIGHT.toString()) && this.adminAuthenticationLastAccess + 60000L > System.currentTimeMillis()) {
            return 4;
        }
        boolean accessFromLocalhost = requestHeader.accessFromLocalhost();
        if (accessFromLocalhost && this.getConfigBool("adminAccountForLocalhost", false)) {
            this.adminAuthenticationLastAccess = System.currentTimeMillis();
            return 3;
        }
        String realmProp = requestHeader.get("Authorization", "").trim();
        String string = realmValue = realmProp.isEmpty() ? null : realmProp.substring(6);
        if (realmValue == null || realmValue.isEmpty()) {
            return 1;
        }
        if ("BASIC".equalsIgnoreCase(requestHeader.getAuthType())) {
            if (realmValue.length() > 256) {
                return 0;
            }
        } else if (requestHeader.getUserPrincipal() != null && requestHeader.isUserInRole(UserDB.AccessRight.ADMIN_RIGHT.toString())) {
            this.adminAuthenticationLastAccess = System.currentTimeMillis();
            return 4;
        }
        String adminAccountUserName = this.getConfig("adminAccountUserName", "admin");
        String adminAccountBase64MD5 = this.getConfig("adminAccountBase64MD5", "");
        String pass = Base64Order.standardCoder.encodeString(adminAccountUserName + ":" + adminAccountBase64MD5);
        if (accessFromLocalhost && pass.equals(realmValue)) {
            this.adminAuthenticationLastAccess = System.currentTimeMillis();
            return 3;
        }
        if (this.userDB.hasAdminRight(requestHeader, requestHeader.getCookies())) {
            this.adminAuthenticationLastAccess = System.currentTimeMillis();
            return 4;
        }
        if (adminAccountBase64MD5.startsWith("MD5:")) {
            Object realmtmp = Base64Order.standardCoder.decodeString(realmValue);
            int i = ((String)realmtmp).indexOf(58);
            if (i >= 3) {
                realmtmp = ((String)realmtmp).substring(0, i + 1) + sb.getConfig("adminRealm", "YaCy") + ":" + ((String)realmtmp).substring(i + 1);
                if (adminAccountBase64MD5.substring(4).equals(Digest.encodeMD5Hex((String)realmtmp))) {
                    this.adminAuthenticationLastAccess = System.currentTimeMillis();
                    return 4;
                }
            } else if (adminAccountBase64MD5.equals(realmValue)) {
                this.adminAuthenticationLastAccess = System.currentTimeMillis();
                return 4;
            }
        } else if (adminAccountBase64MD5.equals(Digest.encodeMD5Hex(realmValue))) {
            this.adminAuthenticationLastAccess = System.currentTimeMillis();
            return 4;
        }
        return 1;
    }

    public String encodeDigestAuth(String user, String pw) {
        return "MD5:" + Digest.encodeMD5Hex(user + ":" + sb.getConfig("adminRealm", "YaCy") + ":" + pw);
    }

    public String encodeBasicAuth(String user, String pw) {
        return Digest.encodeMD5Hex(user + ":" + pw);
    }

    public boolean verifyAuthentication(RequestHeader header) {
        switch (this.adminAuthenticated(header)) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public String dhtShallTransfer() {
        String cautionCause = this.onlineCaution();
        if (cautionCause != null) {
            return "online caution for " + cautionCause + ", dht transmission";
        }
        if (this.peers == null) {
            return "no DHT distribution: seedDB == null";
        }
        if (this.peers.mySeed() == null) {
            return "no DHT distribution: mySeed == null";
        }
        if (this.peers.mySeed().isVirgin()) {
            return "no DHT distribution: status is virgin";
        }
        if (this.peers.noDHTActivity()) {
            return "no DHT distribution: network too small";
        }
        if (!this.getConfigBool("network.unit.dht", true)) {
            return "no DHT distribution: disabled by network.unit.dht";
        }
        if (this.getConfig("allowDistributeIndex", "false").equalsIgnoreCase("false")) {
            return "no DHT distribution: not enabled (per setting)";
        }
        Segment indexSegment = this.index;
        if (indexSegment.RWICount() < 100L) {
            return "no DHT distribution: not enough words - wordIndex.size() = " + indexSegment.RWICount();
        }
        if (this.getConfig("allowDistributeIndexWhileCrawling", "false").equalsIgnoreCase("false") && !this.crawlQueues.noticeURL.isEmptyLocal()) {
            return "no DHT distribution: crawl in progress: noticeURL.stackSize() = " + this.crawlQueues.noticeURL.size() + ", sbQueue.size() = " + this.getIndexingProcessorsQueueSize();
        }
        if (this.getConfig("allowDistributeIndexWhileIndexing", "false").equalsIgnoreCase("false") && this.getIndexingProcessorsQueueSize() > 1) {
            return "no DHT distribution: indexing in progress: noticeURL.stackSize() = " + this.crawlQueues.noticeURL.size() + ", sbQueue.size() = " + this.getIndexingProcessorsQueueSize();
        }
        return null;
    }

    public boolean dhtTransferJob() {
        if (this.dhtDispatcher == null) {
            return false;
        }
        String rejectReason = this.dhtShallTransfer();
        if (rejectReason != null) {
            if (this.log.isFine()) {
                this.log.fine(rejectReason);
            }
            return false;
        }
        boolean hasDoneSomething = false;
        long kbytesUp = ConnectionInfo.getActiveUpbytes() / 1024L;
        if (this.dhtDispatcher.bufferSize() > this.peers.scheme.verticalPartitions()) {
            this.log.fine("dhtTransferJob: no selection, too many entries in transmission buffer: " + this.dhtDispatcher.bufferSize());
        } else if (MemoryControl.available() < 0x1900000L) {
            this.log.info("dhtTransferJob: no selection, too less memory available : " + MemoryControl.available() / 1024L / 1024L + " MB");
        } else if (ConnectionInfo.getLoadPercent() > 50) {
            this.log.info("dhtTransferJob: too many connections in httpc pool : " + ConnectionInfo.getCount());
        } else if (kbytesUp > 128L) {
            this.log.info("dhtTransferJob: too much upload(1), currently uploading: " + kbytesUp + " Kb");
        } else {
            byte[] startHash = null;
            byte[] limitHash = null;
            int tries = 10;
            while (tries-- > 0) {
                startHash = DHTSelection.selectRandomTransferStart();
                assert (startHash != null);
                limitHash = DHTSelection.limitOver(this.peers, startHash);
                if (limitHash == null) continue;
            }
            if (limitHash == null || startHash == null) {
                this.log.info("dhtTransferJob: approaching full DHT dispersion.");
                return false;
            }
            this.log.info("dhtTransferJob: selected " + ASCII.String(startHash) + " as start hash");
            this.log.info("dhtTransferJob: selected " + ASCII.String(limitHash) + " as limit hash");
            boolean enqueued = this.dhtDispatcher.selectContainersEnqueueToBuffer(startHash, limitHash, 500, this.dhtMaxReferenceCount, 5000);
            hasDoneSomething |= enqueued;
            this.log.fine("dhtTransferJob: result from enqueueing: " + (enqueued ? "true" : "false"));
        }
        if (this.dhtDispatcher.transmissionSize() >= 10) {
            this.log.info("dhtTransferJob: no dequeueing from buffer to transmission: too many concurrent sessions: " + this.dhtDispatcher.transmissionSize());
        } else if (ConnectionInfo.getLoadPercent() > 75) {
            this.log.info("dhtTransferJob: too many connections in httpc pool : " + ConnectionInfo.getCount());
        } else if (kbytesUp > 256L) {
            this.log.info("dhtTransferJob: too much upload(2), currently uploading: " + kbytesUp + " Kb");
        } else {
            boolean dequeued = this.dhtDispatcher.dequeueContainer();
            hasDoneSomething |= dequeued;
            this.log.fine("dhtTransferJob: result from dequeueing: " + (dequeued ? "true" : "false"));
        }
        return hasDoneSomething;
    }

    public final void heuristicSite(final SearchEvent searchEvent, final String host) {
        new Thread("Switchboard.heuristicSite:" + host){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AnchorURL url;
                Object r = host;
                if (((String)r).indexOf("//", 0) < 0) {
                    r = "http://" + (String)r;
                }
                try {
                    url = new AnchorURL((String)r);
                }
                catch (MalformedURLException e) {
                    ConcurrentLog.logException(e);
                    return;
                }
                searchEvent.oneFeederStarted();
                try {
                    Map<AnchorURL, String> links = Switchboard.this.loader.loadLinks(url, CacheStrategy.NOCACHE, Blacklist.BlacklistType.SEARCH, ClientIdentification.yacyIntranetCrawlerAgent, searchEvent.query.timezoneOffset);
                    if (links != null) {
                        Iterator<AnchorURL> i = links.keySet().iterator();
                        while (i.hasNext()) {
                            if (i.next().getHost().endsWith(host)) continue;
                            i.remove();
                        }
                        Switchboard.this.addAllToIndex(url, links, searchEvent, "site", CrawlProfile.collectionParser("site"), true);
                    }
                }
                catch (Throwable e) {
                    ConcurrentLog.logException(e);
                }
                finally {
                    searchEvent.oneFeederTerminated();
                }
            }
        }.start();
    }

    public final void heuristicSearchResults(final URIMetadataNode resulturl) {
        new Thread("Switchboard.heuristicSearchResults"){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                startUrl = resulturl.url();
                outlinkit = URIMetadataNode.getLinks(resulturl, false);
                if (outlinkit.hasNext()) {
                    urls = new HashSet<DigestURL>();
                    while (outlinkit.hasNext()) {
                        try {
                            urls.add(new DigestURL(outlinkit.next()));
                        }
                        catch (MalformedURLException var4_4) {}
                    }
                } else {
                    urls = null;
                    try {
                        links = Switchboard.this.loader.loadLinks(startUrl, CacheStrategy.IFFRESH, Blacklist.BlacklistType.SEARCH, ClientIdentification.yacyIntranetCrawlerAgent, 0);
                        if (links == null || links.size() >= 1000) ** GOTO lbl30
                        i = links.keySet().iterator();
                        if (urls == null) {
                            urls = new HashSet<E>();
                        }
                        while (i.hasNext()) {
                            url = i.next();
                            islocal = url.getHost() == null && startUrl.getHost() == null || url.getHost() != null && startUrl.getHost() != null && url.getHost().contentEquals(startUrl.getHost()) != false;
                            if (islocal) continue;
                            urls.add(url);
                        }
                    }
                    catch (Throwable links) {
                        // empty catch block
                    }
                }
lbl30:
                // 4 sources

                if (urls != null && urls.size() > 0) {
                    globalcrawljob = Switchboard.this.getConfigBool("heuristic.searchresults.crawlglobal", false);
                    Switchboard.this.addToCrawler(urls, globalcrawljob);
                }
            }
        }.start();
    }

    @Deprecated
    public final void heuristicRSS(final String urlpattern, final SearchEvent searchEvent, final String feedName) {
        new Thread("heuristicRSS:" + feedName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DigestURL url;
                try {
                    url = new DigestURL(MultiProtocolURL.unescape(urlpattern));
                }
                catch (MalformedURLException e1) {
                    ConcurrentLog.warn("heuristicRSS", "url not well-formed: '" + urlpattern + "'");
                    return;
                }
                RSSReader rss = null;
                searchEvent.oneFeederStarted();
                try {
                    Response response = Switchboard.this.loader.load(Switchboard.this.loader.request(url, true, false), CacheStrategy.NOCACHE, Blacklist.BlacklistType.SEARCH, ClientIdentification.yacyIntranetCrawlerAgent);
                    byte[] resource = response == null ? null : response.getContent();
                    RSSReader rSSReader = rss = resource == null ? null : RSSReader.parse(10000, resource);
                    if (rss != null) {
                        TreeMap<AnchorURL, String> links = new TreeMap<AnchorURL, String>();
                        for (RSSMessage message2 : rss.getFeed()) {
                            try {
                                AnchorURL uri = new AnchorURL(message2.getLink());
                                links.put(uri, message2.getTitle());
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                        ConcurrentLog.info("heuristicRSS", "Heuristic: adding " + links.size() + " links from '" + feedName + "' rss feed");
                        Switchboard.this.addAllToIndex(null, links, searchEvent, feedName, CrawlProfile.collectionParser("rss"), true);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    searchEvent.oneFeederTerminated();
                }
            }
        }.start();
    }

    public static int currentPPM() {
        return EventTracker.countEvents(EventTracker.EClass.INDEX, 20000L) * 3;
    }

    public float averageQPM() {
        long uptime = (System.currentTimeMillis() - this.startupTime) / 1000L;
        return ((float)this.searchQueriesRobinsonFromRemote + this.searchQueriesGlobal) * 60.0f / Math.max((float)uptime, 1.0f);
    }

    public float averageQPMGlobal() {
        long uptime = (System.currentTimeMillis() - this.startupTime) / 1000L;
        return this.searchQueriesGlobal * 60.0f / Math.max((float)uptime, 1.0f);
    }

    public float averageQPMPrivateLocal() {
        long uptime = (System.currentTimeMillis() - this.startupTime) / 1000L;
        return (float)this.searchQueriesRobinsonFromLocal * 60.0f / Math.max((float)uptime, 1.0f);
    }

    public float averageQPMPublicLocal() {
        long uptime = (System.currentTimeMillis() - this.startupTime) / 1000L;
        return (float)this.searchQueriesRobinsonFromRemote * 60.0f / Math.max((float)uptime, 1.0f);
    }

    public void updateMySeed() {
        Set<String> publicips;
        String staticIP;
        this.peers.mySeed().put("Port", Integer.toString(this.getPublicPort("port", 8090)));
        long uptime = (System.currentTimeMillis() - this.startupTime) / 1000L;
        Seed mySeed = this.peers.mySeed();
        mySeed.put("ISpeed", Integer.toString(Switchboard.currentPPM()));
        mySeed.put("RSpeed", Float.toString(this.averageQPM()));
        mySeed.put("Uptime", Long.toString(uptime / 60L));
        long t = System.currentTimeMillis();
        if (t - indexSizeTime > 60000L) {
            indeSizeCache = Switchboard.sb.index.fulltext().collectionSize();
            indexSizeTime = t;
        }
        mySeed.put("LCount", Long.toString(indeSizeCache));
        mySeed.put("NCount", Integer.toString(this.crawlQueues.noticeURL.size()));
        mySeed.put("RCount", Integer.toString(this.crawlQueues.noticeURL.stackSize(NoticedURL.StackType.GLOBAL)));
        mySeed.put("ICount", Long.toString(this.index.RWICount()));
        mySeed.put("SCount", Integer.toString(this.peers.sizeConnected()));
        mySeed.put("CCount", Float.toString((float)((int)((float)(this.peers.sizeConnected() + this.peers.sizeDisconnected() + this.peers.sizePotential()) * 60.0f / ((float)uptime + 1.01f))) * 100.0f / 100.0f));
        mySeed.put("Version", yacyBuildProperties.getReleaseStub());
        mySeed.setFlagDirectConnect(true);
        mySeed.setLastSeenUTC();
        mySeed.put("UTC", GenericFormatter.UTCDiffString());
        mySeed.setFlagAcceptRemoteCrawl(this.getConfigBool("crawlResponse", false));
        mySeed.setFlagAcceptRemoteIndex(this.getConfigBool("allowReceiveIndex", true));
        mySeed.setFlagSSLAvailable(this.getHttpServer() != null && this.getHttpServer().withSSL() && this.getConfigBool("server.https", false));
        if (mySeed.getFlagSSLAvailable()) {
            mySeed.put("PortSSL", Integer.toString(this.getPublicPort("port.ssl", 8443)));
        }
        if ((staticIP = this.getConfig("staticIP", "")).length() > 0) {
            mySeed.setIP(staticIP);
        }
        if (!mySeed.clash(publicips = this.myPublicIPs())) {
            mySeed.setIPs(publicips);
        }
    }

    public void loadSeedLists() {
        String seedListFileURL;
        int sc = this.peers.sizeConnected();
        Network.log.info("BOOTSTRAP: " + sc + " seeds known from previous run, concurrently starting seedlist loader");
        AtomicInteger scc = new AtomicInteger(0);
        int c = 0;
        while (!Thread.currentThread().isInterrupted() && !(seedListFileURL = this.getConfig("network.unit.bootstrap.seedlist" + c, "")).isEmpty()) {
            ++c;
            if (!seedListFileURL.startsWith("http://") && !seedListFileURL.startsWith("https://")) continue;
            this.peers.loadSeedListConcurrently(seedListFileURL, scc, (int)this.getConfigLong("bootstrapLoadTimeout", 20000L), c > 0);
        }
    }

    public void initRemoteProxy() {
        int port;
        String host = this.getConfig("remoteProxyHost", "").trim();
        try {
            port = Integer.parseInt(this.getConfig("remoteProxyPort", "3128"));
        }
        catch (NumberFormatException e) {
            port = 3128;
        }
        ProxySettings.port = port;
        ProxySettings.host = host;
        ProxySettings.setProxyUse4HTTP(ProxySettings.host != null && ProxySettings.host.length() > 0 && this.getConfigBool("remoteProxyUse", false));
        ProxySettings.setProxyUse4HTTPS(this.getConfig("remoteProxyUse4SSL", "true").equalsIgnoreCase("true"));
        ProxySettings.user = this.getConfig("remoteProxyUser", "").trim();
        ProxySettings.password = this.getConfig("remoteProxyPwd", "").trim();
        String remoteProxyNoProxy = this.getConfig("remoteProxyNoProxy", "").trim();
        ProxySettings.noProxy = CommonPattern.COMMA.split(remoteProxyNoProxy);
        int i = 0;
        for (String pattern : ProxySettings.noProxy) {
            ProxySettings.noProxy[i] = pattern.trim();
            ++i;
        }
    }

    public void checkInterruption() throws InterruptedException {
        Thread curThread = Thread.currentThread();
        if (curThread instanceof WorkflowThread && ((WorkflowThread)((Object)curThread)).shutdownInProgress()) {
            throw new InterruptedException("Shutdown in progress ...");
        }
        if (this.terminate || curThread.isInterrupted()) {
            throw new InterruptedException("Shutdown in progress ...");
        }
    }

    public void terminate(long delay, String reason) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("The shutdown delay must be greater than 0.");
        }
        this.log.info("caught delayed terminate request: " + reason);
        new Shutdown(this, delay, reason).start();
    }

    public boolean shallTerminate() {
        return this.terminate;
    }

    public void terminate(String reason) {
        this.terminate = true;
        this.log.info("caught terminate request: " + reason);
        this.tray.setShutdown();
        this.shutdownSync.release();
    }

    public boolean isTerminated() {
        return this.terminate;
    }

    public boolean waitForShutdown() throws InterruptedException {
        final int shutdownPort = this.getConfigInt("port.shutdown", 0);
        if (shutdownPort > 0) {
            Thread shutdownThread = new Thread("Switchboard.waitForShutdown"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ServerSocket ss = null;
                    try {
                        while (true) {
                            Socket shSocket;
                            InputStream in;
                            BufferedReader inreader;
                            String cmd;
                            if ((cmd = (inreader = new BufferedReader(new InputStreamReader(in = (shSocket = (ss = new ServerSocket(shutdownPort, 0, InetAddress.getLoopbackAddress())).accept()).getInputStream()))).readLine()) != null && !cmd.isEmpty()) {
                                if (cmd.contains("shutdown")) {
                                    if (cmd.contains("HTTP")) {
                                        OutputStream out = shSocket.getOutputStream();
                                        out.write(UTF8.getBytes("HTTP/1.1 200 OK"));
                                        out.write(serverCore.CRLF);
                                        out.close();
                                    }
                                    ss.close();
                                    Switchboard.this.terminate("shutdown signal received on shutdown port");
                                } else if (cmd.contains("restart")) {
                                    if (cmd.contains("HTTP")) {
                                        OutputStream out = shSocket.getOutputStream();
                                        out.write(UTF8.getBytes("HTTP/1.1 200 OK"));
                                        out.write(serverCore.CRLF);
                                        out.close();
                                    }
                                    ss.close();
                                    yacyRelease.restart();
                                }
                                break;
                            }
                            ss.close();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (ss != null) {
                            try {
                                ss.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            };
            shutdownThread.start();
        }
        this.shutdownSync.acquire();
        return this.terminate;
    }

    static {
        indeSizeCache = 0L;
        indexSizeTime = 0L;
    }

    public class receiptSending
    implements Runnable {
        private final Seed initiatorPeer;
        private final URIMetadataNode reference;

        public receiptSending(Seed initiatorPeer, URIMetadataNode reference) {
            this.initiatorPeer = initiatorPeer;
            this.reference = reference;
        }

        @Override
        public void run() {
            long t = System.currentTimeMillis();
            Map<String, String> response = Protocol.crawlReceipt(Switchboard.this, Switchboard.this.peers.mySeed(), this.initiatorPeer, "crawl", "fill", "indexed", this.reference, "");
            if (response == null) {
                Switchboard.this.log.info("Sending crawl receipt for '" + this.reference.url().toNormalform(true) + "' to " + this.initiatorPeer.getName() + " FAILED, send time = " + (System.currentTimeMillis() - t));
                return;
            }
            String delay = response.get("delay");
            Switchboard.this.log.info("Sending crawl receipt for '" + this.reference.url().toNormalform(true) + "' to " + this.initiatorPeer.getName() + " success, delay = " + delay + ", send time = " + (System.currentTimeMillis() - t));
        }
    }
}

