/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.peers.NewsDB;
import net.yacy.peers.NewsQueue;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;

public class NewsPool {
    public static final int INCOMING_DB = 0;
    public static final int PROCESSED_DB = 1;
    public static final int OUTGOING_DB = 2;
    public static final int PUBLISHED_DB = 3;
    public static final String CATEGORY_PROFILE_UPDATE = "prfleupd";
    public static final String CATEGORY_PROFILE_BROADCAST = "prflecst";
    private static final String CATEGORY_PROFILE_VOTE_GOOD = "prflegvt";
    private static final String CATEGORY_PROFILE_VOTE_BAD = "prflebvt";
    public static final String CATEGORY_CRAWL_START = "crwlstrt";
    private static final String CATEGORY_CRAWL_STOP = "crwlstop";
    private static final String CATEGORY_CRAWL_COMMENT = "crwlcomm";
    private static final String CATEGORY_BLACKLIST_ADD = "blckladd";
    private static final String CATEGORY_BLACKLIST_VOTE_ADD = "blcklavt";
    private static final String CATEGORY_BLACKLIST_DELETE = "blckldel";
    private static final String CATEGORY_BLACKLIST_VOTE_DEL = "blckldvt";
    private static final String CATEGORY_FILESHARE_ADD = "flshradd";
    private static final String CATEGORY_FILESHARE_DEL = "flshrdel";
    private static final String CATEGORY_FILESHARE_COMMENT = "flshrcom";
    public static final String CATEGORY_BOOKMARK_ADD = "bkmrkadd";
    private static final String CATEGORY_BOOKMARK_VOTE_ADD = "bkmrkavt";
    private static final String CATEGORY_BOOKMARK_MOVE = "bkmrkmov";
    private static final String CATEGORY_BOOKMARK_VOTE_MOVE = "bkmrkmvt";
    private static final String CATEGORY_BOOKMARK_DEL = "bkmrkdel";
    private static final String CATEGORY_BOOKMARK_VOTE_DEL = "bkmrkdvt";
    public static final String CATEGORY_SURFTIPP_ADD = "stippadd";
    public static final String CATEGORY_SURFTIPP_VOTE_ADD = "stippavt";
    public static final String CATEGORY_WIKI_UPDATE = "wiki_upd";
    private static final String CATEGORY_WIKI_DEL = "wiki_del";
    public static final String CATEGORY_BLOG_ADD = "blog_add";
    private static final String CATEGORY_BLOG_DEL = "blog_del";
    public static final String CATEGORY_TRANSLATION_ADD = "transadd";
    public static final String CATEGORY_TRANSLATION_VOTE_ADD = "transavt";
    private static final String[] category = new String[]{"prfleupd", "prflecst", "prflegvt", "prflebvt", "crwlstrt", "crwlstop", "crwlcomm", "blckladd", "blcklavt", "blckldel", "blckldvt", "flshradd", "flshrdel", "flshrcom", "bkmrkadd", "bkmrkavt", "bkmrkmov", "bkmrkmvt", "bkmrkdel", "bkmrkdvt", "stippadd", "stippavt", "wiki_upd", "wiki_del", "blog_add", "blog_del", "transadd", "transavt"};
    private static final Set<String> categories = new HashSet<String>();
    private static final long MILLISECONDS_PER_HOUR = 3600000L;
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private final NewsDB newsDB;
    private final NewsQueue outgoingNews;
    private final NewsQueue publishedNews;
    private final NewsQueue incomingNews;
    private final NewsQueue processedNews;
    private final int maxDistribution;

    public NewsPool(File yacyDBPath, boolean useTailCache, boolean exceed134217727) {
        this.newsDB = new NewsDB(new File(yacyDBPath, "news1024.db"), 1024, useTailCache, exceed134217727);
        this.outgoingNews = new NewsQueue(new File(yacyDBPath, "newsOut.table"), this.newsDB);
        this.publishedNews = new NewsQueue(new File(yacyDBPath, "newsPublished.table"), this.newsDB);
        this.incomingNews = new NewsQueue(new File(yacyDBPath, "newsIn.table"), this.newsDB);
        this.processedNews = new NewsQueue(new File(yacyDBPath, "newsProcessed.table"), this.newsDB);
        this.maxDistribution = 30;
    }

    public synchronized void close() {
        this.newsDB.close();
        this.outgoingNews.close();
        this.publishedNews.close();
        this.incomingNews.close();
        this.processedNews.close();
    }

    public Iterator<NewsDB.Record> recordIterator(int dbKey) {
        NewsQueue queue = this.switchQueue(dbKey);
        return queue.iterator();
    }

    public NewsDB.Record parseExternal(String external) {
        return this.newsDB.newRecord(external);
    }

    public void publishMyNews(Seed mySeed, String category, Map<String, String> attributes) {
        this.publishMyNews(this.newsDB.newRecord(mySeed, category, attributes));
    }

    public void publishMyNews(Seed mySeed, String category, Properties attributes) {
        this.publishMyNews(this.newsDB.newRecord(mySeed, category, attributes));
    }

    private void publishMyNews(NewsDB.Record record) {
        if (record == null) {
            return;
        }
        try {
            if (this.newsDB.get(record.id()) == null) {
                this.incomingNews.push(record);
                this.outgoingNews.push(record);
            } else {
                ConcurrentLog.info("NewsPool", "publishing of news aborted, news with same id (time + originator) exists id=" + record.id());
            }
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }

    public NewsDB.Record myPublication() throws IOException, SpaceExceededException {
        if (this.outgoingNews.isEmpty()) {
            return null;
        }
        NewsDB.Record record = this.outgoingNews.pop();
        if (record == null) {
            return null;
        }
        record.incDistribution();
        if (record.distributed() >= this.maxDistribution) {
            this.publishedNews.push(record);
        } else {
            this.outgoingNews.push(record);
        }
        return record;
    }

    public void enqueueIncomingNews(NewsDB.Record record) throws IOException, SpaceExceededException {
        if (record.id() == null) {
            return;
        }
        if (record.id().length() != NewsDB.idLength) {
            return;
        }
        if (record.category() == null) {
            return;
        }
        if (!categories.contains(record.category())) {
            return;
        }
        if (record.created().getTime() == 0L) {
            return;
        }
        Map<String, String> attributes = record.attributes();
        if (attributes.containsKey("url") && Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.NEWS, new DigestURL(attributes.get("url")))) {
            System.out.println("DEBUG: ignored news-entry url blacklisted: " + attributes.get("url"));
            return;
        }
        if (attributes.containsKey("startURL") && Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.NEWS, new DigestURL(attributes.get("startURL")))) {
            System.out.println("DEBUG: ignored news-entry url blacklisted: " + attributes.get("startURL"));
            return;
        }
        if (this.newsDB.get(record.id()) != null) {
            return;
        }
        this.incomingNews.push(record);
    }

    public int size(int dbKey) {
        return this.switchQueue(dbKey).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int automaticProcess(SeedDB seedDB) throws IOException, InterruptedException, SpaceExceededException {
        int pc = 0;
        NewsQueue newsQueue = this.incomingNews;
        synchronized (newsQueue) {
            Iterator<NewsDB.Record> i = this.incomingNews.iterator();
            HashSet<String> removeIDs = new HashSet<String>();
            long start = System.currentTimeMillis();
            while (i.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Shutdown in progress");
                }
                NewsDB.Record record = i.next();
                if (NewsPool.automaticProcessP(seedDB, record)) {
                    this.processedNews.push(record);
                    removeIDs.add(record.id());
                    ++pc;
                }
                if (System.currentTimeMillis() - start <= 100L) continue;
            }
            for (String id : removeIDs) {
                NewsDB.Record deletedRecord = this.incomingNews.remove(id);
                assert (deletedRecord != null);
            }
        }
        return pc;
    }

    private static boolean automaticProcessP(SeedDB seedDB, NewsDB.Record record) {
        String cat;
        if (record == null) {
            return false;
        }
        if (record.category() == null) {
            return true;
        }
        long created = record.created().getTime();
        long duration = System.currentTimeMillis() - created;
        switch (cat = record.category()) {
            case "wiki_upd": 
            case "blog_add": 
            case "prfleupd": {
                if (duration <= 259200000L) break;
                return true;
            }
            case "crwlstrt": {
                if (duration <= 259200000L) break;
                Seed seed = seedDB.get(record.originator());
                if (seed == null) {
                    return true;
                }
                try {
                    return Integer.parseInt(seed.get("ISpeed", "-")) < 10;
                }
                catch (NumberFormatException ee) {
                    return true;
                }
            }
            case "transadd": 
            case "transavt": {
                if (duration <= 604800000L) break;
                return true;
            }
            default: {
                if (duration <= 86400000L) break;
                return true;
            }
        }
        return false;
    }

    public synchronized NewsDB.Record getSpecific(int dbKey, String category, String key, String value) {
        NewsQueue queue = this.switchQueue(dbKey);
        for (NewsDB.Record record : queue) {
            String s;
            if (record == null || !record.category().equals(category) || (s = record.attributes().get(key)) == null || !s.equals(value)) continue;
            return record;
        }
        return null;
    }

    public synchronized NewsDB.Record getByOriginator(int dbKey, String category, String originatorHash) {
        NewsQueue queue = this.switchQueue(dbKey);
        for (NewsDB.Record record : queue) {
            if (record == null || !record.category().equals(category) || !record.originator().equals(originatorHash)) continue;
            return record;
        }
        return null;
    }

    public synchronized NewsDB.Record getByID(int dbKey, String id) {
        switch (dbKey) {
            case 0: {
                return this.incomingNews.get(id);
            }
            case 1: {
                return this.processedNews.get(id);
            }
            case 2: {
                return this.outgoingNews.get(id);
            }
            case 3: {
                return this.publishedNews.get(id);
            }
        }
        return null;
    }

    private NewsQueue switchQueue(int dbKey) {
        switch (dbKey) {
            case 0: {
                return this.incomingNews;
            }
            case 1: {
                return this.processedNews;
            }
            case 2: {
                return this.outgoingNews;
            }
            case 3: {
                return this.publishedNews;
            }
        }
        return null;
    }

    public void clear(int dbKey) {
        switch (dbKey) {
            case 0: {
                this.incomingNews.clear();
                break;
            }
            case 1: {
                this.processedNews.clear();
                break;
            }
            case 2: {
                this.outgoingNews.clear();
                break;
            }
            case 3: {
                this.publishedNews.clear();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void moveOff(int dbKey, String id) throws IOException, SpaceExceededException {
        switch (dbKey) {
            case 0: {
                this.moveOff(this.incomingNews, this.processedNews, id);
                break;
            }
            case 1: {
                this.moveOff(this.processedNews, null, id);
                break;
            }
            case 2: {
                this.moveOff(this.outgoingNews, this.publishedNews, id);
                break;
            }
            case 3: {
                this.moveOff(this.publishedNews, null, id);
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean moveOff(NewsQueue fromqueue, NewsQueue toqueue, String id) throws IOException, SpaceExceededException {
        NewsDB.Record record = fromqueue.remove(id);
        if (record == null) {
            return false;
        }
        if (toqueue != null) {
            toqueue.push(record);
        } else if (this.incomingNews.get(id) == null && this.processedNews.get(id) == null && this.outgoingNews.get(id) == null && this.publishedNews.get(id) == null) {
            this.newsDB.remove(id);
        }
        return true;
    }

    public void moveOffAll(int dbKey) throws IOException, SpaceExceededException {
        switch (dbKey) {
            case 0: {
                NewsPool.moveOffAll(this.incomingNews, this.processedNews);
                break;
            }
            case 1: {
                this.processedNews.clear();
                break;
            }
            case 2: {
                NewsPool.moveOffAll(this.outgoingNews, this.publishedNews);
                break;
            }
            case 3: {
                this.publishedNews.clear();
            }
        }
    }

    private static int moveOffAll(NewsQueue fromqueue, NewsQueue toqueue) throws IOException, SpaceExceededException {
        Iterator<NewsDB.Record> i = fromqueue.iterator();
        if (toqueue == null) {
            return 0;
        }
        int c = 0;
        while (i.hasNext()) {
            NewsDB.Record record = i.next();
            if (record == null) continue;
            toqueue.push(record);
            ++c;
        }
        fromqueue.clear();
        return c;
    }

    static {
        categories.addAll(Arrays.asList(category));
    }
}

