/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.yacy.kelondro.util.FileUtils;

public class XMLTables {
    private Map<String, Map<String, String>> tables;
    private File propFile;
    private long timestamp;

    public XMLTables() {
        this.propFile = null;
        this.timestamp = System.currentTimeMillis();
        this.tables = new HashMap<String, Map<String, String>>();
    }

    public XMLTables(File file) throws IOException {
        this.propFile = file;
        this.timestamp = System.currentTimeMillis();
        if (this.propFile.exists()) {
            try (XMLDecoder xmldec = new XMLDecoder(new FileInputStream(this.propFile));){
                this.tables = (HashMap)xmldec.readObject();
            }
        } else {
            this.tables = new HashMap<String, Map<String, String>>();
        }
    }

    public void commit(File target) throws IOException {
        this.propFile = target;
        this.commit(true);
    }

    private void commit(boolean force) throws IOException {
        if (force || System.currentTimeMillis() - this.timestamp > 10000L) {
            if (this.propFile == null) {
                throw new RuntimeException("Microtables.commit: no file specified");
            }
            File tmpFile = new File(this.propFile.toString() + ".prt");
            try (XMLEncoder xmlenc = new XMLEncoder(new FileOutputStream(tmpFile));){
                xmlenc.writeObject(this.tables);
            }
            FileUtils.deletedelete(this.propFile);
            tmpFile.renameTo(this.propFile);
            this.timestamp = System.currentTimeMillis();
        }
    }

    public boolean hasTable(String table) {
        return this.tables.get(table) != null;
    }

    public int sizeTable(String table) {
        Map<String, String> l = this.tables.get(table);
        if (l == null) {
            return -1;
        }
        return l.size();
    }

    public void createTable(String table) throws IOException {
        Map<String, String> l = this.tables.get(table);
        if (l != null) {
            return;
        }
        this.tables.put(table, new HashMap());
        if (this.propFile != null) {
            this.commit(false);
        }
    }

    public void set(String table, String key, String value) throws IOException {
        if (table != null) {
            Map<String, String> l = this.tables.get(table);
            if (l == null) {
                throw new RuntimeException("Microtables.set: table does not exist");
            }
            if (value == null) {
                value = "";
            }
            l.put(key, value);
        }
        if (this.propFile != null) {
            this.commit(false);
        }
    }

    public String get(String table, String key, String deflt) {
        if (table != null) {
            Map<String, String> l = this.tables.get(table);
            if (l == null) {
                throw new RuntimeException("Microtables.get: table does not exist");
            }
            if (!l.containsKey(key)) {
                return deflt;
            }
            return l.get(key);
        }
        return null;
    }

    public boolean has(String table, String key) {
        if (table != null) {
            Map<String, String> l = this.tables.get(table);
            if (l == null) {
                throw new RuntimeException("Microtables.has: table does not exist");
            }
            return l.containsKey(key);
        }
        return false;
    }

    public Iterator<String> keys(String table) {
        if (table != null) {
            Map<String, String> l = this.tables.get(table);
            if (l == null) {
                throw new RuntimeException("Microtables.keys: table does not exist");
            }
            return l.keySet().iterator();
        }
        return null;
    }

    public synchronized void close() throws IOException {
        this.commit(true);
    }
}

