/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.util.concurrent.atomic.AtomicBoolean;
import net.yacy.cora.util.Memory;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.MemoryStrategy;

public class StandardMemoryStrategy
extends MemoryStrategy {
    private final long[] gcs = new long[5];
    private int gcs_pos = 0;
    private long properByte = 0L;
    private long prevTreshold = 0L;
    private int tresholdCount = 0;
    private boolean proper = true;

    public StandardMemoryStrategy() {
        name = "Standard Memory Strategy";
        error = false;
    }

    @Override
    protected final synchronized boolean gc(int last, String info) {
        assert (last >= 10000);
        long elapsed = System.currentTimeMillis() - lastGC;
        if (elapsed > (long)last) {
            long before = this.free();
            long start = System.currentTimeMillis();
            System.gc();
            lastGC = System.currentTimeMillis();
            long after = this.free();
            this.gcs[this.gcs_pos++] = after - before;
            if (this.gcs_pos >= this.gcs.length) {
                this.gcs_pos = 0;
            }
            if (log.isFine()) {
                log.info("[gc] before: " + Formatter.bytesToString(before) + ", after: " + Formatter.bytesToString(after) + ", freed: " + Formatter.bytesToString(after - before) + ", rt: " + (lastGC - start) + " ms, call: " + info);
            }
            return true;
        }
        if (log.isFinest()) {
            log.finest("[gc] no execute, last run: " + elapsed / 1000L + " seconds ago, call: " + info);
        }
        return false;
    }

    protected final long getAverageGCFree() {
        long x = 0L;
        int y = 0;
        for (long gc : this.gcs) {
            if (gc == 0L) continue;
            x += gc;
            ++y;
        }
        return y == 0 ? 0L : x / (long)y;
    }

    @Override
    protected final long free() {
        return Memory.free();
    }

    @Override
    protected final long available() {
        return Memory.available();
    }

    @Override
    protected final long maxMemory() {
        return Memory.maxMemory();
    }

    @Override
    protected final long total() {
        return Memory.total();
    }

    @Override
    protected boolean request(long size, boolean force, AtomicBoolean shortStatus) {
        if (size <= 0L) {
            return true;
        }
        boolean r = this.request0(size, force);
        shortStatus.set(!r);
        return r;
    }

    private boolean request0(long size, boolean force) {
        long avg = this.getAverageGCFree();
        long avail = this.available();
        if (avail >= size) {
            return true;
        }
        if (log.isFine()) {
            String t = new Throwable("Stack trace").getStackTrace()[1].toString();
            log.fine(t + " requested " + (size >> 10) + " KB, got " + (avail >> 10) + " KB");
        }
        if (force || avg == 0L || avg + avail >= size) {
            long memBefore = avail;
            boolean performedGC = this.gc(10000, "serverMemory.runGC(...)");
            avail = this.available();
            if (performedGC) {
                long freed = avail - memBefore;
                log.info("performed " + (force ? "explicit" : "necessary") + " GC, freed " + (freed >> 10) + " KB (requested/available/average: " + (size >> 10) + " / " + (avail >> 10) + " / " + (avg >> 10) + " KB)");
            }
            this.checkProper(avail);
            return this.proper && avail >= size;
        }
        if (log.isFine()) {
            log.fine("former GCs indicate to not be able to free enough memory (requested/available/average: " + (size >> 10) + " / " + (avail >> 10) + " / " + (avg >> 10) + " KB)");
        }
        return false;
    }

    @Override
    protected final long used() {
        return Memory.used();
    }

    @Override
    protected boolean properState() {
        return this.proper;
    }

    @Override
    protected void resetProperState() {
        this.proper = true;
        this.tresholdCount = 0;
    }

    @Override
    protected void setProperMbyte(long mbyte) {
        this.properByte = mbyte << 20;
        this.tresholdCount = 0;
    }

    private void checkProper(long available) {
        if (available < this.properByte) {
            long t = System.currentTimeMillis();
            if (this.prevTreshold + 660000L > t) {
                ++this.tresholdCount;
                if (this.tresholdCount > 3) {
                    this.proper = false;
                }
            } else {
                this.tresholdCount = 1;
            }
            this.prevTreshold = t;
            log.info("checkProper: below treshold; tresholdCount: " + this.tresholdCount + "; proper: " + this.proper);
        } else if (!this.proper && available > this.properByte * 2L) {
            this.resetProperState();
        }
    }
}

