/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;

public final class Records {
    private RandomAccessFile raf;
    private final File tablefile;
    protected final int recordsize;
    private int buffercount;
    private byte[] buffer;
    private final byte[] zero;
    private static final int maxWriteBuffer = 16384;

    public Records(File tablefile, int recordsize) {
        this.tablefile = tablefile;
        this.recordsize = recordsize;
        this.zero = new byte[recordsize];
        for (int i = 0; i < recordsize; ++i) {
            this.zero[i] = 0;
        }
        if (!tablefile.exists()) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(tablefile);
            }
            catch (FileNotFoundException e) {
                ConcurrentLog.logException(e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.raf = new RandomAccessFile(tablefile, "rw");
        }
        catch (FileNotFoundException e) {
            ConcurrentLog.logException(e);
        }
        int buffersize = Math.max(1, 16384 / recordsize) * recordsize;
        if (!MemoryControl.request(buffersize + 0x1400000, true)) {
            long lessmem = Math.min(2048L, MemoryControl.available() - 0x100000L);
            buffersize = Math.max(1, (int)(lessmem / (long)recordsize)) * recordsize;
        }
        this.buffer = new byte[buffersize];
        this.buffercount = 0;
    }

    public void clear() {
        try {
            this.raf.setLength(0L);
            int buffersize = Math.max(1, 16384 / this.recordsize) * this.recordsize;
            this.buffer = new byte[buffersize];
            this.buffercount = 0;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    public static final long tableSize(File tablefile, long recordsize) throws IOException {
        if (!tablefile.exists()) {
            return 0L;
        }
        long size = tablefile.length();
        if (size % recordsize != 0L) {
            throw new IOException("wrong file size: file = " + String.valueOf(tablefile) + ", size = " + size + ", recordsize = " + recordsize);
        }
        return size / recordsize;
    }

    public static final void fixTableSize(File tablefile, long recordsize) throws IOException {
        if (!tablefile.exists()) {
            return;
        }
        long size = tablefile.length();
        long cut = size % recordsize;
        if (cut > 0L) {
            RandomAccessFile raf = new RandomAccessFile(tablefile, "rw");
            raf.setLength(size - cut);
            raf.close();
        }
    }

    public final synchronized long size() throws IOException {
        return this.filesize() + (long)this.buffercount;
    }

    public final File filename() {
        return this.tablefile;
    }

    private final long filesize() throws IOException {
        long records = 0L;
        try {
            records = this.raf.length() / (long)this.recordsize;
        }
        catch (NullPointerException e) {
            ConcurrentLog.logException(e);
        }
        return records;
    }

    private final int inBuffer(long index2, long filesize) throws IOException {
        if (index2 >= filesize && index2 < filesize + (long)this.buffercount) {
            return (int)(index2 - filesize);
        }
        return -1;
    }

    protected final synchronized void flushBuffer() {
        if (this.raf == null) {
            return;
        }
        try {
            this.raf.seek(this.raf.length());
            this.raf.write(this.buffer, 0, this.recordsize * this.buffercount);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        this.buffercount = 0;
    }

    public final synchronized void close() {
        if (this.raf != null) {
            try {
                this.flushBuffer();
                this.raf.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        this.raf = null;
        this.buffer = null;
    }

    public final synchronized void get(long index2, byte[] b, int start) throws IOException {
        assert (b.length - start >= this.recordsize);
        long filesize = this.filesize();
        long s = filesize + (long)this.buffercount;
        if (index2 >= s) {
            throw new IndexOutOfBoundsException("kelondroEcoFS.get(" + index2 + ") outside bounds (" + s + ")");
        }
        int q = this.inBuffer(index2, filesize);
        if (q < 0) {
            this.raf.seek((long)this.recordsize * index2);
            this.raf.readFully(b, start, this.recordsize);
            return;
        }
        System.arraycopy(this.buffer, q * this.recordsize, b, start, this.recordsize);
    }

    public final synchronized void put(long index2, byte[] b, int start) throws IOException {
        assert (b.length - start >= this.recordsize);
        long filesize = this.filesize();
        long s = filesize + (long)this.buffercount;
        if (index2 > s) {
            throw new IndexOutOfBoundsException("kelondroEcoFS.put(" + index2 + ") outside bounds (" + s + ")");
        }
        if (Records.isClean(b, start, this.recordsize)) {
            this.clean(index2);
            return;
        }
        int q = this.inBuffer(index2, filesize);
        if (q >= 0) {
            System.arraycopy(b, start, this.buffer, q * this.recordsize, this.recordsize);
            return;
        }
        if (index2 == s) {
            if (this.buffercount >= this.buffer.length / this.recordsize) {
                assert (this.buffercount == this.buffer.length / this.recordsize);
                this.flushBuffer();
                System.arraycopy(b, start, this.buffer, 0, this.recordsize);
                this.buffercount = 1;
            } else {
                System.arraycopy(b, start, this.buffer, this.buffercount * this.recordsize, this.recordsize);
                ++this.buffercount;
            }
            assert (this.buffercount <= this.buffer.length / this.recordsize);
        } else {
            this.raf.seek(index2 * (long)this.recordsize);
            this.raf.write(b, start, this.recordsize);
        }
    }

    public final synchronized void add(byte[] b, int start) throws IOException {
        assert (b.length - start >= this.recordsize);
        if (Records.isClean(b, start, this.recordsize)) {
            throw new IOException("add: record at end is clean");
        }
        if (this.buffercount >= this.buffer.length / this.recordsize) {
            assert (this.buffercount == this.buffer.length / this.recordsize);
            this.flushBuffer();
            System.arraycopy(b, start, this.buffer, 0, this.recordsize);
            this.buffercount = 1;
        } else {
            System.arraycopy(b, start, this.buffer, this.buffercount * this.recordsize, this.recordsize);
            ++this.buffercount;
        }
        assert (this.buffercount <= this.buffer.length / this.recordsize);
    }

    private static final boolean isClean(byte[] b, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (b[i + offset] == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean isClean(long index2) throws IOException {
        long filesize = this.filesize();
        long size = filesize + (long)this.buffercount;
        assert (index2 < size);
        int q = this.inBuffer(index2, filesize);
        if (q >= 0) {
            return Records.isClean(this.buffer, q * this.recordsize, this.recordsize);
        }
        byte[] b = new byte[this.recordsize];
        this.raf.seek(index2 * (long)this.recordsize);
        this.raf.readFully(b, 0, this.recordsize);
        return Records.isClean(b, 0, this.recordsize);
    }

    private final void clean(long index2) throws IOException {
        long filesize = this.filesize();
        long s = filesize + (long)this.buffercount;
        if (index2 >= s) {
            throw new IndexOutOfBoundsException("kelondroEcoFS.clean(" + index2 + ") outside bounds (" + s + ")");
        }
        if (index2 == s - 1L) {
            this.cleanLast();
            return;
        }
        int q = this.inBuffer(index2, filesize);
        if (q >= 0) {
            System.arraycopy(this.zero, 0, this.buffer, q * this.recordsize, this.recordsize);
            return;
        }
        this.raf.seek(index2 * (long)this.recordsize);
        this.raf.write(this.zero, 0, this.recordsize);
    }

    public final synchronized void cleanLast(byte[] b, int start) throws IOException {
        long i;
        this.cleanLast0(b, start);
        while ((i = this.size()) > 0L && this.isClean(i - 1L)) {
            this.cleanLast0();
        }
    }

    private final void cleanLast0(byte[] b, int start) throws IOException {
        assert (b.length - start >= this.recordsize);
        if (this.buffercount > 0) {
            System.arraycopy(this.buffer, (this.buffercount - 1) * this.recordsize, b, start, this.recordsize);
            --this.buffercount;
            return;
        }
        long endpos = this.raf.length() - (long)this.recordsize;
        if (endpos >= 0L) {
            this.raf.seek(endpos);
            this.raf.readFully(b, start, this.recordsize);
        } else {
            endpos = 0L;
            System.arraycopy(this.zero, 0, b, start, this.recordsize);
        }
        this.raf.seek(endpos);
        this.raf.write(this.zero, 0, this.recordsize);
        this.raf.setLength(endpos);
    }

    public final synchronized void cleanLast() throws IOException {
        long i;
        this.cleanLast0();
        while ((i = this.size()) > 0L && this.isClean(i - 1L)) {
            this.cleanLast0();
        }
    }

    private final void cleanLast0() throws IOException {
        if (this.buffercount > 0) {
            --this.buffercount;
            return;
        }
        if (this.raf.length() > 0L) {
            this.raf.setLength(this.raf.length() - (long)this.recordsize);
        }
    }

    public final void deleteOnExit() {
        this.tablefile.deleteOnExit();
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        if (f.exists()) {
            FileUtils.deletedelete(f);
        }
        try {
            Records t = new Records(f, 8);
            byte[] b = new byte[8];
            t.add("01234567".getBytes(), 0);
            t.add("ABCDEFGH".getBytes(), 0);
            t.add("abcdefgh".getBytes(), 0);
            t.add("--------".getBytes(), 0);
            t.add("********".getBytes(), 0);
            for (int i = 0; i < 1000; ++i) {
                t.add("++++++++".getBytes(), 0);
            }
            t.add("=======0".getBytes(), 0);
            t.add("=======1".getBytes(), 0);
            t.add("=======2".getBytes(), 0);
            t.cleanLast(b, 0);
            System.out.println(UTF8.String(b));
            t.cleanLast(b, 0);
            System.out.println(UTF8.String(b));
            t.get(1L, b, 0);
            System.out.println(UTF8.String(b));
            t.put(1L, "AbCdEfGh".getBytes(), 0);
            t.get(1L, b, 0);
            System.out.println(UTF8.String(b));
            t.get(3L, b, 0);
            System.out.println(UTF8.String(b));
            t.get(4L, b, 0);
            System.out.println(UTF8.String(b));
            System.out.println("size = " + t.size());
            t.cleanLast();
            long start = System.currentTimeMillis();
            long c = 0L;
            for (int i = 0; i < 100000; ++i) {
                c = t.size();
            }
            System.out.println("size() needs " + (System.currentTimeMillis() - start) / 100L + " nanoseconds");
            System.out.println("size = " + c);
            t.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }
}

