/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;

public final class CachedRecords {
    private RandomAccessFile raf;
    private final File tablefile;
    protected final int recordsize;
    private long cacheindex;
    private int cachecount;
    private int buffercount;
    private byte[] cache;
    private byte[] buffer;
    private final byte[] zero;
    private static final int maxReadCache = 16384;
    private static final int maxWriteBuffer = 16384;

    public CachedRecords(File tablefile, int recordsize) throws IOException {
        this.tablefile = tablefile;
        this.recordsize = recordsize;
        this.zero = new byte[recordsize];
        for (int i = 0; i < recordsize; ++i) {
            this.zero[i] = 0;
        }
        if (!tablefile.exists()) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(tablefile);
            }
            catch (FileNotFoundException e) {
                ConcurrentLog.logException(e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.raf = new RandomAccessFile(tablefile, "rw");
        }
        catch (FileNotFoundException e) {
            ConcurrentLog.logException(e);
        }
        int cachesize = Math.max(1, 16384 / recordsize) * recordsize;
        int buffersize = Math.max(1, 16384 / recordsize) * recordsize;
        if (!MemoryControl.request(cachesize + buffersize + 0x1400000, true)) {
            long lessmem = Math.min((long)(Math.min(16384, 16384) / 8), MemoryControl.available() - 0x100000L);
            cachesize = Math.max(1, (int)(lessmem / (long)recordsize)) * recordsize;
            buffersize = Math.max(1, (int)(lessmem / (long)recordsize)) * recordsize;
        }
        this.cache = new byte[cachesize];
        this.buffer = new byte[buffersize];
        this.buffercount = 0;
        this.fillCache(0L);
    }

    public static final long tableSize(File tablefile, long recordsize) throws IOException {
        if (!tablefile.exists()) {
            return 0L;
        }
        long size = tablefile.length();
        if (size % recordsize != 0L) {
            throw new IOException("wrong file size: file = " + String.valueOf(tablefile) + ", size = " + size + ", recordsize = " + recordsize);
        }
        return size / recordsize;
    }

    public static final void fixTableSize(File tablefile, long recordsize) throws IOException {
        if (!tablefile.exists()) {
            return;
        }
        long size = tablefile.length();
        long cut = size % recordsize;
        if (cut > 0L) {
            RandomAccessFile raf = new RandomAccessFile(tablefile, "rw");
            raf.setLength(size - cut);
            raf.close();
        }
    }

    public final synchronized long size() throws IOException {
        return this.filesize() + (long)this.buffercount;
    }

    public final File filename() {
        return this.tablefile;
    }

    private final long filesize() throws IOException {
        return this.raf.length() / (long)this.recordsize;
    }

    private final int inCache(long index2) {
        if (index2 >= this.cacheindex && index2 < this.cacheindex + (long)this.cachecount) {
            return (int)(index2 - this.cacheindex);
        }
        return -1;
    }

    private final int inBuffer(long index2) throws IOException {
        long fs = this.filesize();
        if (index2 >= fs && index2 < fs + (long)this.buffercount) {
            return (int)(index2 - fs);
        }
        return -1;
    }

    private final void fillCache(long index2) throws IOException {
        assert (this.inCache(index2) < 0);
        if (this.inCache(index2) >= 0) {
            return;
        }
        long fs = this.filesize();
        if (index2 + (long)(this.cache.length / this.recordsize) > fs) {
            index2 = fs - (long)(this.cache.length / this.recordsize);
        }
        if (index2 < 0L) {
            index2 = 0L;
        }
        this.cachecount = (int)Math.min((long)(this.cache.length / this.recordsize), this.filesize() - index2);
        assert (this.cachecount >= 0);
        this.cacheindex = index2;
        if (this.cachecount == 0) {
            return;
        }
        this.raf.seek((long)this.recordsize * index2);
        this.raf.readFully(this.cache, 0, this.recordsize * this.cachecount);
    }

    public final void flushBuffer() {
        try {
            this.raf.seek(this.raf.length());
            this.raf.write(this.buffer, 0, this.recordsize * this.buffercount);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        this.buffercount = 0;
    }

    public final synchronized void close() {
        this.flushBuffer();
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        this.raf = null;
        this.buffer = null;
        this.cache = null;
    }

    public final synchronized void get(long index2, byte[] b, int start) throws IOException {
        int q;
        assert (b.length - start >= this.recordsize);
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("kelondroEcoFS.get(" + index2 + ") outside bounds (" + this.size() + ")");
        }
        int p = this.inCache(index2);
        int n = q = p >= 0 ? -1 : this.inBuffer(index2);
        if (p < 0 && q < 0) {
            this.fillCache(index2);
            p = this.inCache(index2);
            assert (p >= 0);
        }
        if (p >= 0) {
            System.arraycopy(this.cache, p * this.recordsize, b, start, this.recordsize);
            return;
        }
        if (q >= 0) {
            System.arraycopy(this.buffer, q * this.recordsize, b, start, this.recordsize);
            return;
        }
        assert (false);
    }

    public final synchronized void put(long index2, byte[] b, int start) throws IOException {
        int q;
        assert (b.length - start >= this.recordsize);
        long s = this.filesize() + (long)this.buffercount;
        if (index2 > s) {
            throw new IndexOutOfBoundsException("kelondroEcoFS.put(" + index2 + ") outside bounds (" + this.size() + ")");
        }
        if (CachedRecords.isClean(b, start, this.recordsize)) {
            this.clean(index2);
            return;
        }
        int p = this.inCache(index2);
        int n = q = p >= 0 ? -1 : this.inBuffer(index2);
        if (p >= 0) {
            System.arraycopy(b, start, this.cache, p * this.recordsize, this.recordsize);
            this.raf.seek(index2 * (long)this.recordsize);
            this.raf.write(b, start, this.recordsize);
            return;
        }
        if (q >= 0) {
            System.arraycopy(b, start, this.buffer, q * this.recordsize, this.recordsize);
            return;
        }
        if (index2 == s) {
            if (this.buffercount >= this.buffer.length / this.recordsize) {
                assert (this.buffercount == this.buffer.length / this.recordsize);
                this.flushBuffer();
                System.arraycopy(b, start, this.buffer, 0, this.recordsize);
                this.buffercount = 1;
            } else {
                System.arraycopy(b, start, this.buffer, this.buffercount * this.recordsize, this.recordsize);
                ++this.buffercount;
            }
            assert (this.buffercount <= this.buffer.length / this.recordsize);
        } else {
            this.raf.seek(index2 * (long)this.recordsize);
            this.raf.write(b, start, this.recordsize);
        }
    }

    public final synchronized void add(byte[] b, int start) throws IOException {
        assert (b.length - start >= this.recordsize);
        if (CachedRecords.isClean(b, start, this.recordsize)) {
            throw new IOException("add: record at end is clean");
        }
        if (this.buffercount >= this.buffer.length / this.recordsize) {
            assert (this.buffercount == this.buffer.length / this.recordsize);
            this.flushBuffer();
            System.arraycopy(b, start, this.buffer, 0, this.recordsize);
            this.buffercount = 1;
        } else {
            System.arraycopy(b, start, this.buffer, this.buffercount * this.recordsize, this.recordsize);
            ++this.buffercount;
        }
        assert (this.buffercount <= this.buffer.length / this.recordsize);
    }

    private static final boolean isClean(byte[] b, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (b[i + offset] == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean isClean(long index2) throws IOException {
        int q;
        assert (index2 < this.size());
        int p = this.inCache(index2);
        int n = q = p >= 0 ? -1 : this.inBuffer(index2);
        if (p < 0 && q < 0) {
            this.fillCache(index2);
            p = this.inCache(index2);
            assert (p >= 0);
        }
        if (p >= 0) {
            return CachedRecords.isClean(this.cache, p * this.recordsize, this.recordsize);
        }
        if (q >= 0) {
            return CachedRecords.isClean(this.buffer, q * this.recordsize, this.recordsize);
        }
        assert (false);
        return false;
    }

    public final synchronized void clean(long index2) throws IOException {
        int q;
        long s = this.size();
        if (index2 >= s) {
            throw new IndexOutOfBoundsException("kelondroEcoFS.clean(" + index2 + ") outside bounds (" + s + ")");
        }
        if (index2 == s - 1L) {
            this.cleanLast();
            return;
        }
        int p = this.inCache(index2);
        int n = q = p >= 0 ? -1 : this.inBuffer(index2);
        if (p >= 0) {
            System.arraycopy(this.zero, 0, this.cache, p * this.recordsize, this.recordsize);
            this.raf.seek(index2 * (long)this.recordsize);
            this.raf.write(this.zero, 0, this.recordsize);
            return;
        }
        if (q >= 0) {
            System.arraycopy(this.zero, 0, this.buffer, q * this.recordsize, this.recordsize);
            return;
        }
        this.raf.seek(index2 * (long)this.recordsize);
        this.raf.write(this.zero, 0, this.recordsize);
    }

    public final synchronized void cleanLast(byte[] b, int start) throws IOException {
        long i;
        this.cleanLast0(b, start);
        while ((i = this.size()) > 0L && this.isClean(i - 1L)) {
            this.cleanLast0();
        }
    }

    private final synchronized void cleanLast0(byte[] b, int start) throws IOException {
        int q;
        assert (b.length - start >= this.recordsize);
        long s = this.size();
        int p = this.inCache(s - 1L);
        int n = q = p >= 0 ? -1 : this.inBuffer(s - 1L);
        if (p < 0 && q < 0) {
            this.fillCache(this.size() - 1L);
            p = this.inCache(this.size() - 1L);
            assert (p >= 0);
        }
        if (p >= 0) {
            System.arraycopy(this.cache, p * this.recordsize, b, start, this.recordsize);
            assert (this.buffercount == 0);
            this.raf.setLength((s - 1L) * (long)this.recordsize);
            --this.cachecount;
            return;
        }
        if (q >= 0) {
            System.arraycopy(this.buffer, q * this.recordsize, b, start, this.recordsize);
            assert (this.buffercount > 0);
            --this.buffercount;
            return;
        }
        assert (false);
    }

    public final synchronized void cleanLast() throws IOException {
        long i;
        this.cleanLast0();
        while ((i = this.size()) > 0L && this.isClean(i - 1L)) {
            this.cleanLast0();
        }
    }

    private final synchronized void cleanLast0() throws IOException {
        long q;
        long s = this.size();
        long p = this.inCache(s - 1L);
        long l = q = p >= 0L ? -1L : (long)this.inBuffer(s - 1L);
        if (p >= 0L) {
            assert (this.buffercount == 0);
            this.raf.setLength((s - 1L) * (long)this.recordsize);
            --this.cachecount;
            return;
        }
        if (q >= 0L) {
            assert (this.buffercount > 0);
            --this.buffercount;
            return;
        }
        assert (this.buffercount == 0);
        this.raf.setLength((s - 1L) * (long)this.recordsize);
    }

    public final void deleteOnExit() {
        this.tablefile.deleteOnExit();
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        if (f.exists()) {
            FileUtils.deletedelete(f);
        }
        try {
            CachedRecords t = new CachedRecords(f, 8);
            byte[] b = new byte[8];
            t.add("01234567".getBytes(), 0);
            t.add("ABCDEFGH".getBytes(), 0);
            t.add("abcdefgh".getBytes(), 0);
            t.add("--------".getBytes(), 0);
            t.add("********".getBytes(), 0);
            for (int i = 0; i < 1000; ++i) {
                t.add("++++++++".getBytes(), 0);
            }
            t.add("=======0".getBytes(), 0);
            t.add("=======1".getBytes(), 0);
            t.add("=======2".getBytes(), 0);
            t.cleanLast(b, 0);
            System.out.println(UTF8.String(b));
            t.cleanLast(b, 0);
            System.out.println(UTF8.String(b));
            t.get(1L, b, 0);
            System.out.println(UTF8.String(b));
            t.put(1L, "AbCdEfGh".getBytes(), 0);
            t.get(1L, b, 0);
            System.out.println(UTF8.String(b));
            t.get(3L, b, 0);
            System.out.println(UTF8.String(b));
            t.get(4L, b, 0);
            System.out.println(UTF8.String(b));
            System.out.println("size = " + t.size());
            t.cleanLast();
            long start = System.currentTimeMillis();
            long c = 0L;
            for (int i = 0; i < 100000; ++i) {
                c = t.size();
            }
            System.out.println("size() needs " + (System.currentTimeMillis() - start) / 100L + " nanoseconds");
            System.out.println("size = " + c);
            t.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }
}

