/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.sorting.Array;
import net.yacy.cora.sorting.Sortable;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.kelondroException;

public class RowCollection
implements Sortable<Row.Entry>,
Iterable<Row.Entry>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4670634138825982705L;
    private static final byte[] EMPTY_CACHE = new byte[0];
    public static final long growfactorLarge100 = 140L;
    public static final long growfactorSmall100 = 110L;
    private static final int isortlimit = 20;
    private static final int exp_chunkcount = 0;
    private static final int exp_last_read = 1;
    private static final int exp_last_wrote = 2;
    private static final int exp_order_type = 3;
    private static final int exp_order_bound = 4;
    private static final int exp_collection = 5;
    protected final Row rowdef;
    protected byte[] chunkcache;
    protected int chunkcount;
    protected int sortBound;
    protected long lastTimeWrote;
    private final byte[] keyBuf;
    private static final Row exportMeasureRow = RowCollection.exportRow(0);
    private static final long day = 86400000L;
    protected static final long exportOverheadSize = 14L;
    private static Random random = null;

    protected RowCollection(RowCollection rc) {
        this.rowdef = rc.rowdef;
        this.chunkcache = rc.chunkcache;
        this.chunkcount = rc.chunkcount;
        this.sortBound = rc.sortBound;
        this.lastTimeWrote = rc.lastTimeWrote;
        this.keyBuf = new byte[this.rowdef.primaryKeyLength];
    }

    protected RowCollection(Row rowdef) {
        this.rowdef = rowdef;
        this.sortBound = 0;
        this.lastTimeWrote = System.currentTimeMillis();
        this.chunkcache = EMPTY_CACHE;
        this.chunkcount = 0;
        this.keyBuf = new byte[this.rowdef.primaryKeyLength];
    }

    public RowCollection(Row rowdef, int objectCount) throws SpaceExceededException {
        this(rowdef);
        this.ensureSize(objectCount);
    }

    protected RowCollection(Row rowdef, int objectCount, byte[] cache, int sortBound) {
        this.rowdef = rowdef;
        this.chunkcache = cache;
        this.chunkcount = objectCount;
        this.sortBound = sortBound;
        this.lastTimeWrote = System.currentTimeMillis();
        this.keyBuf = new byte[this.rowdef.primaryKeyLength];
    }

    protected RowCollection(Row rowdef, Row.Entry exportedCollectionRowEnvironment) {
        int payloadWidth = exportedCollectionRowEnvironment.cellwidth(1);
        if ((long)payloadWidth < 14L) {
            throw new kelondroException("RowCollection import: payload too small: cellwidth(1)=" + payloadWidth + " < overhead=14");
        }
        int chunkcachelength = payloadWidth - 14;
        if (rowdef.objectsize <= 0 || chunkcachelength % rowdef.objectsize != 0) {
            ConcurrentLog.warn("KELONDRO", "RowCollection import: payload not aligned to objectsize; payload=" + chunkcachelength + ", objectsize=" + rowdef.objectsize + " (continuing)");
        }
        Row.Entry exportedCollection = RowCollection.exportRow(chunkcachelength).newEntry(exportedCollectionRowEnvironment, 1);
        this.rowdef = rowdef;
        this.chunkcount = (int)exportedCollection.getColLong(0);
        if (this.chunkcount > chunkcachelength / rowdef.objectsize) {
            ConcurrentLog.warn("KELONDRO", "RowCollection: corrected wrong chunkcount; chunkcount = " + this.chunkcount + ", chunkcachelength = " + chunkcachelength + ", rowdef.objectsize = " + rowdef.objectsize);
            this.chunkcount = chunkcachelength / rowdef.objectsize;
        }
        this.lastTimeWrote = (exportedCollection.getColLong(2) + 10957L) * 86400000L;
        String sortOrderKey = exportedCollection.getColASCII(3);
        ByteOrder oldOrder = null;
        if (sortOrderKey == null || sortOrderKey.equals("__")) {
            oldOrder = null;
        } else {
            oldOrder = NaturalOrder.bySignature(sortOrderKey);
            if (oldOrder == null) {
                oldOrder = Base64Order.bySignature(sortOrderKey);
            }
        }
        if (rowdef.objectOrder != null && oldOrder != null && !rowdef.objectOrder.signature().equals(oldOrder.signature())) {
            throw new kelondroException("old collection order does not match with new order; objectOrder.signature = " + rowdef.objectOrder.signature() + ", oldOrder.signature = " + oldOrder.signature());
        }
        this.sortBound = (int)exportedCollection.getColLong(4);
        if (this.sortBound > this.chunkcount) {
            ConcurrentLog.warn("KELONDRO", "RowCollection: corrected wrong sortBound; sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount);
            this.sortBound = this.chunkcount;
        }
        this.chunkcache = exportedCollection.getColBytes(5, false);
        this.keyBuf = new byte[this.rowdef.primaryKeyLength];
    }

    protected RowCollection(Row rowdef, byte[] chunkcache, int chunkcount, int sortBound, long lastTimeWrote) {
        this.rowdef = rowdef;
        this.chunkcache = new byte[chunkcache.length];
        System.arraycopy(chunkcache, 0, this.chunkcache, 0, chunkcache.length);
        this.chunkcount = chunkcount;
        this.sortBound = sortBound;
        this.lastTimeWrote = lastTimeWrote;
        this.keyBuf = new byte[this.rowdef.primaryKeyLength];
    }

    public RowCollection clone() {
        return new RowCollection(this.rowdef, this.chunkcache, this.chunkcount, this.sortBound, this.lastTimeWrote);
    }

    public void reset() {
        this.chunkcache = EMPTY_CACHE;
        this.chunkcount = 0;
        this.sortBound = 0;
    }

    public long mem() {
        return this.chunkcache.length;
    }

    public static final int sizeOfExportedCollectionRows(Row.Entry exportedCollectionRowEnvironment, int columnInEnvironment) {
        Row.Entry exportedCollectionEntry = exportMeasureRow.newEntry(exportedCollectionRowEnvironment, columnInEnvironment);
        int chunkcount = (int)exportedCollectionEntry.getColLong(0);
        return chunkcount;
    }

    private static int daysSince2000(long time) {
        return (int)(time / 86400000L) - 10957;
    }

    private static Row exportRow(int chunkcachelength) {
        Column c0 = new Column("int size-4 {b256}");
        Column c1 = new Column("short lastread-2 {b256}");
        Column c2 = new Column("short lastwrote-2 {b256}");
        Column c3 = new Column("byte[] orderkey-2");
        Column c4 = new Column("int orderbound-4 {b256}");
        Column c5 = new Column("byte[] collection-" + chunkcachelength);
        Row er = new Row(new Column[]{c0, c1, c2, c3, c4, c5}, NaturalOrder.naturalOrder);
        assert ((long)er.objectsize == (long)chunkcachelength + 14L);
        return er;
    }

    public synchronized byte[] exportCollection() {
        this.sort();
        assert (this.sortBound == this.chunkcount);
        assert (this.size() * this.rowdef.objectsize <= this.chunkcache.length) : "this.size() = " + this.size() + ", objectsize = " + this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        Row row = RowCollection.exportRow(this.size() * this.rowdef.objectsize);
        Row.Entry entry2 = row.newEntry();
        assert (this.sortBound <= this.chunkcount) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        assert (this.chunkcount <= this.chunkcache.length / this.rowdef.objectsize) : "chunkcount = " + this.chunkcount + ", chunkcache.length = " + this.chunkcache.length + ", rowdef.objectsize = " + this.rowdef.objectsize;
        entry2.setCol(0, this.chunkcount);
        entry2.setCol(1, RowCollection.daysSince2000(System.currentTimeMillis()));
        entry2.setCol(2, RowCollection.daysSince2000(this.lastTimeWrote));
        entry2.setCol(3, this.rowdef.objectOrder == null ? ASCII.getBytes("__") : ASCII.getBytes(this.rowdef.objectOrder.signature()));
        entry2.setCol(4, this.sortBound);
        entry2.setCol(5, this.chunkcache);
        return entry2.bytes();
    }

    public void saveCollection(File file) throws IOException {
        FileUtils.copy(this.exportCollection(), file);
    }

    public Row row() {
        return this.rowdef;
    }

    private final long neededSpaceForEnsuredSize(int elements) {
        assert (elements > 0) : "elements = " + elements;
        long needed = elements * this.rowdef.objectsize;
        if ((long)this.chunkcache.length >= needed) {
            return 0L;
        }
        assert (needed > 0L) : "needed = " + needed;
        long allocram = Math.max(1024L, needed * 140L / 100L);
        allocram -= allocram % (long)this.rowdef.objectsize;
        assert (allocram > 0L) : "elements = " + elements + ", new = " + allocram;
        if (allocram <= Integer.MAX_VALUE && MemoryControl.request(allocram, false)) {
            return allocram;
        }
        allocram = needed * 110L / 100L;
        allocram -= allocram % (long)this.rowdef.objectsize;
        assert (allocram >= 0L) : "elements = " + elements + ", new = " + allocram;
        return allocram;
    }

    private final void ensureSize(int elements) throws SpaceExceededException {
        if (elements == 0) {
            return;
        }
        long allocram = this.neededSpaceForEnsuredSize(elements);
        if (allocram == 0L) {
            return;
        }
        assert (this.chunkcache.length < elements * this.rowdef.objectsize) : "wrong alloc computation (1): elements * rowdef.objectsize = " + elements * this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        assert (allocram > (long)this.chunkcache.length) : "wrong alloc computation (2): allocram = " + allocram + ", chunkcache.length = " + this.chunkcache.length;
        if (allocram > Integer.MAX_VALUE || !MemoryControl.request(allocram + 32L, true)) {
            throw new SpaceExceededException(allocram + 32L, "RowCollection grow");
        }
        try {
            byte[] newChunkcache = new byte[(int)allocram];
            System.arraycopy(this.chunkcache, 0, newChunkcache, 0, this.chunkcache.length);
            this.chunkcache = newChunkcache;
        }
        catch (OutOfMemoryError e) {
            System.gc();
            try {
                byte[] newChunkcache = new byte[(int)allocram];
                System.arraycopy(this.chunkcache, 0, newChunkcache, 0, this.chunkcache.length);
                this.chunkcache = newChunkcache;
            }
            catch (OutOfMemoryError ee) {
                throw new SpaceExceededException(allocram, "RowCollection grow after OutOfMemoryError " + ee.getMessage());
            }
        }
    }

    protected final long memoryNeededForGrow() {
        return this.neededSpaceForEnsuredSize(this.chunkcount + 1);
    }

    @Override
    public int compare(Row.Entry o1, Row.Entry o2) {
        return o1.compareTo(o2);
    }

    @Override
    public Row.Entry buffer() {
        return this.row().newEntry();
    }

    @Override
    public void swap(int i, int j, Row.Entry buffer) {
        if (i == j) {
            return;
        }
        byte[] swapspace = buffer.bytes();
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * i, swapspace, 0, this.rowdef.objectsize);
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * j, this.chunkcache, this.rowdef.objectsize * i, this.rowdef.objectsize);
        System.arraycopy(swapspace, 0, this.chunkcache, this.rowdef.objectsize * j, this.rowdef.objectsize);
    }

    private final void checkShrink() {
        long allocram = this.rowdef.objectsize * this.chunkcount;
        if (allocram < (long)(this.chunkcache.length / 2) && MemoryControl.request(allocram + 32L, true)) {
            this.trim();
        }
    }

    protected synchronized void trim() {
        if (this.chunkcache.length == 0) {
            return;
        }
        long needed = this.chunkcount * this.rowdef.objectsize;
        assert (needed <= (long)this.chunkcache.length);
        if (needed >= (long)this.chunkcache.length) {
            return;
        }
        if (MemoryControl.available() + 1000L < needed) {
            return;
        }
        try {
            byte[] newChunkcache = new byte[(int)needed];
            System.arraycopy(this.chunkcache, 0, newChunkcache, 0, newChunkcache.length);
            this.chunkcache = newChunkcache;
        }
        catch (OutOfMemoryError e) {
            System.gc();
            try {
                byte[] newChunkcache = new byte[(int)needed];
                System.arraycopy(this.chunkcache, 0, newChunkcache, 0, newChunkcache.length);
                this.chunkcache = newChunkcache;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
    }

    public final long lastWrote() {
        return this.lastTimeWrote;
    }

    protected final synchronized byte[] getKey(int index2) {
        assert (index2 >= 0) : "get: access with index " + index2 + " is below zero";
        assert (index2 < this.chunkcount) : "get: access with index " + index2 + " is above chunkcount " + this.chunkcount + "; sortBound = " + this.sortBound;
        assert (index2 * this.rowdef.objectsize < this.chunkcache.length);
        if (this.chunkcache == null || this.rowdef == null) {
            return null;
        }
        if (index2 >= this.chunkcount) {
            return null;
        }
        if ((index2 + 1) * this.rowdef.objectsize > this.chunkcache.length) {
            return null;
        }
        byte[] b = new byte[this.rowdef.primaryKeyLength];
        System.arraycopy(this.chunkcache, index2 * this.rowdef.objectsize, b, 0, b.length);
        return b;
    }

    protected final synchronized void getKeyInto(int index2, byte[] dst, int off) {
        assert (dst.length - off >= this.rowdef.primaryKeyLength);
        int addr = index2 * this.rowdef.objectsize;
        System.arraycopy(this.chunkcache, addr, dst, off, this.rowdef.primaryKeyLength);
    }

    @Override
    public final synchronized Row.Entry get(int index2, boolean clone) {
        assert (index2 >= 0) : "get: access with index " + index2 + " is below zero";
        assert (index2 < this.chunkcount) : "get: access with index " + index2 + " is above chunkcount " + this.chunkcount + "; sortBound = " + this.sortBound;
        assert (this.chunkcache != null && index2 * this.rowdef.objectsize < this.chunkcache.length);
        assert (this.sortBound <= this.chunkcount) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        if (this.chunkcache == null || this.rowdef == null) {
            return null;
        }
        int addr = index2 * this.rowdef.objectsize;
        if (index2 >= this.chunkcount) {
            return null;
        }
        if (addr + this.rowdef.objectsize > this.chunkcache.length) {
            return null;
        }
        Row.Entry entry2 = this.rowdef.newEntry(this.chunkcache, addr, clone);
        return entry2;
    }

    public final synchronized void set(int index2, Row.Entry a) throws SpaceExceededException {
        assert (index2 >= 0) : "set: access with index " + index2 + " is below zero";
        this.ensureSize(index2 + 1);
        byte[] column = this.keyBuf;
        a.writeToArray(0, column, 0);
        assert (a.cellwidth(0) == this.rowdef.primaryKeyLength);
        assert (column.length >= this.rowdef.primaryKeyLength);
        boolean sameKey = this.match(column, 0, index2);
        a.writeToArray(this.chunkcache, index2 * this.rowdef.objectsize);
        if (index2 >= this.chunkcount) {
            this.chunkcount = index2 + 1;
        }
        if (!sameKey && index2 < this.sortBound) {
            this.sortBound = index2;
        }
        this.lastTimeWrote = System.currentTimeMillis();
    }

    public final void insertUnique(int index2, Row.Entry a) throws SpaceExceededException {
        assert (a != null);
        if (index2 < this.chunkcount) {
            this.ensureSize(this.chunkcount + 1);
            System.arraycopy(this.chunkcache, this.rowdef.objectsize * index2, this.chunkcache, this.rowdef.objectsize * (index2 + 1), (this.chunkcount - index2) * this.rowdef.objectsize);
            ++this.chunkcount;
        }
        this.set(index2, a);
    }

    public synchronized void addUnique(Row.Entry row) throws SpaceExceededException {
        byte[] r = row.bytes();
        this.addUnique(r, 0, r.length);
    }

    public synchronized void addUnique(List<Row.Entry> rows) throws SpaceExceededException {
        assert (this.sortBound == 0) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        Iterator<Row.Entry> i = rows.iterator();
        while (i.hasNext()) {
            this.addUnique(i.next());
        }
    }

    public synchronized void add(byte[] a) throws SpaceExceededException {
        assert (a.length == this.rowdef.objectsize) : "a.length = " + a.length + ", objectsize = " + this.rowdef.objectsize;
        this.addUnique(a, 0, a.length);
    }

    private final void addUnique(byte[] a, int astart, int alength) throws SpaceExceededException {
        assert (a != null);
        assert (astart >= 0 && astart < a.length) : " astart = " + astart;
        assert (!RowCollection.allZero(a, astart, alength)) : "a = " + NaturalOrder.arrayList(a, astart, alength);
        assert (alength > 0);
        assert (astart + alength <= a.length);
        assert (alength == this.rowdef.objectsize) : "alength =" + alength + ", rowdef.objectsize = " + this.rowdef.objectsize;
        int l = Math.min(this.rowdef.objectsize, Math.min(alength, a.length - astart));
        this.ensureSize(this.chunkcount + 1);
        System.arraycopy(a, astart, this.chunkcache, this.rowdef.objectsize * this.chunkcount, l);
        ++this.chunkcount;
        if (this.chunkcount == 1) {
            assert (this.sortBound == 0);
            this.sortBound = 1;
        } else if (this.sortBound + 1 == this.chunkcount && this.rowdef.objectOrder.compare(this.chunkcache, this.rowdef.objectsize * (this.chunkcount - 2), this.chunkcache, this.rowdef.objectsize * (this.chunkcount - 1), this.rowdef.primaryKeyLength) == -1) {
            this.sortBound = this.chunkcount;
        }
        this.lastTimeWrote = System.currentTimeMillis();
    }

    protected final void addSorted(byte[] a, int astart, int alength) throws SpaceExceededException {
        assert (a != null);
        assert (astart >= 0 && astart < a.length) : " astart = " + astart;
        assert (!RowCollection.allZero(a, astart, alength)) : "a = " + NaturalOrder.arrayList(a, astart, alength);
        assert (alength > 0);
        assert (astart + alength <= a.length);
        assert (alength == this.rowdef.objectsize) : "alength =" + alength + ", rowdef.objectsize = " + this.rowdef.objectsize;
        int l = Math.min(this.rowdef.objectsize, Math.min(alength, a.length - astart));
        this.ensureSize(this.chunkcount + 1);
        System.arraycopy(a, astart, this.chunkcache, this.rowdef.objectsize * this.chunkcount, l);
        ++this.chunkcount;
        this.sortBound = this.chunkcount;
        this.lastTimeWrote = System.currentTimeMillis();
    }

    private static final boolean allZero(byte[] a, int astart, int alength) {
        for (int i = 0; i < alength; ++i) {
            if (a[astart + i] == 0) continue;
            return false;
        }
        return true;
    }

    public final synchronized void addAllUnique(RowCollection c) throws SpaceExceededException {
        if (c == null) {
            return;
        }
        assert (this.rowdef.objectsize == c.rowdef.objectsize);
        this.ensureSize(this.chunkcount + c.size());
        System.arraycopy(c.chunkcache, 0, this.chunkcache, this.rowdef.objectsize * this.chunkcount, this.rowdef.objectsize * c.size());
        this.chunkcount += c.size();
    }

    public final synchronized void removeRow(int p, boolean keepOrder) {
        assert (p >= 0) : "p = " + p;
        assert (p < this.chunkcount) : "p = " + p + ", chunkcount = " + this.chunkcount;
        assert (this.chunkcount > 0) : "chunkcount = " + this.chunkcount;
        assert (this.sortBound <= this.chunkcount) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        if (keepOrder && p < this.sortBound) {
            int addr = p * this.rowdef.objectsize;
            System.arraycopy(this.chunkcache, addr + this.rowdef.objectsize, this.chunkcache, addr, (this.chunkcount - p - 1) * this.rowdef.objectsize);
            --this.sortBound;
        } else {
            if (p != this.chunkcount - 1) {
                System.arraycopy(this.chunkcache, (this.chunkcount - 1) * this.rowdef.objectsize, this.chunkcache, p * this.rowdef.objectsize, this.rowdef.objectsize);
            }
            if (this.sortBound > p) {
                this.sortBound = p;
            }
        }
        --this.chunkcount;
        this.lastTimeWrote = System.currentTimeMillis();
        this.checkShrink();
    }

    @Override
    public final void delete(int p) {
        this.removeRow(p, true);
    }

    public synchronized Row.Entry removeOne() {
        if (this.chunkcount == 0) {
            return null;
        }
        Row.Entry r = this.get(this.chunkcount - 1, true);
        if (this.chunkcount == this.sortBound) {
            --this.sortBound;
        }
        --this.chunkcount;
        this.lastTimeWrote = System.currentTimeMillis();
        this.checkShrink();
        return r;
    }

    public synchronized List<Row.Entry> top(int count) {
        if (count > this.chunkcount) {
            count = this.chunkcount;
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        if (this.chunkcount == 0 || count == 0) {
            return list2;
        }
        for (int cursor = this.chunkcount - 1; count > 0 && cursor >= 0; --count, --cursor) {
            Row.Entry entry2 = this.get(cursor, true);
            list2.add(entry2);
        }
        return list2;
    }

    public synchronized List<Row.Entry> random(int count) {
        if (count > this.chunkcount) {
            count = this.chunkcount;
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        if (this.chunkcount == 0 || count == 0) {
            return list2;
        }
        int stepsize = this.chunkcount / count;
        for (int cursor = 0; count > 0 && cursor < this.chunkcount; --count, cursor += stepsize) {
            Row.Entry entry2 = this.get(cursor, true);
            list2.add(entry2);
        }
        return list2;
    }

    public synchronized byte[] smallestKey() {
        if (this.chunkcount == 0) {
            return null;
        }
        this.sort();
        Row.Entry r = this.get(0, false);
        byte[] b = r.getPrimaryKeyBytes();
        return b;
    }

    public synchronized byte[] largestKey() {
        if (this.chunkcount == 0) {
            return null;
        }
        this.sort();
        Row.Entry r = this.get(this.chunkcount - 1, false);
        byte[] b = r.getPrimaryKeyBytes();
        return b;
    }

    public synchronized void clear() {
        if (this.chunkcache.length == 0) {
            return;
        }
        this.chunkcache = EMPTY_CACHE;
        this.chunkcount = 0;
        this.sortBound = 0;
        this.lastTimeWrote = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return this.chunkcount;
    }

    public boolean isEmpty() {
        return this.chunkcount == 0;
    }

    public int sorted() {
        return this.sortBound;
    }

    public synchronized Iterator<byte[]> keys(boolean keepOrderWhenRemoving) {
        return new keyIterator(keepOrderWhenRemoving);
    }

    @Override
    public Iterator<Row.Entry> iterator() {
        return new rowIterator();
    }

    public void optimize() {
        this.sort();
        this.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sort() {
        if (this.sortBound == this.chunkcount) {
            return;
        }
        RowCollection rowCollection = this;
        synchronized (rowCollection) {
            if (this.sortBound == this.chunkcount) {
                return;
            }
            Array.sort(this);
            this.sortBound = this.chunkcount;
        }
    }

    final int partition(int L, int R, int S, byte[] swapspace) {
        assert (L < R - 1) : "L = " + L + ", R = " + R + ", S = " + S;
        assert (R - L >= 20) : "L = " + L + ", R = " + R + ", S = " + S + ", isortlimit = 20";
        int p = L;
        int q = R - 1;
        int pivot = this.pivot(L, R, S);
        if (this.rowdef.objectOrder instanceof Base64Order) {
            while (p <= q) {
                if (pivot < S && p < pivot) {
                    p = pivot;
                    S = 0;
                } else {
                    while (p < R - 1 && this.compare(pivot, p) >= 0) {
                        ++p;
                    }
                }
                while (q > L && this.compare(pivot, q) <= 0) {
                    --q;
                }
                if (p > q) continue;
                pivot = this.swap(p, q, pivot, swapspace);
                ++p;
                --q;
            }
        } else {
            while (p <= q) {
                if (pivot < S && p < pivot) {
                    p = pivot;
                    S = 0;
                } else {
                    while (p < R - 1 && this.compare(pivot, p) >= 0) {
                        ++p;
                    }
                }
                while (q > L && this.compare(pivot, q) <= 0) {
                    --q;
                }
                if (p > q) continue;
                pivot = this.swap(p, q, pivot, swapspace);
                ++p;
                --q;
            }
        }
        if (pivot < p) {
            this.swap(pivot, p - 1, pivot, swapspace);
            return p - 1;
        }
        if (pivot > p) {
            this.swap(pivot, p, pivot, swapspace);
            return p;
        }
        assert (pivot == p);
        return p;
    }

    private final int pivot(int L, int R, int S) {
        if (S == 0 || S < L) {
            int m = this.picMiddle(L, (3 * L + R - 1) / 4, (L + R - 1) / 2, (L + 3 * R - 3) / 4, R - 1);
            assert (L <= m);
            assert (m < R);
            return m;
        }
        if (S < R) {
            int m = this.picMiddle(L, L + (S - L) / 3, (L + R - 1) / 2, S, R - 1);
            assert (L <= m);
            assert (m < R);
            return m;
        }
        return (L + R - 1) / 2;
    }

    private final int picMiddle(int a, int b, int c, int d, int e) {
        return this.picMiddle(this.picMiddle(a, b, c), d, e);
    }

    private final int picMiddle(int a, int b, int c) {
        if (this.compare(a, b) > 0) {
            if (this.compare(c, a) > 0) {
                return a;
            }
            if (this.compare(b, c) > 0) {
                return b;
            }
        } else {
            if (this.compare(a, c) > 0) {
                return a;
            }
            if (this.compare(c, b) > 0) {
                return b;
            }
        }
        return c;
    }

    private final int swap(int i, int j, int p, byte[] swapspace) {
        if (i == j) {
            return p;
        }
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * i, swapspace, 0, this.rowdef.objectsize);
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * j, this.chunkcache, this.rowdef.objectsize * i, this.rowdef.objectsize);
        System.arraycopy(swapspace, 0, this.chunkcache, this.rowdef.objectsize * j, this.rowdef.objectsize);
        if (i == p) {
            return j;
        }
        if (j == p) {
            return i;
        }
        return p;
    }

    protected synchronized void uniq() {
        Array.uniq(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<RowCollection> removeDoubles() throws SpaceExceededException {
        assert (this.rowdef.objectOrder != null);
        this.sort();
        ArrayList<RowCollection> report = new ArrayList<RowCollection>();
        if (this.chunkcount < 2) {
            return report;
        }
        boolean u = true;
        RowCollection collection = new RowCollection(this.rowdef, 2);
        try {
            for (int i = this.chunkcount - 2; i >= 0; --i) {
                if (this.match(i, i + 1)) {
                    collection.addUnique(this.get(i + 1, false));
                    this.removeRow(i + 1, false);
                    if (i + 1 >= this.chunkcount - 1) continue;
                    u = false;
                    continue;
                }
                if (collection.isEmpty()) continue;
                collection.addUnique(this.get(i + 1, false));
                this.removeRow(i + 1, false);
                if (i + 1 < this.chunkcount - 1) {
                    u = false;
                }
                collection.trim();
                report.add(collection);
                collection = new RowSet(this.rowdef, 2);
            }
        }
        catch (RuntimeException e) {
            ConcurrentLog.warn("KELONDRO", "kelondroRowCollection: " + e.getMessage(), e);
        }
        finally {
            if (!u) {
                this.sort();
            }
        }
        return report;
    }

    public synchronized boolean isSorted() {
        assert (this.rowdef.objectOrder != null);
        if (this.chunkcount <= 1) {
            return true;
        }
        return this.chunkcount == this.sortBound;
    }

    public synchronized String toString() {
        StringBuilder s = new StringBuilder(80);
        Iterator<Row.Entry> i = this.iterator();
        if (i.hasNext()) {
            s.append(i.next().toString());
        }
        while (i.hasNext()) {
            s.append(", " + i.next().toString());
        }
        return s.toString();
    }

    @Override
    private final int compare(int i, int j) {
        assert (this.chunkcount * this.rowdef.objectsize <= this.chunkcache.length) : "chunkcount = " + this.chunkcount + ", objsize = " + this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        assert (i >= 0 && i < this.chunkcount) : "i = " + i + ", chunkcount = " + this.chunkcount;
        assert (j >= 0 && j < this.chunkcount) : "j = " + j + ", chunkcount = " + this.chunkcount;
        assert (this.rowdef.objectOrder != null);
        if (i == j) {
            return 0;
        }
        int c = this.rowdef.objectOrder.compare(this.chunkcache, i * this.rowdef.objectsize, this.chunkcache, j * this.rowdef.objectsize, this.rowdef.primaryKeyLength);
        return c;
    }

    protected int compare(byte[] a, int astart, int chunknumber) {
        assert (chunknumber < this.chunkcount);
        assert (a.length - astart >= this.rowdef.primaryKeyLength) : "short key compare not allowed";
        return this.rowdef.objectOrder.compare(a, astart, this.chunkcache, chunknumber * this.rowdef.objectsize, this.rowdef.primaryKeyLength);
    }

    protected final boolean match(int i, int j) {
        assert (this.chunkcount * this.rowdef.objectsize <= this.chunkcache.length) : "chunkcount = " + this.chunkcount + ", objsize = " + this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        assert (i >= 0 && i < this.chunkcount) : "i = " + i + ", chunkcount = " + this.chunkcount;
        assert (j >= 0 && j < this.chunkcount) : "j = " + j + ", chunkcount = " + this.chunkcount;
        if (i >= this.chunkcount) {
            return false;
        }
        if (j >= this.chunkcount) {
            return false;
        }
        assert (this.rowdef.objectOrder != null);
        if (i == j) {
            return true;
        }
        int astart = i * this.rowdef.objectsize;
        int bstart = j * this.rowdef.objectsize;
        int k = this.rowdef.primaryKeyLength;
        while (k-- != 0) {
            if (this.chunkcache[astart++] == this.chunkcache[bstart++]) continue;
            return false;
        }
        return true;
    }

    protected boolean match(byte[] a, int astart, int chunknumber) {
        if (chunknumber >= this.chunkcount) {
            return false;
        }
        assert (a.length - astart >= this.rowdef.primaryKeyLength) : "short key match not allowed";
        int p = chunknumber * this.rowdef.objectsize;
        int len = this.rowdef.primaryKeyLength;
        while (len-- != 0) {
            if (a[astart] != this.chunkcache[p]) {
                return false;
            }
            ++astart;
            ++p;
        }
        return true;
    }

    public synchronized void close() {
        this.chunkcache = null;
    }

    private static long d(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return 1000L * a / b;
    }

    private static String randomHash() {
        return Base64Order.enhancedCoder.encodeLongSB(random.nextLong(), 4).toString() + Base64Order.enhancedCoder.encodeLongSB(random.nextLong(), 4).toString() + Base64Order.enhancedCoder.encodeLongSB(random.nextLong(), 4).toString();
    }

    public static void test(int testsize) throws SpaceExceededException {
        int i;
        Row r = new Row(new Column[]{new Column("hash", 3, 3, 12, "hash")}, (ByteOrder)Base64Order.enhancedCoder);
        Supplier<Long> nano = System::nanoTime;
        Supplier<Long> usedMem = () -> {
            Runtime rt = Runtime.getRuntime();
            return rt.totalMemory() - rt.freeMemory();
        };
        BiFunction<String, Runnable, Long> measure = (name, run) -> {
            long m0 = (Long)usedMem.get();
            long t0 = (Long)nano.get();
            run.run();
            long t1 = (Long)nano.get();
            long m1 = (Long)usedMem.get();
            System.out.println(String.format("%-24s : %12d ns  | \u0394mem %,12d B", name, t1 - t0, m1 - m0));
            return t1 - t0;
        };
        Supplier<String> sep = () -> "--------------------------------------------------------------------------------";
        Random J = new Random(0L);
        random = new Random(0L);
        Supplier<byte[]> rnd12 = () -> ASCII.getBytes(RowCollection.randomHash());
        Function<Long, byte[]> mono12 = x -> ASCII.getBytes(Base64Order.enhancedCoder.encodeLongSB((long)x, 12).toString());
        System.out.println(sep.get());
        System.out.println("compare() sanity checks");
        random = new Random(0L);
        for (int i2 = 0; i2 < Math.min(10000, testsize); ++i2) {
            byte[] b;
            byte[] a = ASCII.getBytes(RowCollection.randomHash());
            int c = Base64Order.enhancedCoder.compare(a, b = ASCII.getBytes(RowCollection.randomHash()));
            if (c == 0 && Base64Order.enhancedCoder.compare(b, a) != 0) {
                System.out.println("compare failed / =; a = " + ASCII.String(a) + ", b = " + ASCII.String(b));
            }
            if (c == -1 && Base64Order.enhancedCoder.compare(b, a) != 1) {
                System.out.println("compare failed / <; a = " + ASCII.String(a) + ", b = " + ASCII.String(b));
            }
            if (c != 1 || Base64Order.enhancedCoder.compare(b, a) == -1) continue;
            System.out.println("compare failed / >; a = " + ASCII.String(a) + ", b = " + ASCII.String(b));
        }
        System.out.println(sep.get());
        System.out.println("kelondroRowCollection baseline test with size = " + testsize);
        RowCollection a = new RowCollection(r, testsize);
        long t0 = nano.get();
        random = new Random(0L);
        for (i = 0; i < testsize / 2; ++i) {
            a.add(rnd12.get());
        }
        random = new Random(0L);
        for (i = 0; i < testsize / 2; ++i) {
            a.add(rnd12.get());
        }
        a.sort();
        a.uniq();
        for (i = 0; i < a.size() - 1; ++i) {
            if (a.get(i, false).compareTo(a.get(i + 1, false)) < 0) continue;
            System.out.println("Compare error at pos " + i + ": a.get(i)=" + String.valueOf(a.get(i, false)) + ", a.get(i + 1)=" + String.valueOf(a.get(i + 1, false)));
        }
        long t1 = nano.get();
        System.out.println("create+sort+uniq a : " + (t1 - t0) + " ns, " + RowCollection.d(testsize, t1 - t0) + " entries/ms; a.size() = " + a.size());
        RowCollection c = new RowCollection(r, testsize);
        random = new Random(0L);
        t0 = nano.get();
        for (int i3 = 0; i3 < testsize; ++i3) {
            c.add(rnd12.get());
        }
        t1 = nano.get();
        System.out.println("create c           : " + (t1 - t0) + " ns, " + RowCollection.d(testsize, t1 - t0) + " entries/ms");
        RowCollection d = new RowCollection(r, testsize);
        for (int i4 = 0; i4 < testsize; ++i4) {
            d.add(c.get(i4, false).getPrimaryKeyBytes());
        }
        long t2 = nano.get();
        System.out.println("copy c -> d        : " + (t2 - t1) + " ns, " + RowCollection.d(testsize, t2 - t1) + " entries/ms");
        c.sort();
        long t3 = nano.get();
        System.out.println("sort c             : " + (t3 - t2) + " ns, " + RowCollection.d(testsize, t3 - t2) + " entries/ms");
        d.sort();
        long t4 = nano.get();
        System.out.println("sort d             : " + (t4 - t3) + " ns, " + RowCollection.d(testsize, t4 - t3) + " entries/ms");
        c.uniq();
        long t5 = nano.get();
        System.out.println("uniq c             : " + (t5 - t4) + " ns, " + RowCollection.d(testsize, t5 - t4) + " entries/ms");
        d.uniq();
        long t6 = nano.get();
        System.out.println("uniq d             : " + (t6 - t5) + " ns, " + RowCollection.d(testsize, t6 - t5) + " entries/ms");
        System.out.println(sep.get());
        System.out.println("Growth behaviour: preallocation vs incremental");
        measure.apply("incremental add()", () -> {
            try {
                int i;
                RowCollection inc = new RowCollection(r, 1);
                random = new Random(1L);
                for (i = 0; i < testsize; ++i) {
                    inc.add((byte[])rnd12.get());
                }
                for (i = 0; i < Math.min(1000, Math.max(10, testsize / 1000)); ++i) {
                    inc.add((byte[])rnd12.get());
                }
                System.out.println("inc.mem()=" + inc.mem() + " bytes; size=" + inc.size());
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        measure.apply("preallocated add()", () -> {
            try {
                RowCollection pre = new RowCollection(r, testsize + 1024);
                random = new Random(1L);
                for (int i = 0; i < testsize; ++i) {
                    pre.add((byte[])rnd12.get());
                }
                System.out.println("pre.mem()=" + pre.mem() + " bytes; size=" + pre.size());
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        System.out.println(sep.get());
        System.out.println("sortBound effectiveness");
        measure.apply("addSorted()+sort() (no-op expected)", () -> {
            try {
                RowCollection sb = new RowCollection(r, testsize);
                for (int i = 0; i < testsize; ++i) {
                    sb.addSorted((byte[])mono12.apply(Long.valueOf(i)), 0, 12);
                }
                long tS0 = (Long)nano.get();
                sb.sort();
                long tS1 = (Long)nano.get();
                System.out.println("sorted? " + sb.isSorted() + " | sort time = " + (tS1 - tS0) + " ns");
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        measure.apply("partially sorted then random tail", () -> {
            try {
                int i;
                RowCollection ps = new RowCollection(r, testsize);
                int sortedPart = Math.max(1, testsize * 3 / 4);
                for (i = 0; i < sortedPart; ++i) {
                    ps.addSorted((byte[])mono12.apply(Long.valueOf(i)), 0, 12);
                }
                random = new Random(2L);
                for (i = sortedPart; i < testsize; ++i) {
                    ps.add((byte[])rnd12.get());
                }
                long tS0 = (Long)nano.get();
                ps.sort();
                long tS1 = (Long)nano.get();
                System.out.println("sorted? " + ps.isSorted() + " | sort time = " + (tS1 - tS0) + " ns");
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        System.out.println(sep.get());
        System.out.println("removeRow performance (keepOrder true/false) and shrink");
        int removeCount = Math.max(1, testsize / 10);
        measure.apply("remove front (keepOrder=true)", () -> {
            try {
                RowCollection rm = new RowCollection(r, testsize);
                random = new Random(3L);
                for (int i = 0; i < testsize; ++i) {
                    rm.add((byte[])rnd12.get());
                }
                long m0 = rm.mem();
                long tR0 = (Long)nano.get();
                for (int i = 0; i < removeCount; ++i) {
                    rm.removeRow(0, true);
                }
                long tR1 = (Long)nano.get();
                System.out.println("mem before=" + m0 + " after=" + rm.mem() + " | time=" + (tR1 - tR0) + " ns | size=" + rm.size());
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        measure.apply("remove random (keepOrder=false)", () -> {
            try {
                RowCollection rm = new RowCollection(r, testsize);
                random = new Random(4L);
                for (int i = 0; i < testsize; ++i) {
                    rm.add((byte[])rnd12.get());
                }
                long tR0 = (Long)nano.get();
                for (int i = 0; i < removeCount; ++i) {
                    int p = J.nextInt(Math.max(1, rm.size()));
                    rm.removeRow(Math.min(p, Math.max(0, rm.size() - 1)), false);
                }
                long tR1 = (Long)nano.get();
                System.out.println("time=" + (tR1 - tR0) + " ns | size=" + rm.size());
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        System.out.println(sep.get());
        System.out.println("alias retention check (demonstrates risk of keeping Entry views across growth)");
        try {
            RowCollection rc = new RowCollection(r, 16);
            for (int i5 = 0; i5 < 10000; ++i5) {
                rc.add(rnd12.get());
            }
            WeakReference<byte[]> wr = new WeakReference<byte[]>(rc.chunkcache);
            Row.Entry alias = rc.get(0, false);
            for (int i6 = 0; i6 < 200000; ++i6) {
                rc.add(rnd12.get());
            }
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException i6) {
                // empty catch block
            }
            boolean retained = wr.get() != null;
            System.out.println("old array retained while alias alive? " + retained);
            alias = null;
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("old array after alias=null: " + (wr.get() == null ? "GC'ed" : "still retained"));
        }
        catch (SpaceExceededException ex) {
            System.out.println("Alias check skipped due to SpaceExceededException: " + ex.getMessage());
        }
        System.out.println(sep.get());
        System.out.println("export/import roundtrip");
        measure.apply("export + import (with env row)", () -> {
            try {
                RowCollection x = new RowCollection(r, testsize);
                random = new Random(5L);
                for (int i = 0; i < testsize; ++i) {
                    x.add((byte[])rnd12.get());
                }
                x.sort();
                byte[] blob = x.exportCollection();
                Row ex = RowCollection.exportRow(x.size() * r.objectsize);
                Row.Entry eb = ex.newEntry(blob);
                String sig = eb.getColASCII(3);
                Row env = new Row(new Column[]{new Column("pad", 3, 3, 1, "pad"), new Column("payload", 2, 3, blob.length, "payload")}, NaturalOrder.naturalOrder);
                Row.Entry envEntry = env.newEntry();
                envEntry.setCol(1, blob);
                RowCollection y = new RowCollection(r, envEntry);
                boolean ok = y.size() == x.size() && y.isSorted();
                for (int i = 0; ok && i < Math.min(1000, x.size()); ok &= Arrays.equals(x.get(i, false).getPrimaryKeyBytes(), y.get(i, false).getPrimaryKeyBytes()), i += Math.max(1, x.size() / 1000)) {
                }
                System.out.println("roundtrip ok? " + ok + " | x.size=" + x.size() + " y.size=" + y.size());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        System.out.println(sep.get());
        System.out.println("top()/random() cloning cost");
        measure.apply("top(k) with cloning", () -> {
            try {
                RowCollection t = new RowCollection(r, testsize);
                random = new Random(6L);
                for (int i = 0; i < testsize; ++i) {
                    t.add((byte[])rnd12.get());
                }
                int k = Math.min(10000, Math.max(100, testsize / 20));
                long tt0 = (Long)nano.get();
                List<Row.Entry> top = t.top(k);
                long tt1 = (Long)nano.get();
                System.out.println("k=" + k + " | time=" + (tt1 - tt0) + " ns | result=" + top.size());
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        measure.apply("random(k) with cloning", () -> {
            try {
                RowCollection t = new RowCollection(r, testsize);
                random = new Random(7L);
                for (int i = 0; i < testsize; ++i) {
                    t.add((byte[])rnd12.get());
                }
                int k = Math.min(10000, Math.max(100, testsize / 20));
                long tt0 = (Long)nano.get();
                List<Row.Entry> rnd = t.random(k);
                long tt1 = (Long)nano.get();
                System.out.println("k=" + k + " | time=" + (tt1 - tt0) + " ns | result=" + rnd.size());
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        System.out.println(sep.get());
        System.out.println("iterator remove() cost (keep order)");
        measure.apply("rowIterator remove half (keepOrder=true)", () -> {
            try {
                int removed;
                RowCollection itc = new RowCollection(r, testsize);
                random = new Random(8L);
                for (int i = 0; i < testsize; ++i) {
                    itc.add((byte[])rnd12.get());
                }
                int target = itc.size() / 2;
                long tIt0 = (Long)nano.get();
                Iterator<Row.Entry> it = itc.iterator();
                for (removed = 0; it.hasNext() && removed < target; ++removed) {
                    it.next();
                    it.remove();
                }
                long tIt1 = (Long)nano.get();
                System.out.println("removed=" + removed + " | time=" + (tIt1 - tIt0) + " ns | size=" + itc.size());
            }
            catch (SpaceExceededException ex) {
                throw new RuntimeException(ex);
            }
        });
        System.out.println(sep.get());
        System.out.println("Result size recap: c=" + c.size() + ", d=" + d.size());
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            RowCollection.test(100000);
            ConcurrentLog.shutdown();
        }
        catch (SpaceExceededException e) {
            e.printStackTrace();
        }
    }

    private class keyIterator
    implements Iterator<byte[]> {
        private int p = 0;
        private final boolean keepOrderWhenRemoving;

        private keyIterator(boolean keepOrderWhenRemoving) {
            this.keepOrderWhenRemoving = keepOrderWhenRemoving;
        }

        @Override
        public boolean hasNext() {
            return this.p < RowCollection.this.chunkcount;
        }

        @Override
        public byte[] next() {
            return RowCollection.this.getKey(this.p++);
        }

        @Override
        public void remove() {
            --this.p;
            RowCollection.this.removeRow(this.p, this.keepOrderWhenRemoving);
        }
    }

    private class rowIterator
    implements Iterator<Row.Entry> {
        private int p = 0;

        @Override
        public boolean hasNext() {
            return this.p < RowCollection.this.chunkcount;
        }

        @Override
        public Row.Entry next() {
            return RowCollection.this.get(this.p++, true);
        }

        @Override
        public void remove() {
            --this.p;
            RowCollection.this.removeRow(this.p, true);
        }
    }

    public static class partitionthread
    implements Callable<Integer> {
        RowCollection rc;
        int L;
        int R;
        int S;

        public partitionthread(RowCollection rc, int L, int R, int S) {
            this.rc = rc;
            this.L = L;
            this.R = R;
            this.S = S;
        }

        @Override
        public Integer call() throws Exception {
            return this.rc.partition(this.L, this.R, this.S, new byte[this.rc.rowdef.objectsize]);
        }
    }
}

