/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.util.ArrayList;
import net.yacy.data.UserDB;
import net.yacy.http.YaCyLegacyCredential;
import net.yacy.search.Switchboard;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Credential;

public class YaCyLoginService
extends HashLoginService
implements LoginService {
    private UserStore _userStore;

    protected void doStart() throws Exception {
        this._userStore = new UserStore();
        this.setUserStore(this._userStore);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._userStore != null) {
            this._userStore.stop();
            this._userStore = null;
        }
    }

    protected AbstractLoginService.UserPrincipal loadUserInfo(String username) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        AbstractLoginService.UserPrincipal theUser = super.loadUserInfo(username);
        if (theUser == null) {
            Switchboard sb = Switchboard.getSwitchboard();
            String adminuser = sb.getConfig("adminAccountUserName", "admin");
            Credential credential = null;
            String[] roles = null;
            if (username.equals(adminuser)) {
                String adminAccountBase64MD5 = sb.getConfig("adminAccountBase64MD5", "");
                credential = YaCyLegacyCredential.getCredentialForAdmin(username, adminAccountBase64MD5);
                roles = new String[]{UserDB.AccessRight.ADMIN_RIGHT.toString()};
            } else {
                UserDB.Entry user = sb.userDB.getEntry(username);
                if (user != null && user.getMD5EncodedUserPwd() != null) {
                    ArrayList<String> roletmp = new ArrayList<String>();
                    for (UserDB.AccessRight right : UserDB.AccessRight.values()) {
                        if (!user.hasRight(right)) continue;
                        roletmp.add(right.toString());
                    }
                    if (roletmp.size() > 0) {
                        roles = roletmp.toArray(new String[roletmp.size()]);
                    }
                    credential = YaCyLegacyCredential.getCredentialForUserDB(username, user.getMD5EncodedUserPwd());
                }
            }
            if (credential != null) {
                theUser = new AbstractLoginService.UserPrincipal(username, credential);
                this._userStore.addUser(username, credential, roles);
                this._userStore.getUserIdentity(username).getUserPrincipal();
                theUser.authenticate(credential);
            }
        }
        return theUser;
    }

    public boolean removeUser(String username) {
        UserIdentity uid = this._userStore.getUserIdentity(username);
        if (uid != null) {
            this.logout(uid);
            this._userStore.removeUser(username);
            return true;
        }
        return false;
    }
}

