/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.http.CrashProtectionHandler;
import net.yacy.http.InetPathAccessHandler;
import net.yacy.http.MonitorHandler;
import net.yacy.http.ProxyCacheHandler;
import net.yacy.http.ProxyHandler;
import net.yacy.http.YaCyErrorHandler;
import net.yacy.http.YaCyLoginService;
import net.yacy.http.YaCySecurityHandler;
import net.yacy.http.YacyDomainHandler;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.search.Switchboard;
import net.yacy.utils.PKCS12Tool;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.InetAccessHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class YaCyHttpServer {
    private final Server server;

    public YaCyHttpServer(int port, String host) {
        Switchboard sb = Switchboard.getSwitchboard();
        this.server = new Server();
        int cores = ProcessorUtils.availableProcessors();
        int acceptors = Math.max(1, Math.min(4, cores / 2));
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(16384);
        HttpConnectionFactory hcf = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(this.server, null, null, null, acceptors, -1, new ConnectionFactory[]{hcf});
        connector.setPort(port);
        connector.setHost(host);
        connector.setName("httpd-" + host + ":" + Integer.toString(port));
        connector.setIdleTimeout(9000L);
        connector.setAcceptQueueSize(128);
        this.server.addConnector((Connector)connector);
        boolean useSSL = sb.getConfigBool("server.https", false);
        if (useSSL) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            SSLContext sslContext = this.initSslContext(sb);
            if (sslContext != null) {
                int sslport = sb.getConfigInt("port.ssl", 8443);
                sslContextFactory.setSslContext(sslContext);
                HttpConfiguration https_config = new HttpConfiguration();
                https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
                sslConnector.setPort(sslport);
                sslConnector.setName("ssld:" + Integer.toString(sslport));
                sslConnector.setIdleTimeout(9000L);
                this.server.addConnector((Connector)sslConnector);
                ConcurrentLog.info("SERVER", "SSL support initialized successfully on port " + sslport);
            }
        }
        YacyDomainHandler domainHandler = new YacyDomainHandler();
        domainHandler.setAlternativeResolver(sb.peers);
        WebAppContext htrootContext = new WebAppContext();
        htrootContext.setContextPath("/");
        String htrootpath = String.valueOf(sb.appPath) + "/" + sb.getConfig("htRootPath", "htroot");
        ConcurrentLog.info("Jetty9HttpServerImpl", "htrootpath = " + htrootpath);
        htrootContext.setErrorHandler((ErrorHandler)new YaCyErrorHandler());
        try {
            htrootContext.setBaseResource(Resource.newResource((String)htrootpath));
            htrootContext.setDefaultsDescriptor(String.valueOf(sb.appPath) + "/defaults/web.xml");
            Resource webxml = Resource.newResource((String)(String.valueOf(sb.dataPath) + "/DATA/SETTINGS/web.xml"));
            if (webxml.exists()) {
                htrootContext.setDescriptor(webxml.getName());
            }
        }
        catch (IOException ex) {
            if (htrootContext.getBaseResource() == null) {
                ConcurrentLog.severe("SERVER", "could not find directory: htroot ");
            }
            ConcurrentLog.warn("SERVER", "could not find: defaults/web.xml or DATA/SETTINGS/web.xml");
        }
        ServletHolder sholder = new ServletHolder(YaCyDefaultServlet.class);
        sholder.setInitParameter("resourceBase", htrootpath);
        sholder.setAsyncSupported(true);
        htrootContext.addServlet(sholder, "/*");
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setInflateBufferSize(4096);
        if (!sb.getConfigBool("server.response.compress.gzip", true)) {
            gzipHandler.setExcludedMethods(new String[]{HttpMethod.GET.asString(), HttpMethod.POST.asString()});
        }
        htrootContext.setGzipHandler(gzipHandler);
        HandlerList handlers = new HandlerList();
        if (sb.getConfigBool("isTransparentProxy", false)) {
            ConcurrentLog.info("SERVER", "load Jetty handler for transparent proxy");
            handlers.setHandlers(new Handler[]{new MonitorHandler(), domainHandler, new ProxyCacheHandler(), new ProxyHandler()});
        } else {
            handlers.setHandlers(new Handler[]{new MonitorHandler(), domainHandler});
        }
        ContextHandler context = new ContextHandler();
        context.setServer(this.server);
        context.setContextPath("/");
        context.setHandler((Handler)handlers);
        context.setMaxFormContentSize(-1);
        Logger log = Log.getRootLogger();
        context.setLogger(log);
        ContextHandlerCollection allrequesthandlers = new ContextHandlerCollection();
        allrequesthandlers.setServer(this.server);
        allrequesthandlers.addHandler((Handler)context);
        allrequesthandlers.addHandler((Handler)htrootContext);
        allrequesthandlers.addHandler((Handler)new DefaultHandler());
        YaCyLoginService loginService = new YaCyLoginService();
        loginService.setName(sb.getConfig("adminRealm", "YaCy"));
        YaCySecurityHandler securityHandler = new YaCySecurityHandler();
        securityHandler.setLoginService(loginService);
        htrootContext.setSecurityHandler((SecurityHandler)securityHandler);
        CrashProtectionHandler crashHandler = new CrashProtectionHandler(this.server, (Handler)allrequesthandlers);
        String white = sb.getConfig("serverClient", "*");
        if (!white.equals("*")) {
            StringTokenizer st = new StringTokenizer(white, ",");
            InetPathAccessHandler whiteListHandler = white.contains("|") ? new InetPathAccessHandler() : new InetAccessHandler();
            int i = 0;
            while (st.hasMoreTokens()) {
                String pattern = st.nextToken();
                try {
                    whiteListHandler.include(pattern);
                }
                catch (IllegalArgumentException nex) {
                    ConcurrentLog.severe("SERVER", "Server Access Settings - IP filter: " + nex.getMessage());
                    continue;
                }
                ++i;
            }
            if (i > 0) {
                String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
                whiteListHandler.include(loopbackAddress);
                whiteListHandler.setHandler(crashHandler);
                this.server.setHandler((Handler)whiteListHandler);
                ConcurrentLog.info("SERVER", "activated IP access restriction to: [" + loopbackAddress + "," + white + "]");
            } else {
                this.server.setHandler((Handler)crashHandler);
            }
        } else {
            this.server.setHandler((Handler)crashHandler);
        }
    }

    public void startupServer() throws Exception {
        this.server.setStopAtShutdown(true);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server.join();
    }

    public boolean withSSL() {
        Connector[] clist;
        for (Connector c : clist = this.server.getConnectors()) {
            if (!c.getName().startsWith("ssl")) continue;
            return true;
        }
        return false;
    }

    public int getSslPort() {
        Connector[] clist;
        for (Connector c : clist = this.server.getConnectors()) {
            if (!c.getName().startsWith("ssl")) continue;
            int port = ((ServerConnector)c).getLocalPort();
            return port;
        }
        return -1;
    }

    public void reconnect(final int milsec) {
        new Thread("Jetty8HttpServer.reconnect"){

            @Override
            public void run() {
                if (milsec > 0) {
                    try {
                        Thread.sleep(milsec);
                    }
                    catch (Exception e) {
                        ConcurrentLog.logException(e);
                    }
                }
                try {
                    if (!YaCyHttpServer.this.server.isRunning() || YaCyHttpServer.this.server.isStopped()) {
                        YaCyHttpServer.this.server.start();
                    }
                    Connector[] cons = YaCyHttpServer.this.server.getConnectors();
                    int port = Switchboard.getSwitchboard().getLocalPort();
                    int sslport = Switchboard.getSwitchboard().getConfigInt("port.ssl", 8443);
                    for (Connector con : cons) {
                        if (con.getName().startsWith("httpd") && ((ServerConnector)con).getPort() != port) {
                            ((ServerConnector)con).close();
                            con.stop();
                            if (!con.isStopped()) {
                                ConcurrentLog.warn("SERVER", "Reconnect: Jetty Connector failed to stop");
                            }
                            ((ServerConnector)con).setPort(port);
                            con.start();
                            ConcurrentLog.info("SERVER", "set new port for Jetty connector " + con.getName());
                            continue;
                        }
                        if (!con.getName().startsWith("ssl") || ((ServerConnector)con).getPort() == sslport) continue;
                        ((ServerConnector)con).close();
                        con.stop();
                        if (!con.isStopped()) {
                            ConcurrentLog.warn("SERVER", "Reconnect: Jetty Connector failed to stop");
                        }
                        ((ServerConnector)con).setPort(sslport);
                        con.start();
                        ConcurrentLog.info("SERVER", "set new port for Jetty connector " + con.getName());
                    }
                }
                catch (Exception ex) {
                    ConcurrentLog.logException(ex);
                }
            }
        }.start();
    }

    public void resetUser(String username) {
        YaCyLoginService loginservice;
        YaCySecurityHandler hx = (YaCySecurityHandler)this.server.getChildHandlerByClass(YaCySecurityHandler.class);
        if (hx != null && (loginservice = (YaCyLoginService)hx.getLoginService()).removeUser(username)) {
            loginservice.loadUserInfo(username);
        }
    }

    public void removeUser(String username) {
        YaCySecurityHandler hx = (YaCySecurityHandler)this.server.getChildHandlerByClass(YaCySecurityHandler.class);
        if (hx != null) {
            YaCyLoginService loginservice = (YaCyLoginService)hx.getLoginService();
            loginservice.removeUser(username);
        }
    }

    public String getVersion() {
        return "Jetty " + Server.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLContext initSslContext(Switchboard sb) {
        String keyStoreFileName = sb.getConfig("keyStore", "").trim();
        String keyStorePwd = sb.getConfig("keyStorePassword", "").trim();
        String pkcs12ImportFile = sb.getConfig("pkcs12ImportFile", "").trim();
        if (keyStoreFileName.isEmpty() && keyStorePwd.isEmpty() && pkcs12ImportFile.isEmpty()) {
            keyStoreFileName = "defaults/freeworldKeystore";
            keyStorePwd = "freeworld";
            sb.setConfig("keyStore", keyStoreFileName);
            sb.setConfig("keyStorePassword", keyStorePwd);
        }
        if (pkcs12ImportFile.length() > 0) {
            ConcurrentLog.info("SERVER", "Import certificates from import file '" + pkcs12ImportFile + "'.");
            try {
                String pkcs12ImportPwd = sb.getConfig("pkcs12ImportPwd", "").trim();
                PKCS12Tool pkcsTool = new PKCS12Tool(pkcs12ImportFile, pkcs12ImportPwd);
                if (keyStoreFileName.isEmpty()) {
                    keyStoreFileName = "DATA/SETTINGS/myPeerKeystore";
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(null, keyStorePwd.toCharArray());
                    try (FileOutputStream ksOut = new FileOutputStream(keyStoreFileName);){
                        ks.store(ksOut, keyStorePwd.toCharArray());
                    }
                    sb.setConfig("keyStore", keyStoreFileName);
                }
                pkcsTool.importToJKS(keyStoreFileName, keyStorePwd);
                sb.setConfig("pkcs12ImportFile", "");
                sb.setConfig("pkcs12ImportPwd", "");
            }
            catch (Exception e) {
                ConcurrentLog.severe("SERVER", "Unable to import certificate from import file '" + pkcs12ImportFile + "'.", e);
            }
        } else if (keyStoreFileName.isEmpty()) {
            return null;
        }
        try {
            ConcurrentLog.info("SERVER", "Initializing SSL support ...");
            if (ConcurrentLog.isFine("SERVER")) {
                ConcurrentLog.fine("SERVER", "Initializing keystore ...");
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            if (ConcurrentLog.isFine("SERVER")) {
                ConcurrentLog.fine("SERVER", "Loading keystore file " + keyStoreFileName);
            }
            FileInputStream stream = new FileInputStream(keyStoreFileName);
            try {
                ks.load(stream, keyStorePwd.toCharArray());
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    ConcurrentLog.warn("SERVER", "Could not close input stream on file " + keyStoreFileName);
                }
            }
            if (ConcurrentLog.isFine("SERVER")) {
                ConcurrentLog.fine("SERVER", "Initializing key manager factory ...");
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStorePwd.toCharArray());
            if (ConcurrentLog.isFine("SERVER")) {
                ConcurrentLog.fine("SERVER", "Initializing SSL context ...");
            }
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(kmf.getKeyManagers(), null, null);
            return sslcontext;
        }
        catch (Exception e) {
            String errorMsg = "FATAL ERROR: Unable to initialize the SSL Socket factory. " + e.getMessage();
            ConcurrentLog.severe("SERVER", errorMsg);
            System.out.println(errorMsg);
            return null;
        }
    }

    public int getServerThreads() {
        return this.server == null ? 0 : this.server.getThreadPool().getThreads() - this.server.getThreadPool().getIdleThreads();
    }

    public String toString() {
        return this.server.dump() + "\n\n" + this.server.getState();
    }
}

