/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Fulltext;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class LLMSelection_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        long ucount;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        Segment segment = sb.index;
        long ucount200 = ucount = segment.fulltext().collectionSize();
        try {
            ucount200 = segment.fulltext().getDefaultConnector().getCountByQuery(CollectionSchema.httpstatus_i.getSolrFieldName() + ":200");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        prop.put("reload", 0L);
        prop.put("lurlexport", 0L);
        prop.putNum("ucount", ucount);
        prop.putNum("ucount200", ucount200);
        int i = 0;
        boolean dark = true;
        for (String file : sb.packsInHold()) {
            prop.put("packs_" + i + "_file", file);
            prop.put("packs_" + i + "_type", "hold");
            prop.put("packs_" + i + "_size", new File(sb.packsHoldPath, file).length() / 1024L);
            prop.put("packs_" + i + "_dark", dark ? "1" : "0");
            ++i;
            dark = !dark;
        }
        for (String file : sb.packsInLoaded()) {
            prop.put("packs_" + i + "_file", file);
            prop.put("packs_" + i + "_type", "loaded");
            prop.put("packs_" + i + "_size", new File(sb.packsLoadedPath, file).length() / 1024L);
            prop.put("packs_" + i + "_dark", dark ? "1" : "0");
            ++i;
            dark = !dark;
        }
        for (String file : sb.packsInLive()) {
            prop.put("packs_" + i + "_file", file);
            prop.put("packs_" + i + "_type", "live");
            prop.put("packs_" + i + "_size", new File(sb.packsLivePath, file).length() / 1024L);
            prop.put("packs_" + i + "_dark", dark ? "1" : "0");
            ++i;
            dark = !dark;
        }
        prop.put("packs", i);
        if (post == null || env == null) {
            return prop;
        }
        if (post.containsKey("lurlexport")) {
            try {
                Fulltext.ExportFormat format = Fulltext.ExportFormat.elasticsearch;
                String fname = post.get("format", "full-elasticsearch");
                boolean dom = fname.startsWith("dom");
                boolean text = fname.startsWith("text");
                if (fname.endsWith("rss")) {
                    format = Fulltext.ExportFormat.rss;
                }
                if (fname.endsWith("solr")) {
                    format = Fulltext.ExportFormat.solr;
                }
                if (fname.endsWith("elasticsearch")) {
                    format = Fulltext.ExportFormat.elasticsearch;
                }
                String filter = post.get("exportfilter", ".*");
                Object query2 = post.get("exportquery", "*:*");
                String collection = post.get("collection", "user");
                query2 = (String)query2 + " AND " + CollectionSchema.collection_sxt.getSolrFieldName() + ":\"" + collection + "\"";
                sb.tables.recordAPICall(post, "IndexPackGenerator_p.html", "dump", "PackGenerator, q=" + (String)query2);
                long now = System.currentTimeMillis();
                long doccount = sb.index.fulltext().getDefaultConnector().getCountByQuery((String)query2);
                if (doccount == 0L) {
                    throw new IOException("number of exported documents == 0");
                }
                String category = post.get("category", "scroll");
                String tier = "common";
                String origin = "web";
                String slug = post.get("slug", "export").trim().replaceAll(" ", "-");
                if (slug.isEmpty()) {
                    slug = "export";
                }
                if (!"user".equals(collection)) {
                    slug = collection.trim().replaceAll(" ", "-");
                }
                String string = "YaCy-Pack_" + category + "-common-web_" + slug + "_" + GenericFormatter.SHORT_DAY_FORMATTER.format(new Date(now));
            }
            catch (IOException e) {
                prop.put("lurlexporterror", 1L);
                prop.put("lurlexporterror_exportfile", "-no export-");
                prop.put("lurlexporterror_exportfailmsg", e.getMessage());
                return prop;
            }
        }
        prop.putNum("ucount", ucount);
        return prop;
    }
}

