/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class BlacklistTest_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        prop.putHTML("blacklistEngine", Blacklist.getEngineInfo());
        if (post != null && post.containsKey("testList")) {
            prop.put("testlist", "1");
            Object urlstring = post.get("testurl", "");
            if (!(((String)urlstring).startsWith("http://") || ((String)urlstring).startsWith("https://") || ((String)urlstring).startsWith("ftp://") || ((String)urlstring).startsWith("smb://") || ((String)urlstring).startsWith("file://"))) {
                urlstring = "http://" + (String)urlstring;
            }
            DigestURL testurl = null;
            try {
                testurl = new DigestURL((String)urlstring);
            }
            catch (MalformedURLException e) {
                testurl = null;
            }
            if (testurl != null) {
                prop.putHTML("url", testurl.toNormalform(false));
                prop.putHTML("testlist_url", testurl.toNormalform(false));
                boolean isblocked = false;
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.CRAWLER, testurl)) {
                    prop.put("testlist_listedincrawler", "1");
                    isblocked = true;
                }
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.DHT, testurl)) {
                    prop.put("testlist_listedindht", "1");
                    isblocked = true;
                }
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.NEWS, testurl)) {
                    prop.put("testlist_listedinnews", "1");
                    isblocked = true;
                }
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.PROXY, testurl)) {
                    prop.put("testlist_listedinproxy", "1");
                    isblocked = true;
                }
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.SEARCH, testurl)) {
                    prop.put("testlist_listedinsearch", "1");
                    isblocked = true;
                }
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.SURFTIPS, testurl)) {
                    prop.put("testlist_listedinsurftips", "1");
                    isblocked = true;
                }
                if (!isblocked) {
                    prop.put("testlist_isnotblocked", "1");
                }
            } else {
                prop.putHTML("url", (String)urlstring);
                prop.put("testlist", "2");
            }
        } else {
            prop.putHTML("url", "http://");
        }
        return prop;
    }
}

