/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.html;

import java.util.Set;
import net.yacy.document.parser.html.Scraper;
import net.yacy.kelondro.util.MemoryControl;

public abstract class AbstractScraper
implements Scraper {
    protected static final String EMPTY_STRING = new String();
    public static final char sp = ' ';
    public static final char lb = '<';
    public static final char rb = '>';
    public static final char sl = '/';
    private Set<String> tags0;
    private Set<String> tags1;

    public AbstractScraper(Set<String> tags0, Set<String> tags1) {
        this.tags0 = tags0;
        this.tags1 = tags1;
    }

    @Override
    public boolean isSingetonTag(String tag) {
        return this.tags0 != null && this.tags0.contains(tag.toLowerCase());
    }

    @Override
    public boolean isPairedTag(String tag) {
        return this.tags1 != null && this.tags1.contains(tag.toLowerCase());
    }

    public static String stripAllTags(char[] s) {
        if (s.length > 80 && !MemoryControl.request(s.length * 2, false)) {
            return "";
        }
        StringBuilder r = new StringBuilder(s.length);
        int bc = 0;
        for (char c : s) {
            if (c == '<') {
                ++bc;
                if (r.length() <= 0 || r.charAt(r.length() - 1) == ' ') continue;
                r.append(' ');
                continue;
            }
            if (c == '>') {
                --bc;
                continue;
            }
            if (bc > 0) continue;
            r.append(c);
        }
        return r.toString().trim();
    }

    protected static final String cleanLine(String s) {
        if (!MemoryControl.request(s.length() * 2, false)) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(s.length());
        char l = ' ';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ') {
                c = ' ';
            }
            if (c == ' ') {
                if (l != ' ') {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            l = c;
        }
        return sb.toString().trim();
    }

    @Override
    public void close() {
        this.tags0 = null;
        this.tags1 = null;
    }

    public static void main(String[] args) {
        String t = "<script src=\"navigation.js\" type=\"text/javascript\"></script>\\n <script src=\"../js/prototype.js\" type=\"text/javascript\"></script>";
        System.out.println("'" + AbstractScraper.stripAllTags(t.toCharArray()) + "'");
    }
}

