/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.importer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResumptionToken
extends TreeMap<String, String> {
    private static final long serialVersionUID = -8389462290545629792L;
    private static final Collator insensitiveCollator = Collator.getInstance(Locale.US);
    private int recordCounter;
    private final DigestURL source;
    private static final ThreadLocal<SAXParser> tlSax;

    public ResumptionToken(DigestURL source, byte[] b) throws IOException {
        super((Collator)insensitiveCollator.clone());
        this.source = source;
        this.recordCounter = 0;
        new Parser(b);
    }

    public static String truncatedURL(DigestURL url) {
        String u = url.toNormalform(true);
        int i = u.indexOf(63);
        if (i > 0) {
            u = u.substring(0, i + 1);
        }
        return u;
    }

    public int getRecordCounter() {
        return this.recordCounter;
    }

    public DigestURL resumptionURL() throws IOException {
        String token = this.getToken();
        if (token == null) {
            throw new IOException("end of resumption reached - token == null");
        }
        if (token.isEmpty()) {
            throw new IOException("end of resumption reached - token.isEmpty()");
        }
        String url = ResumptionToken.truncatedURL(this.source);
        if (token.indexOf("from=", 0) >= 0) {
            return new DigestURL(url + "verb=ListRecords&" + token);
        }
        Date expiration = this.getExpirationDate();
        if (expiration != null && expiration.before(new Date())) {
            throw new IOException("the resumption is expired at " + ISO8601Formatter.FORMATTER.format(expiration) + " (now: " + ISO8601Formatter.FORMATTER.format());
        }
        String u = url + "verb=ListRecords&resumptionToken=" + String.valueOf(this.escape(token));
        return new DigestURL(u);
    }

    private StringBuilder escape(String s) {
        int len = s.length();
        StringBuilder sbuf = new StringBuilder(len + 10);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '/') {
                sbuf.append("%2F");
                continue;
            }
            if (ch == '?') {
                sbuf.append("%3F");
                continue;
            }
            if (ch == '#') {
                sbuf.append("%23");
                continue;
            }
            if (ch == '=') {
                sbuf.append("%3D");
                continue;
            }
            if (ch == '&') {
                sbuf.append("%26");
                continue;
            }
            if (ch == ':') {
                sbuf.append("%3A");
                continue;
            }
            if (ch == ';') {
                sbuf.append("%3B");
                continue;
            }
            if (ch == ' ') {
                sbuf.append("%20");
                continue;
            }
            if (ch == '%') {
                sbuf.append("%25");
                continue;
            }
            if (ch == '+') {
                sbuf.append("%2B");
                continue;
            }
            sbuf.append(ch);
        }
        return sbuf;
    }

    public Date getExpirationDate() {
        String d = (String)this.get("expirationDate");
        if (d == null) {
            return null;
        }
        try {
            return ISO8601Formatter.FORMATTER.parse(d, 0).getTime();
        }
        catch (ParseException e) {
            ConcurrentLog.logException(e);
            return new Date();
        }
    }

    public int getCompleteListSize() {
        String t = (String)this.get("completeListSize");
        if (t == null) {
            return 0;
        }
        return Integer.parseInt(t);
    }

    public int getCursor() {
        String t = (String)this.get("cursor");
        if (t == null) {
            return 0;
        }
        return Integer.parseInt(t);
    }

    public String getToken() {
        return (String)this.get("token");
    }

    @Override
    public String toString() {
        return "source = " + String.valueOf(this.source) + ", expirationDate=" + ISO8601Formatter.FORMATTER.format(this.getExpirationDate()) + ", completeListSize=" + this.getCompleteListSize() + ", cursor=" + this.getCursor() + ", token=" + this.getToken();
    }

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    static {
        insensitiveCollator.setStrength(1);
        insensitiveCollator.setDecomposition(0);
        tlSax = new ThreadLocal();
    }

    private class Parser
    extends DefaultHandler {
        private final StringBuilder buffer;
        private boolean parsingValue;
        private SAXParser saxParser;
        private Attributes atts;

        public Parser(byte[] b) throws IOException {
            block16: {
                this.buffer = new StringBuilder();
                this.parsingValue = false;
                this.atts = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(b);
                try {
                    this.saxParser = ResumptionToken.getParser();
                    this.saxParser.parse((InputStream)stream, (DefaultHandler)this);
                }
                catch (SAXException e) {
                    Object in = UTF8.String(b);
                    int istart = ((String)in).lastIndexOf("<resumptionToken");
                    if (istart >= 0) {
                        int iend = ((String)in).indexOf("</resumptionToken", istart);
                        if (iend < 0) break block16;
                        in = ((String)in).substring(istart, iend) + "</resumptionToken>";
                        stream = new ByteArrayInputStream(UTF8.getBytes((String)in));
                        try {
                            this.saxParser.parse((InputStream)stream, (DefaultHandler)this);
                            ++ResumptionToken.this.recordCounter;
                        }
                        catch (SAXException e2) {
                            ConcurrentLog.warn("ResumptionToken", "token was not parsed (invalid resumption token): " + (String)in);
                        }
                        ConcurrentLog.warn("ResumptionToken", "input file with error: " + e.getMessage());
                        break block16;
                    }
                    ConcurrentLog.logException(e);
                    ConcurrentLog.warn("ResumptionToken", "token was not parsed (parser error):\n" + UTF8.String(b));
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    ConcurrentLog.warn("ResumptionToken", "token was not parsed (IO error)");
                    throw new IOException(e.getMessage());
                }
                finally {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
            }
        }

        @Override
        public void startElement(String uri, String name, String tag, Attributes atts) throws SAXException {
            if ("record".equals(tag)) {
                ++ResumptionToken.this.recordCounter;
            }
            if ("resumptionToken".equals(tag)) {
                this.parsingValue = true;
                this.atts = atts;
            }
        }

        @Override
        public void endElement(String uri, String name, String tag) {
            if (tag == null) {
                return;
            }
            if ("resumptionToken".equals(tag)) {
                ResumptionToken.this.put("expirationDate", this.atts.getValue("expirationDate"));
                ResumptionToken.this.put("completeListSize", this.atts.getValue("completeListSize"));
                ResumptionToken.this.put("cursor", this.atts.getValue("cursor"));
                ResumptionToken.this.put("token", this.buffer.toString());
                this.buffer.setLength(0);
                this.parsingValue = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.parsingValue) {
                this.buffer.append(ch, start, length);
            }
        }
    }
}

