/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.content.dao;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.content.DCEntry;
import net.yacy.document.content.dao.Dao;
import net.yacy.document.content.dao.DatabaseConnection;

public class PhpBB3Dao
implements Dao {
    protected DatabaseConnection conn = null;
    private final String urlstub;
    private final String prefix;
    private final HashMap<Integer, String> users;

    public PhpBB3Dao(String urlstub, String dbType, String host, int port, String dbname, String prefix, String user, String pw) throws Exception {
        this.conn = new DatabaseConnection(dbType, host, port, dbname, user, pw);
        this.urlstub = urlstub;
        this.prefix = prefix;
        this.users = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date first() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.statement();
            rs = stmt.executeQuery("select min(post_time) from " + this.prefix + "posts");
            if (rs.next()) {
                Date date = new Date(rs.getLong(1) * 1000L);
                return date;
            }
            Date date = null;
            return date;
        }
        catch (SQLException e) {
            ConcurrentLog.logException(e);
            Date date = null;
            return date;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date latest() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.statement();
            rs = stmt.executeQuery("select max(post_time) from " + this.prefix + "posts");
            if (rs.next()) {
                Date date = new Date(rs.getLong(1) * 1000L);
                return date;
            }
            Date date = null;
            return date;
        }
        catch (SQLException e) {
            ConcurrentLog.logException(e);
            Date date = null;
            return date;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public int size() throws SQLException {
        return this.conn.count(this.prefix + "posts");
    }

    @Override
    public DCEntry get(int item) {
        return this.getOne("select * from " + this.prefix + "posts where post_id = " + item);
    }

    @Override
    public BlockingQueue<DCEntry> query(int from, int until, int queueSize) {
        StringBuilder sql = new StringBuilder(256);
        sql.append("select * from " + this.prefix + "posts where post_id >= ");
        sql.append(from);
        if (until > from) {
            sql.append(" and post_id < ");
            sql.append(until);
        }
        sql.append(" order by post_id");
        return this.toQueue(sql, queueSize);
    }

    @Override
    public BlockingQueue<DCEntry> query(Date from, int queueSize) {
        StringBuilder sql = new StringBuilder(256);
        sql.append("select * from " + this.prefix + "posts where post_time >= ");
        sql.append(from.getTime() / 1000L);
        sql.append(" order by post_id");
        return this.toQueue(sql, queueSize);
    }

    /*
     * Exception decompiling
     */
    private DCEntry getOne(String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BlockingQueue<DCEntry> toQueue(final StringBuilder sql, int queueSize) {
        final ArrayBlockingQueue<DCEntry> queue = new ArrayBlockingQueue<DCEntry>(queueSize);
        Thread dbreader = new Thread("PhpBB3Dao.toQueue"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = PhpBB3Dao.this.conn.statement();
                    rs = stmt.executeQuery(sql.toString());
                    while (rs.next()) {
                        try {
                            queue.put(PhpBB3Dao.this.parseResultSet(rs));
                        }
                        catch (MalformedURLException e) {
                            ConcurrentLog.logException(e);
                        }
                    }
                    queue.put(DCEntry.poison);
                }
                catch (InterruptedException e) {
                    ConcurrentLog.logException(e);
                }
                catch (SQLException e) {
                    ConcurrentLog.logException(e);
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {}
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        };
        dbreader.start();
        return queue;
    }

    protected DCEntry parseResultSet(ResultSet rs) throws SQLException, MalformedURLException {
        int item = rs.getInt("post_id");
        DigestURL url = new DigestURL(this.urlstub + "/viewtopic.php?t=" + item);
        String subject = rs.getString("post_subject");
        String text = PhpBB3Dao.xmlCleaner(rs.getString("post_text"));
        String user = this.getUser(rs.getInt("poster_id"));
        Date date = new Date(rs.getLong("post_time") * 1000L);
        return new DCEntry(url, date, subject, user, text, 0.0, 0.0);
    }

    public static String xmlCleaner(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sbOutput = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c == '\t' || c == '\n') && c != '\r') continue;
            sbOutput.append(c);
        }
        return sbOutput.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUser(int poster_id) {
        String nick = this.users.get(poster_id);
        if (nick != null) {
            return nick;
        }
        StringBuilder sql = new StringBuilder(256);
        sql.append("select * from " + this.prefix + "users where user_id = ");
        sql.append(poster_id);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.statement();
            rs = stmt.executeQuery(sql.toString());
            if (rs.next()) {
                nick = rs.getString("username");
            }
            if (nick == null) {
                nick = "";
            }
            this.users.put(poster_id, nick);
            String string = nick;
            return string;
        }
        catch (SQLException e) {
            ConcurrentLog.logException(e);
            String string = "";
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writePacks(BlockingQueue<DCEntry> queue, File targetdir, String versioninfo, int maxEntriesInFile) {
        FileOutputStream outStream = null;
        OutputStreamWriter osw = null;
        try {
            DCEntry e;
            String targethost = new DigestURL(this.urlstub).getHost();
            int fc = 0;
            File outputfiletmp = null;
            File outputfile = null;
            int c = 0;
            while ((e = queue.take()) != DCEntry.poison) {
                if (osw == null) {
                    outputfiletmp = new File(targetdir, targethost + "." + versioninfo + "." + fc + ".xml.prt");
                    outputfile = new File(targetdir, targethost + "." + versioninfo + "." + fc + ".xml");
                    if (outputfiletmp.exists()) {
                        outputfiletmp.delete();
                    }
                    if (outputfile.exists()) {
                        outputfile.delete();
                    }
                    outStream = new FileOutputStream(outputfiletmp);
                    osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outStream), StandardCharsets.UTF_8);
                    osw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<surrogates xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:yacy=\"http://yacy.net/\" xmlns:geo=\"http://www.w3.org/2003/01/geo/wgs84_pos#\">\n");
                }
                e.writeXML(osw);
                if (++c < maxEntriesInFile) continue;
                osw.write("</surrogates>\n");
                osw.close();
                outStream.close();
                outputfiletmp.renameTo(outputfile);
                osw = null;
                outStream = null;
                c = 0;
                ++fc;
            }
            osw.write("</surrogates>\n");
            osw.close();
            outStream.close();
            osw = null;
            outputfiletmp.renameTo(outputfile);
            int n = fc + 1;
            return n;
        }
        catch (MalformedURLException e) {
            ConcurrentLog.logException(e);
        }
        catch (UnsupportedEncodingException e) {
            ConcurrentLog.logException(e);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (InterruptedException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        return 0;
    }

    @Override
    public synchronized void close() {
        this.conn.close();
    }

    public static void main(String[] args) {
        try {
            PhpBB3Dao db = new PhpBB3Dao("http://forum.yacy-websuche.de", "mysql", "localhost", 3306, "forum", "forum_", "root", "");
            System.out.println("Posts in database : " + db.size());
            System.out.println("First entry       : " + String.valueOf(db.first()));
            System.out.println("Last entry        : " + String.valueOf(db.latest()));
            File targetdir = new File("x").getParentFile();
            db.writePacks(db.query(0, -1, 100), targetdir, "id0-current", 3000);
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }
}

